/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml;

import java.io.InputStream;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import org.apache.commons.pool2.ObjectPool;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzml.MZMLIndex;
import umich.ms.fileio.filetypes.mzml.MZMLIndexBuilder;
import umich.ms.fileio.filetypes.mzml.MZMLIndexElement;
import umich.ms.fileio.filetypes.mzml.MZMLIndexParser;
import umich.ms.fileio.filetypes.mzml.MZMLMultiSpectraParser;
import umich.ms.fileio.filetypes.mzml.MZMLRunHeaderParser;
import umich.ms.fileio.filetypes.mzml.MZMLRunInfo;
import umich.ms.fileio.filetypes.xmlbased.AbstractXMLBasedDataSource;
import umich.ms.fileio.filetypes.xmlbased.IndexBuilder;

public class MZMLFile
extends AbstractXMLBasedDataSource<MZMLIndexElement, MZMLIndex> {
    private MZMLIndex index;

    public MZMLFile(String path) {
        super(path);
    }

    public ObjectPool<XMLStreamReaderImpl> getReaderPool() {
        return this.readerPool;
    }

    @Override
    public MZMLIndex getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MZMLIndex fetchIndex() throws FileParsingException {
        MZMLIndex tmp = this.index;
        if (tmp == null) {
            MZMLFile mZMLFile = this;
            synchronized (mZMLFile) {
                tmp = this.getIndex();
                if (tmp == null) {
                    this.index = tmp = this.parseIndex();
                }
            }
        }
        return tmp;
    }

    @Override
    public MZMLIndex parseIndex() throws FileParsingException {
        MZMLIndexParser parser = new MZMLIndexParser(this);
        return parser.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MZMLRunInfo fetchRunInfo() throws FileParsingException {
        MZMLRunInfo info = (MZMLRunInfo)this.runInfo;
        if (this.runInfo == null) {
            MZMLFile mZMLFile = this;
            synchronized (mZMLFile) {
                info = (MZMLRunInfo)this.runInfo;
                if (info == null) {
                    info = this.parseRunInfo();
                    this.runInfo = info;
                }
            }
        }
        return info;
    }

    @Override
    public MZMLRunInfo parseRunInfo() throws FileParsingException {
        MZMLRunHeaderParser parser = new MZMLRunHeaderParser(this);
        return parser.parse();
    }

    @Override
    protected void releaseResources() {
        this.index = null;
    }

    @Override
    public MZMLMultiSpectraParser getSpectraParser(InputStream inputStream, LCMSDataSubset subset, ObjectPool<XMLStreamReaderImpl> readerPool, Integer numSpectra) {
        MZMLMultiSpectraParser parser;
        try {
            parser = new MZMLMultiSpectraParser(inputStream, subset, this);
        }
        catch (FileParsingException ex) {
            throw new IllegalStateException(ex);
        }
        parser.setNumScansToProcess(numSpectra);
        parser.setReaderPool(readerPool);
        return parser;
    }

    @Override
    public IndexBuilder<MZMLIndexElement> getIndexBuilder(IndexBuilder.Info info) {
        return new MZMLIndexBuilder(info, this.getReaderPool());
    }
}

