/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml.util;

import java.util.concurrent.TimeUnit;

public enum UnitsCV {
    UO_NANOSECONDS("UO:0000150", "nanosecond", TimeUnit.NANOSECONDS),
    UO_MICROSECONDS("UO:0000029", "microsecond", TimeUnit.MICROSECONDS),
    UO_MILLISECONDS("UO:0000028", "millisecond", TimeUnit.MILLISECONDS),
    UO_SECONDS("UO:0000010", "second", TimeUnit.SECONDS),
    UO_MINUTES("UO:0000031", "minute", TimeUnit.MINUTES),
    UO_HOURS("UO:0000032", "hour", TimeUnit.HOURS);

    public final String accession;
    public final String name;
    public final TimeUnit timeUnit;

    private UnitsCV(String accession, String name, TimeUnit timeUnit) {
        this.accession = accession;
        this.name = name;
        this.timeUnit = timeUnit;
    }

    public static double inMinutes(String uoAccession, String value) {
        double val = Double.parseDouble(value);
        if (UnitsCV.UO_SECONDS.accession.equals(uoAccession)) {
            return val / 60.0;
        }
        if (UnitsCV.UO_MINUTES.accession.equals(uoAccession)) {
            return val;
        }
        if (UnitsCV.UO_MILLISECONDS.accession.equals(uoAccession)) {
            return val / 1000.0 / 60.0;
        }
        if (UnitsCV.UO_MICROSECONDS.accession.equals(uoAccession)) {
            return val / 1000000.0 / 60.0;
        }
        if (UnitsCV.UO_NANOSECONDS.accession.equals(uoAccession)) {
            return val / 1.0E9 / 60.0;
        }
        if (UnitsCV.UO_HOURS.accession.equals(uoAccession)) {
            return val * 60.0;
        }
        throw new IllegalArgumentException("Unsupported ontology ref for time units encountered: " + uoAccession);
    }
}

