/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import umich.ms.datatypes.scan.PeaksCompression;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.util.ByteArrayHolder;
import umich.ms.util.ZlibInflater;

public class MZXMLPeaksDecoder {
    private MZXMLPeaksDecoder() {
        throw new AssertionError();
    }

    public static DecodedData decode(byte[] bytesIn, int precision, PeaksCompression compression) throws FileParsingException, IOException, DataFormatException {
        return MZXMLPeaksDecoder.decode(bytesIn, bytesIn.length, precision, compression);
    }

    public static DecodedData decode(byte[] bytesIn, int lengthIn, int precision, PeaksCompression compression) throws DataFormatException, IOException, FileParsingException {
        ByteArrayHolder bytes;
        if (compression == null) {
            compression = PeaksCompression.NONE;
        }
        if (bytesIn.length == 0 || lengthIn == 0) {
            return DecodedData.createEmpty();
        }
        boolean isBytesFromPool = false;
        switch (compression) {
            case ZLIB: {
                bytes = ZlibInflater.zlibUncompressBuffer(bytesIn, lengthIn, null);
                isBytesFromPool = true;
                break;
            }
            case NUMPRESS_LINPRED: 
            case NUMPRESS_POSINT: 
            case NUMPRESS_SHLOGF: {
                throw new UnsupportedOperationException("Numpress compression is not yet supported");
            }
            default: {
                bytes = new ByteArrayHolder(bytesIn);
                bytes.setPosition(lengthIn);
            }
        }
        int decodedLen = bytes.getPosition();
        byte[] decoded = bytes.getUnderlyingBytes();
        int chunkSize = precision / 8;
        int numPeaks = decodedLen / (2 * chunkSize);
        try {
            double[] mzsArray = new double[numPeaks];
            double[] intArray = new double[numPeaks];
            int maxIntensityPos = 0;
            double maxIntensity = Double.NEGATIVE_INFINITY;
            int minIntensityPos = 0;
            double minIntensity = Double.POSITIVE_INFINITY;
            int minIntensityNonZeroPos = 0;
            double minIntensityNonZero = Double.POSITIVE_INFINITY;
            double intensitySum = 0.0;
            switch (precision) {
                case 32: {
                    for (int i = 0; i < numPeaks; ++i) {
                        int offset = i * 2 * chunkSize;
                        int asInt = decoded[offset + 3] & 0xFF | (decoded[offset + 2] & 0xFF) << 8 | (decoded[offset + 1] & 0xFF) << 16 | (decoded[offset] & 0xFF) << 24;
                        float mzAsFloat = Float.intBitsToFloat(asInt);
                        asInt = decoded[(offset += chunkSize) + 3] & 0xFF | (decoded[offset + 2] & 0xFF) << 8 | (decoded[offset + 1] & 0xFF) << 16 | (decoded[offset] & 0xFF) << 24;
                        float intAsFloat = Float.intBitsToFloat(asInt);
                        assert (intAsFloat >= 0.0f);
                        if ((double)intAsFloat > maxIntensity) {
                            maxIntensity = intAsFloat;
                            maxIntensityPos = i;
                        }
                        if ((double)intAsFloat < minIntensityNonZero) {
                            if (intAsFloat > 0.0f) {
                                minIntensityNonZero = intAsFloat;
                                minIntensityNonZeroPos = i;
                            }
                            if ((double)intAsFloat < minIntensity) {
                                minIntensity = intAsFloat;
                                minIntensityPos = i;
                            }
                        }
                        intensitySum += (double)intAsFloat;
                        mzsArray[i] = mzAsFloat;
                        intArray[i] = intAsFloat;
                    }
                    break;
                }
                case 64: {
                    for (int i = 0; i < numPeaks; ++i) {
                        int offset = i * 2 * chunkSize;
                        long asLong = (long)(decoded[offset + 7] & 0xFF) | (long)(decoded[offset + 6] & 0xFF) << 8 | (long)(decoded[offset + 5] & 0xFF) << 16 | (long)(decoded[offset + 4] & 0xFF) << 24 | (long)(decoded[offset + 3] & 0xFF) << 32 | (long)(decoded[offset + 2] & 0xFF) << 40 | (long)(decoded[offset + 1] & 0xFF) << 48 | (long)(decoded[offset] & 0xFF) << 56;
                        double mzAsDouble = Double.longBitsToDouble(asLong);
                        asLong = (long)(decoded[(offset += chunkSize) + 7] & 0xFF) | (long)(decoded[offset + 6] & 0xFF) << 8 | (long)(decoded[offset + 5] & 0xFF) << 16 | (long)(decoded[offset + 4] & 0xFF) << 24 | (long)(decoded[offset + 3] & 0xFF) << 32 | (long)(decoded[offset + 2] & 0xFF) << 40 | (long)(decoded[offset + 1] & 0xFF) << 48 | (long)(decoded[offset] & 0xFF) << 56;
                        double intAsDouble = Double.longBitsToDouble(asLong);
                        assert (intAsDouble >= 0.0);
                        if (intAsDouble > maxIntensity) {
                            maxIntensity = intAsDouble;
                            maxIntensityPos = i;
                        }
                        if (intAsDouble < minIntensityNonZero) {
                            if (intAsDouble > 0.0) {
                                minIntensityNonZero = intAsDouble;
                                minIntensityNonZeroPos = i;
                            }
                            if (intAsDouble < minIntensity) {
                                minIntensity = intAsDouble;
                                minIntensityPos = i;
                            }
                        }
                        intensitySum += intAsDouble;
                        mzsArray[i] = mzAsDouble;
                        intArray[i] = intAsDouble;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Precision can only be 32/64 bits, other values are not valid.");
                }
            }
            DecodedData decodedData = new DecodedData(mzsArray, intArray, maxIntensityPos, maxIntensity, minIntensityPos, minIntensity, minIntensityNonZeroPos, minIntensityNonZero, intensitySum);
            return decodedData;
        }
        catch (OutOfMemoryError oom) {
            throw new FileParsingException("Could not allocate arrays during spectra decoding step", oom);
        }
        finally {
            if (isBytesFromPool) {
                try {
                    ZlibInflater.getPool().returnObject((Object)bytes);
                }
                catch (Exception e) {
                    throw new FileParsingException("Could not return ByteArrayHolder to the pool.", e);
                }
            }
        }
    }

    private static byte[] charsToBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        return bytes;
    }

    public static class DecodedData {
        public final double[] mzs;
        public final double[] intensities;
        public final int maxIntensityPos;
        public final double maxIntensity;
        public final double maxIntensityMz;
        public final int minIntensityPos;
        public final double minIntensity;
        public final int minIntensityNonZeroPos;
        public final double minIntensityNonZero;
        public final double intensitySum;

        public DecodedData(double[] mzs, double[] intensities, int maxIntensityPos, double maxIntensity, int minIntensityPos, double minIntensity, int minIntensityNonZeroPos, double minIntensityNonZero, double intensitySum) {
            this.mzs = mzs;
            this.intensities = intensities;
            this.maxIntensityPos = maxIntensityPos;
            this.maxIntensity = maxIntensity;
            this.minIntensityPos = minIntensityPos;
            this.minIntensity = minIntensity;
            this.minIntensityNonZeroPos = minIntensityNonZeroPos;
            this.minIntensityNonZero = minIntensityNonZero;
            this.intensitySum = intensitySum;
            this.maxIntensityMz = mzs.length == 0 ? 0.0 : mzs[maxIntensityPos];
        }

        public static DecodedData createEmpty() {
            return new DecodedData(new double[0], new double[0], -1, 0.0, -1, 0.0, -1, 0.0, 0.0);
        }
    }
}

