/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml.example;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import umich.ms.datatypes.LCMSData;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.StorageStrategy;
import umich.ms.datatypes.scancollection.IScanCollection;
import umich.ms.datatypes.scancollection.ScanIndex;
import umich.ms.datatypes.scancollection.impl.ScanCollectionDefault;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzxml.MZXMLFile;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndex;

public class Example {
    public static void main(String[] args) throws FileParsingException {
        String path = args[0];
        MZXMLFile source = new MZXMLFile(path);
        source.setExcludeEmptyScans(false);
        source.setNumThreadsForParsing(null);
        source.setParsingTimeout(30L);
        MZXMLIndex mzxmlIndex = source.fetchIndex();
        ScanCollectionDefault scans = new ScanCollectionDefault();
        scans.setDefaultStorageStrategy(StorageStrategy.SOFT);
        scans.isAutoloadSpectra(true);
        scans.setDataSource(source);
        scans.loadData(LCMSDataSubset.MS2_WITH_SPECTRA);
        TreeMap<Integer, IScan> num2scan = scans.getMapNum2scan();
        Set<Map.Entry<Integer, IScan>> scanEntries = num2scan.entrySet();
        MZXMLIndex idx = source.fetchIndex();
        for (Map.Entry<Integer, IScan> scanEntry : scanEntries) {
            Integer scanNum = scanEntry.getKey();
            IScan scan = scanEntry.getValue();
            int scanNumInternal = scan.getNum();
            Object idxElem = idx.getByNum(scanNumInternal);
            int scanNumRaw = idxElem.getRawNumber();
            ISpectrum spectrum = scan.fetchSpectrum();
            int n = spectrum.getMZs().length;
            if (scan.getMsLevel() > 1) {
                System.out.printf("Scan #%d MS%d[%s] (raw #%d), precursor: #%s(mz: %.3f, z: %d) contained %d data points\n", scanNumInternal, scan.getMsLevel(), scan.getPolarity().toString(), scanNumRaw, scan.getPrecursor().getParentScanRefRaw(), scan.getPrecursor().getMzTarget(), scan.getPrecursor().getCharge(), n);
                continue;
            }
            System.out.printf("Scan #%d MS%d[%s] (raw #%d) contained %d data points\n", scanNumInternal, scan.getMsLevel(), scan.getPolarity().toString(), scanNumRaw, n);
        }
        System.exit(1);
        MZXMLIndex idx2 = source.fetchIndex();
        LCMSRunInfo runInfo = source.fetchRunInfo();
        Set<Integer> msLevel = Collections.singleton(2);
        LCMSDataSubset subset = new LCMSDataSubset(1, 3, msLevel, null);
        List<IScan> parsedScans = source.parse(subset);
        LCMSData data = new LCMSData(source);
        data.load(LCMSDataSubset.WHOLE_RUN);
        data.releaseMemory();
        data.load(new LCMSDataSubset(null, null, msLevel, null));
        data.releaseMemory();
        data.load(LCMSDataSubset.MS2_WITH_SPECTRA);
        data.releaseMemory();
        Object dataUser = new Object();
        data.load(LCMSDataSubset.WHOLE_RUN, dataUser);
        System.out.printf("The data is loaded and used by [%s] object.\n", System.identityHashCode(dataUser));
        dataUser = null;
        data.load(LCMSDataSubset.STRUCTURE_ONLY);
        IScanCollection scans2 = data.getScans();
        scans2.isAutoloadSpectra(true);
        scans2.setDefaultStorageStrategy(StorageStrategy.SOFT);
        TreeMap<Integer, ScanIndex> msLevel2index = scans2.getMapMsLevel2index();
        ScanIndex ms2idx = msLevel2index.get(2);
        TreeMap<Integer, IScan> num2scan2 = ms2idx.getNum2scan();
        Set<Map.Entry<Integer, IScan>> scanEntries2 = num2scan2.entrySet();
        for (Map.Entry entry : scanEntries2) {
            Integer scanNum = (Integer)entry.getKey();
            IScan scan = (IScan)entry.getValue();
            ISpectrum spectrum = scan.fetchSpectrum();
            int scanNumInternal = scan.getNum();
            Object idxElem = idx2.getByNum(scanNumInternal);
            int scanNumRaw = idxElem.getRawNumber();
            int numPoints = spectrum.getMZs().length;
            System.out.printf("Scan #%d (raw #%d) contained %d data points\n", scanNumInternal, scanNumRaw, numPoints);
        }
        Integer firstMS2ScanNum = scans2.getMapMsLevel2index().get(2).getNum2scan().firstKey();
        IScan iScan2 = scans2.getScanByNum(firstMS2ScanNum);
        iScan2 = scans2.getNextScanAtSameMsLevel(iScan2);
        String parentScanRef = iScan2.getPrecursor().getParentScanRefRaw();
        System.out.printf("Scan #%d (MS%d) is a child scan of {%s}\n", iScan2.getNum(), iScan2.getMsLevel(), parentScanRef);
        data.releaseMemory();
    }
}

