/*
 * Decompiled with CFR 0.152.
 */
package Preprocessing;

import DatParser.MascotDatparser;
import DatParser.SpectrumAnnotationContainer;
import MZIDparser.CalcFeature;
import MZIDparser.JPSM;
import MZIDparser.PeakMatch;
import MZIDparser.ReadmzID;
import Preprocessing.Config;
import Preprocessing.DeltaMassDB;
import Preprocessing.JPeak;
import Preprocessing.JPeakPair;
import Preprocessing.JSpectrum;
import Preprocessing.PMass;
import Preprocessing.ParameterManager;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.bind.JAXBException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.ParseException;
import org.apache.commons.math.MathException;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;

public class pCleanMainClass {
    public static final String TOOL = "pClean";
    public static final String VERSION = "Release (v2012.10.25)";
    public static final String RELEASE_DATE = "25 October 2021";

    public static void main(String[] args) throws ParseException, IOException, MzMLUnmarshallerException, JAXBException, ClassNotFoundException, SQLException, MathException, InterruptedException {
        DefaultParser parser = new DefaultParser();
        ParameterManager params = new ParameterManager(TOOL, VERSION, RELEASE_DATE);
        CommandLine cmd = parser.parse(params.getOptions(), args);
        if (cmd.hasOption("h") || cmd.hasOption("help") || args.length == 0) {
            params.printUsageInfo();
            System.exit(0);
        }
        params.InitializeParameters(cmd);
        JSpectrum.setImmoniumIons();
        String outlog = params.getOutdir() + "/spectrumInfor.txt";
        if (params.getIdres() == null) {
            if (params.doNetworkFilter()) {
                if (params.getLabelMethod() != null) {
                    String labelmethod = params.getLabelMethod();
                    pCleanMainClass.doPreprocessing123(params.getInput(), params.getOutdir(), outlog, params.doImionFilter(), params.getLabelMethod(), params.doRepFilter(), params.doLabelFilter(), params.doLowWindowFilter(), params.doHighWindowFilter(), params.doIsoReduction(), params.doChargeDeconv(), params.doIonsMerge(), params.doLargerThanPrecursor());
                } else {
                    pCleanMainClass.doPreprocessing23(params.getInput(), params.getOutdir(), outlog, params.doImionFilter(), params.doIsoReduction(), params.doChargeDeconv(), params.doIonsMerge(), params.doLargerThanPrecursor());
                }
            } else if (params.getLabelMethod() != null) {
                if (params.doIsoReduction() || params.doChargeDeconv() || params.doIonsMerge() || params.doLargerThanPrecursor()) {
                    pCleanMainClass.doModule12(params.getInput(), params.getOutdir(), params.doImionFilter(), params.getLabelMethod(), params.doRepFilter(), params.doLabelFilter(), params.doLowWindowFilter(), params.doHighWindowFilter(), params.doIsoReduction(), params.doChargeDeconv(), params.doIonsMerge(), params.doLargerThanPrecursor());
                } else {
                    pCleanMainClass.doModule1(params.getInput(), params.getOutdir(), params.doImionFilter(), params.getLabelMethod(), params.doRepFilter(), params.doLabelFilter(), params.doLowWindowFilter(), params.doHighWindowFilter());
                }
            } else {
                pCleanMainClass.doModule2(params.getInput(), params.getOutdir(), params.doImionFilter(), params.doIsoReduction(), params.doChargeDeconv(), params.doIonsMerge(), params.doLargerThanPrecursor());
            }
        } else {
            String idres = params.getIdres();
            if (idres.endsWith(".mzid")) {
                if (params.getLabelMethod() != null) {
                    pCleanMainClass.doParseMzid123(params.getInput(), params.getOutdir(), outlog, params.doImionFilter(), params.getLabelMethod(), params.doRepFilter(), params.doLabelFilter(), params.doLowWindowFilter(), params.doHighWindowFilter(), params.doIsoReduction(), params.doChargeDeconv(), params.doIonsMerge(), params.doLargerThanPrecursor(), idres);
                } else {
                    pCleanMainClass.doParseMzid23(params.getInput(), params.getOutdir(), outlog, params.doImionFilter(), params.doIsoReduction(), params.doChargeDeconv(), params.doIonsMerge(), params.doLargerThanPrecursor(), idres);
                }
            } else if (idres.endsWith(".dat")) {
                if (params.getLabelMethod() != null) {
                    pCleanMainClass.doParseDat123(params.getInput(), params.getOutdir(), outlog, params.doImionFilter(), params.getLabelMethod(), params.doRepFilter(), params.doLabelFilter(), params.doLowWindowFilter(), params.doHighWindowFilter(), params.doIsoReduction(), params.doChargeDeconv(), params.doIonsMerge(), params.doLargerThanPrecursor(), idres);
                } else {
                    pCleanMainClass.doParseDat23(params.getInput(), params.getOutdir(), outlog, params.doImionFilter(), params.doIsoReduction(), params.doChargeDeconv(), params.doIonsMerge(), params.doLargerThanPrecursor(), idres);
                }
            }
        }
    }

    private static void doModule1(String mgf, String outdir, Boolean imonFilter, String labelMethod, Boolean repFilter, Boolean labelFilter, Boolean lowWinFilter, Boolean highWinFilter) throws IOException, MzMLUnmarshallerException {
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        String outmgf = outdir + System.getProperty("file.separator") + mgfFile.getName().replace(".mgf", ".pClean_M1.mgf");
        BufferedWriter bwmgf = new BufferedWriter(new FileWriter(new File(outmgf)));
        spectrumFactory.addSpectra(mgfFile, null);
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                JPeak jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            if (imonFilter.booleanValue()) {
                jSpectrum.removeImmoniumIons();
            }
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module1(labelMethod, repFilter, labelFilter, lowWinFilter, highWinFilter);
            StringBuilder sb = jSpectrum.toMgf();
            bwmgf.write(sb.toString());
        }
        bwmgf.close();
    }

    private static void doModule2(String mgf, String outdir, Boolean imonFilter, Boolean isoReduction, Boolean chargeDeconv, Boolean ionsMerge, Boolean largerThanPrecursor) throws IOException, MzMLUnmarshallerException {
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        String outmgf = outdir + System.getProperty("file.separator") + mgfFile.getName().replace(".mgf", ".pClean_M2.mgf");
        BufferedWriter bwmgf = new BufferedWriter(new FileWriter(new File(outmgf)));
        spectrumFactory.addSpectra(mgfFile, null);
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                JPeak jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            if (imonFilter.booleanValue()) {
                jSpectrum.removeImmoniumIons();
            }
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
            StringBuilder sb = jSpectrum.toMgf();
            bwmgf.write(sb.toString());
        }
        bwmgf.close();
    }

    private static void doModule12(String mgf, String outdir, Boolean imonFilter, String labelMethod, Boolean repFilter, Boolean labelFilter, Boolean lowWinFilter, Boolean highWinFilter, Boolean isoReduction, Boolean chargeDeconv, Boolean ionsMerge, Boolean largerThanPrecursor) throws IOException, MzMLUnmarshallerException {
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        String outmgf = outdir + System.getProperty("file.separator") + mgfFile.getName().replace(".mgf", ".pClean_M12.mgf");
        BufferedWriter bwmgf = new BufferedWriter(new FileWriter(new File(outmgf)));
        spectrumFactory.addSpectra(mgfFile, null);
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                JPeak jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            if (!repFilter.booleanValue()) {
                JSpectrum.IsobaricTag tag = JSpectrum.IsobaricTag.valueOf(labelMethod.toUpperCase());
                jSpectrum.detectReporterPeaks(tag.reporterIons, 0.01);
            }
            if (imonFilter.booleanValue()) {
                jSpectrum.removeImmoniumIons();
            }
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module1(labelMethod, repFilter, labelFilter, lowWinFilter, highWinFilter);
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
            if (!repFilter.booleanValue()) {
                jSpectrum.restoreReporterPeaks();
            }
            StringBuilder sb = jSpectrum.toMgf();
            bwmgf.write(sb.toString());
        }
        bwmgf.close();
    }

    private static void doPreprocessing123(String mgf, String outdir, String outlog, Boolean imonFilter, String labelMethod, Boolean repFilter, Boolean labelFilter, Boolean lowWinFilter, Boolean highWinFilter, Boolean isoReduction, Boolean chargeDeconv, Boolean ionsMerge, Boolean largerThanPrecursor) throws IOException, MzMLUnmarshallerException {
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        spectrumFactory.addSpectra(mgfFile, null);
        StringBuilder logStrBuilder = new StringBuilder();
        logStrBuilder.append("index\ttitle\tedge\tvertex\tmz\tintensity\tcharge\n");
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            int i;
            JPeak jPeak;
            String outprefix = "spectrum" + k;
            String peakfile = outdir + "/" + outprefix + "_peak.txt";
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(peakfile)));
            bWriter.write("name\ttype\tintensity\n");
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            if (imonFilter.booleanValue()) {
                jSpectrum.removeImmoniumIons();
            }
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module1(labelMethod, repFilter, labelFilter, lowWinFilter, highWinFilter);
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
            jSpectrum.sortPeaksByMZ();
            StringBuilder peakBuilder = new StringBuilder();
            for (i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                jPeak = jSpectrum.getPeaks().get(i);
                peakBuilder.append(jPeak.getMz());
                peakBuilder.append("\tNA\t");
                peakBuilder.append(jPeak.getIntensity());
                peakBuilder.append("\n");
            }
            bWriter.write(peakBuilder.toString() + "\n");
            bWriter.close();
            for (i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                jPeak = jSpectrum.getPeaks().get(i);
                jPeak.setID(String.valueOf(jPeak.getMz()));
                if (chargeDeconv.booleanValue()) continue;
                jPeak.setMz(jPeak.getMz() * (double)jPeak.getCharge() - (double)(jPeak.getCharge() - 1) * ElementaryIon.proton.getTheoreticMass());
            }
            ArrayList<JPeakPair> jPeakPairs = pCleanMainClass.findPeakPair(jSpectrum, labelMethod);
            StringBuilder edgeStrBuilder = new StringBuilder();
            edgeStrBuilder.append("From\tTo\tmass1\tmass2\tcharge1\tcharge2\tmztol\tdelta\tdeltaName\tintensity\n");
            for (JPeakPair jpp : jPeakPairs) {
                edgeStrBuilder.append(jpp.print());
                edgeStrBuilder.append("\n");
            }
            String edgefile = outdir + "/" + outprefix + "_edge.txt";
            BufferedWriter edgeWriter = new BufferedWriter(new FileWriter(new File(edgefile)));
            edgeWriter.write(edgeStrBuilder.toString());
            edgeWriter.close();
            logStrBuilder.append(outprefix + "\t" + spectrum.getSpectrumTitle() + "\t" + edgefile + "\t" + peakfile + "\t" + spectrum.getPrecursor().getMz() + "\t" + spectrum.getPrecursor().getIntensity() + "\t" + ch + "\n");
        }
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(new File(outlog)));
        logWriter.write(logStrBuilder.toString());
        logWriter.close();
    }

    private static void doPreprocessing23(String mgf, String outdir, String outlog, Boolean imonFilter, Boolean isoReduction, Boolean chargeDeconv, Boolean ionsMerge, Boolean largerThanPrecursor) throws IOException, MzMLUnmarshallerException {
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        spectrumFactory.addSpectra(mgfFile, null);
        StringBuilder logStrBuilder = new StringBuilder();
        logStrBuilder.append("index\ttitle\tedge\tvertex\tmz\tintensity\tcharge\n");
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            int i;
            JPeak jPeak;
            String outprefix = "spectrum" + k;
            String peakfile = outdir + "/" + outprefix + "_peak.txt";
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(peakfile)));
            bWriter.write("name\ttype\tintensity\n");
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            if (imonFilter.booleanValue()) {
                jSpectrum.removeImmoniumIons();
            }
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
            jSpectrum.sortPeaksByMZ();
            StringBuilder peakBuilder = new StringBuilder();
            for (i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                jPeak = jSpectrum.getPeaks().get(i);
                peakBuilder.append(jPeak.getMz());
                peakBuilder.append("\tNA\t");
                peakBuilder.append(jPeak.getIntensity());
                peakBuilder.append("\n");
            }
            bWriter.write(peakBuilder.toString() + "\n");
            bWriter.close();
            for (i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                jPeak = jSpectrum.getPeaks().get(i);
                jPeak.setID(String.valueOf(jPeak.getMz()));
                if (chargeDeconv.booleanValue()) continue;
                jPeak.setMz(jPeak.getMz() * (double)jPeak.getCharge() - (double)(jPeak.getCharge() - 1) * ElementaryIon.proton.getTheoreticMass());
            }
            ArrayList<JPeakPair> jPeakPairs = pCleanMainClass.findPeakPair(jSpectrum, null);
            StringBuilder edgeStrBuilder = new StringBuilder();
            edgeStrBuilder.append("From\tTo\tmass1\tmass2\tcharge1\tcharge2\tmztol\tdelta\tdeltaName\tintensity\n");
            for (JPeakPair jpp : jPeakPairs) {
                edgeStrBuilder.append(jpp.print());
                edgeStrBuilder.append("\n");
            }
            String edgefile = outdir + "/" + outprefix + "_edge.txt";
            BufferedWriter edgeWriter = new BufferedWriter(new FileWriter(new File(edgefile)));
            edgeWriter.write(edgeStrBuilder.toString());
            edgeWriter.close();
            logStrBuilder.append(outprefix + "\t" + spectrum.getSpectrumTitle() + "\t" + edgefile + "\t" + peakfile + "\t" + spectrum.getPrecursor().getMz() + "\t" + spectrum.getPrecursor().getIntensity() + "\t" + ch + "\n");
        }
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(new File(outlog)));
        logWriter.write(logStrBuilder.toString());
        logWriter.close();
    }

    private static void doParseMzid123(String mgf, String outdir, String outlog, Boolean imonFilter, String labelMethod, Boolean repFilter, Boolean labelFilter, Boolean lowWinFilter, Boolean highWinFilter, Boolean isoReduction, Boolean chargeDeconv, Boolean ionsMerge, Boolean largerThanPrecursor, String mzid) throws IOException, MzMLUnmarshallerException, JAXBException, ClassNotFoundException, SQLException, MathException, InterruptedException {
        ReadmzID readmzID = new ReadmzID(100.0);
        ArrayList<JPSM> psmArrayList = readmzID.readmzIdentML(mzid);
        HashMap<Integer, JPSM> psmMap = new HashMap<Integer, JPSM>();
        for (JPSM psm : psmArrayList) {
            if (psm.getRank() >= 2) continue;
            psmMap.put(psm.getSpectrumIndex(), psm);
        }
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        spectrumFactory.addSpectra(mgfFile, null);
        StringBuilder logStrBuilder = new StringBuilder();
        logStrBuilder.append("index\ttitle\tedge\tvertex\tmz\tintensity\tcharge\n");
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            JPeak jPeak;
            String outprefix = "spectrum" + k;
            String peakfile = outdir + "/" + outprefix + "_peak.txt";
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(peakfile)));
            bWriter.write("name\ttype\tintensity\n");
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            if (imonFilter.booleanValue()) {
                jSpectrum.removeImmoniumIons();
            }
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module1(labelMethod, repFilter, labelFilter, lowWinFilter, highWinFilter);
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
            jSpectrum.sortPeaksByMZ();
            StringBuilder peakBuilder = new StringBuilder();
            if (psmMap.containsKey(k)) {
                JPSM psm = (JPSM)psmMap.get(k);
                PeakMatch peakMatch = new PeakMatch(spectrum, jSpectrum, psm);
                int maxFragCharge = 2;
                PeakMatch.setMs2tol(Config.ms2tol);
                peakMatch.initialize(true, maxFragCharge);
                CalcFeature calcFeature = new CalcFeature(jSpectrum);
                calcFeature.addMatch(peakMatch.getIonMatches());
                JSpectrum js = calcFeature.getSpectrum();
                jSpectrum.sortPeaksByMZ();
                jSpectrum.module1(labelMethod, repFilter, labelFilter, lowWinFilter, highWinFilter);
                js.sortPeaksByMZ();
                js.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
                js.sortPeaksByMZ();
                for (int i = 0; i < js.getPeaks().size(); ++i) {
                    JPeak jPeak2 = js.getPeaks().get(i);
                    if (jPeak2.isMatch == 1.0) {
                        peakBuilder.append(jPeak2.getMz());
                        peakBuilder.append("\t" + jPeak2.getIonType() + "\t");
                        peakBuilder.append(jPeak2.getIntensity());
                        peakBuilder.append("\n");
                        continue;
                    }
                    peakBuilder.append(jPeak2.getMz());
                    peakBuilder.append("\tNA\t");
                    peakBuilder.append(jPeak2.getIntensity());
                    peakBuilder.append("\n");
                }
            } else {
                for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                    jPeak = jSpectrum.getPeaks().get(i);
                    peakBuilder.append(jPeak.getMz());
                    peakBuilder.append("\tNA\t");
                    peakBuilder.append(jPeak.getIntensity());
                    peakBuilder.append("\n");
                }
            }
            bWriter.write(peakBuilder.toString() + "\n");
            bWriter.close();
            for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                jPeak = jSpectrum.getPeaks().get(i);
                jPeak.setID(String.valueOf(jPeak.getMz()));
                if (chargeDeconv.booleanValue()) continue;
                jPeak.setMz(jPeak.getMz() * (double)jPeak.getCharge() - (double)(jPeak.getCharge() - 1) * ElementaryIon.proton.getTheoreticMass());
            }
            ArrayList<JPeakPair> jPeakPairs = pCleanMainClass.findPeakPair(jSpectrum, labelMethod);
            StringBuilder edgeStrBuilder = new StringBuilder();
            edgeStrBuilder.append("From\tTo\tmass1\tmass2\tcharge1\tcharge2\tmztol\tdelta\tdeltaName\tintensity\n");
            for (JPeakPair jpp : jPeakPairs) {
                edgeStrBuilder.append(jpp.print());
                edgeStrBuilder.append("\n");
            }
            String edgefile = outdir + "/" + outprefix + "_edge.txt";
            BufferedWriter edgeWriter = new BufferedWriter(new FileWriter(new File(edgefile)));
            edgeWriter.write(edgeStrBuilder.toString());
            edgeWriter.close();
            logStrBuilder.append(outprefix + "\t" + spectrum.getSpectrumTitle() + "\t" + edgefile + "\t" + peakfile + "\t" + spectrum.getPrecursor().getMz() + "\t" + spectrum.getPrecursor().getIntensity() + "\t" + ch + "\n");
        }
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(new File(outlog)));
        logWriter.write(logStrBuilder.toString());
        logWriter.close();
    }

    private static void doParseMzid23(String mgf, String outdir, String outlog, Boolean imonFilter, Boolean isoReduction, Boolean chargeDeconv, Boolean ionsMerge, Boolean largerThanPrecursor, String mzid) throws JAXBException, IOException, MzMLUnmarshallerException, ClassNotFoundException, SQLException, MathException, InterruptedException {
        ReadmzID readmzID = new ReadmzID(100.0);
        ArrayList<JPSM> psmArrayList = readmzID.readmzIdentML(mzid);
        HashMap<Integer, JPSM> psmMap = new HashMap<Integer, JPSM>();
        for (JPSM psm : psmArrayList) {
            if (psm.getRank() >= 2) continue;
            psmMap.put(psm.getSpectrumIndex(), psm);
        }
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        spectrumFactory.addSpectra(mgfFile, null);
        StringBuilder logStrBuilder = new StringBuilder();
        logStrBuilder.append("index\ttitle\tedge\tvertex\tmz\tintensity\tcharge\n");
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            JPeak jPeak;
            String outprefix = "spectrum" + k;
            String peakfile = outdir + "/" + outprefix + "_peak.txt";
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(peakfile)));
            bWriter.write("name\ttype\tintensity\n");
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            if (imonFilter.booleanValue()) {
                jSpectrum.removeImmoniumIons();
            }
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
            jSpectrum.sortPeaksByMZ();
            StringBuilder peakBuilder = new StringBuilder();
            if (psmMap.containsKey(k)) {
                JPSM psm = (JPSM)psmMap.get(k);
                PeakMatch peakMatch = new PeakMatch(spectrum, jSpectrum, psm);
                int maxFragCharge = 2;
                PeakMatch.setMs2tol(Config.ms2tol);
                peakMatch.initialize(true, maxFragCharge);
                CalcFeature calcFeature = new CalcFeature(jSpectrum);
                calcFeature.addMatch(peakMatch.getIonMatches());
                JSpectrum js = calcFeature.getSpectrum();
                js.sortPeaksByMZ();
                js.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
                js.sortPeaksByMZ();
                for (int i = 0; i < js.getPeaks().size(); ++i) {
                    JPeak jPeak2 = js.getPeaks().get(i);
                    if (jPeak2.isMatch == 1.0) {
                        peakBuilder.append(jPeak2.getMz());
                        peakBuilder.append("\t" + jPeak2.getIonType() + "\t");
                        peakBuilder.append(jPeak2.getIntensity());
                        peakBuilder.append("\n");
                        continue;
                    }
                    peakBuilder.append(jPeak2.getMz());
                    peakBuilder.append("\tNA\t");
                    peakBuilder.append(jPeak2.getIntensity());
                    peakBuilder.append("\n");
                }
            } else {
                for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                    jPeak = jSpectrum.getPeaks().get(i);
                    peakBuilder.append(jPeak.getMz());
                    peakBuilder.append("\tNA\t");
                    peakBuilder.append(jPeak.getIntensity());
                    peakBuilder.append("\n");
                }
            }
            bWriter.write(peakBuilder.toString() + "\n");
            bWriter.close();
            for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                jPeak = jSpectrum.getPeaks().get(i);
                jPeak.setID(String.valueOf(jPeak.getMz()));
                if (chargeDeconv.booleanValue()) continue;
                jPeak.setMz(jPeak.getMz() * (double)jPeak.getCharge() - (double)(jPeak.getCharge() - 1) * ElementaryIon.proton.getTheoreticMass());
            }
            ArrayList<JPeakPair> jPeakPairs = pCleanMainClass.findPeakPair(jSpectrum, null);
            StringBuilder edgeStrBuilder = new StringBuilder();
            edgeStrBuilder.append("From\tTo\tmass1\tmass2\tcharge1\tcharge2\tmztol\tdelta\tdeltaName\tintensity\n");
            for (JPeakPair jpp : jPeakPairs) {
                edgeStrBuilder.append(jpp.print());
                edgeStrBuilder.append("\n");
            }
            String edgefile = outdir + "/" + outprefix + "_edge.txt";
            BufferedWriter edgeWriter = new BufferedWriter(new FileWriter(new File(edgefile)));
            edgeWriter.write(edgeStrBuilder.toString());
            edgeWriter.close();
            logStrBuilder.append(outprefix + "\t" + spectrum.getSpectrumTitle() + "\t" + edgefile + "\t" + peakfile + "\t" + spectrum.getPrecursor().getMz() + "\t" + spectrum.getPrecursor().getIntensity() + "\t" + ch + "\n");
        }
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(new File(outlog)));
        logWriter.write(logStrBuilder.toString());
        logWriter.close();
    }

    private static void doParseDat123(String mgf, String outdir, String outlog, Boolean imonFilter, String labelMethod, Boolean repFilter, Boolean labelFilter, Boolean lowWinFilter, Boolean highWinFilter, Boolean isoReduction, Boolean chargeDeconv, Boolean ionsMerge, Boolean largerThanPrecursor, String dat) throws IOException, MzMLUnmarshallerException {
        MascotDatparser mascotDatparser = new MascotDatparser();
        ArrayList<SpectrumAnnotationContainer> dpsms = mascotDatparser.fragAnnotation(dat);
        HashMap<String, SpectrumAnnotationContainer> psmMap = new HashMap<String, SpectrumAnnotationContainer>();
        for (SpectrumAnnotationContainer psm : dpsms) {
            psmMap.put(psm.getSpectrumID(), psm);
        }
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        spectrumFactory.addSpectra(mgfFile, null);
        StringBuilder logStrBuilder = new StringBuilder();
        logStrBuilder.append("index\ttitle\tedge\tvertex\tmz\tintensity\tcharge\n");
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            JPeak jPeak;
            String outprefix = "spectrum" + k;
            String peakfile = outdir + "/" + outprefix + "_peak.txt";
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(peakfile)));
            bWriter.write("name\ttype\tintensity\n");
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            if (imonFilter.booleanValue()) {
                jSpectrum.removeImmoniumIons();
            }
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module1(labelMethod, repFilter, labelFilter, lowWinFilter, highWinFilter);
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
            jSpectrum.sortPeaksByMZ();
            StringBuilder peakBuilder = new StringBuilder();
            if (psmMap.containsKey(jSpectrum.getSpectrumTitle())) {
                SpectrumAnnotationContainer psm = (SpectrumAnnotationContainer)psmMap.get(jSpectrum.getSpectrumTitle());
                HashMap<Double, String> frags = psm.getFragannotation();
                for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                    JPeak jPeak2 = jSpectrum.getPeaks().get(i);
                    if (frags.containsKey(jPeak2.getMz())) {
                        peakBuilder.append(jPeak2.getMz());
                        peakBuilder.append("\t" + frags.get(jPeak2.getMz()) + "\t");
                        peakBuilder.append(jPeak2.getIntensity());
                        peakBuilder.append("\n");
                        System.out.println(jSpectrum.getSpectrumTitle() + "\t" + frags.get(jPeak2.getMz()) + "\t" + jPeak2.getMz());
                        continue;
                    }
                    peakBuilder.append(jPeak2.getMz());
                    peakBuilder.append("\tNA\t");
                    peakBuilder.append(jPeak2.getIntensity());
                    peakBuilder.append("\n");
                }
            } else {
                for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                    jPeak = jSpectrum.getPeaks().get(i);
                    peakBuilder.append(jPeak.getMz());
                    peakBuilder.append("\tNA\t");
                    peakBuilder.append(jPeak.getIntensity());
                    peakBuilder.append("\n");
                }
            }
            bWriter.write(peakBuilder.toString() + "\n");
            bWriter.close();
            for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                jPeak = jSpectrum.getPeaks().get(i);
                jPeak.setID(String.valueOf(jPeak.getMz()));
                if (chargeDeconv.booleanValue()) continue;
                jPeak.setMz(jPeak.getMz() * (double)jPeak.getCharge() - (double)(jPeak.getCharge() - 1) * ElementaryIon.proton.getTheoreticMass());
            }
            ArrayList<JPeakPair> jPeakPairs = pCleanMainClass.findPeakPair(jSpectrum, labelMethod);
            StringBuilder edgeStrBuilder = new StringBuilder();
            edgeStrBuilder.append("From\tTo\tmass1\tmass2\tcharge1\tcharge2\tmztol\tdelta\tdeltaName\tintensity\n");
            for (JPeakPair jpp : jPeakPairs) {
                edgeStrBuilder.append(jpp.print());
                edgeStrBuilder.append("\n");
            }
            String edgefile = outdir + "/" + outprefix + "_edge.txt";
            BufferedWriter edgeWriter = new BufferedWriter(new FileWriter(new File(edgefile)));
            edgeWriter.write(edgeStrBuilder.toString());
            edgeWriter.close();
            logStrBuilder.append(outprefix + "\t" + spectrum.getSpectrumTitle() + "\t" + edgefile + "\t" + peakfile + "\t" + spectrum.getPrecursor().getMz() + "\t" + spectrum.getPrecursor().getIntensity() + "\t" + ch + "\n");
        }
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(new File(outlog)));
        logWriter.write(logStrBuilder.toString());
        logWriter.close();
    }

    private static void doParseDat23(String mgf, String outdir, String outlog, Boolean imonFilter, Boolean isoReduction, Boolean chargeDeconv, Boolean ionsMerge, Boolean largerThanPrecursor, String dat) throws IOException, MzMLUnmarshallerException {
        MascotDatparser mascotDatparser = new MascotDatparser();
        ArrayList<SpectrumAnnotationContainer> dpsms = mascotDatparser.fragAnnotation(dat);
        HashMap<String, SpectrumAnnotationContainer> psmMap = new HashMap<String, SpectrumAnnotationContainer>();
        for (SpectrumAnnotationContainer psm : dpsms) {
            psmMap.put(psm.getSpectrumID(), psm);
        }
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        spectrumFactory.addSpectra(mgfFile, null);
        StringBuilder logStrBuilder = new StringBuilder();
        logStrBuilder.append("index\ttitle\tedge\tvertex\tmz\tintensity\tcharge\n");
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            JPeak jPeak;
            String outprefix = "spectrum" + k;
            String peakfile = outdir + "/" + outprefix + "_peak.txt";
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(peakfile)));
            bWriter.write("name\ttype\tintensity\n");
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            if (imonFilter.booleanValue()) {
                jSpectrum.removeImmoniumIons();
            }
            jSpectrum.sortPeaksByMZ();
            jSpectrum.module2(isoReduction, chargeDeconv, ionsMerge, largerThanPrecursor);
            jSpectrum.sortPeaksByMZ();
            StringBuilder peakBuilder = new StringBuilder();
            if (psmMap.containsKey(jSpectrum.getSpectrumTitle())) {
                SpectrumAnnotationContainer psm = (SpectrumAnnotationContainer)psmMap.get(jSpectrum.getSpectrumTitle());
                HashMap<Double, String> frags = psm.getFragannotation();
                for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                    JPeak jPeak2 = jSpectrum.getPeaks().get(i);
                    if (frags.containsKey(jPeak2.getMz())) {
                        peakBuilder.append(jPeak2.getMz());
                        peakBuilder.append("\t" + frags.get(jPeak2.getMz()) + "\t");
                        peakBuilder.append(jPeak2.getIntensity());
                        peakBuilder.append("\n");
                        System.out.println(jSpectrum.getSpectrumTitle() + "\t" + frags.get(jPeak2.getMz()) + "\t" + jPeak2.getMz());
                        continue;
                    }
                    peakBuilder.append(jPeak2.getMz());
                    peakBuilder.append("\tNA\t");
                    peakBuilder.append(jPeak2.getIntensity());
                    peakBuilder.append("\n");
                }
            } else {
                for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                    jPeak = jSpectrum.getPeaks().get(i);
                    peakBuilder.append(jPeak.getMz());
                    peakBuilder.append("\tNA\t");
                    peakBuilder.append(jPeak.getIntensity());
                    peakBuilder.append("\n");
                }
            }
            bWriter.write(peakBuilder.toString() + "\n");
            bWriter.close();
            for (int i = 0; i < jSpectrum.getPeaks().size(); ++i) {
                jPeak = jSpectrum.getPeaks().get(i);
                jPeak.setID(String.valueOf(jPeak.getMz()));
                if (chargeDeconv.booleanValue()) continue;
                jPeak.setMz(jPeak.getMz() * (double)jPeak.getCharge() - (double)(jPeak.getCharge() - 1) * ElementaryIon.proton.getTheoreticMass());
            }
            ArrayList<JPeakPair> jPeakPairs = pCleanMainClass.findPeakPair(jSpectrum, null);
            StringBuilder edgeStrBuilder = new StringBuilder();
            edgeStrBuilder.append("From\tTo\tmass1\tmass2\tcharge1\tcharge2\tmztol\tdelta\tdeltaName\tintensity\n");
            for (JPeakPair jpp : jPeakPairs) {
                edgeStrBuilder.append(jpp.print());
                edgeStrBuilder.append("\n");
            }
            String edgefile = outdir + "/" + outprefix + "_edge.txt";
            BufferedWriter edgeWriter = new BufferedWriter(new FileWriter(new File(edgefile)));
            edgeWriter.write(edgeStrBuilder.toString());
            edgeWriter.close();
            logStrBuilder.append(outprefix + "\t" + spectrum.getSpectrumTitle() + "\t" + edgefile + "\t" + peakfile + "\t" + spectrum.getPrecursor().getMz() + "\t" + spectrum.getPrecursor().getIntensity() + "\t" + ch + "\n");
        }
        BufferedWriter logWriter = new BufferedWriter(new FileWriter(new File(outlog)));
        logWriter.write(logStrBuilder.toString());
        logWriter.close();
    }

    private static ArrayList<JPeakPair> findPeakPair(JSpectrum jSpectrum, String labelMethod) {
        ArrayList<JPeakPair> jPeakPairList = new ArrayList<JPeakPair>();
        DeltaMassDB deltaMassDB = new DeltaMassDB(labelMethod);
        deltaMassDB.init();
        jSpectrum.sortPeaksByMZ();
        int npeaks = jSpectrum.getPeaks().size();
        HashSet<String> usedPeak = new HashSet<String>();
        HashSet<String> findPairs = new HashSet<String>();
        for (int i = 0; i < npeaks; ++i) {
            JPeak jPeak = jSpectrum.getPeaks().get(i);
            double mz = jPeak.getMz();
            String pID = jPeak.getID();
            if (usedPeak.contains(pID)) continue;
            for (int j = i; j < npeaks; ++j) {
                if (i == j) continue;
                double mzNext = jSpectrum.getPeaks().get(j).getMz();
                String pID2 = jSpectrum.getPeaks().get(j).getID();
                if (pID.equals(pID2)) continue;
                double delta2parent = Math.abs(mz + mzNext - 2.0 - jSpectrum.getParentMass());
                if (delta2parent <= 2.0 * Config.ms2tol) {
                    double sumInt = jPeak.getIntensity() + jSpectrum.getPeaks().get(j).getIntensity();
                    if (Double.valueOf(pID) >= Double.valueOf(pID2)) {
                        if (findPairs.contains(pID2 + ";" + pID)) continue;
                        findPairs.add(pID2 + ";" + pID);
                    } else {
                        if (findPairs.contains(pID + ";" + pID2)) continue;
                        findPairs.add(pID + ";" + pID2);
                    }
                    JPeakPair jPeakPair = new JPeakPair();
                    jPeakPair.setFrom(pID);
                    jPeakPair.setTo(pID2);
                    jPeakPair.mass1 = mz;
                    jPeakPair.mass2 = mzNext;
                    jPeakPair.charge1 = jPeak.getCharge();
                    jPeakPair.charge2 = jSpectrum.getPeaks().get(j).getCharge();
                    jPeakPair.delta = delta2parent;
                    jPeakPair.mzdelta = delta2parent;
                    jPeakPair.deltaName = "Parent";
                    jPeakPair.intensity = sumInt;
                    jPeakPairList.add(jPeakPair);
                    usedPeak.add(pID);
                    continue;
                }
                ArrayList<PMass> matchPMass = deltaMassDB.searchDB(Math.abs(mz - mzNext), Config.ms2tol, 2);
                if (matchPMass.size() == 1) {
                    double sumInt = jPeak.getIntensity() + jSpectrum.getPeaks().get(j).getIntensity();
                    if (Double.valueOf(pID) >= Double.valueOf(pID2)) {
                        if (findPairs.contains(pID2 + ";" + pID)) continue;
                        findPairs.add(pID2 + ";" + pID);
                    } else {
                        if (findPairs.contains(pID + ";" + pID2)) continue;
                        findPairs.add(pID + ";" + pID2);
                    }
                    JPeakPair jPeakPair = new JPeakPair();
                    jPeakPair.setFrom(pID);
                    jPeakPair.setTo(pID2);
                    jPeakPair.mass1 = mz;
                    jPeakPair.mass2 = mzNext;
                    jPeakPair.charge1 = jPeak.getCharge();
                    jPeakPair.charge2 = jSpectrum.getPeaks().get(j).getCharge();
                    jPeakPair.delta = matchPMass.get((int)0).deltaMZ;
                    jPeakPair.mzdelta = matchPMass.get((int)0).mzTol;
                    jPeakPair.deltaName = matchPMass.get((int)0).name;
                    jPeakPair.intensity = sumInt;
                    jPeakPairList.add(jPeakPair);
                    usedPeak.add(pID);
                    continue;
                }
                if (!matchPMass.isEmpty() && matchPMass.size() > 1) {
                    double sumInt = jPeak.getIntensity() + jSpectrum.getPeaks().get(j).getIntensity();
                    if (Double.valueOf(pID) >= Double.valueOf(pID2)) {
                        if (findPairs.contains(pID2 + ";" + pID)) continue;
                        findPairs.add(pID2 + ";" + pID);
                    } else {
                        if (findPairs.contains(pID + ";" + pID2)) continue;
                        findPairs.add(pID + ";" + pID2);
                    }
                    double deltaTmp = matchPMass.get((int)0).deltaMZ;
                    double mzdeltaTmp = matchPMass.get((int)0).mzTol;
                    String deltaNameTmp = matchPMass.get((int)0).name;
                    for (PMass pm : matchPMass) {
                        if (pm.name.length() != 1) continue;
                        deltaTmp = pm.deltaMZ;
                        mzdeltaTmp = pm.mzTol;
                        deltaNameTmp = pm.name;
                    }
                    JPeakPair jPeakPair = new JPeakPair();
                    jPeakPair.setFrom(pID);
                    jPeakPair.setTo(pID2);
                    jPeakPair.mass1 = mz;
                    jPeakPair.mass2 = mzNext;
                    jPeakPair.charge1 = jPeak.getCharge();
                    jPeakPair.charge2 = jSpectrum.getPeaks().get(j).getCharge();
                    jPeakPair.delta = deltaTmp;
                    jPeakPair.mzdelta = mzdeltaTmp;
                    jPeakPair.deltaName = deltaNameTmp;
                    jPeakPair.intensity = sumInt;
                    jPeakPairList.add(jPeakPair);
                    usedPeak.add(pID);
                    continue;
                }
                ArrayList<PMass> matchPMass2 = deltaMassDB.searchDB(delta2parent, Config.ms2tol, 2);
                if (matchPMass2.isEmpty() || matchPMass2.size() < 1) continue;
                double sumInt = jPeak.getIntensity() + jSpectrum.getPeaks().get(j).getIntensity();
                if (Double.valueOf(pID) >= Double.valueOf(pID2)) {
                    if (findPairs.contains(pID2 + ";" + pID)) continue;
                    findPairs.add(pID2 + ";" + pID);
                } else {
                    if (findPairs.contains(pID + ";" + pID2)) continue;
                    findPairs.add(pID + ";" + pID2);
                }
                String deltaName = "Parent-" + matchPMass2.get((int)0).name;
                JPeakPair jPeakPair = new JPeakPair();
                jPeakPair.setFrom(pID);
                jPeakPair.setTo(pID2);
                jPeakPair.mass1 = mz;
                jPeakPair.mass2 = mzNext;
                jPeakPair.charge1 = jPeak.getCharge();
                jPeakPair.charge2 = jSpectrum.getPeaks().get(j).getCharge();
                jPeakPair.delta = matchPMass2.get((int)0).deltaMZ;
                jPeakPair.mzdelta = matchPMass2.get((int)0).mzTol;
                jPeakPair.deltaName = deltaName;
                jPeakPair.intensity = sumInt;
                jPeakPairList.add(jPeakPair);
                usedPeak.add(pID);
            }
        }
        return jPeakPairList;
    }

    private static void doPrecursorIsotopesTest(String mgf, String outdir, Boolean b) throws IOException, MzMLUnmarshallerException {
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        File mgfFile = new File(mgf);
        spectrumFactory.addSpectra(mgfFile, null);
        String outmgf = outdir + "/precursorIsotope_" + mgfFile.getName();
        BufferedWriter bwmgf = new BufferedWriter(new FileWriter(new File(outmgf)));
        ArrayList tList = spectrumFactory.getSpectrumTitles(mgfFile.getName());
        for (int k = 0; k < tList.size(); ++k) {
            String outprefix = "spectrum" + k;
            MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(mgfFile.getName(), (String)tList.get(k));
            JSpectrum jSpectrum = new JSpectrum();
            Integer ch = ((Charge)spectrum.getPrecursor().getPossibleCharges().get((int)0)).value;
            jSpectrum.setParentMass(spectrum.getPrecursor().getMassPlusProton(ch.intValue()));
            jSpectrum.setParentMassToCharge(spectrum.getPrecursor().getMz());
            jSpectrum.setCharge(ch);
            jSpectrum.setSpectrumTitle(spectrum.getSpectrumTitle());
            jSpectrum.setIntensity(spectrum.getPrecursor().getIntensity());
            jSpectrum.setRt(spectrum.getPrecursor().getRt());
            for (Peak p : spectrum.getPeakList()) {
                if (b.booleanValue()) {
                    Boolean q = true;
                    for (double preciso : jSpectrum.predictPrecEnvelope()) {
                        if (!(Config.delta(p.getMz(), preciso) < Config.ms2tol)) continue;
                        System.out.println(jSpectrum.getSpectrumTitle() + "\t" + preciso);
                        q = false;
                        break;
                    }
                    if (!q.booleanValue()) continue;
                    JPeak jPeak = new JPeak(p.getMz(), p.getIntensity());
                    jSpectrum.addRawPeak(jPeak);
                    continue;
                }
                JPeak jPeak = new JPeak(p.getMz(), p.getIntensity());
                jSpectrum.addRawPeak(jPeak);
            }
            jSpectrum.resetPeaks();
            jSpectrum.sortPeaksByMZ();
            StringBuilder sb = jSpectrum.toMgf();
            bwmgf.write(sb.toString());
        }
        bwmgf.close();
    }
}

