/*
 * Decompiled with CFR 0.152.
 */
package org.jsuffixarrays;

import java.util.Arrays;
import org.jsuffixarrays.ISuffixArrayBuilder;
import org.jsuffixarrays.MinMax;
import org.jsuffixarrays.Tools;

public class DeepShallow
implements ISuffixArrayBuilder {
    static final int OVERSHOOT = 575;
    private static final int SETMASK = 0x40000000;
    private static final int CLEARMASK = -1073741825;
    private static final int MARKER = Integer.MIN_VALUE;
    private static final int MK_QS_TRESH = 20;
    private static final int MAX_TRESH = 30;
    private static final int SHALLOW_LIMIT = 550;
    private static final int MAX_PSEUDO_ANCHOR_OFFSET = 0;
    private static final int B2G_RATIO = 1000;
    private static final boolean UPDATE_ANCHOR_RANKS = false;
    private static final int BLIND_SORT_RATIO = 2000;
    private static final int STACK_SIZE = 100;
    private int[] text;
    private int textSize;
    private int[] suffixArray;
    private int anchorDist;
    private int anchorNum;
    private int[] anchorOffset;
    private int[] anchorRank;
    private final int[] ftab = new int[66049];
    private final int[] bucketRanked = new int[66049];
    private final int[] runningOrder = new int[257];
    private final int[] lcpAux = new int[31];
    private int lcp;
    private int cmpLeft;
    private int cmpDone;
    private int aux;
    private int auxWritten;
    private int stackSize;
    private Node[] stack;
    private int start;
    private final boolean preserveInput;

    public DeepShallow() {
        this.preserveInput = true;
    }

    public DeepShallow(boolean preserveInput) {
        this.preserveInput = preserveInput;
    }

    @Override
    public int[] buildSuffixArray(int[] input, int start, int length) {
        int j;
        int c2;
        int i;
        Tools.assertAlways(input.length >= start + length, "Input array is too short");
        MinMax mm = Tools.minmax(input, start, length);
        Tools.assertAlways(mm.min >= 0, "input must not be negative");
        Tools.assertAlways(mm.max < 256, "max alphabet size is 256");
        this.lcp = 1;
        this.stack = new Node[length];
        this.start = start;
        if (this.preserveInput) {
            this.start = 0;
            this.text = new int[length + 575];
            System.arraycopy(input, start, this.text, 0, length);
        } else {
            Tools.assertAlways(input.length >= start + length + 575, "Input array length must have a trailing space of at least 575 bytes.");
            this.text = input;
        }
        for (i = length; i < length + 575; ++i) {
            this.text[this.start + i] = 0;
        }
        this.textSize = length;
        this.suffixArray = new int[length];
        int numQSorted = 0;
        boolean[] bigDone = new boolean[257];
        int[] copyStart = new int[257];
        int[] copyEnd = new int[257];
        if (this.anchorDist == 0) {
            this.anchorNum = 0;
        } else {
            this.anchorNum = 2 + (length - 1) / this.anchorDist;
            this.anchorRank = new int[this.anchorNum];
            this.anchorOffset = new int[this.anchorNum];
            for (i = 0; i < this.anchorNum; ++i) {
                this.anchorRank[i] = -1;
                this.anchorOffset[i] = this.anchorDist;
            }
        }
        for (i = 0; i < 66049; ++i) {
            this.ftab[i] = 0;
        }
        int c1 = this.text[this.start + 0];
        for (i = 1; i <= this.textSize; ++i) {
            c2 = this.text[this.start + i];
            int n = (c1 << 8) + c2;
            this.ftab[n] = this.ftab[n] + 1;
            c1 = c2;
        }
        for (i = 1; i < 66049; ++i) {
            int n = i;
            this.ftab[n] = this.ftab[n] + this.ftab[i - 1];
        }
        c1 = this.text[this.start + 0];
        i = 0;
        while (i < this.textSize) {
            c2 = this.text[this.start + i + 1];
            j = (c1 << 8) + c2;
            c1 = c2;
            int n = j;
            this.ftab[n] = this.ftab[n] - 1;
            this.suffixArray[this.ftab[j]] = i++;
        }
        this.calculateRunningOrder();
        for (i = 0; i < 257; ++i) {
            bigDone[i] = false;
        }
        for (i = 0; i <= 256; ++i) {
            int k;
            int ss = this.runningOrder[i];
            for (j = 0; j <= 256; ++j) {
                int lo;
                int hi;
                if (j == ss) continue;
                int sb = (ss << 8) + j;
                if ((this.ftab[sb] & 0x40000000) == 0 && (hi = (this.ftab[sb + 1] & 0xBFFFFFFF) - 1) > (lo = this.ftab[sb] & 0xBFFFFFFF)) {
                    this.shallowSort(lo, hi - lo + 1);
                    numQSorted += hi - lo + 1;
                }
                int n = sb;
                this.ftab[n] = this.ftab[n] | 0x40000000;
            }
            for (j = 0; j <= 256; ++j) {
                copyStart[j] = this.ftab[(j << 8) + ss] & 0xBFFFFFFF;
                copyEnd[j] = (this.ftab[(j << 8) + ss + 1] & 0xBFFFFFFF) - 1;
            }
            if (ss == 0 && !bigDone[c1 = this.text[this.start + (k = this.textSize - 1)]]) {
                int n = c1;
                int n2 = copyStart[n];
                copyStart[n] = n2 + 1;
                this.suffixArray[n2] = k;
            }
            for (j = this.ftab[ss << 8] & 0xBFFFFFFF; j < copyStart[ss]; ++j) {
                k = this.suffixArray[j] - 1;
                if (k < 0 || bigDone[c1 = this.text[this.start + k]]) continue;
                int n = c1;
                int n3 = copyStart[n];
                copyStart[n] = n3 + 1;
                this.suffixArray[n3] = k;
            }
            for (j = (this.ftab[ss + 1 << 8] & 0xBFFFFFFF) - 1; j > copyEnd[ss]; --j) {
                k = this.suffixArray[j] - 1;
                if (k < 0 || bigDone[c1 = this.text[this.start + k]]) continue;
                int n = c1;
                int n4 = copyEnd[n];
                copyEnd[n] = n4 - 1;
                this.suffixArray[n4] = k;
            }
            for (j = 0; j <= 256; ++j) {
                int n = (j << 8) + ss;
                this.ftab[n] = this.ftab[n] | 0x40000000;
            }
            bigDone[ss] = true;
        }
        return this.suffixArray;
    }

    private void shallowSort(int a, int n) {
        this.shallowMkq32(a, n, 2);
    }

    private void shallowMkq32(int a, int n, int text_depth) {
        int next_depth;
        int pa = 0;
        int pb = 0;
        int pc = 0;
        int pd = 0;
        int pl = 0;
        int pm = 0;
        int pn = 0;
        boolean repeatFlag = true;
        if (n < 20) {
            this.shallowInssortLcp(a, n, text_depth);
            return;
        }
        while (repeatFlag) {
            repeatFlag = false;
            pl = a;
            pm = a + n / 2;
            pn = a + (n - 1);
            if (n > 30) {
                int d = n / 8;
                pl = this.med3(pl, pl + d, pl + 2 * d, text_depth);
                pm = this.med3(pm - d, pm, pm + d, text_depth);
                pn = this.med3(pn - 2 * d, pn - d, pn, text_depth);
            }
            pm = this.med3(pl, pm, pn, text_depth);
            this.swap2(a, pm);
            int partval = this.ptr2char32(a, text_depth);
            pa = pb = a + 1;
            pc = pd = a + n - 1;
            while (true) {
                int val;
                if (pb <= pc && (val = this.ptr2char32(pb, text_depth)) <= partval) {
                    if (val == partval) {
                        this.swap2(pa, pb);
                        ++pa;
                    }
                    ++pb;
                    continue;
                }
                while (pb <= pc && (val = this.ptr2char32(pc, text_depth)) >= partval) {
                    if (val == partval) {
                        this.swap2(pc, pd);
                        --pd;
                    }
                    --pc;
                }
                if (pb > pc) break;
                this.swap2(pb, pc);
                ++pb;
                --pc;
            }
            if (pa <= pd) continue;
            next_depth = text_depth + 4;
            if (next_depth >= 550) {
                this.helpedSort(a, n, next_depth);
                return;
            }
            text_depth = next_depth;
            repeatFlag = true;
        }
        pn = a + n;
        int r = DeepShallow.min(pa - a, pb - pa);
        this.vecswap2(a, pb - r, r);
        r = DeepShallow.min(pd - pc, pn - pd - 1);
        this.vecswap2(pb, pn - r, r);
        r = pb - pa;
        if (r > 1) {
            this.shallowMkq32(a, r, text_depth);
        }
        if ((next_depth = text_depth + 4) < 550) {
            this.shallowMkq32(a + r, pa - pd + n - 1, next_depth);
        } else {
            this.helpedSort(a + r, pa - pd + n - 1, next_depth);
        }
        r = pd - pc;
        if (r > 1) {
            this.shallowMkq32(a + n - r, r, text_depth);
        }
    }

    private void vecswap2(int a, int b, int n) {
        while (n-- > 0) {
            int t = this.suffixArray[a];
            this.suffixArray[a++] = this.suffixArray[b];
            this.suffixArray[b++] = t;
        }
    }

    private static int min(int i, int j) {
        return i < j ? i : j;
    }

    private void shallowInssortLcp(int a, int n, int text_depth) {
        int j;
        int i;
        this.lcpAux[0] = -1;
        for (i = 0; i < n; ++i) {
            this.lcpAux[this.lcp + i] = 0;
        }
        int cmp_from_limit = 550 - text_depth;
        for (i = 1; i < n; ++i) {
            int ai = this.suffixArray[a + i];
            int lcpi = 0;
            int text_depth_ai = ai + text_depth;
            j = i;
            int j1 = j - 1;
            do {
                this.cmpLeft = cmp_from_limit - lcpi;
                int r = this.cmpUnrolledShallowLcp(lcpi + this.suffixArray[a + j1] + text_depth, lcpi + text_depth_ai);
                int lcp_new = cmp_from_limit - this.cmpLeft;
                assert (r != 0 || lcp_new >= cmp_from_limit);
                if (r <= 0) {
                    this.lcpAux[this.lcp + j1] = lcp_new;
                    break;
                }
                lcpi = lcp_new;
                do {
                    this.suffixArray[a + j] = this.suffixArray[a + j1];
                    this.lcpAux[this.lcp + j] = this.lcpAux[this.lcp + j1];
                    j = j1--;
                } while (lcpi < this.lcpAux[this.lcp + j1]);
            } while (lcpi <= this.lcpAux[this.lcp + j1]);
            this.suffixArray[a + j] = ai;
            this.lcpAux[this.lcp + j] = lcpi;
        }
        i = 0;
        while (i < n - 1) {
            for (j = i; j < n && this.lcpAux[this.lcp + j] >= cmp_from_limit; ++j) {
            }
            if (j - i > 0) {
                this.helpedSort(a + i, j - i + 1, 550);
            }
            i = j + 1;
        }
    }

    private int cmpUnrolledShallowLcp(int b1, int b2) {
        do {
            int c2;
            int c1;
            if ((c1 = this.text[this.start + b1]) != (c2 = this.text[this.start + b2])) {
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                --this.cmpLeft;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 2;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 3;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 4;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 5;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 6;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 7;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 8;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 9;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 10;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 11;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 12;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 13;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 14;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpLeft -= 15;
                return c1 - c2;
            }
            ++b1;
            ++b2;
            this.cmpLeft -= 16;
        } while (this.cmpLeft > 0);
        return 0;
    }

    private void helpedSort(int a, int n, int depth) {
        int i;
        if (n == 1) {
            return;
        }
        if (this.anchorDist == 0) {
            this.pseudoOrDeepSort(a, n, depth);
            return;
        }
        int curr_sb = this.getSmallBucket(this.suffixArray[a]);
        int min_forw_offset_buc = Integer.MAX_VALUE;
        int min_forw_offset = Integer.MAX_VALUE;
        int max_back_offset = Integer.MIN_VALUE;
        int best_back_anchor = -1;
        int best_forw_anchor_buc = -1;
        int best_forw_anchor = -1;
        int back_anchor_index = -1;
        int forw_anchor_index_buc = -1;
        int forw_anchor_index = -1;
        for (i = 0; i < n; ++i) {
            int text_pos = this.suffixArray[a + i];
            int anchor = text_pos / this.anchorDist;
            int toffset = text_pos % this.anchorDist;
            int aoffset = this.anchorOffset[anchor];
            if (aoffset >= this.anchorDist) continue;
            int diff = aoffset - toffset;
            if (diff > 0) {
                if (curr_sb != this.getSmallBucket(text_pos + diff)) {
                    if (diff >= min_forw_offset) continue;
                    min_forw_offset = diff;
                    best_forw_anchor = anchor;
                    forw_anchor_index = i;
                    continue;
                }
                if (diff >= min_forw_offset_buc) continue;
                min_forw_offset_buc = diff;
                best_forw_anchor_buc = anchor;
                forw_anchor_index_buc = i;
                continue;
            }
            if (diff > max_back_offset) {
                max_back_offset = diff;
                best_back_anchor = anchor;
                back_anchor_index = i;
            }
            if ((aoffset = this.anchorOffset[++anchor]) >= this.anchorDist) continue;
            diff = this.anchorDist + aoffset - toffset;
            assert (diff > 0);
            if (curr_sb != this.getSmallBucket(text_pos + diff)) {
                if (diff >= min_forw_offset) continue;
                min_forw_offset = diff;
                best_forw_anchor = anchor;
                forw_anchor_index = i;
                continue;
            }
            if (diff >= min_forw_offset_buc) continue;
            min_forw_offset_buc = diff;
            best_forw_anchor_buc = anchor;
            forw_anchor_index_buc = i;
        }
        if (best_forw_anchor >= 0 && min_forw_offset < depth - 1) {
            int anchor_pos = this.suffixArray[a + forw_anchor_index] + min_forw_offset;
            int anchor_rank = this.anchorRank[best_forw_anchor];
            this.generalAnchorSort(a, n, anchor_pos, anchor_rank, min_forw_offset);
            if (this.anchorDist > 0) {
                this.updateAnchors(a, n);
            }
            return;
        }
        boolean fail = false;
        if (best_back_anchor >= 0) {
            for (i = 0; i < n; ++i) {
                if (this.suffixArray[a + i] + max_back_offset >= 0) continue;
                fail = true;
            }
            int T0 = this.suffixArray[a];
            for (i = 1; i < n; ++i) {
                int Ti = this.suffixArray[a + i];
                for (int j = max_back_offset; j <= -1; ++j) {
                    if (this.text[this.start + T0 + j] == this.text[this.start + Ti + j]) continue;
                    fail = true;
                }
            }
            if (!fail) {
                int anchor_pos = this.suffixArray[a + back_anchor_index] + max_back_offset;
                int anchor_rank = this.anchorRank[best_back_anchor];
                this.generalAnchorSort(a, n, anchor_pos, anchor_rank, max_back_offset);
                if (this.anchorDist > 0) {
                    this.updateAnchors(a, n);
                }
                return;
            }
        }
        if (fail && best_forw_anchor_buc >= 0 && min_forw_offset_buc < depth - 1) {
            int equal = 0;
            int lower = 0;
            int upper = 0;
            int anchor_pos = this.suffixArray[a + forw_anchor_index_buc] + min_forw_offset_buc;
            int anchor_rank = this.anchorRank[best_forw_anchor_buc];
            SplitGroupResult res = this.splitGroup(a, n, depth, min_forw_offset_buc, forw_anchor_index_buc, lower);
            equal = res.equal;
            lower = res.lower;
            if (equal == n) {
                this.generalAnchorSort(a, n, anchor_pos, anchor_rank, min_forw_offset_buc);
            } else {
                upper = n - equal - lower;
                if (equal > 1) {
                    this.generalAnchorSort(a + lower, equal, anchor_pos, anchor_rank, min_forw_offset_buc);
                }
                if (lower > 1) {
                    this.pseudoOrDeepSort(a, lower, depth);
                }
                if (upper > 1) {
                    this.pseudoOrDeepSort(a + lower + equal, upper, depth);
                }
            }
            if (this.anchorDist > 0) {
                this.updateAnchors(a, n);
            }
            return;
        }
        this.pseudoOrDeepSort(a, n, depth);
    }

    private SplitGroupResult splitGroup(int a, int n, int depth, int offset, int pivot, int first) {
        int text_depth;
        int pivot_pos = this.suffixArray[a + pivot];
        int text_limit = text_depth + offset;
        int pa = a;
        int pd = a + n - 1;
        for (text_depth = depth; pa != pd && text_depth < text_limit; ++text_depth) {
            int r;
            int pd_old;
            int pa_old;
            int partval = this.text[this.start + text_depth + pivot_pos];
            int pb = pa_old = pa;
            int pc = pd_old = pd;
            while (true) {
                if (pb <= pc && (r = this.ptr2char(pb, text_depth) - partval) <= 0) {
                    if (r == 0) {
                        this.swap2(pa, pb);
                        ++pa;
                    }
                    ++pb;
                    continue;
                }
                while (pb <= pc && (r = this.ptr2char(pc, text_depth) - partval) >= 0) {
                    if (r == 0) {
                        this.swap2(pc, pd);
                        --pd;
                    }
                    --pc;
                }
                if (pb > pc) break;
                this.swap2(pb, pc);
                ++pb;
                --pc;
            }
            r = DeepShallow.min(pa - pa_old, pb - pa);
            this.vecswap2(pa_old, pb - r, r);
            r = DeepShallow.min(pd - pc, pd_old - pd);
            this.vecswap2(pb, pd_old + 1 - r, r);
            pa = pa_old + (pb - pa);
            pd = pd_old - (pd - pc);
        }
        first = pa - a;
        return new SplitGroupResult(pd - pa + 1, first);
    }

    private void updateAnchors(int a, int n) {
        for (int i = 0; i < n; ++i) {
            int text_pos = this.suffixArray[a + i];
            int toffset = text_pos % this.anchorDist;
            int anchor = text_pos / this.anchorDist;
            int aoffset = this.anchorOffset[anchor];
            if (toffset >= aoffset) continue;
            this.anchorOffset[anchor] = toffset;
            this.anchorRank[anchor] = a + i;
        }
    }

    private void generalAnchorSort(int a, int n, int anchor_pos, int anchor_rank, int offset) {
        int curr_lo;
        int sb = this.getSmallBucket(anchor_pos);
        int lo = this.bucketFirst(sb);
        int hi = this.bucketLast(sb);
        Arrays.sort(this.suffixArray, a, a + n);
        int curr_hi = curr_lo = anchor_rank;
        this.mark(curr_lo);
        int to_be_found = n - 1;
        while (to_be_found > 0) {
            int item;
            int ris;
            assert (curr_lo > lo || curr_hi < hi);
            while (curr_lo > lo && (ris = Arrays.binarySearch(this.suffixArray, a, a + n, item = this.suffixArray[--curr_lo] - offset)) != 0) {
                this.mark(curr_lo);
                --to_be_found;
            }
            while (curr_hi < hi && (ris = Arrays.binarySearch(this.suffixArray, a, a + n, item = this.suffixArray[++curr_hi] - offset)) != 0) {
                this.mark(curr_hi);
                --to_be_found;
            }
        }
        int j = 0;
        for (int i = curr_lo; i <= curr_hi; ++i) {
            if (!this.isMarked(i)) continue;
            this.unmark(i);
            this.suffixArray[a + j++] = this.suffixArray[i] - offset;
        }
    }

    private void unmark(int i) {
        int n = i;
        this.suffixArray[n] = this.suffixArray[n] & Integer.MAX_VALUE;
    }

    private boolean isMarked(int i) {
        return (this.suffixArray[i] & Integer.MIN_VALUE) != 0;
    }

    private void mark(int i) {
        int n = i;
        this.suffixArray[n] = this.suffixArray[n] | Integer.MIN_VALUE;
    }

    private int bucketLast(int sb) {
        return (this.ftab[sb + 1] & 0xBFFFFFFF) - 1;
    }

    private int bucketFirst(int sb) {
        return this.ftab[sb] & 0xBFFFFFFF;
    }

    private int bucketSize(int sb) {
        return (this.ftab[sb + 1] & 0xBFFFFFFF) - (this.ftab[sb] & 0xBFFFFFFF);
    }

    private int getSmallBucket(int pos) {
        return (this.text[this.start + pos] << 8) + this.text[this.start + pos + 1];
    }

    private void pseudoOrDeepSort(int a, int n, int depth) {
        this.deepSort(a, n, depth);
    }

    private boolean isSortedBucket(int sb) {
        return (this.ftab[sb] & 0x40000000) != 0;
    }

    private void deepSort(int a, int n, int depth) {
        int blind_limit = this.textSize / 2000;
        if (n <= blind_limit) {
            this.blindSsort(a, n, depth);
        } else {
            this.qsUnrolledLcp(a, n, depth, blind_limit);
        }
    }

    private void qsUnrolledLcp(int a, int n, int depth, int blind_limit) {
        int[] stack_lo = new int[100];
        int[] stack_hi = new int[100];
        int[] stack_d = new int[100];
        int sp = 0;
        int r = 0;
        stack_lo[sp] = 0;
        stack_hi[sp] = n - 1;
        stack_d[sp] = depth;
        ++sp;
        while (sp > 0) {
            assert (sp < 100);
            int lo = stack_lo[--sp];
            int hi = stack_hi[sp];
            int text_depth = depth = stack_d[sp];
            if (hi - lo < blind_limit) {
                this.blindSsort(a + lo, hi - lo + 1, depth);
                continue;
            }
            int r3 = (r = (r * 7621 + 1) % 32768) % 3;
            int med = r3 == 0 ? lo : (r3 == 1 ? lo + hi >> 1 : hi);
            this.swap(med, hi, a);
            int text_pos_pivot = text_depth + this.suffixArray[a + hi];
            int i = lo - 1;
            int j = hi;
            int lcp_hi = Integer.MAX_VALUE;
            int lcp_lo = Integer.MAX_VALUE;
            while (true) {
                int ris;
                if (++i < hi) {
                    ris = this.cmpUnrolledLcp(text_depth + this.suffixArray[a + i], text_pos_pivot);
                    if (ris > 0) {
                        if (this.cmpDone < lcp_hi) {
                            lcp_hi = this.cmpDone;
                        }
                    } else {
                        if (this.cmpDone >= lcp_lo) continue;
                        lcp_lo = this.cmpDone;
                        continue;
                    }
                }
                while (--j > lo) {
                    ris = this.cmpUnrolledLcp(text_depth + this.suffixArray[a + j], text_pos_pivot);
                    if (ris < 0) {
                        if (this.cmpDone >= lcp_lo) break;
                        lcp_lo = this.cmpDone;
                        break;
                    }
                    if (this.cmpDone >= lcp_hi) continue;
                    lcp_hi = this.cmpDone;
                }
                if (i >= j) break;
                this.swap(i, j, a);
            }
            this.swap(i, hi, a);
            if (i - lo < hi - i) {
                stack_lo[sp] = i + 1;
                stack_hi[sp] = hi;
                stack_d[sp] = depth + lcp_hi;
                ++sp;
                if (i - lo <= 1) continue;
                stack_lo[sp] = lo;
                stack_hi[sp] = i - 1;
                stack_d[sp] = depth + lcp_lo;
                ++sp;
                continue;
            }
            stack_lo[sp] = lo;
            stack_hi[sp] = i - 1;
            stack_d[sp] = depth + lcp_lo;
            ++sp;
            if (hi - i <= 1) continue;
            stack_lo[sp] = i + 1;
            stack_hi[sp] = hi;
            stack_d[sp] = depth + lcp_hi;
            ++sp;
        }
    }

    private int cmpUnrolledLcp(int b1, int b2) {
        this.cmpDone = 0;
        do {
            int c2;
            int c1;
            if ((c1 = this.text[this.start + b1]) != (c2 = this.text[this.start + b2])) {
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                ++this.cmpDone;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 2;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 3;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 4;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 5;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 6;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 7;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 8;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 9;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 10;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 11;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 12;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 13;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 14;
                return c1 - c2;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                this.cmpDone += 15;
                return c1 - c2;
            }
            this.cmpDone += 16;
        } while (++b1 < this.textSize && ++b2 < this.textSize);
        return b2 - b1;
    }

    private void swap(int i, int j, int a) {
        int tmp = this.suffixArray[a + i];
        this.suffixArray[a + i] = this.suffixArray[a + j];
        this.suffixArray[a + j] = tmp;
    }

    private void blindSsort(int a, int n, int depth) {
        int j;
        Arrays.sort(this.suffixArray, a, a + n);
        int left = 0;
        for (int right = n - 1; left < right; ++left, --right) {
            int temp = this.suffixArray[a + left];
            this.suffixArray[a + left] = this.suffixArray[a + right];
            this.suffixArray[a + right] = temp;
        }
        for (j = 0; j < n && this.suffixArray[a + j] + depth >= this.textSize; ++j) {
        }
        if (j >= n - 1) {
            return;
        }
        Node nh = new Node();
        nh.skip = -1;
        nh.right = null;
        nh.downInt = this.suffixArray[a + j];
        Node root = nh;
        for (int i = j + 1; i < n; ++i) {
            Node h = this.findCompanion(root, this.suffixArray[a + i]);
            int aj = h.downInt;
            int lcp = this.compareSuffixes(aj, this.suffixArray[a + i], depth);
            this.insertSuffix(root, this.suffixArray[a + i], lcp, this.text[this.start + aj + lcp]);
        }
        this.aux = a;
        this.auxWritten = j;
        this.traverseTrie(root);
    }

    private void traverseTrie(Node h) {
        if (h.skip < 0) {
            this.suffixArray[this.aux + this.auxWritten++] = h.downInt;
        } else {
            Node p = h.down;
            do {
                Node nextp;
                if ((nextp = p.right) != null && nextp.key == p.key) {
                    this.traverseTrie(nextp);
                    this.traverseTrie(p);
                    p = nextp.right;
                    continue;
                }
                this.traverseTrie(p);
                p = nextp;
            } while (p != null);
        }
    }

    private void insertSuffix(Node h, int suf, int n, int mmchar) {
        Node p;
        int s = suf;
        if (h.skip != n) {
            p = new Node();
            p.key = mmchar;
            p.skip = h.skip;
            p.down = h.down;
            p.downInt = h.downInt;
            p.right = null;
            h.skip = n;
            h.down = p;
        }
        int c = this.text[this.start + s + n];
        Node pp = h.down;
        while (pp != null && pp.key < c) {
            pp = pp.right;
        }
        p = new Node();
        p.skip = -1;
        p.key = c;
        p.right = pp;
        pp = p;
        p.downInt = suf;
    }

    private int compareSuffixes(int suf1, int suf2, int depth) {
        int s1 = depth + suf1;
        int s2 = depth + suf2;
        int limit = this.textSize - suf1 - depth;
        return depth + this.getLcpUnrolled(s1, s2, limit);
    }

    private int getLcpUnrolled(int b1, int b2, int cmp_limit) {
        int c2;
        int c1;
        int cmp2do = cmp_limit;
        while ((c1 = this.text[this.start + b1]) == (c2 = this.text[this.start + b2])) {
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                --cmp2do;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 2;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 3;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 4;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 5;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 6;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 7;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 8;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 9;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 10;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 11;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 12;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 13;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 14;
                break;
            }
            if ((c1 = this.text[this.start + ++b1]) != (c2 = this.text[this.start + ++b2])) {
                cmp2do -= 15;
                break;
            }
            ++b1;
            ++b2;
            if ((cmp2do -= 16) > 0) continue;
        }
        if (cmp_limit - cmp2do < cmp_limit) {
            return cmp_limit - cmp2do;
        }
        return cmp_limit - 1;
    }

    private Node findCompanion(Node head, int s) {
        this.stackSize = 0;
        while (head.skip >= 0) {
            this.stack[this.stackSize++] = head;
            int t = head.skip;
            if (s + t >= this.textSize) {
                return this.getLeaf(head);
            }
            int c = this.text[this.start + s + t];
            Node p = head.down;
            boolean repeat = true;
            while (repeat) {
                if (c == p.key) {
                    head = p;
                    repeat = false;
                } else if (c < p.key) {
                    return this.getLeaf(head);
                }
                if (!repeat || (p = p.right) != null) continue;
                return this.getLeaf(head);
            }
        }
        this.stack[this.stackSize++] = head;
        return head;
    }

    private Node getLeaf(Node head) {
        Tools.assertAlways(head.skip >= 0, "");
        do {
            head = head.down;
        } while (head.skip >= 0);
        return head;
    }

    private void pseudoAnchorSort(int a, int n, int pseudo_anchor_pos, int offset) {
        int pseudo_anchor_rank = this.getRank(pseudo_anchor_pos);
        assert (this.suffixArray[pseudo_anchor_rank] == pseudo_anchor_pos);
        this.generalAnchorSort(a, n, pseudo_anchor_pos, pseudo_anchor_rank, offset);
    }

    private int getRank(int pos) {
        int sb = this.getSmallBucket(pos);
        if (!this.isSortedBucket(sb)) {
            throw new RuntimeException("Illegal call to get_rank! (get_rank1)");
        }
        int lo = this.bucketFirst(sb);
        int hi = this.bucketLast(sb);
        for (int j = lo; j <= hi; ++j) {
            if (this.suffixArray[j] != pos) continue;
            return j;
        }
        throw new RuntimeException("Illegal call to get_rank! (get_rank2)");
    }

    private int getRankUpdateAnchors(int pos) {
        int sb = this.getSmallBucket(pos);
        if (!this.isSortedBucket(sb)) {
            throw new RuntimeException("Illegal call to get_rank! (get_rank_update_anchors)");
        }
        if (this.bucketRanked[sb] != 0) {
            return this.getRank(pos);
        }
        this.bucketRanked[sb] = 1;
        int rank = -1;
        int lo = this.bucketFirst(sb);
        int hi = this.bucketLast(sb);
        for (int j = lo; j <= hi; ++j) {
            int toffset = this.suffixArray[j] % this.anchorDist;
            int anchor = this.suffixArray[j] / this.anchorDist;
            int aoffset = this.anchorOffset[anchor];
            if (toffset < aoffset) {
                this.anchorOffset[anchor] = toffset;
                this.anchorRank[anchor] = j;
            }
            if (this.suffixArray[j] != pos) continue;
            assert (rank == -1);
            rank = j;
        }
        assert (rank >= 0);
        return rank;
    }

    private void swap2(int a, int b) {
        int tmp = this.suffixArray[a];
        this.suffixArray[a] = this.suffixArray[b];
        this.suffixArray[b] = tmp;
    }

    private int ptr2char32(int a, int depth) {
        return this.getword32(this.suffixArray[a] + depth);
    }

    private int getword32(int s) {
        return this.text[this.start + s] << 24 | this.text[this.start + s + 1] << 16 | this.text[this.start + s + 2] << 8 | this.text[this.start + s + 3];
    }

    private int ptr2char(int i, int text_depth) {
        return this.text[this.start + this.suffixArray[i] + text_depth];
    }

    private int med3(int a, int b, int c, int depth) {
        int vb;
        int va = this.ptr2char(a, depth);
        if (va == (vb = this.ptr2char(b, depth))) {
            return a;
        }
        int vc = this.ptr2char(c, depth);
        if (vc == va || vc == vb) {
            return c;
        }
        return va < vb ? (vb < vc ? b : (va < vc ? c : a)) : (vb > vc ? b : (va < vc ? a : c));
    }

    private void calculateRunningOrder() {
        int i;
        for (i = 0; i <= 256; ++i) {
            this.runningOrder[i] = i;
        }
        int h = 1;
        while ((h = 3 * h + 1) <= 257) {
        }
        do {
            for (i = h /= 3; i <= 256; ++i) {
                int vv = this.runningOrder[i];
                int j = i;
                while (this.bigFreq(this.runningOrder[j - h]) > this.bigFreq(vv)) {
                    this.runningOrder[j] = this.runningOrder[j - h];
                    if ((j -= h) > h - 1) continue;
                }
                this.runningOrder[j] = vv;
            }
        } while (h != 1);
    }

    private int bigFreq(int b) {
        return this.ftab[b + 1 << 8] - this.ftab[b << 8];
    }

    public static void main(String[] args) {
        for (int i = 0; i < 5; ++i) {
            System.gc();
        }
        int size = 1000000;
        Runtime rt = Runtime.getRuntime();
        Node[] nodes = new Node[size];
        long before = rt.totalMemory() - rt.freeMemory();
        for (int i = 0; i < size; ++i) {
            nodes[i] = new Node();
        }
        long after = rt.totalMemory() - rt.freeMemory();
        double a = 1.0 * (double)(after - before) / (double)size;
        System.out.println(before + " " + after + " " + size + " " + a);
    }

    private static class Node {
        int skip;
        int key;
        Node right;
        Node down;
        int downInt;

        private Node() {
        }
    }

    private static class SplitGroupResult {
        final int equal;
        final int lower;

        public SplitGroupResult(int equal, int lower) {
            this.equal = equal;
            this.lower = lower;
        }
    }
}

