/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock;

import fr.proline.studio.dock.TopPanelListener;
import fr.proline.studio.dock.container.DockComponent;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;

public abstract class AbstractTopPanel
extends JPanel {
    private boolean m_openedOnce = false;
    private List<TopPanelListener> m_panelListeners;

    public abstract String getTopPanelIdentifierKey();

    public abstract Image getIcon();

    public abstract String getTitle();

    public void componentAdded() {
        if (!this.m_openedOnce) {
            this.m_openedOnce = true;
            this.componentOpened();
        }
    }

    public Action[] getActions(DockComponent component) {
        return null;
    }

    protected abstract void componentOpened();

    public abstract void componentClosed();

    public boolean warnBeforeClosing() {
        return false;
    }

    public String getWarnClosingMessage() {
        return "";
    }

    public void addTopPanelListener(TopPanelListener listener) {
        if (this.m_panelListeners == null) {
            this.m_panelListeners = new ArrayList<TopPanelListener>();
        }
        this.m_panelListeners.add(listener);
    }

    public void removeTopPanelListener(TopPanelListener listener) {
        if (this.m_panelListeners == null) {
            return;
        }
        this.m_panelListeners.remove(listener);
    }

    public void clearTopPanelListener() {
        this.m_panelListeners = null;
    }

    protected void fireTopPanelPropertyChange(String property) {
        if (this.m_panelListeners != null && !this.m_panelListeners.isEmpty()) {
            this.m_panelListeners.forEach(listener -> listener.propertyChanged(property));
        }
    }
}

