/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.gui;

import fr.proline.studio.WindowManager;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;

public class InfoLabel
extends JLabel
implements MouseListener {
    private INFO_LEVEL m_infoLevel = INFO_LEVEL.INFO;
    private Throwable m_throwable = null;

    public InfoLabel() {
        this.setInfo(INFO_LEVEL.INFO, "", null);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setBorder(border);
    }

    public void setInfo(INFO_LEVEL infoLevel, Throwable t) {
        this.setInfo(infoLevel, t.getMessage(), t);
    }

    public void setInfo(INFO_LEVEL infoLevel, String message, Throwable t) {
        switch (infoLevel) {
            case INFO: {
                this.setIcon(IconManager.getIcon(IconManager.IconType.INFORMATION));
                break;
            }
            case WARNING: {
                this.setIcon(IconManager.getIcon(IconManager.IconType.WARNING));
                break;
            }
            case ERROR: {
                this.setIcon(IconManager.getIcon(IconManager.IconType.EXCLAMATION));
            }
        }
        this.setText(message);
        this.m_throwable = t;
        if (this.m_throwable != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.m_throwable != null) {
            ExceptionDialog.getSingleton(this.m_throwable.getMessage(), this.m_throwable).setVisible(true);
        }
        this.setInfo(INFO_LEVEL.INFO, "", null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public static enum INFO_LEVEL {
        INFO,
        WARNING,
        ERROR;

    }

    private static class ExceptionDialog
    extends DefaultDialog {
        private JTextArea m_textArea;
        private String _requestContent = "";
        private boolean m_firstDisplay = true;
        private static ExceptionDialog m_singleton = null;

        private ExceptionDialog() {
            super((Window)WindowManager.getDefault().getMainWindow());
            this.setTitle("Exception");
            this.setButtonVisible(1, false);
            this.setButtonVisible(5, false);
            this.setStatusVisible(false);
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setPreferredSize(new Dimension(600, 400));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(5, 5, 5, 5);
            this.m_textArea = new JTextArea();
            this.m_textArea.setText(this._requestContent);
            this.m_textArea.setCaretPosition(0);
            this.m_textArea.setEditable(false);
            this.m_textArea.setLineWrap(true);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            JScrollPane top = new JScrollPane(this.m_textArea);
            mainPanel.add((Component)top, c);
            this.setInternalComponent(mainPanel);
            this.setResizable(true);
        }

        public static ExceptionDialog getSingleton(String message, Throwable t) {
            if (m_singleton == null) {
                m_singleton = new ExceptionDialog();
            }
            m_singleton.setContent(message, t);
            return m_singleton;
        }

        @Override
        public void setVisible(boolean v) {
            if (this.m_firstDisplay) {
                m_singleton.centerToWindow(WindowManager.getDefault().getMainWindow());
                this.m_firstDisplay = false;
            }
            super.setVisible(v);
        }

        private void setContent(String message, Throwable t) {
            this.setTitle(message);
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.m_textArea.setText(sw.toString());
        }
    }
}

