/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import fr.proline.studio.export.TableUtil;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.util.ArrayList;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class TableRowTransferHandler
extends TransferHandler {
    private final DataFlavor localObjectFlavor = new DataFlavor(Integer.class, "Integer Row Index");
    private JTable table = null;

    public TableRowTransferHandler(JTable table) {
        this.table = table;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        assert (c == this.table);
        return new DataHandler((Object)this.table.getSelectedRow(), this.localObjectFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        boolean b = info.getComponent() == this.table && info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
        this.table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return b;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        JTable target = (JTable)info.getComponent();
        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
        int index = dl.getRow();
        int max = this.table.getModel().getRowCount();
        if (index < 0 || index > max) {
            index = max;
        }
        target.setCursor(Cursor.getPredefinedCursor(0));
        try {
            Integer rowFrom = (Integer)info.getTransferable().getTransferData(this.localObjectFlavor);
            if (rowFrom != -1 && rowFrom != index) {
                int[] rows = this.table.getSelectedRows();
                int dist = 0;
                for (int row : rows) {
                    if (index <= row) continue;
                    ++dist;
                }
                index -= dist;
                ArrayList<Vector> list = TableUtil.getSelectedList(this.table);
                TableUtil.removeSelected(this.table);
                ArrayList<Integer> sels = new ArrayList<Integer>();
                for (Vector obj : list) {
                    sels.add(index);
                    TableUtil.addRowAt(this.table, obj, index++);
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int act) {
        if (act == 2) {
            this.table.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

