/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.extendedtablemodel;

import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.graphics.PlotDataSpec;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractJoinDataModel
extends AbstractTableModel
implements GlobalTableModelInterface {
    protected GlobalTableModelInterface m_data1;
    protected GlobalTableModelInterface m_data2;
    protected String m_name;
    private boolean m_key1FloatOrDouble = false;
    private boolean m_key2FloatOrDouble = false;
    protected int m_selectedTable1Key1 = -1;
    protected int m_selectedTable2Key1 = -1;
    protected int m_selectedTable1Key2 = -1;
    protected int m_selectedTable2Key2 = -1;
    protected double m_tolerance1 = 0.0;
    protected double m_tolerance2 = 0.0;
    protected boolean m_showSourceColumn;
    protected ArrayList<Integer> m_rowsInTable1 = new ArrayList();
    protected ArrayList<Integer> m_rowsInTable2 = new ArrayList();
    protected ArrayList<Integer> m_sourceColumn1 = new ArrayList();
    protected ArrayList<Integer> m_sourceColumn2 = new ArrayList();

    protected abstract void setColumns();

    public void setData(GlobalTableModelInterface data1, GlobalTableModelInterface data2) {
        this.m_data1 = data1;
        this.m_data2 = data2;
        this.m_showSourceColumn = false;
        this.selectKeys();
        if (this.joinPossible()) {
            this.join();
        }
    }

    public void setData(GlobalTableModelInterface data1, GlobalTableModelInterface data2, Integer table1Key1, Integer table2Key1, Double tolerance1, Integer table1Key2, Integer table2Key2, Double tolerance2, Boolean showSourceColumn) {
        this.m_data1 = data1;
        this.m_data2 = data2;
        this.m_selectedTable1Key1 = table1Key1;
        this.m_selectedTable2Key1 = table2Key1;
        this.m_tolerance1 = tolerance1;
        this.m_selectedTable1Key2 = table1Key2;
        this.m_selectedTable2Key2 = table2Key2;
        this.m_tolerance2 = tolerance2;
        this.m_showSourceColumn = showSourceColumn;
        Class c = this.m_data1.getDataColumnClass(this.m_selectedTable1Key1);
        boolean bl = this.m_key1FloatOrDouble = c.equals(Double.class) || c.equals(Float.class);
        if (this.m_selectedTable1Key2 != -1) {
            c = this.m_data1.getDataColumnClass(this.m_selectedTable1Key2);
            boolean bl2 = this.m_key2FloatOrDouble = c.equals(Double.class) || c.equals(Float.class);
        }
        if (this.joinPossible()) {
            this.join();
        }
    }

    public GlobalTableModelInterface getFirstTableModel() {
        return this.m_data1;
    }

    public GlobalTableModelInterface getSecondTableModel() {
        return this.m_data2;
    }

    public Integer getRowInFirstModel(int row) {
        return this.m_rowsInTable1.get(row);
    }

    public Integer getRowInSecondModel(int row) {
        return this.m_rowsInTable2.get(row);
    }

    protected void selectKeys() {
        int[] keys1 = this.m_data1.getKeysColumn();
        int[] keys2 = this.m_data2.getKeysColumn();
        if (keys1 != null && keys2 != null) {
            for (int i = 0; i < keys1.length; ++i) {
                int col1 = keys1[i];
                Class c1 = this.m_data1.getDataColumnClass(col1);
                String id1 = this.m_data1.getDataColumnIdentifier(col1);
                for (int j = 0; j < keys2.length; ++j) {
                    int col2 = keys2[i];
                    Class c2 = this.m_data2.getDataColumnClass(col2);
                    String id2 = this.m_data2.getDataColumnIdentifier(col2);
                    if (!c1.equals(c2)) continue;
                    if (id1.compareTo(id2) == 0) {
                        this.m_selectedTable1Key1 = col1;
                        this.m_selectedTable2Key1 = col2;
                        return;
                    }
                    if (this.m_selectedTable1Key1 != -1) continue;
                    this.m_selectedTable1Key1 = col1;
                    this.m_selectedTable2Key1 = col2;
                }
            }
        }
        this.m_selectedTable1Key2 = -1;
        this.m_selectedTable2Key2 = -1;
    }

    protected void join() {
        JoinKeyStructure joinKeyStructure;
        if (!this.joinPossible()) {
            return;
        }
        int nb = this.m_data1.getRowCount();
        ArrayList<Object> table1Key1 = new ArrayList<Object>(nb);
        ArrayList<Integer> rowsInTable1Key1 = new ArrayList<Integer>(nb);
        for (int i = 0; i < nb; ++i) {
            table1Key1.add(this.m_data1.getDataValueAt(i, this.m_selectedTable1Key1));
            rowsInTable1Key1.add(i);
        }
        nb = this.m_data2.getRowCount();
        ArrayList<Object> table2Key1 = new ArrayList<Object>(nb);
        ArrayList<Integer> rowsInTable2Key1 = new ArrayList<Integer>(nb);
        for (int i = 0; i < nb; ++i) {
            table2Key1.add(this.m_data2.getDataValueAt(i, this.m_selectedTable2Key1));
            rowsInTable2Key1.add(i);
        }
        JoinKeyStructure joinKeyStructure2 = joinKeyStructure = this.m_key1FloatOrDouble ? this.joinKeysDouble(table1Key1, rowsInTable1Key1, table2Key1, rowsInTable2Key1, this.m_tolerance1) : this.joinKeysNew(table1Key1, rowsInTable1Key1, table2Key1, rowsInTable2Key1);
        if (this.m_selectedTable1Key2 != -1) {
            HashSet<Integer> orphanKeys1 = new HashSet<Integer>();
            HashSet<Integer> orphanKeys2 = new HashSet<Integer>();
            ArrayList<Object> allKeys = joinKeyStructure.m_allKeys;
            nb = allKeys.size();
            for (int i = 0; i < nb; ++i) {
                Object key = allKeys.get(i);
                CorrespondingKeyValues correspondingKeysValues = joinKeyStructure.m_correspondingKeys.get(key);
                int nbSub = correspondingKeysValues.m_correspondingKeys1.size();
                ArrayList<Object> table1Key2 = new ArrayList<Object>(nb);
                ArrayList<Integer> rowsInTable1Key2 = new ArrayList<Integer>(nb);
                for (int j = 0; j < nbSub; ++j) {
                    Integer rowCur = correspondingKeysValues.m_correspondingKeys1.get(j);
                    rowsInTable1Key2.add(rowCur);
                    table1Key2.add(this.m_data1.getDataValueAt(rowCur, this.m_selectedTable1Key2));
                }
                nbSub = correspondingKeysValues.m_correspondingKeys2.size();
                ArrayList<Object> table2Key2 = new ArrayList<Object>(nb);
                ArrayList<Integer> rowsInTable2Key2 = new ArrayList<Integer>(nb);
                for (int j = 0; j < nbSub; ++j) {
                    Integer rowCur = correspondingKeysValues.m_correspondingKeys2.get(j);
                    rowsInTable2Key2.add(rowCur);
                    table2Key2.add(this.m_data2.getDataValueAt(rowCur, this.m_selectedTable2Key2));
                }
                JoinKeyStructure joinKeyStructureSub = this.m_key2FloatOrDouble ? this.joinKeysDouble(table1Key2, rowsInTable1Key2, table2Key2, rowsInTable2Key2, this.m_tolerance2) : this.joinKeysNew(table1Key2, rowsInTable1Key2, table2Key2, rowsInTable2Key2);
                ArrayList<Object> allKeysSub = joinKeyStructureSub.m_allKeys;
                nbSub = allKeysSub.size();
                for (int j = 0; j < nbSub; ++j) {
                    int k;
                    Object keySub = allKeysSub.get(j);
                    CorrespondingKeyValues correspondingKeysValuesSub = joinKeyStructureSub.m_correspondingKeys.get(keySub);
                    int size1 = correspondingKeysValuesSub.m_correspondingKeys1.size();
                    int size2 = correspondingKeysValuesSub.m_correspondingKeys2.size();
                    if (size1 == 0) {
                        for (k = 0; k < size2; ++k) {
                            orphanKeys2.add(correspondingKeysValuesSub.m_correspondingKeys2.get(k));
                        }
                        continue;
                    }
                    if (size2 == 0) {
                        for (k = 0; k < size1; ++k) {
                            orphanKeys1.add(correspondingKeysValuesSub.m_correspondingKeys1.get(k));
                        }
                        continue;
                    }
                    for (k = 0; k < size1; ++k) {
                        for (int m = 0; m < size2; ++m) {
                            this.m_rowsInTable1.add(correspondingKeysValuesSub.m_correspondingKeys1.get(k));
                            this.m_rowsInTable2.add(correspondingKeysValuesSub.m_correspondingKeys2.get(m));
                            this.m_sourceColumn1.add(size1);
                            this.m_sourceColumn2.add(size2);
                        }
                    }
                }
            }
            orphanKeys1.removeAll(this.m_rowsInTable1);
            orphanKeys2.removeAll(this.m_rowsInTable2);
            for (Integer i : orphanKeys1) {
                this.m_rowsInTable1.add(i);
                this.m_rowsInTable2.add(null);
                this.m_sourceColumn1.add(1);
                this.m_sourceColumn2.add(null);
            }
            for (Integer i : orphanKeys2) {
                this.m_rowsInTable1.add(null);
                this.m_rowsInTable2.add(i);
                this.m_sourceColumn1.add(null);
                this.m_sourceColumn2.add(1);
            }
        } else {
            ArrayList<Object> allKeys = joinKeyStructure.m_allKeys;
            int nbSub = allKeys.size();
            for (int j = 0; j < nbSub; ++j) {
                int k;
                Object keySub = allKeys.get(j);
                CorrespondingKeyValues correspondingKeyValues = joinKeyStructure.m_correspondingKeys.get(keySub);
                int size1 = correspondingKeyValues.m_correspondingKeys1.size();
                int size2 = correspondingKeyValues.m_correspondingKeys2.size();
                if (size1 == 0) {
                    for (k = 0; k < size2; ++k) {
                        this.m_rowsInTable1.add(null);
                        this.m_rowsInTable2.add(correspondingKeyValues.m_correspondingKeys2.get(k));
                        this.m_sourceColumn1.add(null);
                        this.m_sourceColumn2.add(1);
                    }
                    continue;
                }
                if (size2 == 0) {
                    for (k = 0; k < size1; ++k) {
                        this.m_rowsInTable1.add(correspondingKeyValues.m_correspondingKeys1.get(k));
                        this.m_rowsInTable2.add(null);
                        this.m_sourceColumn1.add(1);
                        this.m_sourceColumn2.add(null);
                    }
                    continue;
                }
                for (k = 0; k < size1; ++k) {
                    for (int m = 0; m < size2; ++m) {
                        this.m_rowsInTable1.add(correspondingKeyValues.m_correspondingKeys1.get(k));
                        this.m_rowsInTable2.add(correspondingKeyValues.m_correspondingKeys2.get(m));
                        this.m_sourceColumn1.add(size1);
                        this.m_sourceColumn2.add(size2);
                    }
                }
            }
        }
        this.setColumns();
    }

    private JoinKeyStructure joinKeysNew(ArrayList<Object> tableKey1, ArrayList<Integer> rowsInTableKey1, ArrayList<Object> tableKey2, ArrayList<Integer> rowsInTableKey2) {
        CorrespondingKeyValues values;
        Object key;
        int i;
        JoinKeyStructure joinKeyStructure = new JoinKeyStructure();
        HashSet<Object> keysFound = joinKeyStructure.m_keysFound;
        HashMap<Object, CorrespondingKeyValues> correspondingKeys = joinKeyStructure.m_correspondingKeys;
        ArrayList<Object> allKeys = joinKeyStructure.m_allKeys;
        int nb = tableKey1.size();
        for (i = 0; i < nb; ++i) {
            key = tableKey1.get(i);
            values = correspondingKeys.get(key);
            if (values == null) {
                values = new CorrespondingKeyValues();
                correspondingKeys.put(key, values);
                keysFound.add(key);
                allKeys.add(key);
            }
            values.m_correspondingKeys1.add(rowsInTableKey1.get(i));
        }
        nb = tableKey2.size();
        for (i = 0; i < nb; ++i) {
            key = tableKey2.get(i);
            values = correspondingKeys.get(key);
            if (values == null) {
                values = new CorrespondingKeyValues();
                correspondingKeys.put(key, values);
                keysFound.add(key);
                allKeys.add(key);
            }
            values.m_correspondingKeys2.add(rowsInTableKey2.get(i));
        }
        return joinKeyStructure;
    }

    private JoinKeyStructure joinKeysDouble(ArrayList<Object> tableKey1, ArrayList<Integer> rowsInTableKey1, ArrayList<Object> tableKey2, ArrayList<Integer> rowsInTableKey2, double tolerance) {
        JoinKeyStructure joinKeyStructure = new JoinKeyStructure();
        HashSet<Object> keysFound = joinKeyStructure.m_keysFound;
        HashMap<Object, CorrespondingKeyValues> correspondingKeys = joinKeyStructure.m_correspondingKeys;
        ArrayList<Object> allKeys = joinKeyStructure.m_allKeys;
        int size1 = tableKey1.size();
        if (size1 > 0) {
            double[] values1 = new double[size1];
            for (int i = 0; i < size1; ++i) {
                CorrespondingKeyValues values;
                Number key = (Number)tableKey1.get(i);
                if (key == null) {
                    key = Double.NaN;
                }
                if ((values = correspondingKeys.get(key)) == null) {
                    values = new CorrespondingKeyValues();
                    correspondingKeys.put(key, values);
                    keysFound.add(key);
                    allKeys.add(key);
                }
                values.m_correspondingKeys1.add(rowsInTableKey1.get(i));
                values1[i] = key.doubleValue();
            }
            ArrayIndexComparator comparator = new ArrayIndexComparator(values1);
            Integer[] indexes = comparator.createIndexArray();
            Arrays.sort(indexes, comparator);
            int size2 = tableKey2.size();
            for (int i = 0; i < size2; ++i) {
                try {
                    Number key = (Number)tableKey2.get(i);
                    if (key == null) {
                        key = Double.NaN;
                    }
                    double value = key.doubleValue();
                    Integer nearestIndex = AbstractJoinDataModel.searchNearestValueIndex(value, indexes, values1);
                    boolean correspondanceFound = false;
                    double delta = 0.0;
                    int index = nearestIndex;
                    int increment = -1;
                    do {
                        double nearestValue;
                        if ((delta = (nearestValue = values1[indexes[index]]) - value) < 0.0) {
                            delta = -delta;
                        }
                        Number keyAssorted = key;
                        if (delta <= tolerance) {
                            keyAssorted = (Number)tableKey1.get(indexes[index]);
                            CorrespondingKeyValues values = correspondingKeys.get(keyAssorted);
                            values.m_correspondingKeys2.add(rowsInTableKey2.get(i));
                            correspondanceFound = true;
                            if ((index += increment) >= 0 && index < values1.length) continue;
                            increment += 2;
                            index = nearestIndex + 1;
                            continue;
                        }
                        increment += 2;
                        index = nearestIndex + 1;
                    } while (increment <= 1 && index >= 0 && index < values1.length);
                    if (correspondanceFound) continue;
                    CorrespondingKeyValues values = correspondingKeys.get(key);
                    if (values == null) {
                        values = new CorrespondingKeyValues();
                        correspondingKeys.put(key, values);
                        keysFound.add(key);
                        allKeys.add(key);
                    }
                    values.m_correspondingKeys2.add(rowsInTableKey2.get(i));
                    continue;
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    String s = sw.toString();
                    System.out.println(s);
                }
            }
        } else {
            int size2 = tableKey2.size();
            for (int i = 0; i < size2; ++i) {
                try {
                    CorrespondingKeyValues values;
                    Number key = (Number)tableKey2.get(i);
                    if (key == null) {
                        key = Double.NaN;
                    }
                    if ((values = correspondingKeys.get(key)) == null) {
                        values = new CorrespondingKeyValues();
                        correspondingKeys.put(key, values);
                        keysFound.add(key);
                        allKeys.add(key);
                    }
                    values.m_correspondingKeys2.add(rowsInTableKey2.get(i));
                    continue;
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    String s = sw.toString();
                    System.out.println(s);
                }
            }
        }
        return joinKeyStructure;
    }

    private static Integer searchNearestValueIndex(double value, Integer[] indexes, double[] values) {
        int lo = 0;
        int hi = indexes.length - 1;
        Integer lastValueIndex = null;
        int mid = (lo + hi) / 2;
        while (lo <= hi) {
            mid = (lo + hi) / 2;
            lastValueIndex = indexes[mid];
            if (value < values[lastValueIndex]) {
                hi = mid - 1;
                continue;
            }
            if (value > values[lastValueIndex]) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        double min = Double.MAX_VALUE;
        for (int k = Math.max(0, mid - 1); k <= Math.min(indexes.length - 1, mid + 1); ++k) {
            if (!(Math.abs(values[indexes[k]] - value) < min)) continue;
            min = Math.abs(values[indexes[k]] - value);
            mid = k;
        }
        return mid;
    }

    public int getSelectedKey1() {
        return this.m_selectedTable1Key1;
    }

    public int getSelectedKey2() {
        return this.m_selectedTable2Key1;
    }

    public boolean checkKeys(int key1, int key2) {
        if (key1 == -1 && key2 == -1) {
            return true;
        }
        if (key1 == -1 || key2 == -1) {
            return false;
        }
        Class c1 = this.m_data1.getDataColumnClass(key1);
        Class c2 = this.m_data2.getDataColumnClass(key2);
        return c1.equals(c2);
    }

    public void setKeys(int key1, int key2) {
        this.m_selectedTable1Key1 = key1;
        this.m_selectedTable2Key1 = key2;
    }

    public boolean joinPossible() {
        return this.m_selectedTable1Key1 != -1;
    }

    @Override
    public int getRowCount() {
        if (!this.joinPossible()) {
            return 0;
        }
        return this.m_rowsInTable1.size();
    }

    @Override
    public int[] getKeysColumn() {
        if (!this.joinPossible()) {
            return null;
        }
        int[] keysColumn = new int[]{0};
        return keysColumn;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean isLoaded() {
        return this.m_data1.isLoaded() && this.m_data2.isLoaded();
    }

    @Override
    public int getLoadingPercentage() {
        return (this.m_data1.getLoadingPercentage() + this.m_data2.getLoadingPercentage()) / 2;
    }

    @Override
    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    @Override
    public int uniqueId2Row(long id) {
        return (int)id;
    }

    @Override
    public ArrayList<ExtraDataType> getExtraDataTypes() {
        ArrayList<ExtraDataType> list2;
        ArrayList<ExtraDataType> list = null;
        ArrayList<ExtraDataType> list1 = this.m_data1.getExtraDataTypes();
        if (list1 != null) {
            list = new ArrayList<ExtraDataType>(list1);
        }
        if ((list2 = this.m_data1.getExtraDataTypes()) != null) {
            if (list == null) {
                list = new ArrayList<ExtraDataType>(list2);
            } else {
                list.addAll(list2);
            }
        }
        return list;
    }

    @Override
    public Object getValue(Class c) {
        if (!this.joinPossible()) {
            return null;
        }
        Object o = this.m_data1.getValue(c);
        if (o != null) {
            return o;
        }
        o = this.m_data2.getValue(c);
        if (o != null) {
            return o;
        }
        return null;
    }

    @Override
    public Object getRowValue(Class c, int rowIndex) {
        if (!this.joinPossible()) {
            return null;
        }
        Object value = null;
        Integer row1Index = this.m_rowsInTable1.get(rowIndex);
        if (row1Index != null) {
            value = this.m_data1.getRowValue(c, row1Index);
        }
        if (value != null) {
            return value;
        }
        Integer row2Index = this.m_rowsInTable2.get(rowIndex);
        if (row2Index != null) {
            value = this.m_data2.getRowValue(c, row2Index);
        }
        return value;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public Object getSingleValue(Class c) {
        return null;
    }

    @Override
    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }

    public class JoinKeyStructure {
        public HashSet<Object> m_keysFound = new HashSet();
        public ArrayList<Object> m_allKeys = new ArrayList();
        public HashMap<Object, CorrespondingKeyValues> m_correspondingKeys = new HashMap();
    }

    public class CorrespondingKeyValues {
        public final ArrayList<Integer> m_correspondingKeys1 = new ArrayList();
        public final ArrayList<Integer> m_correspondingKeys2 = new ArrayList();
    }

    public class ArrayIndexComparator
    implements Comparator<Integer> {
        private final double[] m_doubleArray;

        public ArrayIndexComparator(double[] array) {
            this.m_doubleArray = array;
        }

        public Integer[] createIndexArray() {
            Integer[] indexes = new Integer[this.m_doubleArray.length];
            for (int i = 0; i < this.m_doubleArray.length; ++i) {
                indexes[i] = i;
            }
            return indexes;
        }

        @Override
        public int compare(Integer index1, Integer index2) {
            if (this.m_doubleArray[index1] < this.m_doubleArray[index2]) {
                return -1;
            }
            if (this.m_doubleArray[index1] > this.m_doubleArray[index2]) {
                return 1;
            }
            return 0;
        }
    }
}

