/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterStatus;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateFilter
extends Filter {
    private static final Integer VALUE_MIN = 0;
    private static final Integer VALUE_MAX = 1;
    private Date m_min;
    private Date m_max;
    private SimpleDateFormat m_dateFormat;
    private SimpleDateFormat m_alterDateFormat = new SimpleDateFormat("dd MMM yyyy");
    static String DATE_FORMAT = "HH:mm:ss.SSS - dd MMM yyyy";

    public DateFilter(String variableName, ConvertValueInterface convertValueInterface, int modelColumn) {
        super(variableName, convertValueInterface, modelColumn);
        this.m_dateFormat = new SimpleDateFormat("HH:mm:ss.SSS - dd MMM yyyy");
    }

    public DateFilter(SimpleDateFormat dateFormat, String variableName, ConvertValueInterface convertValueInterface, int modelColumn) {
        super(variableName, convertValueInterface, modelColumn);
        this.m_dateFormat = dateFormat;
    }

    @Override
    public Filter cloneFilter4Search() {
        DateFilter clone = new DateFilter(this.m_dateFormat, this.m_variableName, this.m_convertValueInterface, this.m_modelColumn);
        clone.m_dateFormat = this.m_dateFormat;
        clone.m_min = this.m_min;
        clone.m_max = this.m_max;
        this.setValuesForClone(clone);
        return clone;
    }

    @Override
    public boolean filter(Object v1, Object v2) {
        Date value = (Date)v1;
        if (this.m_min != null && value.getTime() < this.m_min.getTime()) {
            return false;
        }
        return this.m_max == null || value.getTime() <= this.m_max.getTime();
    }

    @Override
    public FilterStatus checkValues() {
        Date max;
        Date min;
        String minValue = ((JTextField)this.getComponent(VALUE_MIN)).getText().trim();
        if (minValue == null || minValue.length() == 0) {
            min = null;
        } else {
            try {
                min = this.parseTime(minValue);
            }
            catch (ParseException ex) {
                return new FilterStatus("Min Value is  not a Date", (Component)this.m_components.get(VALUE_MIN));
            }
        }
        String maxValue = ((JTextField)this.getComponent(VALUE_MAX)).getText().trim();
        if (maxValue == null || maxValue.length() == 0) {
            max = null;
        } else {
            try {
                max = this.parseTime(maxValue);
            }
            catch (ParseException ex) {
                return new FilterStatus("Max Value is  not a Date", (Component)this.m_components.get(VALUE_MAX));
            }
        }
        if (min != null && max != null && min.getTime() > max.getTime()) {
            return new FilterStatus("Min Value is greater than Max Value", (Component)this.m_components.get(VALUE_MIN));
        }
        return null;
    }

    private Date parseTime(String time) throws ParseException {
        try {
            return this.m_dateFormat.parse(time.trim());
        }
        catch (ParseException ex) {
            return this.m_alterDateFormat.parse(time.trim());
        }
    }

    @Override
    public boolean registerValues() {
        boolean hasChanged = false;
        if (this.isDefined()) {
            Date lastMinValue = this.m_min;
            Date lastMaxValue = this.m_max;
            String minValue = ((JTextField)this.getComponent(VALUE_MIN)).getText().trim();
            if (minValue == null || minValue.length() == 0) {
                this.m_min = null;
            } else {
                try {
                    this.m_min = this.parseTime(minValue);
                }
                catch (ParseException ex) {
                    this.m_min = null;
                }
            }
            String maxValue = ((JTextField)this.getComponent(VALUE_MAX)).getText().trim();
            if (maxValue == null || maxValue.length() == 0) {
                this.m_max = null;
            } else {
                try {
                    this.m_max = this.parseTime(maxValue);
                }
                catch (ParseException ex) {
                    this.m_max = null;
                }
            }
            if (lastMinValue == null && this.m_min != null || lastMinValue != null && this.m_min == null) {
                hasChanged = true;
            } else if (lastMaxValue == null && this.m_max != null || lastMaxValue != null && this.m_max == null) {
                hasChanged = true;
            } else if (lastMinValue != null && !lastMinValue.equals(this.m_min)) {
                hasChanged = true;
            } else if (lastMaxValue != null && !lastMaxValue.equals(this.m_max)) {
                hasChanged = true;
            }
        }
        this.registerDefinedAsUsed();
        return hasChanged;
    }

    @Override
    public void createComponents(JPanel p, GridBagConstraints c) {
        String today = "00:00:00.000 - " + this.m_alterDateFormat.format(new Date());
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        JTextField minTextField = (JTextField)this.getComponent(VALUE_MIN);
        if (minTextField == null) {
            minTextField = new JTextField(18);
            minTextField.setToolTipText(DATE_FORMAT);
            if (this.m_min != null) {
                minTextField.setText(this.m_dateFormat.format(this.m_min));
            } else {
                minTextField.setText(today);
            }
            this.registerComponent(VALUE_MIN, minTextField);
        }
        p.add((Component)minTextField, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("<="), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        JLabel nameLabel = new JLabel(this.getName());
        nameLabel.setHorizontalAlignment(0);
        p.add((Component)nameLabel, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("<="), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        JTextField maxTextField = (JTextField)this.getComponent(VALUE_MAX);
        if (maxTextField == null) {
            maxTextField = new JTextField(18);
            maxTextField.setToolTipText(DATE_FORMAT);
            if (this.m_max != null) {
                maxTextField.setText(this.m_dateFormat.format(this.m_max));
            } else {
                maxTextField.setText(today);
            }
            this.registerComponent(VALUE_MAX, maxTextField);
        }
        p.add((Component)maxTextField, c);
        ++c.gridx;
    }

    @Override
    public void reset() {
        this.m_min = null;
        this.m_max = null;
    }
}

