/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.filter;

import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.FilterStatus;
import fr.proline.studio.filter.LongFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DurationFilter
extends LongFilter {
    static String DURATION_FORMAT = "DDD:hh:ss:ms";
    private static final Integer VALUE_MIN = 0;
    private static final Integer VALUE_MAX = 1;
    private Long m_min;
    private Long m_max;

    public DurationFilter(String variableName, ConvertValueInterface convertValueInterface, int modelColumn) {
        super(variableName, convertValueInterface, modelColumn);
    }

    @Override
    public Filter cloneFilter4Search() {
        DurationFilter clone = new DurationFilter(this.m_variableName, this.m_convertValueInterface, this.m_modelColumn);
        clone.m_min = this.m_min;
        clone.m_max = this.m_max;
        this.setValuesForClone(clone);
        return clone;
    }

    @Override
    public boolean filter(Object v1, Object v2) {
        long value = (Long)v1;
        if (this.m_min != null && value < this.m_min) {
            return false;
        }
        return this.m_max == null || value <= this.m_max;
    }

    public static String formatDurationInHour(long duration) {
        int second = 1000;
        int minute = 60000;
        int hour = 3600000;
        String time = String.format("%d:%02d:%02d.%03d", duration / (long)hour, duration % (long)hour / (long)minute, duration % (long)minute / (long)second, duration % (long)second);
        return time;
    }

    private Long getTextFieldValue(String content) {
        int h = 3600000;
        int m = 60000;
        int s = 1000;
        long duration = 0L;
        String regex = "(\\d+):([0-5][0-9]):([0-5][0-9])\\.(\\d\\d\\d)";
        Pattern pattern = Pattern.compile("(\\d+):([0-5][0-9]):([0-5][0-9])\\.(\\d\\d\\d)");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            block6: for (int i = 1; i <= matcher.groupCount(); ++i) {
                int v = Integer.parseInt(matcher.group(i));
                switch (i) {
                    case 1: {
                        duration += (long)(v * 3600000);
                        continue block6;
                    }
                    case 2: {
                        duration += (long)(v * 60000);
                        continue block6;
                    }
                    case 3: {
                        duration += (long)(v * 1000);
                        continue block6;
                    }
                    case 4: {
                        duration += (long)v;
                    }
                }
            }
            return duration;
        }
        String regexSimple = "(\\d+)([HhMmSs])?";
        pattern = Pattern.compile("(\\d+)([HhMmSs])?");
        matcher = pattern.matcher(content);
        if (matcher.find()) {
            int vs = Integer.parseInt(matcher.group(1));
            String type = matcher.group(2);
            if (type == null) {
                duration = vs;
            } else if (type.equalsIgnoreCase("h")) {
                duration = vs * h;
            } else if (type.equalsIgnoreCase("m")) {
                duration = vs * m;
            } else if (type.equalsIgnoreCase("s")) {
                duration = vs * s;
            }
            return duration;
        }
        return null;
    }

    @Override
    public FilterStatus checkValues() {
        Long max;
        Long min;
        String minValue = ((JTextField)this.getComponent(VALUE_MIN)).getText().trim();
        if (minValue == null || minValue.length() == 0) {
            min = null;
        } else {
            try {
                min = this.getTextFieldValue(minValue);
                if (min == null) {
                    return new FilterStatus("Min Value is  not a duration in (HHHH:mm:ss.SSS) format, or in (\\d+)h |(\\d+)m (\\d+)s ", (Component)this.m_components.get(VALUE_MIN));
                }
            }
            catch (Exception nfe) {
                return new FilterStatus("Min Value is  not a duration in (HHHH:mm:ss.SSS) format, or in (\\d+)h |(\\d+)m (\\d+)s ", (Component)this.m_components.get(VALUE_MIN));
            }
        }
        String maxValue = ((JTextField)this.getComponent(VALUE_MAX)).getText().trim();
        if (maxValue == null || maxValue.length() == 0) {
            max = null;
        } else {
            try {
                max = this.getTextFieldValue(maxValue);
                if (max == null) {
                    return new FilterStatus("Max Value is  not a duration in (HHHH:mm:ss.SSS) format, or in (\\d+)h |(\\d+)m (\\d+)s ", (Component)this.m_components.get(VALUE_MAX));
                }
            }
            catch (Exception nfe) {
                return new FilterStatus("Max Value is  not a duration in (HHHH:mm:ss.SSS) format, or in (\\d+)h |(\\d+)m (\\d+)s ", (Component)this.m_components.get(VALUE_MAX));
            }
        }
        if (min != null && max != null && min > max) {
            return new FilterStatus("Min Value is greater than Max Value", (Component)this.m_components.get(VALUE_MIN));
        }
        if (min != null && max != null && min.equals(max)) {
            return new FilterStatus("Max Value is same as Min Value", (Component)this.m_components.get(VALUE_MAX));
        }
        return null;
    }

    @Override
    public boolean registerValues() {
        boolean hasChanged = false;
        if (this.isDefined()) {
            Long lastMinValue = this.m_min;
            Long lastMaxValue = this.m_max;
            String minValue = ((JTextField)this.getComponent(VALUE_MIN)).getText().trim();
            if (minValue == null || minValue.length() == 0) {
                this.m_min = null;
            } else {
                try {
                    this.m_min = this.getTextFieldValue(minValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String maxValue = ((JTextField)this.getComponent(VALUE_MAX)).getText().trim();
            if (maxValue == null || maxValue.length() == 0) {
                this.m_max = null;
            } else {
                try {
                    this.m_max = this.getTextFieldValue(maxValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lastMinValue == null && this.m_min != null || lastMinValue != null && this.m_min == null) {
                hasChanged = true;
            } else if (lastMaxValue == null && this.m_max != null || lastMaxValue != null && this.m_max == null) {
                hasChanged = true;
            } else if (lastMinValue != null && lastMinValue.longValue() != this.m_min.longValue()) {
                hasChanged = true;
            } else if (lastMaxValue != null && lastMaxValue.longValue() != this.m_max.longValue()) {
                hasChanged = true;
            }
        }
        this.registerDefinedAsUsed();
        return hasChanged;
    }

    @Override
    public void createComponents(JPanel p, GridBagConstraints c) {
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        JTextField minTextField = (JTextField)this.getComponent(VALUE_MIN);
        if (minTextField == null) {
            minTextField = new JTextField(10);
            minTextField.setToolTipText(DURATION_FORMAT);
            if (this.m_min != null) {
                minTextField.setText(DurationFilter.formatDurationInHour(this.m_min));
            } else {
                minTextField.setText("  0:00:00.000");
            }
            this.registerComponent(VALUE_MIN, minTextField);
        }
        p.add((Component)minTextField, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("<="), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        JLabel nameLabel = new JLabel(this.getName());
        nameLabel.setHorizontalAlignment(0);
        p.add((Component)nameLabel, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        p.add((Component)new JLabel("<="), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        JTextField maxTextField = (JTextField)this.getComponent(VALUE_MAX);
        if (maxTextField == null) {
            maxTextField = new JTextField(10);
            maxTextField.setToolTipText(DURATION_FORMAT);
            if (this.m_max != null) {
                maxTextField.setText(DurationFilter.formatDurationInHour(this.m_max));
            } else {
                maxTextField.setText("  0:00:00.000");
            }
            this.registerComponent(VALUE_MAX, maxTextField);
        }
        p.add((Component)maxTextField, c);
        ++c.gridx;
    }

    @Override
    public void reset() {
        this.m_min = null;
        this.m_max = null;
    }
}

