/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.LogAdapterModel;
import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.ColorOrGradient;
import fr.proline.studio.graphics.ColorOrGradientChooserPanel;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.ReferenceIdName;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.core.PlotToolbarListenerInterface;
import fr.proline.studio.graphics.marker.LabelMarker;
import fr.proline.studio.graphics.marker.LineMarker;
import fr.proline.studio.graphics.marker.coordinates.DataCoordinates;
import fr.proline.studio.parameter.ColorOrGradientParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.DataFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotLinear
extends PlotXYAbstract {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final int DEFAULT_POINT_RADIUS = 3;
    private double m_xMin;
    private double m_xMax;
    private double m_yMin;
    private double m_yMax;
    private double[] m_dataX;
    private double[] m_dataY;
    private PlotDataSpec[] m_dataSpec;
    private double m_gradientParamValuesMin;
    private double m_gradientParamValuesMax;
    private double[] m_gradientParamValues;
    private int m_gradientParamCol = -1;
    private Color[] m_gradientColors;
    private float[] m_gradientFractions;
    private boolean[] m_selected;
    private PlotInformation m_plotInformation = null;
    private static final int SELECT_SENSIBILITY = 2;
    private static final int SELECT_SENSIBILITY_POW = 4;
    private static final String PLOT_SCATTER_COLOR_KEY = "PLOT_SCATTER_COLOR";
    private ColorOrGradientParameter m_colorParameter;
    private boolean m_isDrawPoints = false;
    private boolean m_isDrawGap = true;
    private static final BasicStroke STROKE_1 = new BasicStroke(1.2f, 0, 0);
    private static final BasicStroke STROKE_2 = new BasicStroke(2.0f, 0, 0);
    private boolean strokeFixed = false;
    private static final float[] dash = new float[]{2.0f, 2.0f};
    private static final BasicStroke STROKE_1_DASHED = new BasicStroke(1.2f, 0, 0, 10.0f, dash, 0.0f);
    private BasicStroke m_strokeLine = STROKE_1;
    private BasicStroke m_userStrock = null;
    private static final BasicStroke EDGE_STROKE = new BasicStroke(1.0f, 0, 0);
    private static final BasicStroke SELECTED_STROCK = new BasicStroke(4.0f, 0, 0);
    private static final Color SELECTED_COLOR = new Color(0, 120, 215);
    private ArrayList<ParameterList> m_parameterListArray = null;
    private boolean m_hasSharedParameters = false;
    private boolean displayAntiAliasing = true;
    private double m_tolerance;
    private Double m_limitMinY = null;
    private StringBuilder m_sb = null;
    private static final Point2D m_gradientStart = new Point2D.Double();
    private static final Point2D m_gradientEnd = new Point2D.Double();
    private static final float[] ERROR_GRADIENT_STEPS = new float[]{0.0f, 0.3f, 1.0f};
    private static final Color[] ERROR_GRADIENT_COLORS = new Color[3];

    public PlotLinear(BasePlotPanel plotPanel, ExtendedTableModelInterface compareDataInterface, CrossSelectionInterface crossSelectionInterface, int colX, int colY) {
        this(plotPanel, compareDataInterface, crossSelectionInterface, colX, colY, null, null);
    }

    public PlotLinear(BasePlotPanel plotPanel, ExtendedTableModelInterface compareDataInterface, CrossSelectionInterface crossSelectionInterface, int colX, int colY, Double limitMinY, ArrayList<ParameterList> sharedParameterListArray) {
        super(plotPanel, PlotType.SCATTER_PLOT, compareDataInterface, crossSelectionInterface);
        if (sharedParameterListArray != null) {
            this.m_hasSharedParameters = true;
            this.m_parameterListArray = sharedParameterListArray;
        }
        this.m_limitMinY = limitMinY;
        int[] cols = new int[]{colX, colY};
        this.update(cols, null);
        if (!this.m_hasSharedParameters) {
            ParameterList colorParameterList = new ParameterList("Colors");
            ColorOrGradient colorOrGradient = new ColorOrGradient();
            colorOrGradient.setColor(CyclicColorPalette.getColor(21, 128));
            float[] fractions = new float[]{0.0f, 1.0f};
            Color[] colors = new Color[]{Color.white, Color.red};
            LinearGradientPaint gradient = ColorOrGradientChooserPanel.getGradientForPanel(colors, fractions);
            colorOrGradient.setGradient(gradient);
            this.m_colorParameter = new ColorOrGradientParameter(PLOT_SCATTER_COLOR_KEY, "Scatter Plot Color", colorOrGradient, null);
            colorParameterList.add(this.m_colorParameter);
            this.m_parameterListArray = new ArrayList(1);
            this.m_parameterListArray.add(colorParameterList);
        } else {
            ParameterList colorParameterList = this.m_parameterListArray.get(0);
            this.m_colorParameter = (ColorOrGradientParameter)colorParameterList.getParameter(PLOT_SCATTER_COLOR_KEY);
        }
        this.m_tolerance = 0.0;
        this.m_plotPanel.enableButton(PlotToolbarListenerInterface.BUTTONS.VIEW_ALL_MAP, true);
    }

    public void setTolerance(double tolerance) {
        this.m_tolerance = tolerance;
    }

    @Override
    public ArrayList<ParameterList> getParameters() {
        if (this.m_plotInformation != null && this.m_plotInformation.getPlotColor() != null) {
            return null;
        }
        ArrayList<ReferenceIdName> m_potentialGradientParamArray = new ArrayList<ReferenceIdName>();
        HashSet<Class> acceptedValues = this.m_plotType.getAcceptedValuesAsParam();
        int nbCol = this.m_compareDataInterface.getColumnCount();
        for (int i = 0; i < nbCol; ++i) {
            Class c = this.m_compareDataInterface.getDataColumnClass(i);
            if (!acceptedValues.contains(c)) continue;
            ReferenceIdName ref = new ReferenceIdName(this.m_compareDataInterface.getDataColumnIdentifier(i), i);
            m_potentialGradientParamArray.add(ref);
        }
        this.m_colorParameter.setGradientParam(m_potentialGradientParamArray);
        return this.m_parameterListArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getToolTipText(double x, double y) {
        void var7_8;
        int indexFound = this.findPoint(x, y);
        if (indexFound == -1) {
            return null;
        }
        if (this.m_sb == null) {
            this.m_sb = new StringBuilder();
        }
        if (this.m_plotInformation != null && this.m_plotInformation.getPlotColor() != null) {
            String rsmHtmlColor = CyclicColorPalette.getHTMLColor(this.m_plotInformation.getPlotColor());
            this.m_sb.append("<font color='").append(rsmHtmlColor).append("'>&#x25A0;&nbsp;</font>");
        }
        if (this.m_plotInformation != null && this.m_plotInformation.getPlotTitle() != null && !this.m_plotInformation.getPlotTitle().isEmpty()) {
            this.m_sb.append(this.m_plotInformation.getPlotTitle());
        } else {
            this.m_sb.append(this.m_compareDataInterface.getDataValueAt(indexFound, this.m_compareDataInterface.getInfoColumn()).toString());
        }
        if (this.m_plotInformation != null && this.m_plotInformation.getPlotInfo() != null) {
            for (Map.Entry entry : this.m_plotInformation.getPlotInfo().entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.m_sb.append(key);
                this.m_sb.append(": ");
                this.m_sb.append(value);
                this.m_sb.append("<br>");
            }
            this.m_sb.append("<br>");
        }
        String labelX = this.m_plotPanel.getXAxis().isEnum() ? this.m_plotPanel.getEnumValueX(indexFound, true) : DataFormat.format(this.m_dataX[indexFound], 4);
        if (this.m_plotPanel.getYAxis().isEnum()) {
            String string = this.m_plotPanel.getEnumValueY(indexFound, true, this.m_plotPanel.getYAxis());
        } else {
            String string = DataFormat.format(this.m_dataY[indexFound], 4);
        }
        this.m_sb.append("<BR>");
        this.m_sb.append(this.m_plotPanel.getXAxis().getTitle());
        this.m_sb.append(" : ");
        this.m_sb.append(labelX);
        this.m_sb.append("<BR>");
        this.m_sb.append(this.m_plotPanel.getYAxis().getTitle());
        this.m_sb.append(" : ");
        this.m_sb.append((String)var7_8);
        String tooltip = this.m_sb.toString();
        this.m_sb.setLength(0);
        return tooltip;
    }

    @Override
    public boolean select(double x, double y, boolean append) {
        int size;
        int indexFound = this.findPoint(x, y);
        int n = size = this.m_dataX == null ? 0 : this.m_dataX.length;
        if (!append) {
            for (int i = 0; i < size; ++i) {
                this.m_selected[i] = false;
            }
        }
        if (indexFound != -1) {
            this.m_selected[indexFound] = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean select(Path2D.Double path, double minX, double maxX, double minY, double maxY, boolean append) {
        boolean aSelection = false;
        int size = this.m_dataX == null ? 0 : this.m_dataX.length;
        for (int i = 0; i < size; ++i) {
            double dataX = this.m_dataX[i];
            double dataY = this.m_dataY[i];
            if (dataX < minX || dataX > maxX || dataY < minY || dataY > maxY) {
                if (append) continue;
                this.m_selected[i] = false;
                continue;
            }
            if (path.contains(dataX, dataY)) {
                this.m_selected[i] = true;
                aSelection = true;
                continue;
            }
            if (append) continue;
            this.m_selected[i] = false;
        }
        return aSelection;
    }

    @Override
    public ArrayList<Long> getSelectedIds() {
        return null;
    }

    @Override
    public void setSelectedIds(ArrayList<Long> selection) {
    }

    private static double distance(Point p1, Point p2) {
        int d2 = (p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y);
        return d2;
    }

    public double[] getDataX() {
        return this.m_dataX;
    }

    public double[] getDataY() {
        return this.m_dataY;
    }

    private static double distanceToSegment(Point ps, Point pe, Point p) {
        if (ps.x == pe.x && ps.y == pe.y) {
            return PlotLinear.distance(ps, p);
        }
        int sx = pe.x - ps.x;
        int ux = p.x - ps.x;
        int sy = pe.y - ps.y;
        int uy = p.y - ps.y;
        int dp = sx * ux + sy * uy;
        if (dp < 0) {
            return PlotLinear.distance(ps, p);
        }
        int sn2 = sx * sx + sy * sy;
        if (dp > sn2) {
            return PlotLinear.distance(pe, p);
        }
        double ah2 = dp * dp / sn2;
        int un2 = ux * ux + uy * uy;
        return (double)un2 - ah2;
    }

    private int findPoint(double x, double y) {
        double rangeX = this.m_xMax - this.m_xMin;
        double rangeY = this.m_yMax - this.m_yMin;
        double distanceMin = Double.MAX_VALUE;
        int nearestDataIndex = -1;
        int size = this.m_dataX == null ? 0 : this.m_dataX.length;
        for (int i = size - 1; i >= 0; --i) {
            double squaredDistance;
            double normalizedDistanceY;
            double normalizedDistanceX;
            double dataX = this.m_dataX[i];
            double dataY = this.m_dataY[i];
            double d = normalizedDistanceX = rangeX <= 1.0E-9 ? 0.0 : (x - dataX) / rangeX;
            if (normalizedDistanceX < 0.0) {
                normalizedDistanceX = -normalizedDistanceX;
            }
            double d2 = normalizedDistanceY = rangeY <= 1.0E-9 ? 0.0 : (y - dataY) / rangeY;
            if (normalizedDistanceY < 0.0) {
                normalizedDistanceY = -normalizedDistanceY;
            }
            if (!(distanceMin > (squaredDistance = normalizedDistanceX * normalizedDistanceX + normalizedDistanceY * normalizedDistanceY))) continue;
            distanceMin = squaredDistance;
            nearestDataIndex = i;
        }
        XAxis xAxis = this.m_plotPanel.getXAxis();
        YAxis yAxis = this.m_plotPanel.getYAxis();
        if (nearestDataIndex != -1) {
            double d1;
            double d0;
            Point p = new Point(xAxis.valueToPixel(x), this.m_plotPanel.getYAxis().valueToPixel(y));
            Point ps = null;
            Point pe = null;
            Point pnd = new Point(xAxis.valueToPixel(this.m_dataX[nearestDataIndex]), yAxis.valueToPixel(this.m_dataY[nearestDataIndex]));
            if (nearestDataIndex > 0) {
                ps = new Point(xAxis.valueToPixel(this.m_dataX[nearestDataIndex - 1]), yAxis.valueToPixel(this.m_dataY[nearestDataIndex - 1]));
            }
            if (nearestDataIndex < size - 1) {
                pe = new Point(xAxis.valueToPixel(this.m_dataX[nearestDataIndex + 1]), yAxis.valueToPixel(this.m_dataY[nearestDataIndex + 1]));
            }
            if (ps != null && Math.abs(d0 = PlotLinear.distanceToSegment(ps, pnd, p)) <= 4.0) {
                return nearestDataIndex;
            }
            if (pe != null && Math.abs(d1 = PlotLinear.distanceToSegment(pnd, pe, p)) <= 4.0) {
                return nearestDataIndex;
            }
        }
        return -1;
    }

    @Override
    public double getNearestXData(double x) {
        return x;
    }

    @Override
    public double getNearestYData(double y) {
        return y;
    }

    @Override
    public final void update() {
        double minY;
        double minX;
        boolean log;
        int size = this.m_compareDataInterface.getRowCount();
        if (size == 0) {
            return;
        }
        boolean logX = this.m_plotPanel.getXAxis().isLog();
        boolean logY = this.m_plotPanel.getYAxis().isLog();
        boolean bl = log = logX || logY;
        if (log) {
            if (!(this.m_compareDataInterface instanceof LogAdapterModel)) {
                this.m_compareDataInterface = new LogAdapterModel(this.m_compareDataInterface);
            }
            double replaceValueD = 0.1;
            ((LogAdapterModel)this.m_compareDataInterface).update(LogAdapterModel.POLICY.REPLACE_BY_VALUE, -1, logY ? this.m_cols[1] : -1, replaceValueD);
        } else if (this.m_compareDataInterface instanceof LogAdapterModel) {
            this.m_compareDataInterface = ((LogAdapterModel)this.m_compareDataInterface).getInnerModel();
        }
        size = this.m_compareDataInterface.getRowCount();
        this.m_dataX = new double[size];
        this.m_dataY = new double[size];
        this.m_dataSpec = new PlotDataSpec[size];
        this.m_selected = new boolean[size];
        boolean xAsEnum = this.m_plotPanel.getXAxis().isEnum();
        boolean yAsEnum = this.m_plotPanel.getYAxis().isEnum();
        for (int i = 0; i < size; ++i) {
            Object value;
            if (xAsEnum) {
                this.m_dataX[i] = i;
            } else {
                value = this.m_compareDataInterface.getDataValueAt(i, this.m_cols[0]);
                double d = this.m_dataX[i] = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
            }
            this.m_dataY[i] = yAsEnum ? (double)i : ((value = this.m_compareDataInterface.getDataValueAt(i, this.m_cols[1])) == null || value.equals(Float.valueOf(Float.NaN)) || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue());
            this.m_selected[i] = false;
            this.m_dataSpec[i] = this.m_compareDataInterface.getDataSpecAt(i);
        }
        double maxX = minX = this.m_dataX[0];
        double maxY = minY = this.m_dataY[0];
        for (int i = 0; i < size; ++i) {
            double x = this.m_dataX[i];
            double y = this.m_dataY[i];
            if (!Double.valueOf(x).isNaN()) {
                if (Double.valueOf(minX).isNaN()) {
                    minX = x;
                }
                if (Double.valueOf(maxX).isNaN()) {
                    maxX = x;
                }
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
            }
            if (Double.valueOf(y).isNaN()) continue;
            if (Double.valueOf(minY).isNaN()) {
                minY = y;
            }
            if (Double.valueOf(maxY).isNaN()) {
                maxY = y;
            }
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        if (Double.valueOf(minX).isNaN() || Double.valueOf(minY).isNaN()) {
            this.m_dataX = new double[0];
            this.m_dataY = new double[0];
            this.m_selected = new boolean[0];
            this.m_dataSpec = new PlotDataSpec[0];
            return;
        }
        this.m_xMin = minX;
        this.m_xMax = maxX;
        this.m_yMin = this.m_limitMinY != null ? Math.min(minY, this.m_limitMinY) : minY;
        this.m_yMax = maxY;
        if (!xAsEnum) {
            if (logX) {
                this.m_xMax *= 2.0;
                this.m_xMin /= 2.0;
            } else {
                double deltaX = this.m_xMax - this.m_xMin;
                if (deltaX <= 1.0E-9) {
                    this.m_xMin -= 1.0;
                    this.m_xMax += 1.0;
                } else {
                    this.m_xMax += deltaX * 0.01;
                }
            }
        }
        if (!yAsEnum) {
            if (logY) {
                this.m_yMax *= 2.0;
                this.m_yMin /= 2.0;
            } else {
                double deltaY = this.m_yMax - this.m_yMin;
                if (deltaY <= 1.0E-9) {
                    this.m_yMin -= 1.0;
                    this.m_yMax += 1.0;
                } else {
                    this.m_yMax += deltaY * 0.01;
                }
            }
        }
        this.sortData();
        double yLabel = this.m_yMax;
        if (this.m_compareDataInterface.getExternalData() != null) {
            this.m_yMax = logY ? (this.m_yMax *= 10.0) : (this.m_yMax *= 1.2);
        }
        DecimalFormat df = new DecimalFormat("#.00");
        if (this.m_compareDataInterface.getExternalData() != null && this.m_compareDataInterface.getExternalData().containsKey("VERTICAL_MARKER_VALUE")) {
            Object o = this.m_compareDataInterface.getExternalData().get("VERTICAL_MARKER_VALUE");
            Object o2 = this.m_compareDataInterface.getExternalData().get("VERTICAL_MARKER_TEXT");
            List colors = null;
            if (this.m_compareDataInterface.getExternalData().containsKey("VERTICAL_MARKER_COLOR")) {
                colors = (List)this.m_compareDataInterface.getExternalData().get("VERTICAL_MARKER_COLOR");
            }
            try {
                List values = (List)o;
                List texts = new ArrayList();
                if (o2 != null) {
                    texts = (List)o2;
                }
                int j = 0;
                double minForMarker = this.m_xMin;
                double maxForMarker = this.m_xMax;
                double delta = 5.0 * (this.m_xMax - this.m_xMin) / 100.0;
                double yL = yLabel;
                for (Double d : values) {
                    this.addMarker(new LineMarker(this.m_plotPanel, (double)d, 1));
                    minForMarker = Math.min(minForMarker, d - delta);
                    maxForMarker = Math.max(maxForMarker, d + delta);
                    if (texts.size() >= j) {
                        int orientation = 1;
                        if (j > 0) {
                            orientation = 0;
                        }
                        LabelMarker labelMarker = new LabelMarker(this.m_plotPanel, new DataCoordinates(d, yL), (String)texts.get(j) + df.format(d), orientation, 3);
                        if (colors != null && colors.size() >= j) {
                            labelMarker = new LabelMarker(this.m_plotPanel, new DataCoordinates(d, yL), (String)texts.get(j) + df.format(d), orientation, 3, (Color)colors.get(j));
                        }
                        this.addMarker(labelMarker);
                    }
                    ++j;
                    yL = yLabel * 1.1;
                    this.m_xMin = Math.min(this.m_xMin, minForMarker);
                    this.m_xMax = Math.max(this.m_xMax, maxForMarker);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_plotPanel.updateAxis(this);
        this.m_plotPanel.setXAxisTitle(this.m_compareDataInterface.getDataColumnIdentifier(this.m_cols[0]));
        this.m_plotPanel.setYAxisTitle(this.m_compareDataInterface.getDataColumnIdentifier(this.m_cols[1]));
    }

    private void setGradientValues() {
        double d;
        boolean useGradient;
        ColorOrGradient colorOrGradient = this.m_colorParameter.getColor();
        boolean bl = useGradient = !colorOrGradient.isColorSelected();
        if (!useGradient) {
            return;
        }
        this.m_gradientColors = colorOrGradient.getGradient().getColors();
        this.m_gradientFractions = colorOrGradient.getGradient().getFractions();
        int gradientParamCol = this.m_colorParameter.getSelectedReferenceIdName().getColumnIndex();
        if (gradientParamCol == this.m_gradientParamCol) {
            return;
        }
        this.m_gradientParamCol = gradientParamCol;
        int size = this.m_compareDataInterface.getRowCount();
        if (this.m_gradientParamValues == null || this.m_gradientParamValues.length != size) {
            this.m_gradientParamValues = new double[size];
        }
        if (size == 0) {
            return;
        }
        Object value = this.m_compareDataInterface.getDataValueAt(0, this.m_gradientParamCol);
        this.m_gradientParamValues[0] = d = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
        this.m_gradientParamValuesMin = d;
        this.m_gradientParamValuesMax = d;
        for (int i = 1; i < size; ++i) {
            value = this.m_compareDataInterface.getDataValueAt(i, this.m_gradientParamCol);
            this.m_gradientParamValues[i] = d = value == null || !Number.class.isAssignableFrom(value.getClass()) ? Double.NaN : ((Number)value).doubleValue();
            if (d < this.m_gradientParamValuesMin) {
                this.m_gradientParamValuesMin = d;
                continue;
            }
            if (!(d > this.m_gradientParamValuesMax)) continue;
            this.m_gradientParamValuesMax = d;
        }
    }

    private Color getColorInGradient(LinearGradientPaint gradient, double d) {
        double f = (d - this.m_gradientParamValuesMin) / (this.m_gradientParamValuesMax - this.m_gradientParamValuesMin);
        for (int i = 0; i < this.m_gradientFractions.length - 1; ++i) {
            float f1 = this.m_gradientFractions[i];
            float f2 = this.m_gradientFractions[i + 1];
            if (!(f >= (double)f1) || !(f <= (double)f2)) continue;
            Color c1 = this.m_gradientColors[i];
            Color c2 = this.m_gradientColors[i + 1];
            double fInInterval = (f - (double)f1) / (double)(f2 - f1);
            int r = (int)Math.round((double)(c2.getRed() - c1.getRed()) * fInInterval + (double)c1.getRed());
            int g = (int)Math.round((double)(c2.getGreen() - c1.getGreen()) * fInInterval + (double)c1.getGreen());
            int b = (int)Math.round((double)(c2.getBlue() - c1.getBlue()) * fInInterval + (double)c1.getBlue());
            int a = (int)Math.round((double)(c2.getAlpha() - c1.getAlpha()) * fInInterval + (double)c1.getAlpha());
            return new Color(r, g, b, a);
        }
        if (f <= (double)this.m_gradientFractions[0]) {
            return this.m_gradientColors[0];
        }
        return this.m_gradientColors[this.m_gradientFractions.length - 1];
    }

    @Override
    public double getXMin() {
        return this.m_xMin;
    }

    @Override
    public double getXMax() {
        return this.m_xMax;
    }

    @Override
    public double getYMin() {
        return this.m_yMin;
    }

    @Override
    public double getYMax() {
        return this.m_yMax;
    }

    @Override
    public void paint(Graphics2D g, XAxis xAxis, YAxis yAxis) {
        int size;
        int clipX = xAxis.valueToPixel(xAxis.getMinValue());
        int clipWidth = xAxis.valueToPixel(xAxis.getMaxValue()) - clipX;
        int clipY = yAxis.valueToPixel(yAxis.getMaxValue());
        int clipHeight = yAxis.valueToPixel(yAxis.getMinValue()) - clipY + 1;
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        boolean isLog = xAxis.isLog() || yAxis.isLog();
        ColorOrGradient colorOrGradient = this.m_colorParameter.getColor();
        boolean useGradient = !colorOrGradient.isColorSelected();
        Color plotColor = Color.black;
        LinearGradientPaint gradientPaint = null;
        if (!useGradient) {
            plotColor = colorOrGradient.getColor();
        } else {
            this.setGradientValues();
            gradientPaint = colorOrGradient.getGradient();
        }
        if (this.m_plotInformation != null && this.m_plotInformation.getPlotColor() != null) {
            plotColor = this.m_plotInformation.getPlotColor();
        }
        if (this.displayAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int n = size = this.m_dataX == null ? 0 : this.m_dataX.length;
        if (size > 0) {
            if (this.m_plotInformation != null && this.m_plotInformation.isSelected()) {
                this.paintExtendedLinear(g, SELECTED_COLOR, SELECTED_STROCK, 0.0);
            }
            int x0 = xAxis.valueToPixel(this.m_dataX[0]);
            int y0 = yAxis.valueToPixel(this.m_dataY[0]);
            boolean isDef0 = !Double.valueOf(this.m_dataX[0]).isNaN() && !Double.valueOf(this.m_dataY[0]).isNaN();
            for (int i = 0; i < size; ++i) {
                boolean errorOnLog;
                if (useGradient && (this.m_plotInformation == null || this.m_plotInformation.getPlotColor() == null)) {
                    plotColor = this.getColorInGradient(gradientPaint, this.m_gradientParamValues[i]);
                }
                int x = xAxis.valueToPixel(this.m_dataX[i]);
                int y = yAxis.valueToPixel(this.m_dataY[i]);
                boolean isDef = !Double.valueOf(this.m_dataX[i]).isNaN() && !Double.valueOf(this.m_dataY[i]).isNaN();
                g.setColor(plotColor);
                if (this.m_userStrock != null) {
                    g.setStroke(this.m_userStrock);
                } else if (this.m_plotInformation != null && this.m_plotInformation.isDashed()) {
                    g.setStroke(STROKE_1_DASHED);
                } else {
                    g.setStroke(this.m_strokeLine);
                }
                boolean bl = errorOnLog = isLog && ((LogAdapterModel)this.m_compareDataInterface).isOnError(i);
                if (errorOnLog || !isDef) {
                    g.setColor(Color.red);
                }
                if (this.m_isDrawPoints && isDef) {
                    int radius = 3;
                    if (this.m_dataSpec[i] != null && this.m_dataSpec[i].getFill().equals((Object)PlotDataSpec.FILL.EMPTY)) {
                        g.drawOval(x - radius, y - radius, radius * 2, radius * 2);
                    } else {
                        g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
                    }
                } else if (errorOnLog || !isDef) {
                    int radius = 3;
                    g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
                }
                if (this.m_isDrawGap || !this.m_isDrawGap && isDef && isDef0) {
                    g.setColor(plotColor);
                    if (!(isDef && isDef0 || x0 == x)) {
                        this.prepareGradientErrorColors(plotColor);
                        if (y0 < y) {
                            m_gradientStart.setLocation(x0, y0);
                            m_gradientEnd.setLocation(x, y);
                        } else {
                            m_gradientStart.setLocation(x, y);
                            m_gradientEnd.setLocation(x0, y0);
                        }
                        LinearGradientPaint gradient = new LinearGradientPaint(m_gradientStart, m_gradientEnd, ERROR_GRADIENT_STEPS, ERROR_GRADIENT_COLORS);
                        g.setPaint(gradient);
                    }
                    g.drawLine(x0, y0, x, y);
                }
                x0 = x;
                y0 = y;
                isDef0 = isDef;
            }
            if (this.m_tolerance != 0.0) {
                this.paintExtendedLinear(g, plotColor, EDGE_STROKE, this.m_tolerance);
                this.paintExtendedLinear(g, plotColor, EDGE_STROKE, -this.m_tolerance);
            }
        }
    }

    private void prepareGradientErrorColors(Color plotColor) {
        PlotLinear.ERROR_GRADIENT_COLORS[0] = plotColor;
        PlotLinear.ERROR_GRADIENT_COLORS[1] = new Color(plotColor.getRed(), plotColor.getGreen(), plotColor.getBlue(), 64);
        PlotLinear.ERROR_GRADIENT_COLORS[2] = new Color(plotColor.getRed(), plotColor.getGreen(), plotColor.getBlue(), 0);
    }

    private void paintExtendedLinear(Graphics2D g, Color color, Stroke strock, double tolerance) {
        XAxis xAxis = this.m_plotPanel.getXAxis();
        YAxis yAxis = this.m_plotPanel.getYAxis();
        int size = this.m_dataX == null ? 0 : this.m_dataX.length;
        int x0 = xAxis.valueToPixel(this.m_dataX[0]);
        int y0 = yAxis.valueToPixel(this.m_dataY[0] + tolerance);
        boolean isDef0 = !Double.valueOf(this.m_dataX[0]).isNaN() && !Double.valueOf(this.m_dataY[0]).isNaN();
        int radius = this.m_isDrawPoints ? 3 : 0;
        for (int i = 0; i < size; ++i) {
            boolean isDef = !Double.valueOf(this.m_dataX[i]).isNaN() && !Double.valueOf(this.m_dataY[i]).isNaN();
            int x = xAxis.valueToPixel(this.m_dataX[i]);
            int y = yAxis.valueToPixel(this.m_dataY[i] + tolerance);
            g.setStroke(strock);
            g.setColor(color);
            if (this.m_isDrawGap || !this.m_isDrawGap && isDef && isDef0) {
                g.drawLine(x0 + radius, y0, x, y);
            }
            if (this.m_isDrawPoints && isDef) {
                g.setColor(this.m_plotPanel.getBackground());
                g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
            }
            x0 = x;
            y0 = y;
            isDef0 = isDef;
        }
    }

    @Override
    public boolean getDoubleBufferingPolicy() {
        return this.m_dataX != null && this.m_dataX.length > 2000;
    }

    @Override
    public boolean needsXAxis() {
        return true;
    }

    @Override
    public boolean needsYAxis() {
        return true;
    }

    @Override
    public boolean canLogXAxis() {
        return true;
    }

    @Override
    public boolean canLogYAxis() {
        return true;
    }

    private void sortData() {
        int dataSize;
        int n = dataSize = this.m_dataX == null ? 0 : this.m_dataX.length;
        if (dataSize > 1) {
            for (int i = 1; i < dataSize; ++i) {
                double el = this.m_dataX[i];
                double elY = this.m_dataY[i];
                PlotDataSpec spec = this.m_dataSpec[i];
                for (int j = i; j > 0 && this.m_dataX[j - 1] > el; --j) {
                    this.m_dataX[j] = this.m_dataX[j - 1];
                    this.m_dataY[j] = this.m_dataY[j - 1];
                    this.m_dataSpec[j] = this.m_dataSpec[j - 1];
                }
                this.m_dataX[j] = el;
                this.m_dataY[j] = elY;
                this.m_dataSpec[j] = spec;
            }
        }
    }

    public void setPlotInformation(PlotInformation plotInformation) {
        this.m_plotInformation = plotInformation;
        if (plotInformation != null) {
            this.setDrawPoints(plotInformation.isDrawPoints());
            this.setDrawGap(plotInformation.isDrawGap());
            Color c = plotInformation.getPlotColor();
            if (c != null) {
                // empty if block
            }
        }
    }

    public PlotInformation getPlotInformation() {
        if (this.m_plotInformation.getPlotColor() != null) {
            this.m_plotInformation.setPlotColor(this.m_colorParameter.getColor().getColor());
        }
        return this.m_plotInformation;
    }

    @Override
    public boolean setIsPaintMarker(boolean isPaintMarker) {
        if (this.strokeFixed) {
            this.m_isPaintMarker = true;
            return false;
        }
        boolean modified = isPaintMarker ^ this.m_isPaintMarker;
        if (modified) {
            this.m_isPaintMarker = isPaintMarker;
            this.m_strokeLine = isPaintMarker ? STROKE_2 : (this.m_userStrock != null ? this.m_userStrock : STROKE_1);
        }
        return modified;
    }

    @Override
    public boolean isMouseOnPlot(double x, double y) {
        return this.findPoint(x, y) != -1;
    }

    @Override
    public boolean isMouseOnSelectedPlot(double x, double y) {
        return false;
    }

    public void setDrawPoints(boolean drawPoints) {
        this.m_isDrawPoints = drawPoints;
    }

    public void setDrawGap(boolean drawGap) {
        this.m_isDrawGap = drawGap;
    }

    @Override
    public void parametersChanged() {
    }

    @Override
    public String getEnumValueX(int index, boolean fromData) {
        if (index < 0 || index >= this.m_dataX.length) {
            return "";
        }
        return this.m_compareDataInterface.getDataValueAt(index, this.m_cols[0]).toString();
    }

    @Override
    public String getEnumValueY(int index, boolean fromData, Axis axis) {
        if (index < 0 || index >= this.m_dataY.length) {
            return "";
        }
        return this.m_compareDataInterface.getDataValueAt(index, this.m_cols[1]).toString();
    }

    public void setStrokeFixed(boolean b) {
        this.strokeFixed = b;
        this.m_strokeLine = STROKE_1;
    }

    public void setStroke(float witdh) {
        this.m_userStrock = new BasicStroke(witdh, 0, 0);
    }

    public void setAntiAliasing(boolean displayAntiAliasing) {
        this.displayAntiAliasing = displayAntiAliasing;
    }
}

