/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.marker.coordinates;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.marker.coordinates.AbstractCoordinates;

public class PercentageCoordinates
extends AbstractCoordinates {
    private double m_percentageX;
    private double m_percentageY;

    public PercentageCoordinates(double percentageX, double percentageY) {
        this.m_percentageX = percentageX;
        this.m_percentageY = percentageY;
    }

    @Override
    public int getPixelX(BasePlotPanel plotPanel) {
        XAxis xAxis = plotPanel.getXAxis();
        double xMax = xAxis.getMaxValue();
        double xMin = xAxis.getMinValue();
        return xAxis.valueToPixel(xMin + (xMax - xMin) * this.m_percentageX);
    }

    @Override
    public int getPixelY(BasePlotPanel plotPanel) {
        YAxis yAxis = plotPanel.getYAxis();
        double yMax = yAxis.getMaxValue();
        double yMin = yAxis.getMinValue();
        return yAxis.valueToPixel(yMin + (yMax - yMin) * this.m_percentageY);
    }

    @Override
    public void setPixelPosition(BasePlotPanel plotPanel, int pixelX, int pixelY) {
        XAxis xAxis = plotPanel.getXAxis();
        double xMax = xAxis.getMaxValue();
        double xMin = xAxis.getMinValue();
        double dataX = xAxis.pixelToValue(pixelX);
        this.m_percentageX = (dataX - xMin) / (xMax - xMin);
        YAxis yAxis = plotPanel.getYAxis();
        double yMax = yAxis.getMaxValue();
        double yMin = yAxis.getMinValue();
        double dataY = yAxis.pixelToValue(pixelY);
        this.m_percentageY = (dataY - yMin) / (yMax - yMin);
    }
}

