/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.venndiagram;

import fr.proline.studio.graphics.venndiagram.Circle;
import fr.proline.studio.graphics.venndiagram.SetIntersection;
import java.util.ArrayList;
import java.util.HashMap;

public class Set
implements Comparable<Set> {
    private final String m_name;
    private ArrayList<SetIntersection> m_intersections = new ArrayList(16);
    private HashMap<Set, SetIntersection> m_intersectionsMap = new HashMap();
    private Circle m_circle;
    private int m_id = -1;
    private double m_size;
    private double m_specificSize;

    public Set(String name, double size, int id) {
        this.m_name = name;
        this.m_id = id;
        this.m_circle = new Circle(size);
        this.m_size = size;
    }

    public void setSpecificSize(double specificSize) {
        this.m_specificSize = specificSize;
    }

    public double getSpecificSize() {
        return this.m_specificSize;
    }

    public int getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        return this.m_name + " : " + this.m_specificSize + "/" + this.m_size;
    }

    public Circle getCircle() {
        return this.m_circle;
    }

    public boolean intersect(Set s) {
        return this.m_intersectionsMap.containsKey(s);
    }

    public double getIntersection(Set s) {
        SetIntersection intersection = this.m_intersectionsMap.get(s);
        if (intersection == null) {
            return 0.0;
        }
        return intersection.getIntersectionSize();
    }

    public void addIntersection(SetIntersection intersection) {
        this.m_intersections.add(intersection);
        this.m_intersectionsMap.put(intersection.getOtherSet(this), intersection);
    }

    public int getNumberOfIntersections() {
        return this.m_intersections.size();
    }

    public int getNumberOfIntersectionsWithPositionedSet() {
        int nbIntersections = 0;
        for (Set s : this.m_intersectionsMap.keySet()) {
            if (!s.getCircle().isPositionSet()) continue;
            ++nbIntersections;
        }
        return nbIntersections;
    }

    public double getIntersectionsSize() {
        double intersectionsSize = 0.0;
        for (SetIntersection intersection : this.m_intersections) {
            intersectionsSize += intersection.getIntersectionSize();
        }
        return intersectionsSize;
    }

    @Override
    public int compareTo(Set s) {
        if (this.m_circle.isPositionSet()) {
            if (s.getCircle().isPositionSet()) {
                return 0;
            }
            return -1;
        }
        if (s.getCircle().isPositionSet()) {
            return 1;
        }
        int intersectionsWithPositionedSetDelta = this.getNumberOfIntersectionsWithPositionedSet() - s.getNumberOfIntersectionsWithPositionedSet();
        if (intersectionsWithPositionedSetDelta != 0) {
            return intersectionsWithPositionedSetDelta;
        }
        int intersectionsDelta = this.getNumberOfIntersections() - s.getNumberOfIntersections();
        if (intersectionsDelta != 0) {
            return intersectionsDelta;
        }
        double intersectionsSizeDelta = this.getIntersectionsSize() - s.getIntersectionsSize();
        if (intersectionsSizeDelta > 0.0) {
            return 1;
        }
        if (intersectionsSizeDelta < 0.0) {
            return -1;
        }
        return 0;
    }
}

