/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AdvancedSelectionPanel<E>
extends JPanel {
    private JList m_selectedList = null;
    private JList m_unselectedList = null;
    private ArrayList<E> m_objects = null;
    private JTextField m_selectionTextField = null;
    private JLabel m_selectionLabel = null;
    private JComboBox m_selectionComboBox = null;
    private static final String SELECT_FROM_PREFIX_SUFFIX = "<Select from Prefix/Suffix>";
    private static final String SEARCH_FOR_TEXT = "<Search for Text>";

    public AdvancedSelectionPanel(String selectedName, String unselectedName, ArrayList<E> objects, ArrayList<Boolean> selection) {
        this.m_objects = objects;
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        JPanel selectedPanel = this.createListPanel(true, selectedName, objects, selection);
        JPanel midActionPanel = this.createMiddlePanel();
        JPanel notSelectedPanel = this.createListPanel(false, unselectedName, objects, selection);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)notSelectedPanel, c);
        ++c.gridx;
        this.add((Component)midActionPanel, c);
        ++c.gridx;
        this.add((Component)selectedPanel, c);
        this.setFastSelectionValues(this.preparePrefixAndSuffix(objects));
    }

    private void setFastSelectionValues(String[] columnGroupNamesArray) {
        if (columnGroupNamesArray == null) {
            return;
        }
        this.m_selectionComboBox.setVisible(true);
        this.m_selectionLabel.setVisible(true);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_selectionComboBox.getModel();
        model.addElement(SELECT_FROM_PREFIX_SUFFIX);
        int nb = columnGroupNamesArray.length;
        for (int i = 0; i < nb; ++i) {
            model.addElement(columnGroupNamesArray[i]);
        }
        this.m_selectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectionIndex = AdvancedSelectionPanel.this.m_selectionComboBox.getSelectedIndex();
                if (selectionIndex <= 0) {
                    return;
                }
                String value = AdvancedSelectionPanel.this.removeHtmlColor(AdvancedSelectionPanel.this.m_selectionComboBox.getSelectedItem().toString());
                AdvancedSelectionPanel.this.selectFromText(value, AdvancedSelectionPanel.this.m_selectedList);
                AdvancedSelectionPanel.this.selectFromText(value, AdvancedSelectionPanel.this.m_unselectedList);
                AdvancedSelectionPanel.this.m_selectionComboBox.setSelectedIndex(0);
            }
        });
    }

    private void selectFromText(String value, JList list) {
        ListSelectionModel sm = list.getSelectionModel();
        sm.clearSelection();
        if (value.isEmpty()) {
            return;
        }
        value = value.toLowerCase();
        DefaultListModel listModel = (DefaultListModel)list.getModel();
        int lastSelectedIndex = -1;
        int nb = listModel.getSize();
        for (int i = 0; i < nb; ++i) {
            String valueCur = this.removeHtmlColor(listModel.getElementAt(i).toString()).toLowerCase();
            if (valueCur.indexOf(value) == -1) continue;
            sm.addSelectionInterval(i, i);
            lastSelectedIndex = i;
        }
        list.ensureIndexIsVisible(lastSelectedIndex);
        list.ensureIndexIsVisible(list.getSelectedIndex());
    }

    private String removeHtmlColor(String value) {
        int colorRemoveStart = value.indexOf("</font>", 0);
        int colorRemoveStop = value.indexOf("</html>", 0);
        if (colorRemoveStart > -1 && colorRemoveStop > colorRemoveStart) {
            value = value.substring(colorRemoveStart + "</font>".length(), colorRemoveStop);
        }
        return value;
    }

    public List<E> getSelectedItems() {
        ListModel model = this.m_selectedList.getModel();
        int size = model.getSize();
        ArrayList l = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            l.add(model.getElementAt(i));
        }
        return l;
    }

    public List<E> getNonSelectedItems() {
        ListModel model = this.m_unselectedList.getModel();
        int size = model.getSize();
        ArrayList l = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            l.add(model.getElementAt(i));
        }
        return l;
    }

    public int[] getSelectedIndices() {
        ListModel model = this.m_selectedList.getModel();
        int nbNonSelected = model.getSize();
        int[] rv = new int[nbNonSelected];
        for (int i = 0; i < nbNonSelected; ++i) {
            Object item = model.getElementAt(i);
            rv[i] = this.m_objects.indexOf(item);
        }
        return rv;
    }

    public int[] getNonSelectedIndices() {
        ListModel model = this.m_unselectedList.getModel();
        int nbNonSelected = model.getSize();
        int[] rv = new int[nbNonSelected];
        for (int i = 0; i < nbNonSelected; ++i) {
            Object item = model.getElementAt(i);
            rv[i] = this.m_objects.indexOf(item);
        }
        return rv;
    }

    public final JPanel createListPanel(boolean selectedList, String name, ArrayList<E> objects, ArrayList<Boolean> selection) {
        JPanel listPanel = new JPanel(new GridBagLayout());
        listPanel.setBorder(BorderFactory.createTitledBorder(name));
        listPanel.setBackground(Color.white);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        DefaultListModel<E> listModel = new DefaultListModel<E>();
        for (int i = 0; i < objects.size(); ++i) {
            if ((!selectedList || !selection.get(i).booleanValue()) && (selectedList || selection.get(i).booleanValue())) continue;
            listModel.addElement(objects.get(i));
        }
        JList list = new JList(listModel);
        list.setSelectionMode(2);
        JScrollPane listScrollPane = new JScrollPane(list){
            private final Dimension preferredSize;
            {
                this.preferredSize = new Dimension(280, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        listPanel.add((Component)listScrollPane, c);
        if (selectedList) {
            this.m_selectedList = list;
        } else {
            this.m_unselectedList = list;
        }
        return listPanel;
    }

    public final JPanel createMiddlePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JButton arrowRight = new JButton(IconManager.getIcon(IconManager.IconType.ARROW));
        JButton arrowLeft = new JButton(IconManager.getIcon(IconManager.IconType.BACK));
        this.m_selectionTextField = new JTextField(SEARCH_FOR_TEXT, 30);
        this.m_selectionTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AdvancedSelectionPanel.this.m_selectionTextField.getText().compareTo(AdvancedSelectionPanel.SEARCH_FOR_TEXT) == 0) {
                    AdvancedSelectionPanel.this.m_selectionTextField.setText("");
                }
            }
        });
        this.m_selectionTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChanged();
            }

            public void textChanged() {
                String value = AdvancedSelectionPanel.this.m_selectionTextField.getText();
                AdvancedSelectionPanel.this.selectFromText(value, AdvancedSelectionPanel.this.m_selectedList);
                AdvancedSelectionPanel.this.selectFromText(value, AdvancedSelectionPanel.this.m_unselectedList);
            }
        });
        this.m_selectionComboBox = new JComboBox();
        this.m_selectionComboBox.setVisible(false);
        this.m_selectionLabel = new JLabel(IconManager.getIcon(IconManager.IconType.SEARCH));
        this.m_selectionLabel.setVisible(false);
        arrowRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List objectsToMoveList = AdvancedSelectionPanel.this.m_unselectedList.getSelectedValuesList();
                List selectedColumnsNonSorted = AdvancedSelectionPanel.this.getSelectedItems();
                selectedColumnsNonSorted.addAll(objectsToMoveList);
                DefaultListModel selectedModel = (DefaultListModel)AdvancedSelectionPanel.this.m_selectedList.getModel();
                DefaultListModel unselectedModel = (DefaultListModel)AdvancedSelectionPanel.this.m_unselectedList.getModel();
                selectedModel.removeAllElements();
                unselectedModel.removeAllElements();
                int[] selectedIndices = new int[objectsToMoveList.size()];
                int index = 0;
                int indexCur = 0;
                for (int i = 0; i < AdvancedSelectionPanel.this.m_objects.size(); ++i) {
                    Object object = AdvancedSelectionPanel.this.m_objects.get(i);
                    if (selectedColumnsNonSorted.contains(object)) {
                        selectedModel.addElement(object);
                        if (objectsToMoveList.contains(object)) {
                            selectedIndices[index] = indexCur;
                            ++index;
                        }
                        ++indexCur;
                        continue;
                    }
                    unselectedModel.addElement(object);
                }
                AdvancedSelectionPanel.this.m_selectedList.setSelectedIndices(selectedIndices);
            }
        });
        arrowLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List objectsToMoveList = AdvancedSelectionPanel.this.m_selectedList.getSelectedValuesList();
                List unselectedColumnsNonSorted = AdvancedSelectionPanel.this.getNonSelectedItems();
                unselectedColumnsNonSorted.addAll(objectsToMoveList);
                DefaultListModel selectedModel = (DefaultListModel)AdvancedSelectionPanel.this.m_selectedList.getModel();
                DefaultListModel unselectedModel = (DefaultListModel)AdvancedSelectionPanel.this.m_unselectedList.getModel();
                selectedModel.removeAllElements();
                unselectedModel.removeAllElements();
                int[] selectedIndices = new int[objectsToMoveList.size()];
                int index = 0;
                int indexCur = 0;
                for (int i = 0; i < AdvancedSelectionPanel.this.m_objects.size(); ++i) {
                    Object object = AdvancedSelectionPanel.this.m_objects.get(i);
                    if (unselectedColumnsNonSorted.contains(object)) {
                        unselectedModel.addElement(object);
                        if (objectsToMoveList.contains(object)) {
                            selectedIndices[index] = indexCur;
                            ++index;
                        }
                        ++indexCur;
                        continue;
                    }
                    selectedModel.addElement(object);
                }
                AdvancedSelectionPanel.this.m_unselectedList.setSelectedIndices(selectedIndices);
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        panel.add((Component)Box.createVerticalBox(), c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 10;
        panel.add((Component)arrowRight, c);
        ++c.gridy;
        panel.add((Component)arrowLeft, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)Box.createVerticalBox(), c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.anchor = 18;
        c.fill = 1;
        panel.add((Component)new JLabel(IconManager.getIcon(IconManager.IconType.SEARCH)), c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)this.m_selectionTextField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)this.m_selectionLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        panel.add((Component)this.m_selectionComboBox, c);
        return panel;
    }

    private String[] preparePrefixAndSuffix(ArrayList<E> objects) {
        HashMap<String, Integer> similarColumnsNumberMap = new HashMap<String, Integer>();
        HashMap<String, String> similarColumnsColorsMap = new HashMap<String, String>();
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            String fullValue = objects.get(i).toString();
            Object nohtmlValue = fullValue;
            int colorIndexStart = fullValue.indexOf("<font color='", 0);
            int colorIndexStop = fullValue.indexOf("</font>", 0);
            if (colorIndexStart != -1 && colorIndexStop > colorIndexStart) {
                nohtmlValue = ((String)nohtmlValue).substring(0, colorIndexStart) + ((String)nohtmlValue).substring(colorIndexStop + "</font>".length(), ((String)nohtmlValue).length());
            }
            int indexStart = ((String)nohtmlValue).indexOf(60);
            int indexStop = ((String)nohtmlValue).indexOf(62);
            while (indexStart != -1 && indexStop > indexStart) {
                nohtmlValue = ((String)nohtmlValue).substring(0, indexStart) + ((String)nohtmlValue).substring(indexStop + 1, ((String)nohtmlValue).length());
                indexStart = ((String)nohtmlValue).indexOf(60);
                indexStop = ((String)nohtmlValue).indexOf(62);
            }
            Object prefix = nohtmlValue;
            int indexFirstSpace = ((String)prefix).indexOf(32);
            if (indexFirstSpace != -1) {
                prefix = ((String)prefix).substring(0, indexFirstSpace);
            }
            if (((String)prefix).length() > 0) {
                Integer nb = (Integer)similarColumnsNumberMap.get(prefix);
                if (nb == null) {
                    similarColumnsNumberMap.put((String)prefix, 1);
                } else {
                    similarColumnsNumberMap.put((String)prefix, nb + 1);
                }
                colorIndexStart = fullValue.indexOf("<font color='", 0);
                colorIndexStop = fullValue.indexOf("</font>", 0);
                if (colorIndexStart > -1 && colorIndexStop > colorIndexStart) {
                    String colorName = fullValue.substring(colorIndexStart, colorIndexStop + "</font>".length());
                    String curColorName = similarColumnsColorsMap.get(prefix);
                    if (curColorName != null) {
                        if (curColorName.compareTo(colorName) != 0) {
                            similarColumnsColorsMap.put((String)prefix, "");
                        }
                    } else {
                        similarColumnsColorsMap.put((String)prefix, colorName);
                    }
                } else {
                    similarColumnsColorsMap.put((String)prefix, "");
                }
            }
            int indexLastSpace = ((String)nohtmlValue).lastIndexOf(32);
            while (indexLastSpace != -1) {
                indexLastSpace = this.addSuffix(indexLastSpace, (String)nohtmlValue, fullValue, similarColumnsNumberMap, similarColumnsColorsMap);
            }
        }
        Set suffixSet = similarColumnsNumberMap.keySet();
        String[] suffixArray = suffixSet.toArray(new String[suffixSet.size()]);
        for (int i = 0; i < suffixArray.length; ++i) {
            String suffixCur = suffixArray[i];
            if (!similarColumnsNumberMap.containsKey(suffixCur)) continue;
            Integer nb = (Integer)similarColumnsNumberMap.get(suffixCur);
            if (nb <= 1) {
                similarColumnsNumberMap.remove(suffixCur);
                continue;
            }
            for (int j = i + 1; j < suffixArray.length; ++j) {
                Integer nb2;
                String suffixCur2 = suffixArray[j];
                if ((suffixCur.length() >= suffixCur2.length() || !suffixCur2.endsWith(suffixCur)) && (suffixCur.length() <= suffixCur2.length() || !suffixCur.endsWith(suffixCur2)) || nb != (nb2 = similarColumnsNumberMap.get(suffixCur2))) continue;
                if (suffixCur.length() < suffixCur2.length()) {
                    similarColumnsNumberMap.remove(suffixCur);
                    continue;
                }
                similarColumnsNumberMap.remove(suffixCur2);
            }
        }
        Object[] groups = null;
        int nbGroups = similarColumnsNumberMap.size();
        if (nbGroups > 0) {
            groups = new String[nbGroups];
            Iterator it = similarColumnsNumberMap.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                String name = (String)it.next();
                String colorName = (String)similarColumnsColorsMap.get(name);
                groups[i] = colorName != null && colorName.length() > 0 ? "<html>" + colorName + name + "</html>" : name;
                ++i;
            }
            Arrays.sort(groups);
        }
        return groups;
    }

    private int addSuffix(int indexLastSpace, String nohtmlValue, String fullValue, HashMap<String, Integer> similarColumnsNumberMap, HashMap<String, String> similarColumnsColorsMap) {
        if (indexLastSpace != -1) {
            String suffix = nohtmlValue;
            int indexPreviousSpace = nohtmlValue.substring(0, indexLastSpace).lastIndexOf(32);
            if (indexPreviousSpace != -1 && (suffix = nohtmlValue.substring(indexPreviousSpace, nohtmlValue.length())).length() > 0) {
                Integer nb = similarColumnsNumberMap.get(suffix);
                if (nb == null) {
                    similarColumnsNumberMap.put(suffix, 1);
                } else {
                    similarColumnsNumberMap.put(suffix, nb + 1);
                }
                int colorIndexStart = fullValue.indexOf("<font color='", 0);
                int colorIndexStop = fullValue.indexOf("</font>", 0);
                if (colorIndexStart > -1 && colorIndexStop > colorIndexStart) {
                    String colorName = fullValue.substring(colorIndexStart, colorIndexStop + "</font>".length());
                    String curColorName = similarColumnsColorsMap.get(suffix);
                    if (curColorName != null) {
                        if (curColorName.compareTo(colorName) != 0) {
                            similarColumnsColorsMap.put(suffix, "");
                        }
                    } else {
                        similarColumnsColorsMap.put(suffix, colorName);
                    }
                } else {
                    similarColumnsColorsMap.put(suffix, "");
                }
            }
            return indexPreviousSpace;
        }
        return -1;
    }
}

