/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.gui;

import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SplittedPanelContainer
extends JPanel {
    private ArrayList<SplittedPanel> m_panelArray = new ArrayList(4);
    private ArrayList<JSplitPane> m_splitPaneArray = new ArrayList(3);
    private JPanel m_mainPanel;
    private IconifiedPanel m_iconifiedPanel;
    private JPanel m_containerPanel;
    private boolean m_aPanelMaximized = false;
    private final boolean m_includeSaveAndAddButtonsInToolbar;
    private Component previousMainComponent = null;
    private Container previousPanelParent = null;
    private int[] previousHeights = null;

    public SplittedPanelContainer(boolean includeSaveAndAddButtonsInToolbar) {
        this.m_includeSaveAndAddButtonsInToolbar = includeSaveAndAddButtonsInToolbar;
    }

    public void generateListOfPanels(ArrayList<JPanel> panelList, ArrayList<PanelLayout> layoutList) {
        for (int i = 0; i < this.m_panelArray.size(); ++i) {
            SplittedPanel splittedPanel = this.m_panelArray.get(i);
            JComponent c = splittedPanel.getEmbededPanel();
            this.generateForComponent(c, panelList, layoutList, PanelLayout.VERTICAL);
        }
    }

    private void generateForComponent(Component c, ArrayList<JPanel> panelList, ArrayList<PanelLayout> layoutList, PanelLayout layout) {
        if (c instanceof JTabbedPane) {
            if (layout != null) {
                layoutList.add(layout);
            }
            this.generateForTabbedPane((JTabbedPane)c, panelList, layoutList);
        } else if (c instanceof JSplitPane) {
            if (layout != null) {
                layoutList.add(layout);
            }
            this.generateForSplitPane((JSplitPane)c, panelList, layoutList);
        } else if (c instanceof JPanel) {
            if (layout != null) {
                layoutList.add(layout);
            }
            panelList.add((JPanel)c);
        }
    }

    private void generateForTabbedPane(JTabbedPane tabbedPane, ArrayList<JPanel> panelList, ArrayList<PanelLayout> layoutList) {
        int nbTabs = tabbedPane.getComponentCount();
        for (int i = 0; i < nbTabs; ++i) {
            Component c = tabbedPane.getComponentAt(i);
            this.generateForComponent(c, panelList, layoutList, i == 0 ? null : PanelLayout.TABBED);
        }
    }

    private void generateForSplitPane(JSplitPane splitPane, ArrayList<JPanel> panelList, ArrayList<PanelLayout> layoutList) {
        this.generateForComponent(splitPane.getLeftComponent(), panelList, layoutList, null);
        this.generateForComponent(splitPane.getRightComponent(), panelList, layoutList, PanelLayout.HORIZONTAL);
    }

    public void registerPanel(JComponent panel) {
        SplittedPanel splittedPanel = new SplittedPanel(this.m_panelArray.size(), panel, this);
        this.m_panelArray.add(splittedPanel);
    }

    public void registerAddedPanel(JComponent panel) {
        int[] heights = this.getHeights();
        int totalHeight = 0;
        for (int i = 0; i < heights.length; ++i) {
            totalHeight += heights[i];
        }
        int heightOfNewPanel = totalHeight / (heights.length + 1);
        int decPanel = heightOfNewPanel / heights.length;
        int[] newHeights = new int[heights.length + 1];
        for (int i = 0; i < heights.length; ++i) {
            newHeights[i] = heights[i] - decPanel;
        }
        newHeights[heights.length] = heightOfNewPanel;
        SplittedPanel splittedPanel = new SplittedPanel(this.m_panelArray.size(), panel, this);
        this.insertPanel(splittedPanel);
        this.updateButtons();
        this.dispatchHeight(newHeights);
    }

    public void registerAddedPanelAsTab(JComponent panel) {
        SplittedPanel splittedBottomPanel = this.m_panelArray.get(this.m_panelArray.size() - 1);
        JComponent bottomComponent = splittedBottomPanel.getEmbededPanel();
        ArrayList<Component> components = new ArrayList<Component>();
        if (bottomComponent instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)bottomComponent;
            int nbTabs = tabbedPane.getTabCount();
            for (int i = 0; i < nbTabs; ++i) {
                components.add(tabbedPane.getComponentAt(i));
            }
            tabbedPane.removeAll();
        } else {
            components.add(bottomComponent);
        }
        components.add(panel);
        ReactiveTabbedPane tb = new ReactiveTabbedPane();
        tb.setBorder(new EmptyBorder(8, 8, 8, 8));
        Object name = "";
        int nbTabs = components.size();
        for (int i = 0; i < nbTabs; ++i) {
            Component curComp = (Component)components.get(i);
            String curName = curComp.getName();
            tb.addTab(curName, curComp);
            name = i == 0 ? curName : (String)name + " / " + curName;
        }
        tb.setName((String)name);
        tb.setSelectedIndex(nbTabs - 1);
        splittedBottomPanel.replaceEmbededPanel(tb);
        this.revalidate();
        this.repaint();
        this.updateButtons();
    }

    public void registerAddedPanelAsSplitted(JComponent panel) {
        SplittedPanel splittedBottomPanel = this.m_panelArray.get(this.m_panelArray.size() - 1);
        JComponent bottomComponent = splittedBottomPanel.getEmbededPanel();
        JSplitPane sp = new JSplitPane();
        sp.setLeftComponent(bottomComponent);
        sp.setRightComponent(panel);
        sp.setName(bottomComponent.getName() + " / " + panel.getName());
        splittedBottomPanel.replaceEmbededPanel(sp);
        int width = this.getWidth();
        if (width > 0) {
            sp.setDividerLocation(this.getWidth() / 2);
        } else {
            final JSplitPane _sp = sp;
            final SplittedPanelContainer _p = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    _sp.setDividerLocation(_p.getWidth() / 2);
                }
            });
        }
        this.revalidate();
        this.repaint();
        this.updateButtons();
    }

    public void removeLastPanel() {
        SplittedPanel splittedPanel = this.m_panelArray.get(this.m_panelArray.size() - 1);
        JComponent c = splittedPanel.getEmbededPanel();
        if (c instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)c;
            int nbTabs = tabbedPane.getComponentCount();
            tabbedPane.removeTabAt(nbTabs - 1);
            if (nbTabs == 2) {
                JComponent newEmbeddedComponent = (JComponent)tabbedPane.getComponentAt(0);
                tabbedPane.removeTabAt(0);
                splittedPanel.replaceEmbededPanel(newEmbeddedComponent);
            }
        } else if (c instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)c;
            splittedPanel.replaceEmbededPanel((JComponent)splitPane.getLeftComponent());
        } else {
            int[] heights = this.getHeights();
            int incPanel = heights[heights.length - 1] / (heights.length - 1);
            int[] newHeights = new int[heights.length - 1];
            for (int i = 0; i < newHeights.length; ++i) {
                newHeights[i] = heights[i] + incPanel;
            }
            this.removePanel(this.m_panelArray.size() - 1);
            this.dispatchHeight(newHeights);
        }
        this.revalidate();
        this.repaint();
        this.updateButtons();
    }

    public void updateButtons() {
        int size = this.m_panelArray.size();
        for (int i = 0; i < size; ++i) {
            SplittedPanel p = this.m_panelArray.get(i);
            p.updateAssociationButtons();
            p.updateRemoveAddButtons(i == 0, i == size - 1);
        }
    }

    public void splitPanel(JComponent panel, int index) {
        int[] heights = this.getHeights();
        int totalHeight = 0;
        for (int i = 0; i < heights.length; ++i) {
            totalHeight += heights[i];
        }
        double coef = (double)totalHeight / (double)(totalHeight + heights[index - 1]);
        int[] newHeights = new int[heights.length + 1];
        for (int i = 0; i < newHeights.length; ++i) {
            newHeights[i] = i < index ? (int)((double)heights[i] * coef) : (i == index ? newHeights[i - 1] : (int)((double)heights[i - 1] * coef));
        }
        SplittedPanel splittedPanel = new SplittedPanel(index, panel, this);
        for (int i = index; i < this.m_panelArray.size(); ++i) {
            this.m_panelArray.get(i).incIndex();
        }
        this.m_panelArray.add(index, splittedPanel);
        if (index == 0) {
            JSplitPane splitPane = new JSplitPane();
            splitPane.setOrientation(0);
            splitPane.setTopComponent(this.m_panelArray.get(0));
            splitPane.setBottomComponent(this.m_splitPaneArray.get(0));
            this.m_splitPaneArray.add(0, splitPane);
        } else if (index == this.m_panelArray.size() - 1) {
            JPanel lastPanel = this.m_panelArray.get(this.m_panelArray.size() - 2);
            if (this.m_splitPaneArray.size() > 0) {
                JSplitPane lastSplitPane = this.m_splitPaneArray.get(this.m_splitPaneArray.size() - 1);
                lastSplitPane.remove(lastPanel);
                JSplitPane splitPane = new JSplitPane();
                splitPane.setOrientation(0);
                splitPane.setTopComponent(lastPanel);
                splitPane.setBottomComponent(splittedPanel);
                lastSplitPane.setBottomComponent(splitPane);
                this.m_splitPaneArray.add(splitPane);
            } else {
                JSplitPane splitPane = new JSplitPane();
                splitPane.setOrientation(0);
                splitPane.setTopComponent(lastPanel);
                splitPane.setBottomComponent(splittedPanel);
                this.m_splitPaneArray.add(splitPane);
                this.m_containerPanel.removeAll();
                this.m_containerPanel.add(splitPane);
            }
        } else {
            JSplitPane splitPaneParent = this.m_splitPaneArray.get(index - 1);
            Component bottomComponent = splitPaneParent.getBottomComponent();
            splitPaneParent.remove(bottomComponent);
            JSplitPane splitPane = new JSplitPane();
            splitPane.setOrientation(0);
            splitPane.setTopComponent(splittedPanel);
            splitPane.setBottomComponent(bottomComponent);
            splitPaneParent.setBottomComponent(splitPane);
            this.m_splitPaneArray.add(index, splitPane);
        }
        this.updateButtons();
        this.revalidate();
        this.repaint();
        this.dispatchHeight(newHeights);
    }

    public void associatePanelsAsTab(int bottomPanelIndex) {
        int i;
        int nbTabs;
        JTabbedPane tabbedPane;
        if (bottomPanelIndex == 0) {
            return;
        }
        int[] heights = this.getHeights();
        int totalHeight = 0;
        for (int i2 = 0; i2 < heights.length; ++i2) {
            totalHeight += heights[i2];
        }
        double coef = (double)totalHeight / (double)(totalHeight - heights[bottomPanelIndex]);
        int[] newHeights = new int[heights.length - 1];
        for (int i3 = 0; i3 < heights.length; ++i3) {
            if (i3 < bottomPanelIndex) {
                newHeights[i3] = (int)((double)heights[i3] * coef);
                continue;
            }
            if (i3 <= bottomPanelIndex) continue;
            newHeights[i3 - 1] = (int)((double)heights[i3] * coef);
        }
        SplittedPanel splittedTopPanel = this.m_panelArray.get(bottomPanelIndex - 1);
        SplittedPanel splittedBottomPanel = this.m_panelArray.get(bottomPanelIndex);
        JComponent topComponent = splittedTopPanel.getEmbededPanel();
        JComponent bottomComponent = splittedBottomPanel.getEmbededPanel();
        this.removePanel(bottomPanelIndex);
        ArrayList<Component> components = new ArrayList<Component>();
        if (topComponent instanceof JTabbedPane) {
            tabbedPane = (JTabbedPane)topComponent;
            nbTabs = tabbedPane.getTabCount();
            for (i = 0; i < nbTabs; ++i) {
                components.add(tabbedPane.getComponentAt(i));
            }
            tabbedPane.removeAll();
        } else {
            components.add(topComponent);
        }
        if (bottomComponent instanceof JTabbedPane) {
            tabbedPane = (JTabbedPane)bottomComponent;
            nbTabs = tabbedPane.getTabCount();
            for (i = 0; i < nbTabs; ++i) {
                components.add(tabbedPane.getComponentAt(i));
            }
            tabbedPane.removeAll();
        } else {
            components.add(bottomComponent);
        }
        ReactiveTabbedPane tb = new ReactiveTabbedPane();
        tb.setBorder(new EmptyBorder(8, 8, 8, 8));
        Object name = "";
        for (i = 0; i < components.size(); ++i) {
            Component curComp = (Component)components.get(i);
            String curName = curComp.getName();
            tb.addTab(curName, curComp);
            name = i == 0 ? curName : (String)name + " / " + curName;
        }
        tb.setName((String)name);
        splittedTopPanel.replaceEmbededPanel(tb);
        this.revalidate();
        this.repaint();
        this.dispatchHeight(newHeights);
    }

    public void resetDefaultSize() {
        int[] heights = this.getHeights();
        int totalHeight = 0;
        int nb = heights.length;
        for (int i = 0; i < nb; ++i) {
            totalHeight += heights[i];
        }
        int defaultHeight = totalHeight / nb;
        for (int i = 0; i < nb; ++i) {
            heights[i] = defaultHeight;
        }
        this.dispatchHeight(heights);
    }

    public void createPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new GridBagLayout());
        this.add(this.m_mainPanel);
        this.m_iconifiedPanel = new IconifiedPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        this.m_mainPanel.add((Component)this.m_iconifiedPanel, c);
        this.m_containerPanel = new JPanel();
        this.m_containerPanel.setLayout(new GridLayout(1, 1));
        ++c.gridy;
        c.weighty = 1.0;
        this.m_mainPanel.add((Component)this.m_containerPanel, c);
        this.createPanel(this.m_containerPanel, 0);
        this.updateButtons();
    }

    private JComponent createPanel(JComponent container, int indexPanel) {
        if (indexPanel == this.m_panelArray.size() - 1) {
            container.add(this.m_panelArray.get(indexPanel));
        } else {
            JSplitPane splitPane = new JSplitPane();
            splitPane.setOrientation(0);
            splitPane.setTopComponent(this.m_panelArray.get(indexPanel));
            this.m_splitPaneArray.add(splitPane);
            JPanel bottomPanel = new JPanel();
            GridLayout layout = new GridLayout(1, 1);
            bottomPanel.setLayout(layout);
            splitPane.setBottomComponent(this.createPanel(bottomPanel, indexPanel + 1));
            container.add(splitPane);
        }
        return container;
    }

    private void insertPanel(SplittedPanel splittedPanel) {
        int insertIndex = 0;
        int size = this.m_panelArray.size();
        if (size == 0) {
            this.m_containerPanel.add(splittedPanel);
        } else {
            int indexAtCreation = splittedPanel.getIndex();
            for (insertIndex = 0; insertIndex < size && indexAtCreation >= this.m_panelArray.get(insertIndex).getIndex(); ++insertIndex) {
            }
            if (insertIndex == 0) {
                Component componentToKeep = this.m_containerPanel.getComponent(0);
                this.m_containerPanel.remove(0);
                JSplitPane splitPane = new JSplitPane();
                splitPane.setOrientation(0);
                splitPane.setTopComponent(splittedPanel);
                splitPane.setBottomComponent(componentToKeep);
                this.m_containerPanel.add(splitPane);
                this.m_splitPaneArray.add(0, splitPane);
            } else if (insertIndex == size) {
                if (size == 1) {
                    Component componentToKeep = this.m_containerPanel.getComponent(0);
                    this.m_containerPanel.remove(0);
                    JSplitPane splitPane = new JSplitPane();
                    splitPane.setOrientation(0);
                    splitPane.setTopComponent(componentToKeep);
                    splitPane.setBottomComponent(splittedPanel);
                    this.m_containerPanel.add(splitPane);
                    this.m_splitPaneArray.add(0, splitPane);
                } else {
                    JSplitPane splitPaneParent = this.m_splitPaneArray.get(insertIndex - 2);
                    Component componentToKeep = splitPaneParent.getBottomComponent();
                    splitPaneParent.setBottomComponent(null);
                    JSplitPane splitPane = new JSplitPane();
                    splitPane.setOrientation(0);
                    splitPane.setTopComponent(componentToKeep);
                    splitPane.setBottomComponent(splittedPanel);
                    splitPaneParent.setBottomComponent(splitPane);
                    this.m_splitPaneArray.add(insertIndex - 1, splitPane);
                }
            } else {
                JSplitPane splitPaneParent = this.m_splitPaneArray.get(insertIndex - 1);
                Component componentToKeep = splitPaneParent.getBottomComponent();
                splitPaneParent.setBottomComponent(null);
                JSplitPane splitPane = new JSplitPane();
                splitPane.setOrientation(0);
                splitPane.setTopComponent(splittedPanel);
                splitPane.setBottomComponent(componentToKeep);
                splitPaneParent.setBottomComponent(splitPane);
                this.m_splitPaneArray.add(insertIndex, splitPane);
            }
        }
        this.m_panelArray.add(insertIndex, splittedPanel);
        this.revalidate();
        this.repaint();
    }

    private void removePanel(int index) {
        if (index < this.m_splitPaneArray.size()) {
            splitPane = this.m_splitPaneArray.get(index);
            componentKept = splitPane.getBottomComponent();
            splitPane.setTopComponent(null);
            splitPane.setBottomComponent(null);
            if (index > 0) {
                parentSplitPane = this.m_splitPaneArray.get(index - 1);
                parentSplitPane.setBottomComponent(componentKept);
            } else {
                this.m_containerPanel.remove(0);
                this.m_containerPanel.add(componentKept);
            }
            this.m_splitPaneArray.remove(index);
        } else if (index > 0) {
            splitPane = this.m_splitPaneArray.get(index - 1);
            componentKept = splitPane.getTopComponent();
            splitPane.setTopComponent(null);
            splitPane.setBottomComponent(null);
            if (index - 2 >= 0) {
                parentSplitPane = this.m_splitPaneArray.get(index - 2);
                parentSplitPane.setBottomComponent(componentKept);
            } else {
                this.m_containerPanel.remove(0);
                this.m_containerPanel.add(componentKept);
            }
            this.m_splitPaneArray.remove(index - 1);
        } else {
            this.m_containerPanel.remove(0);
        }
        this.m_panelArray.remove(index);
        for (int i = index; i < this.m_panelArray.size(); ++i) {
            this.m_panelArray.get(i).decIndex();
        }
        this.revalidate();
        this.repaint();
    }

    private void inflate(SplittedPanel splittedPanel, int height) {
        boolean doHeightCalculation;
        int[] heights = this.getHeights();
        boolean bl = doHeightCalculation = heights.length > 0;
        if (doHeightCalculation) {
            int heightToRemove = height / heights.length;
            int i = 0;
            while (i < heights.length) {
                int n = i++;
                heights[n] = heights[n] - heightToRemove;
            }
        }
        this.insertPanel(splittedPanel);
        if (doHeightCalculation) {
            int insertIndex;
            int indexAtCreation = splittedPanel.getIndex();
            for (insertIndex = 0; insertIndex < this.m_panelArray.size() && indexAtCreation >= this.m_panelArray.get(insertIndex).getIndex(); ++insertIndex) {
            }
            int[] newHeights = new int[heights.length + 1];
            int newHeightIndex = 0;
            for (int i = 0; i < heights.length; ++i) {
                newHeights[newHeightIndex++] = i == insertIndex ? height : heights[i];
            }
            this.dispatchHeight(newHeights);
        }
    }

    private void maximize(SplittedPanel panel) {
        this.m_aPanelMaximized = true;
        int index = this.m_panelArray.indexOf(panel);
        this.previousHeights = this.getHeights();
        this.previousMainComponent = this.getComponent(0);
        this.remove(0);
        SplittedPanel panelToMaximize = this.m_panelArray.get(index);
        this.previousPanelParent = panelToMaximize.getParent();
        this.previousPanelParent.remove(panelToMaximize);
        this.add(panelToMaximize);
        this.revalidate();
        this.repaint();
    }

    private void reduce(SplittedPanel panelToReduce) {
        this.m_aPanelMaximized = false;
        this.remove(0);
        this.previousPanelParent.add(panelToReduce);
        this.add(this.previousMainComponent);
        this.revalidate();
        this.repaint();
        this.dispatchHeight(this.previousHeights);
    }

    private int[] getHeights() {
        int size = this.m_panelArray.size();
        int[] heights = new int[size];
        for (int i = 0; i < size; ++i) {
            heights[i] = this.m_panelArray.get(i).getHeight();
        }
        return heights;
    }

    private void dispatchHeight(int[] heights) {
        int nbSplits = this.m_splitPaneArray.size();
        if (nbSplits == 0) {
            return;
        }
        final Runnable[] rs = new Runnable[nbSplits];
        for (int i = 0; i < nbSplits; ++i) {
            final JSplitPane s = this.m_splitPaneArray.get(i);
            final int height = heights[i];
            final int _i = i;
            rs[i] = new Runnable(){

                @Override
                public void run() {
                    s.setDividerLocation(height);
                    if (_i + 1 < rs.length) {
                        SwingUtilities.invokeLater(rs[_i + 1]);
                    }
                }
            };
        }
        SwingUtilities.invokeLater(rs[0]);
    }

    private UserActions lookForUserActions(Component c) {
        if (c instanceof UserActions) {
            return (UserActions)((Object)c);
        }
        if (c instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)c;
            return this.lookForUserActions(tabbedPane.getComponentAt(tabbedPane.getTabCount() - 1));
        }
        if (c instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)c;
            return this.lookForUserActions(splitPane.getRightComponent());
        }
        return null;
    }

    private class SplittedPanel
    extends JPanel {
        private JComponent m_embededPanel;
        private SplittedPanelContainer m_container;
        private int m_index;
        private JButton m_maximizeButton;
        private JButton m_reduceButton;
        private JButton m_associateButton;
        private JButton m_dissociateButton;
        private JButton m_removeButton;
        private JButton m_addButton;
        private JButton m_saveButton;
        private JPanel m_rightButtonPanel;

        public SplittedPanel(int index, JComponent embededPanel, SplittedPanelContainer container) {
            this.m_embededPanel = embededPanel;
            this.m_container = container;
            this.m_index = index;
            this.setName(embededPanel.getName());
            this.initComponents();
        }

        public void updateRemoveAddButtons(boolean firstPanel, boolean lastPanel) {
            if (!lastPanel) {
                this.m_removeButton.setVisible(false);
            } else if (firstPanel) {
                if (this.m_embededPanel instanceof JTabbedPane || this.m_embededPanel instanceof JSplitPane) {
                    this.m_removeButton.setVisible(SplittedPanelContainer.this.m_includeSaveAndAddButtonsInToolbar);
                } else {
                    this.m_removeButton.setVisible(false);
                }
            } else {
                this.m_removeButton.setVisible(SplittedPanelContainer.this.m_includeSaveAndAddButtonsInToolbar);
            }
            this.m_addButton.setVisible(lastPanel && SplittedPanelContainer.this.m_includeSaveAndAddButtonsInToolbar);
            this.m_saveButton.setVisible(lastPanel && SplittedPanelContainer.this.m_includeSaveAndAddButtonsInToolbar);
        }

        public JComponent getEmbededPanel() {
            return this.m_embededPanel;
        }

        public void replaceEmbededPanel(JComponent embededPanel) {
            if (embededPanel.equals(this.m_embededPanel)) {
                return;
            }
            this.removeAll();
            this.m_embededPanel = embededPanel;
            this.setName(embededPanel.getName());
            this.initComponents();
        }

        public int getIndex() {
            return this.m_index;
        }

        public void incIndex() {
            ++this.m_index;
        }

        public void decIndex() {
            --this.m_index;
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            final SplittedPanel _p = this;
            this.m_rightButtonPanel = new JPanel();
            this.m_rightButtonPanel.setLayout(new GridBagLayout());
            ImageIcon maximizeIcon = IconManager.getIcon(IconManager.IconType.MAXIMIZE);
            this.m_maximizeButton = new MiniButton(maximizeIcon);
            this.m_maximizeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SplittedPanel.this.m_maximizeButton.setVisible(false);
                    SplittedPanel.this.m_reduceButton.setVisible(true);
                    SplittedPanel.this.m_container.maximize(_p);
                    SplittedPanelContainer.this.updateButtons();
                }
            });
            ImageIcon minimizeIcon = IconManager.getIcon(IconManager.IconType.MINIMIZE);
            this.m_reduceButton = new MiniButton(minimizeIcon);
            this.m_reduceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SplittedPanel.this.m_maximizeButton.setVisible(true);
                    SplittedPanel.this.m_reduceButton.setVisible(false);
                    SplittedPanel.this.m_container.reduce(_p);
                    SplittedPanelContainer.this.updateButtons();
                }
            });
            this.m_reduceButton.setVisible(false);
            this.m_associateButton = new MiniButton(IconManager.getIcon(IconManager.IconType.ASSOCIATE));
            this.m_associateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SplittedPanel.this.m_container.associatePanelsAsTab(SplittedPanel.this.m_index);
                    SplittedPanelContainer.this.updateButtons();
                }
            });
            final SplittedPanel _splittedPanel = this;
            this.m_dissociateButton = new MiniButton(IconManager.getIcon(IconManager.IconType.DISSOCIATE));
            this.m_dissociateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JTabbedPane tabbedPane = (JTabbedPane)SplittedPanel.this.m_embededPanel;
                    int nbTabs = tabbedPane.getTabCount();
                    JComponent lastComponent = (JComponent)tabbedPane.getComponentAt(nbTabs - 1);
                    tabbedPane.remove(nbTabs - 1);
                    Component firstComponent = nbTabs == 2 ? tabbedPane.getComponentAt(0) : tabbedPane;
                    _splittedPanel.replaceEmbededPanel((JComponent)firstComponent);
                    _splittedPanel.repaint();
                    SplittedPanel.this.m_container.splitPanel(lastComponent, SplittedPanel.this.m_index + 1);
                    SplittedPanelContainer.this.updateButtons();
                }
            });
            this.m_removeButton = new MiniButton(IconManager.getIcon(IconManager.IconType.MINUS11));
            this.m_removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserActions userAction = SplittedPanelContainer.this.lookForUserActions(SplittedPanel.this.m_embededPanel);
                    if (userAction != null) {
                        userAction.getRemoveAction(SplittedPanel.this.m_container).actionPerformed(e);
                    }
                }
            });
            this.m_addButton = new MiniButton(IconManager.getIcon(IconManager.IconType.PLUS11));
            this.m_addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserActions userAction = SplittedPanelContainer.this.lookForUserActions(SplittedPanel.this.m_embededPanel);
                    if (userAction != null) {
                        userAction.getAddAction(SplittedPanel.this.m_container).actionPerformed(e);
                    }
                }
            });
            this.m_saveButton = new MiniButton(IconManager.getIcon(IconManager.IconType.SAVE_WND));
            this.m_saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserActions userAction = SplittedPanelContainer.this.lookForUserActions(SplittedPanel.this.m_embededPanel);
                    if (userAction != null) {
                        userAction.getSaveAction(SplittedPanel.this.m_container).actionPerformed(e);
                    }
                }
            });
            GridBagConstraints cButton = new GridBagConstraints();
            cButton.gridx = 0;
            cButton.gridy = 0;
            cButton.weighty = 0.0;
            this.m_rightButtonPanel.add((Component)this.m_maximizeButton, cButton);
            ++cButton.gridy;
            this.m_rightButtonPanel.add((Component)this.m_reduceButton, cButton);
            ++cButton.gridy;
            this.m_rightButtonPanel.add((Component)this.m_associateButton, cButton);
            ++cButton.gridy;
            this.m_rightButtonPanel.add((Component)this.m_dissociateButton, cButton);
            cButton.weighty = 1.0;
            ++cButton.gridy;
            this.m_rightButtonPanel.add((Component)Box.createVerticalBox(), cButton);
            cButton.weighty = 0.0;
            ++cButton.gridy;
            this.m_rightButtonPanel.add((Component)this.m_removeButton, cButton);
            ++cButton.gridy;
            this.m_rightButtonPanel.add((Component)this.m_addButton, cButton);
            ++cButton.gridy;
            this.m_rightButtonPanel.add((Component)this.m_saveButton, cButton);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            this.add((Component)this.m_embededPanel, c);
            ++c.gridx;
            c.weightx = 0.0;
            this.add((Component)this.m_rightButtonPanel, c);
        }

        public void updateAssociationButtons() {
            if (!SplittedPanelContainer.this.m_iconifiedPanel.isEmpty() || SplittedPanelContainer.this.m_aPanelMaximized) {
                this.m_associateButton.setEnabled(false);
                this.m_dissociateButton.setEnabled(false);
                return;
            }
            if (this.m_embededPanel instanceof JTabbedPane) {
                this.m_associateButton.setEnabled(this.m_index > 0);
                this.m_dissociateButton.setEnabled(true);
            } else {
                this.m_associateButton.setEnabled(this.m_index > 0);
                this.m_dissociateButton.setEnabled(false);
            }
        }
    }

    public static enum PanelLayout {
        VERTICAL(0),
        HORIZONTAL(1),
        TABBED(2);

        int m_type;
        private static HashMap<Integer, PanelLayout> m_layoutMap;

        private PanelLayout(int type) {
            this.m_type = type;
        }

        public int intValue() {
            return this.m_type;
        }

        private static HashMap<Integer, PanelLayout> generateLayoutMap() {
            HashMap<Integer, PanelLayout> map = new HashMap<Integer, PanelLayout>();
            PanelLayout[] layoutArray = PanelLayout.values();
            for (int i = 0; i < layoutArray.length; ++i) {
                PanelLayout type = layoutArray[i];
                map.put(type.m_type, type);
            }
            return map;
        }

        public static PanelLayout getLayoutType(int type) {
            if (m_layoutMap == null) {
                m_layoutMap = PanelLayout.generateLayoutMap();
            }
            return m_layoutMap.get(type);
        }

        static {
            m_layoutMap = null;
        }
    }

    public static class ReactiveTabbedPane
    extends JTabbedPane {
        private int m_lastSelectedIndex = -1;

        public ReactiveTabbedPane() {
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                    int selectedIndex = tabbedPane.getSelectedIndex();
                    if (selectedIndex == m_lastSelectedIndex) {
                        return;
                    }
                    m_lastSelectedIndex = selectedIndex;
                    int nbTabs = tabbedPane.getTabCount();
                    for (int i = 0; i < nbTabs; ++i) {
                        Component c = tabbedPane.getComponentAt(i);
                        if (!(c instanceof ReactiveTabbedComponent)) continue;
                        ((ReactiveTabbedComponent)((Object)c)).setShowed(i == selectedIndex);
                    }
                }
            });
        }

        @Override
        public void insertTab(String title, Icon icon, Component component, String tip, int index) {
            super.insertTab(title, icon, component, tip, index);
            int selectedIndex = this.getSelectedIndex();
            int nbTabs = this.getTabCount();
            for (int i = 0; i < nbTabs; ++i) {
                Component c = this.getComponentAt(i);
                if (!(c instanceof ReactiveTabbedComponent)) continue;
                ((ReactiveTabbedComponent)((Object)c)).setShowed(i == selectedIndex);
            }
            this.m_lastSelectedIndex = selectedIndex;
        }
    }

    private class IconifiedPanel
    extends JPanel
    implements ActionListener {
        private ArrayList<JButton> buttons = new ArrayList(4);
        private ArrayList<JSeparator> separators = new ArrayList(4);
        private ArrayList<SplittedPanel> splittedPanels = new ArrayList(4);
        private ArrayList<Integer> previousHeights = new ArrayList(4);
        private MouseAdapter mouseListenerForButtons;

        public IconifiedPanel() {
            this.setLayout(new FlowLayout(0, 1, 1));
            this.mouseListenerForButtons = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ((JButton)e.getSource()).setContentAreaFilled(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ((JButton)e.getSource()).setContentAreaFilled(false);
                }
            };
        }

        public boolean isEmpty() {
            return this.splittedPanels.isEmpty();
        }

        public void addPanel(SplittedPanel panel, int height) {
            int i;
            String name = panel.getName();
            int index = panel.getIndex();
            int size = this.splittedPanels.size();
            for (i = 0; i < size && index >= this.splittedPanels.get(i).getIndex(); ++i) {
            }
            JButton button = new JButton(name);
            button.setMargin(new Insets(1, 1, 1, 1));
            button.setBorderPainted(false);
            button.setFocusPainted(false);
            button.setContentAreaFilled(false);
            button.addMouseListener(this.mouseListenerForButtons);
            this.add((Component)button, i * 2);
            this.buttons.add(i, button);
            JSeparator separator = new JSeparator(1){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(3, 8);
                }
            };
            this.add((Component)separator, i * 2 + 1);
            this.separators.add(i, separator);
            this.splittedPanels.add(i, panel);
            this.previousHeights.add(i, height);
            button.addActionListener(this);
            this.revalidate();
            this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            int index = this.buttons.indexOf(b);
            this.removePanel(index);
            SplittedPanelContainer.this.updateButtons();
        }

        private void removePanel(int index) {
            SplittedPanel splittedPanel = this.splittedPanels.remove(index);
            JButton b = this.buttons.remove(index);
            JSeparator separator = this.separators.remove(index);
            Integer height = this.previousHeights.remove(index);
            this.remove(b);
            this.remove(separator);
            SplittedPanelContainer.this.inflate(splittedPanel, height);
            this.revalidate();
            this.repaint();
        }
    }

    public static interface UserActions {
        public ActionListener getRemoveAction(SplittedPanelContainer var1);

        public ActionListener getAddAction(SplittedPanelContainer var1);

        public ActionListener getSaveAction(SplittedPanelContainer var1);
    }

    public static interface ReactiveTabbedComponent {
        public void setShowed(boolean var1);

        public boolean isShowed();
    }

    private static class MiniButton
    extends JButton {
        public MiniButton(Icon icon) {
            super(icon);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
        }
    }
}

