/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.info;

import fr.proline.studio.WindowManager;
import fr.proline.studio.info.InfoFloatingPanel;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.utils.IconManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JToggleButton;

public class InfoToggleButton
extends JToggleButton {
    private ProgressInterface m_progressInterface = null;
    private InfoInterface m_infoInterface = null;
    private InfoFloatingPanel m_infoPanel = null;

    public InfoToggleButton(ProgressInterface progressInterface, InfoInterface infoInterface) {
        this.init(progressInterface, infoInterface);
        this.initGraphic();
    }

    public final void init(ProgressInterface progressInterface, InfoInterface infoInterface) {
        this.m_progressInterface = progressInterface;
        this.m_infoInterface = infoInterface;
    }

    private void initGraphic() {
        this.m_infoPanel = new InfoFloatingPanel();
        this.m_infoPanel.setToggleButton(this);
        this.setIcon(IconManager.getIcon(IconManager.IconType.INFORMATION));
        this.setFocusPainted(false);
        this.addActionListener(new ActionListener(){
            boolean firstTime = true;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InfoToggleButton.this.m_progressInterface != null && !InfoToggleButton.this.m_progressInterface.isLoaded()) {
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog(WindowManager.getDefault().getMainWindow(), InfoToggleButton.this.m_progressInterface, "Data loading", "Info is not available while data is loading. Please Wait.");
                    dialog.setLocation(InfoToggleButton.this.getLocationOnScreen().x + InfoToggleButton.this.getWidth() + 5, InfoToggleButton.this.getLocationOnScreen().y + InfoToggleButton.this.getHeight() + 5);
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        InfoToggleButton.this.setSelected(false);
                        return;
                    }
                }
                InfoToggleButton.this.updateInfo();
                InfoToggleButton.this.m_infoPanel.setVisible(InfoToggleButton.this.isSelected());
                if (this.firstTime) {
                    this.firstTime = false;
                    InfoToggleButton.this.m_infoPanel.setLocation(InfoToggleButton.this.getX() + InfoToggleButton.this.getWidth() + 5, InfoToggleButton.this.getY() + 5);
                }
            }
        });
    }

    public InfoFloatingPanel getInfoPanel() {
        return this.m_infoPanel;
    }

    public void updateInfo() {
        if (this.isSelected()) {
            this.m_infoPanel.setInfo(this.m_infoInterface.getInfo());
        }
    }
}

