/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class BooleanParameter
extends AbstractParameter {
    private final Boolean m_defaultValue;
    private boolean m_valueSet = false;
    boolean m_edited = false;
    Boolean m_startValue = null;
    private ArrayList<AbstractLinkedParameters> m_linkedParametersList = null;

    public BooleanParameter(String key, String name, Class graphicalType, Boolean defaultValue) {
        super(key, name, Boolean.class, graphicalType);
        this.m_defaultValue = defaultValue;
        this.m_labelVisibility = AbstractParameter.LabelVisibility.NO_VISIBLE;
    }

    public BooleanParameter(String key, String name, JComponent component, Boolean defaultValue) {
        super(key, name, Boolean.class, component.getClass());
        this.m_defaultValue = defaultValue;
        this.m_parameterComponent = component;
        this.m_labelVisibility = AbstractParameter.LabelVisibility.NO_VISIBLE;
    }

    @Override
    public JComponent getComponent(Object value) {
        this.m_startValue = null;
        if (value != null) {
            try {
                boolean valueParsed = Boolean.parseBoolean(value.toString());
                this.m_startValue = valueParsed;
            }
            catch (NumberFormatException valueParsed) {
                // empty catch block
            }
        }
        if (this.m_startValue == null) {
            Boolean bl = this.m_startValue = this.m_defaultValue != null ? this.m_defaultValue : Boolean.TRUE;
        }
        if (this.m_parameterComponent != null) {
            if (this.m_graphicalType.equals(JCheckBox.class)) {
                ((JCheckBox)this.m_parameterComponent).setSelected(this.m_startValue);
                this.m_valueSet = true;
                return this.m_parameterComponent;
            }
            if (this.m_graphicalType.equals(JRadioButton.class)) {
                ((JRadioButton)this.m_parameterComponent).setSelected(this.m_startValue);
                this.m_valueSet = true;
                return this.m_parameterComponent;
            }
        }
        if (this.m_graphicalType.equals(JCheckBox.class)) {
            JCheckBox checkBox = new JCheckBox(this.getName());
            checkBox.setSelected(this.m_startValue);
            this.m_valueSet = true;
            this.m_parameterComponent = checkBox;
            return checkBox;
        }
        if (this.m_graphicalType.equals(JRadioButton.class)) {
            JRadioButton radioButton = new JRadioButton(this.getName());
            radioButton.setSelected(this.m_startValue);
            this.m_valueSet = true;
            this.m_parameterComponent = radioButton;
            return radioButton;
        }
        return null;
    }

    @Override
    public void initDefault() {
        if (this.m_defaultValue == null) {
            return;
        }
        if (this.m_graphicalType.equals(JCheckBox.class)) {
            JCheckBox checkBox = (JCheckBox)this.m_parameterComponent;
            checkBox.setSelected(this.m_defaultValue);
            this.m_valueSet = true;
        } else if (this.m_graphicalType.equals(JRadioButton.class)) {
            JRadioButton radioButton = (JRadioButton)this.m_parameterComponent;
            radioButton.setSelected(this.m_defaultValue);
            this.m_valueSet = true;
        }
    }

    @Override
    public ParameterError checkParameter() {
        return null;
    }

    @Override
    public void setValue(String v) {
        if (this.m_graphicalType.equals(JCheckBox.class) && this.m_parameterComponent != null) {
            ((JCheckBox)this.m_parameterComponent).setSelected(Boolean.parseBoolean(v));
            this.m_valueSet = true;
        } else if (this.m_graphicalType.equals(JRadioButton.class) && this.m_parameterComponent != null) {
            ((JRadioButton)this.m_parameterComponent).setSelected(Boolean.parseBoolean(v));
            this.m_valueSet = true;
        }
        if (this.m_valueSet && v != null && this.m_startValue != null) {
            this.m_edited = Boolean.parseBoolean(v) != this.m_startValue;
        }
    }

    @Override
    public String getStringValue() {
        return this.getObjectValue().toString();
    }

    @Override
    public Object getObjectValue() {
        if (this.m_graphicalType.equals(JCheckBox.class)) {
            return ((JCheckBox)this.m_parameterComponent).isSelected();
        }
        if (this.m_graphicalType.equals(JRadioButton.class)) {
            return ((JRadioButton)this.m_parameterComponent).isSelected();
        }
        return "";
    }

    public void addLinkedParameters(final AbstractLinkedParameters linkedParameters) {
        this.getComponent(null);
        if (this.m_linkedParametersList == null) {
            this.m_linkedParametersList = new ArrayList(1);
        }
        this.m_linkedParametersList.add(linkedParameters);
        if (this.m_parameterComponent instanceof JCheckBox) {
            ((JCheckBox)this.m_parameterComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    linkedParameters.valueChanged(BooleanParameter.this.getStringValue(), BooleanParameter.this.getObjectValue());
                }
            });
        } else if (this.m_parameterComponent instanceof JRadioButton) {
            ((JRadioButton)this.m_parameterComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    linkedParameters.valueChanged(BooleanParameter.this.getStringValue(), BooleanParameter.this.getObjectValue());
                }
            });
        }
        if (!this.m_valueSet) {
            this.initDefault();
        } else {
            linkedParameters.valueChanged(this.getStringValue(), this.getObjectValue());
        }
    }

    @Override
    public boolean isEdited() {
        return this.m_edited;
    }
}

