/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.gui.StringChooserPanel;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StringParameter
extends AbstractParameter {
    private ArrayList<AbstractLinkedParameters> m_linkedParametersList = null;
    private String m_defaultValue;
    private Integer m_minChars;
    private Integer m_maxChars;
    private String[] m_possibilitiesName = null;
    private String[] m_possibilities = null;
    private String m_startValue;
    private boolean m_edited = false;

    public StringParameter(String key, String name, Class graphicalType, String defaultValue, Integer minChars, Integer maxChars) {
        super(key, name, String.class, graphicalType);
        this.m_defaultValue = defaultValue;
        this.m_minChars = minChars;
        this.m_maxChars = maxChars;
    }

    public StringParameter(String key, String name, JComponent component, String defaultValue, Integer minChars, Integer maxChars) {
        super(key, name, String.class, component.getClass());
        this.m_defaultValue = defaultValue;
        this.m_parameterComponent = component;
        this.m_minChars = minChars;
        this.m_maxChars = maxChars;
    }

    public StringParameter(String key, String name, String defaultValue, Integer minChars, Integer maxChars, String[] possibilitiesName, String[] possibilities) {
        super(key, name, String.class, StringChooserPanel.class);
        this.m_defaultValue = defaultValue;
        this.m_minChars = minChars;
        this.m_maxChars = maxChars;
        this.m_possibilitiesName = possibilitiesName;
        this.m_possibilities = possibilities;
    }

    @Override
    public JComponent getComponent(Object value) {
        this.m_startValue = null;
        if (value != null) {
            this.m_startValue = value.toString();
        }
        if (this.m_startValue == null) {
            String string = this.m_startValue = this.m_defaultValue != null ? this.m_defaultValue : "";
        }
        if (this.m_parameterComponent != null) {
            if (this.m_graphicalType.equals(JTextField.class)) {
                ((JTextField)this.m_parameterComponent).setText(this.m_startValue);
                return this.m_parameterComponent;
            }
            if (this.m_graphicalType.equals(StringChooserPanel.class)) {
                ((StringChooserPanel)this.m_parameterComponent).setText(this.m_startValue);
                return this.m_parameterComponent;
            }
        }
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = new JTextField(30);
            if (this.m_startValue != null) {
                textField.setText(this.m_startValue);
            }
            this.m_parameterComponent = textField;
            return textField;
        }
        if (this.m_graphicalType.equals(StringChooserPanel.class)) {
            StringChooserPanel stringChooser = new StringChooserPanel(this.m_possibilitiesName, this.m_possibilities, 2, this.m_startValue, true);
            this.m_parameterComponent = stringChooser;
            return stringChooser;
        }
        return null;
    }

    @Override
    public void initDefault() {
        if (this.m_defaultValue == null) {
            return;
        }
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = (JTextField)this.m_parameterComponent;
            textField.setText(this.m_defaultValue);
        } else if (this.m_graphicalType.equals(StringChooserPanel.class)) {
            StringChooserPanel stringChooser = (StringChooserPanel)this.m_parameterComponent;
            stringChooser.setText(this.m_defaultValue);
        }
    }

    @Override
    public ParameterError checkParameter() {
        if (!this.m_used && !this.m_compulsory) {
            return null;
        }
        String value = "";
        if (this.m_graphicalType.equals(JTextField.class)) {
            JTextField textField = (JTextField)this.m_parameterComponent;
            value = textField.getText();
        } else if (this.m_graphicalType.equals(StringChooserPanel.class)) {
            StringChooserPanel stringChooser = (StringChooserPanel)this.m_parameterComponent;
            value = stringChooser.getText();
        }
        int length = value.length();
        if (this.m_minChars != null && length < this.m_minChars) {
            if (length == 0) {
                return new ParameterError(this.m_name + " field is not filled", this.m_parameterComponent);
            }
            return new ParameterError("Minimum length of " + this.m_name + " is " + this.m_minChars + " characters", this.m_parameterComponent);
        }
        if (this.m_maxChars != null && length > this.m_maxChars) {
            return new ParameterError(this.m_name + " exceeds " + this.m_maxChars + " characters", this.m_parameterComponent);
        }
        return null;
    }

    @Override
    public void setValue(String v) {
        if (this.m_graphicalType.equals(JTextField.class) && this.m_parameterComponent != null) {
            ((JTextField)this.m_parameterComponent).setText(v);
        } else if (this.m_graphicalType.equals(StringChooserPanel.class) && this.m_parameterComponent != null) {
            ((StringChooserPanel)this.m_parameterComponent).setText(v);
        }
        if (v != null && this.m_startValue != null) {
            this.m_edited = !v.equalsIgnoreCase(this.m_startValue);
        }
    }

    @Override
    public String getStringValue() {
        return this.getObjectValue().toString();
    }

    @Override
    public Object getObjectValue() {
        if (this.m_graphicalType.equals(JTextField.class)) {
            return ((JTextField)this.m_parameterComponent).getText();
        }
        if (this.m_graphicalType.equals(StringChooserPanel.class)) {
            return ((StringChooserPanel)this.m_parameterComponent).getText();
        }
        return "";
    }

    public void addLinkedParameters(final AbstractLinkedParameters linkedParameters) {
        this.getComponent(null);
        if (this.m_linkedParametersList == null) {
            this.m_linkedParametersList = new ArrayList(1);
        }
        this.m_linkedParametersList.add(linkedParameters);
        if (this.m_graphicalType.equals(JTextField.class)) {
            ((JTextField)this.m_parameterComponent).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                public void textChanged() {
                    linkedParameters.valueChanged(StringParameter.this.getStringValue(), StringParameter.this.getObjectValue());
                }
            });
        } else if (this.m_graphicalType.equals(StringChooserPanel.class)) {
            ((StringChooserPanel)this.m_parameterComponent).setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    linkedParameters.valueChanged(StringParameter.this.getStringValue(), StringParameter.this.getObjectValue());
                }
            });
        }
    }

    @Override
    public boolean isEdited() {
        return this.m_edited;
    }
}

