/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table.renderer;

import fr.proline.studio.utils.DataFormat;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DoubleRenderer
implements TableCellRenderer {
    private final TableCellRenderer m_defaultRenderer;
    private int m_nbDigits = 2;
    private boolean m_scientific = false;
    private boolean m_showNaN = false;

    public DoubleRenderer(TableCellRenderer defaultRenderer, int digits, boolean scientific, boolean showNaN) {
        this.m_defaultRenderer = defaultRenderer;
        this.m_nbDigits = digits;
        this.m_scientific = scientific;
        this.m_showNaN = showNaN;
    }

    public DoubleRenderer(TableCellRenderer defaultRenderer) {
        this.m_defaultRenderer = defaultRenderer;
        this.m_nbDigits = 2;
    }

    public DoubleRenderer(TableCellRenderer defaultRenderer, int nbDigits) {
        this.m_defaultRenderer = defaultRenderer;
        this.m_nbDigits = nbDigits;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String formatedValue;
        Double d = (Double)value;
        if (d == null || d.isNaN()) {
            formatedValue = this.m_showNaN ? "NaN" : "";
        } else if (this.m_scientific) {
            double dAbs = Math.abs(d);
            if (dAbs != 0.0 && dAbs * Math.pow(10.0, this.m_nbDigits - 1) >= 1.0) {
                formatedValue = DataFormat.format((double)d, this.m_nbDigits);
            } else {
                int digits = this.m_nbDigits - 2;
                if (digits < 2) {
                    digits = 2;
                }
                formatedValue = DataFormat.formatScientific((double)d, digits);
            }
        } else {
            formatedValue = DataFormat.format((double)d, this.m_nbDigits);
        }
        return this.m_defaultRenderer.getTableCellRendererComponent(table, formatedValue, isSelected, hasFocus, row, column);
    }
}

