/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table.renderer;

import fr.proline.studio.table.renderer.GrayableTableCellRenderer;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class GrayedRenderer
implements TableCellRenderer,
Serializable {
    private final TableCellRenderer m_renderer;
    private boolean innerRenderIsGrayable = false;

    public GrayedRenderer(TableCellRenderer renderer) {
        this.m_renderer = renderer;
        this.innerRenderIsGrayable = this.m_renderer instanceof GrayableTableCellRenderer;
        if (this.innerRenderIsGrayable) {
            ((GrayableTableCellRenderer)this.m_renderer).setGrayed(true);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = this.m_renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!this.innerRenderIsGrayable) {
            c.setFont(c.getFont().deriveFont(2));
        }
        return c;
    }

    public TableCellRenderer getBaseRenderer() {
        return this.m_renderer;
    }
}

