/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzknife.mzdb;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.BBSizes;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.model.SharedParamTree;
import fr.profi.mzdb.db.model.params.ScanList;
import fr.profi.mzdb.db.model.params.ScanParamTree;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.param.UserParam;
import fr.profi.mzdb.db.model.params.param.UserText;
import fr.profi.mzdb.io.util.MzDBUtil;
import fr.profi.mzdb.io.writer.MzDBWriter;
import fr.profi.mzdb.io.writer.ParamTreeStringifier;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.MzDBMetaData;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumMetaData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzDBSplitter {
    File m_inputMzdbFile;
    List<File> m_outputMzdbFiles;
    MzDbReader m_mzDbReader;
    String m_fileExtension = ".mzdb";
    private RETURN_CODE m_finishCode = RETURN_CODE.UNDEFINED;
    private static final String USER_TEXT_TAG = "instrumentMethods";
    private static final String FAIMS_CV_PREFIX = "FAIMS CV";
    private static final String CV_PARAM_ACC = "MS:1001581";
    private static final Logger LOG = LoggerFactory.getLogger(MzDBSplitter.class);

    public MzDBSplitter(File inputMzdbFile) {
        this.m_inputMzdbFile = inputMzdbFile;
        this.initReader();
    }

    private void initReader() {
        try {
            this.m_mzDbReader = new MzDbReader(this.m_inputMzdbFile, true);
            this.m_mzDbReader.enableScanListLoading();
            this.m_mzDbReader.enableParamTreeLoading();
            this.m_mzDbReader.enablePrecursorListLoading();
            this.m_mzDbReader.enableDataStringCache();
        }
        catch (SQLiteException | FileNotFoundException e) {
            e.printStackTrace();
            if (this.m_mzDbReader != null) {
                this.m_mzDbReader.close();
            }
            throw new IllegalArgumentException("Unable to read specified mzDbFile");
        }
    }

    private File getOutFile(String prefix) {
        Object rootFileName = this.m_inputMzdbFile.getName();
        int index = ((String)rootFileName).lastIndexOf(46);
        if (index > 0) {
            rootFileName = ((String)rootFileName).substring(0, index);
        }
        rootFileName = (String)rootFileName + prefix.trim() + this.m_fileExtension;
        return new File(this.m_inputMzdbFile.getParentFile(), (String)rootFileName);
    }

    public void setOutputFileExtension(String extension) {
        this.m_fileExtension = extension;
    }

    public List<File> getOutputMzdbFiles() {
        return this.m_outputMzdbFiles;
    }

    public RETURN_CODE getFinishStateCode() {
        return this.m_finishCode;
    }

    public boolean splitMzDbFile() {
        LOG.info(" Split mzDB files " + this.m_inputMzdbFile.getName());
        HashMap<String, MzDBWriter> writerPerCV = new HashMap<String, MzDBWriter>();
        BBSizes defaultBBsize = new BBSizes(5.0, 10000.0, 15.0f, 0.0f);
        try {
            if (!this.m_mzDbReader.getConnection().isOpen()) {
                this.initReader();
            }
            SpectrumHeader[] headers = this.m_mzDbReader.getSpectrumHeaders();
            Arrays.sort(headers, Comparator.comparingLong(SpectrumHeader::getSpectrumId));
            List sharedParamTrees = this.m_mzDbReader.getSharedParamTreeList();
            boolean isSplittable = false;
            block2: for (SharedParamTree sharedParamTree : sharedParamTrees) {
                List params = sharedParamTree.getData().getCVParams();
                for (CVParam p : params) {
                    if (!p.getName().toLowerCase().contains("exploris")) continue;
                    isSplittable = true;
                    continue block2;
                }
            }
            LOG.trace(" is mzDB file Shared Param Tree 'Exploris'? " + isSplittable);
            int nbrCV = 0;
            ArrayList<String> cvPrefix = new ArrayList<String>();
            List userParams = this.m_mzDbReader.getMzDbHeader().getUserTexts();
            if (userParams != null && !userParams.isEmpty()) {
                for (UserText userText : userParams) {
                    if (!USER_TEXT_TAG.equals(userText.getName())) continue;
                    String instrumMethods = userText.getText();
                    Scanner scanner = new Scanner(instrumMethods);
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine().trim();
                        if (line.startsWith(FAIMS_CV_PREFIX)) {
                            isSplittable = true;
                            ++nbrCV;
                            Object cvName = line.substring(8).trim();
                            if (((String)cvName).startsWith("=")) {
                                cvName = ((String)cvName).substring(1);
                            }
                            String cvValue = String.valueOf(Float.valueOf(((String)cvName).trim()).intValue());
                            cvPrefix.add(cvValue);
                            continue;
                        }
                        if (!line.contains("Exploris")) continue;
                        isSplittable = true;
                    }
                }
            }
            LOG.trace(" is mzDB file USerText 'Exploris'? {} with {} CV => {}", new Object[]{isSplittable, nbrCV, cvPrefix});
            if (!isSplittable || nbrCV <= 1) {
                LOG.warn(" --- The specified file is not an Exploris result or no CV has been defined");
                if (!isSplittable) {
                    this.m_finishCode = RETURN_CODE.NOT_EXPLORIS;
                } else if (nbrCV <= 1) {
                    this.m_finishCode = RETURN_CODE.NO_CVS;
                }
                this.m_mzDbReader.close();
                return false;
            }
            this.m_outputMzdbFiles = new ArrayList<File>(cvPrefix.size());
            HashMap<Long, Long> newIndexByOldIndex = new HashMap<Long, Long>();
            HashMap<String, Long> nextIndexByCvPrefix = new HashMap<String, Long>();
            MzDBMetaData mzDbMetaData = MzDBUtil.createMzDbMetaData((MzDbReader)this.m_mzDbReader);
            AcquisitionMode srcAcqMode = this.m_mzDbReader.getAcquisitionMode();
            boolean isDIA = srcAcqMode != null && srcAcqMode.equals((Object)AcquisitionMode.SWATH);
            for (String nextCV : cvPrefix) {
                File f = this.getOutFile(nextCV);
                this.m_outputMzdbFiles.add(f);
                MzDBWriter writer = new MzDBWriter(f, false, mzDbMetaData, defaultBBsize, Boolean.valueOf(isDIA));
                writer.initialize();
                writerPerCV.put(nextCV, writer);
                nextIndexByCvPrefix.put(nextCV, 1L);
            }
            LOG.trace(" Writers created for each CVs");
            long start1 = System.currentTimeMillis();
            int rewritedScanCount = 0;
            int readScanCount = 0;
            Pattern spectrumTitlePattern = Pattern.compile("[\\w]*scan[\\s]*=[\\s]*([\\d]+)");
            for (SpectrumHeader srcSpectrumHeader : headers) {
                ++readScanCount;
                MzDBWriter spectrumWriter = null;
                long nextIndex = -1L;
                List params = srcSpectrumHeader.getCVParams();
                if (params != null && !params.isEmpty()) {
                    String title;
                    Matcher titleMatcher;
                    List uParams;
                    for (CVParam nextParam : params) {
                        String nextVal;
                        if (!nextParam.getAccession().equals(CV_PARAM_ACC) || !cvPrefix.contains(nextVal = String.valueOf(Float.valueOf(nextParam.getValue()).intValue()))) continue;
                        spectrumWriter = (MzDBWriter)writerPerCV.get(nextVal);
                        nextIndex = (Long)nextIndexByCvPrefix.get(nextVal);
                        nextIndexByCvPrefix.put(nextVal, nextIndex + 1L);
                        break;
                    }
                    if (spectrumWriter == null) {
                        LOG.warn(" !!!!! Spectra {} (tile {}) has NO CV. Will not be write in any output file ", (Object)srcSpectrumHeader.getSpectrumId(), (Object)srcSpectrumHeader.getTitle());
                        continue;
                    }
                    Spectrum srcSpectrum = this.m_mzDbReader.getSpectrum(srcSpectrumHeader.getSpectrumId());
                    Long initialId = srcSpectrum.getHeader().getId();
                    newIndexByOldIndex.put(initialId, nextIndex);
                    boolean scanUpdated = false;
                    if (srcSpectrum.getHeader().getScanList() != null && srcSpectrum.getHeader().getScanList().getScans() != null && !srcSpectrum.getHeader().getScanList().getScans().isEmpty() && (uParams = ((ScanParamTree)srcSpectrum.getHeader().getScanList().getScans().get(0)).getUserParams()) != null && !uParams.isEmpty()) {
                        for (int i = 0; i < uParams.size(); ++i) {
                            UserParam uParam = (UserParam)uParams.get(i);
                            if (!"[Thermo Trailer Extra]Master Scan Number:".equals(uParam.getName())) continue;
                            Integer prevScIndex = Integer.parseInt(uParam.getValue());
                            if (prevScIndex <= 0) break;
                            Long newScIndex = (Long)newIndexByOldIndex.get(prevScIndex.longValue());
                            uParam.setValue(newScIndex.toString());
                            uParams.set(i, uParam);
                            scanUpdated = true;
                            break;
                        }
                    }
                    if ((titleMatcher = spectrumTitlePattern.matcher(title = srcSpectrum.getHeader().getTitle())).find() && Long.valueOf(titleMatcher.group(1)).equals(initialId)) {
                        title = titleMatcher.replaceAll("scan=" + newIndexByOldIndex.get(initialId));
                        srcSpectrum.getHeader().setTitle(title);
                    }
                    String scanAsString = scanUpdated ? ParamTreeStringifier.stringifyScanList((ScanList)srcSpectrumHeader.getScanList()) : srcSpectrumHeader.getScanListAsString(this.m_mzDbReader.getConnection());
                    SpectrumMetaData spectrumMetaData = new SpectrumMetaData(Long.valueOf(srcSpectrumHeader.getSpectrumId()), srcSpectrumHeader.getParamTreeAsString(this.m_mzDbReader.getConnection()), scanAsString, srcSpectrumHeader.getPrecursorListAsString(this.m_mzDbReader.getConnection()));
                    spectrumWriter.insertSpectrum(srcSpectrum, spectrumMetaData, this.m_mzDbReader.getSpectrumDataEncoding(srcSpectrumHeader.getSpectrumId()));
                    ++rewritedScanCount;
                    if (readScanCount % 5000 != 0 && srcSpectrumHeader.getSpectrumId() != (long)this.m_mzDbReader.getSpectraCount()) continue;
                    LOG.info("Read {} spectra over {} ({} already rewrited)", new Object[]{readScanCount, this.m_mzDbReader.getSpectraCount(), rewritedScanCount});
                    continue;
                }
                LOG.warn("Spectra {} (tile {})  has NO CV. Will not be write in any output file ", (Object)srcSpectrumHeader.getSpectrumId(), (Object)srcSpectrumHeader.getTitle());
            }
            long end2 = System.currentTimeMillis();
            LOG.info("{} spectrum rewrited  in {} ms", (Object)rewritedScanCount, (Object)(end2 - start1));
            writerPerCV.values().forEach(w -> w.close());
            this.m_mzDbReader.close();
            this.m_finishCode = RETURN_CODE.OK;
            return true;
        }
        catch (SQLiteException | StreamCorruptedException e) {
            e.printStackTrace();
            this.m_mzDbReader.close();
            this.m_finishCode = RETURN_CODE.EXCEPTION;
            writerPerCV.values().forEach(w -> w.close());
            return false;
        }
    }

    public static enum RETURN_CODE {
        UNDEFINED,
        OK,
        NOT_EXPLORIS,
        NO_CVS,
        EXCEPTION;

    }
}

