/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.InterruptDetectedException;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class RAFContainer
extends FileContainer
implements PrivilegedExceptionAction {
    protected StorageRandomAccessFile fileData;
    protected boolean needsSync;
    private int actionCode;
    private static final int GET_FILE_NAME_ACTION = 1;
    private static final int CREATE_CONTAINER_ACTION = 2;
    private static final int REMOVE_FILE_ACTION = 3;
    private static final int OPEN_CONTAINER_ACTION = 4;
    private static final int STUBBIFY_ACTION = 5;
    private static final int GET_RANDOM_ACCESS_FILE_ACTION = 7;
    private static final int REOPEN_CONTAINER_ACTION = 8;
    private ContainerKey actionIdentity;
    private boolean actionStub;
    private boolean actionErrorOK;
    private boolean actionTryAlternatePath;
    private StorageFile actionFile;
    private LogInstant actionInstant;
    private boolean inBackup = false;
    private boolean inRemove = false;
    private String fileName;

    RAFContainer(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
    }

    public synchronized boolean isDirty() {
        return super.isDirty() || this.needsSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeContainer(LogInstant logInstant, boolean bl) throws StandardException {
        RAFContainer rAFContainer;
        try {
            RAFContainer rAFContainer2 = this;
            synchronized (rAFContainer2) {
                this.inRemove = true;
                while (this.inBackup) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
            }
            this.pageCache.discard(this.identity);
            this.stubbify(logInstant);
            Object var7_6 = null;
            rAFContainer = this;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            RAFContainer rAFContainer3 = this;
            synchronized (rAFContainer3) {
                this.inRemove = false;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (rAFContainer) {
            this.inRemove = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeContainer() {
        if (this.fileData != null) {
            try {
                try {
                    this.fileData.close();
                }
                catch (IOException iOException) {
                    Object var3_2 = null;
                    this.fileData = null;
                }
                Object var3_1 = null;
                this.fileData = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.fileData = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPage(long l, byte[] byArray) throws IOException, StandardException {
        long l2 = l * (long)this.pageSize;
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            this.fileData.seek(l2);
            this.fileData.readFully(byArray, 0, this.pageSize);
        }
        if (this.dataFactory.databaseEncrypted() && l != 0L) {
            this.decryptPage(byArray, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            if (this.getCommittedDropState()) {
                return;
            }
            long l2 = l * (long)this.pageSize;
            byte[] byArray2 = null;
            if (this.dataFactory.databaseEncrypted() && l != 0L) {
                byArray2 = this.getEncryptionBuffer();
            }
            byte[] byArray3 = this.updatePageArray(l, byArray, byArray2, false);
            try {
                this.fileData.seek(l2);
                if (this.fileData.getFilePointer() != l2) {
                    this.padFile(this.fileData, l2);
                }
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(byArray3, 0, this.pageSize);
                    Object var11_8 = null;
                    this.dataFactory.writeFinished();
                }
                catch (Throwable throwable) {
                    Object var11_9 = null;
                    this.dataFactory.writeFinished();
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                if (!this.padFile(this.fileData, l2)) {
                    throw iOException;
                }
                this.fileData.seek(l2);
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(byArray3, 0, this.pageSize);
                    Object var13_12 = null;
                    this.dataFactory.writeFinished();
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    this.dataFactory.writeFinished();
                    throw throwable;
                }
            }
            if (bl) {
                this.dataFactory.writeInProgress();
                try {
                    if (!this.dataFactory.dataNotSyncedAtAllocation) {
                        this.fileData.sync();
                    }
                    Object var15_15 = null;
                    this.dataFactory.writeFinished();
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    this.dataFactory.writeFinished();
                    throw throwable;
                }
            } else {
                this.needsSync = true;
            }
        }
    }

    protected byte[] updatePageArray(long l, byte[] byArray, byte[] byArray2, boolean bl) throws StandardException, IOException {
        if (l == 0L) {
            this.writeHeader(this.getIdentity(), byArray);
            return byArray;
        }
        if (byArray2 != null && (this.dataFactory.databaseEncrypted() || bl)) {
            return this.encryptPage(byArray, this.pageSize, byArray2, bl);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean padFile(StorageRandomAccessFile storageRandomAccessFile, long l) throws IOException, StandardException {
        long l2 = storageRandomAccessFile.length();
        if (l2 >= l) {
            return false;
        }
        byte[] byArray = new byte[this.pageSize];
        storageRandomAccessFile.seek(l2);
        while (l2 < l) {
            Object var10_6;
            this.dataFactory.writeInProgress();
            try {
                long l3 = l - l2;
                if (l3 > (long)this.pageSize) {
                    l3 = this.pageSize;
                }
                storageRandomAccessFile.write(byArray, 0, (int)l3);
                var10_6 = null;
                this.dataFactory.writeFinished();
            }
            catch (Throwable throwable) {
                var10_6 = null;
                this.dataFactory.writeFinished();
                throw throwable;
            }
            l2 += (long)this.pageSize;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(boolean bl) throws StandardException {
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 120;
        while (!bl3) {
            bl3 = true;
            RAFContainer rAFContainer = this;
            synchronized (rAFContainer) {
                if (this.getCommittedDropState()) {
                    this.clearDirty();
                    return;
                }
                while (this.preDirty) {
                    bl2 = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
                if (bl2 && this.getCommittedDropState()) {
                    this.clearDirty();
                    return;
                }
                if (!bl && this.isDirty()) {
                    try {
                        this.writeRAFHeader(this.getIdentity(), this.fileData, false, true);
                        this.clearDirty();
                    }
                    catch (InterruptDetectedException interruptDetectedException) {
                        if (--n > 0) {
                            bl3 = false;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                InterruptStatus.setInterrupted();
                            }
                            continue;
                        }
                        throw StandardException.newException("XSDG9.D", interruptDetectedException);
                    }
                    catch (IOException iOException) {
                        throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException, (Object)(this.getIdentity() != null ? this.getIdentity().toString() : "unknown"), (Object)"clean", (Object)this.fileName));
                    }
                }
            }
        }
    }

    private void clearDirty() {
        this.isDirty = false;
        this.needsSync = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int preAllocate(long l, int n) {
        int n2 = this.doPreAllocatePages(l, n);
        if (n2 > 0) {
            RAFContainer rAFContainer = this;
            synchronized (rAFContainer) {
                block14: {
                    boolean bl = false;
                    try {
                        block13: {
                            try {
                                this.dataFactory.writeInProgress();
                                bl = true;
                                if (this.dataFactory.dataNotSyncedAtAllocation) break block13;
                                this.fileData.sync();
                            }
                            catch (IOException iOException) {
                                n2 = 0;
                                Object var9_7 = null;
                                if (bl) {
                                    this.dataFactory.writeFinished();
                                }
                                break block14;
                            }
                            catch (StandardException standardException) {
                                n2 = 0;
                                Object var9_8 = null;
                                if (bl) {
                                    this.dataFactory.writeFinished();
                                }
                            }
                        }
                        Object var9_6 = null;
                        if (bl) {
                            this.dataFactory.writeFinished();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (bl) {
                            this.dataFactory.writeFinished();
                        }
                        throw throwable;
                    }
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncatePages(long l) throws StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            block12: {
                boolean bl = false;
                try {
                    try {
                        this.dataFactory.writeInProgress();
                        bl = true;
                        this.fileData.setLength((l + 1L) * (long)this.pageSize);
                    }
                    catch (IOException iOException) {
                        Object var7_5 = null;
                        if (bl) {
                            this.dataFactory.writeFinished();
                        }
                        break block12;
                    }
                    catch (StandardException standardException) {
                        Object var7_6 = null;
                        if (bl) {
                            this.dataFactory.writeFinished();
                        }
                    }
                    Object var7_4 = null;
                    if (bl) {
                        this.dataFactory.writeFinished();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (bl) {
                        this.dataFactory.writeFinished();
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRAFHeader(Object object, StorageRandomAccessFile storageRandomAccessFile, boolean bl, boolean bl2) throws IOException, StandardException {
        byte[] byArray = bl ? new byte[this.pageSize] : this.getEmbryonicPage(storageRandomAccessFile, 0L);
        this.writeHeader(object, storageRandomAccessFile, bl, byArray);
        if (bl2) {
            this.dataFactory.writeInProgress();
            try {
                if (!this.dataFactory.dataNotSyncedAtCheckpoint) {
                    storageRandomAccessFile.sync();
                }
                Object var7_6 = null;
                this.dataFactory.writeFinished();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.dataFactory.writeFinished();
                throw throwable;
            }
        }
    }

    protected void flushAll() throws StandardException {
        this.pageCache.clean(this.identity);
        this.clean(false);
    }

    synchronized StorageFile getFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        this.actionCode = 1;
        this.actionIdentity = containerKey;
        this.actionStub = bl;
        this.actionErrorOK = bl2;
        this.actionTryAlternatePath = bl3;
        try {
            StorageFile storageFile = (StorageFile)AccessController.doPrivileged(this);
            Object var7_7 = null;
            this.actionIdentity = null;
            return storageFile;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                throw (StandardException)privilegedActionException.getException();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.actionIdentity = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageFile privGetFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2 = this.dataFactory.getContainerPath(containerKey, bl);
        if (!storageFile2.exists() && bl3) {
            storageFile2 = this.dataFactory.getAlternateContainerPath(containerKey, bl);
        }
        if (!storageFile2.exists() && !(storageFile = storageFile2.getParentDir()).exists()) {
            BaseDataFileFactory baseDataFileFactory = this.dataFactory;
            synchronized (baseDataFileFactory) {
                if (!storageFile.exists()) {
                    if (!storageFile.mkdirs()) {
                        if (bl2) {
                            return null;
                        }
                        throw StandardException.newException("XSDF3.S", storageFile);
                    }
                    storageFile.limitAccessToOwner();
                }
            }
        }
        return storageFile2;
    }

    synchronized void createContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 2;
        this.actionIdentity = containerKey;
        try {
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (StandardException)privilegedActionException.getException();
            }
            Object var4_2 = null;
            this.actionIdentity = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.actionIdentity = null;
            throw throwable;
        }
    }

    private void copyFile(final StorageFile storageFile, final File file) throws StandardException {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ReuseFactory.getBoolean(FileUtil.copyFile(RAFContainer.this.dataFactory.getStorageFactory(), storageFile, file));
            }
        });
        if (!bl.booleanValue()) {
            throw StandardException.newException("XSRS5.S", (Object)storageFile, (Object)file);
        }
    }

    private void removeFile(final File file) throws StandardException {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ReuseFactory.getBoolean(!file.exists() || file.delete());
            }
        });
        if (!bl.booleanValue()) {
            throw StandardException.newException("XBM0R.D", file);
        }
    }

    synchronized boolean removeFile(StorageFile storageFile) throws SecurityException, StandardException {
        this.actionCode = 3;
        this.actionFile = storageFile;
        try {
            boolean bl = AccessController.doPrivileged(this) != null;
            Object var4_4 = null;
            this.actionFile = null;
            return bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                throw (StandardException)privilegedActionException.getException();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.actionFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean privRemoveFile(StorageFile storageFile) throws StandardException {
        block3: {
            this.closeContainer();
            this.dataFactory.writeInProgress();
            try {
                if (!storageFile.exists()) break block3;
                boolean bl = storageFile.delete();
                Object var4_3 = null;
                this.dataFactory.writeFinished();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.dataFactory.writeFinished();
                throw throwable;
            }
        }
        Object var4_4 = null;
        this.dataFactory.writeFinished();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized boolean openContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 4;
        this.actionIdentity = containerKey;
        try {
            try {
                boolean bl = AccessController.doPrivileged(this) != null;
                Object var4_5 = null;
                this.actionIdentity = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.closeContainer();
                throw (StandardException)privilegedActionException.getException();
            }
            catch (RuntimeException runtimeException) {
                this.closeContainer();
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.actionIdentity = null;
            throw throwable;
        }
    }

    protected synchronized void reopenContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 8;
        this.actionIdentity = containerKey;
        try {
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.closeContainer();
                throw (StandardException)privilegedActionException.getException();
            }
            catch (RuntimeException runtimeException) {
                this.closeContainer();
                throw runtimeException;
            }
            Object var4_2 = null;
            this.actionIdentity = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.actionIdentity = null;
            throw throwable;
        }
    }

    private synchronized void stubbify(LogInstant logInstant) throws StandardException {
        this.setDroppedState(true);
        this.setCommittedDropState(true);
        this.actionIdentity = (ContainerKey)this.getIdentity();
        this.actionInstant = logInstant;
        this.actionCode = 5;
        try {
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (StandardException)privilegedActionException.getException();
            }
            Object var4_2 = null;
            this.actionIdentity = null;
            this.actionInstant = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.actionIdentity = null;
            this.actionInstant = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void backupContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        Object object32;
        Object var18_17;
        boolean bl = false;
        File file = null;
        RandomAccessFile randomAccessFile = null;
        boolean bl2 = false;
        BasePage basePage = null;
        while (!bl) {
            Object object2 = this;
            // MONITORENTER : object2
            while (this.inRemove) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            if (this.getCommittedDropState()) {
                bl2 = true;
            }
            this.inBackup = true;
            // MONITOREXIT : object2
            if (bl2) {
                object2 = this.getFileName((ContainerKey)this.getIdentity(), true, false, true);
                file = new File(string, object2.getName());
                this.copyFile((StorageFile)object2, file);
            } else {
                long l = this.getLastPageNumber(baseContainerHandle);
                if (l == -1L) {
                    var18_17 = null;
                    object32 = this;
                    // MONITORENTER : object32
                    this.inBackup = false;
                    this.notifyAll();
                    // MONITOREXIT : object32
                    if (basePage != null) {
                        basePage.unlatch();
                        basePage = null;
                    }
                    if (bl) return;
                    if (file == null) return;
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                            randomAccessFile = null;
                        }
                        catch (IOException object32) {
                            throw StandardException.newException("XSDFH.S", (Throwable)object32, (Object)file);
                        }
                    }
                    this.removeFile(file);
                    return;
                }
                StorageFile storageFile = this.getFileName((ContainerKey)this.getIdentity(), false, false, true);
                file = new File(string, storageFile.getName());
                randomAccessFile = this.getRandomAccessFile(file);
                byte[] byArray = null;
                if (this.dataFactory.databaseEncrypted()) {
                    byArray = new byte[this.pageSize];
                }
                for (long i = 0L; i <= l; ++i) {
                    basePage = this.getLatchedPage(baseContainerHandle, i);
                    byte[] byArray2 = this.updatePageArray(i, basePage.getPageArray(), byArray, false);
                    randomAccessFile.write(byArray2, 0, this.pageSize);
                    basePage.unlatch();
                    basePage = null;
                    RAFContainer rAFContainer = this;
                    // MONITORENTER : rAFContainer
                    if (this.inRemove) {
                        // MONITOREXIT : rAFContainer
                        break;
                    }
                    // MONITOREXIT : rAFContainer
                }
            }
            if (!bl2) {
                randomAccessFile.getFD().sync();
                randomAccessFile.close();
                randomAccessFile = null;
            }
            bl = true;
            var18_17 = null;
            object32 = this;
            // MONITORENTER : object32
            this.inBackup = false;
            this.notifyAll();
            // MONITOREXIT : object32
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
            if (bl || file == null) continue;
            if (randomAccessFile != null) {
                try {}
                catch (IOException object32) {
                    throw StandardException.newException("XSDFH.S", (Throwable)object32, (Object)file);
                }
                randomAccessFile.close();
                randomAccessFile = null;
            }
            this.removeFile(file);
        }
        return;
        {
            catch (IOException iOException) {
                throw StandardException.newException("XSDFH.S", iOException, file);
            }
        }
        catch (Throwable throwable) {
            var18_17 = null;
            object32 = this;
            // MONITORENTER : object32
            this.inBackup = false;
            this.notifyAll();
            // MONITOREXIT : object32
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
            if (bl) throw throwable;
            if (file == null) throw throwable;
            if (randomAccessFile != null) {
                try {}
                catch (IOException object32) {
                    throw StandardException.newException("XSDFH.S", (Throwable)object32, file);
                }
                randomAccessFile.close();
                randomAccessFile = null;
            }
            this.removeFile(file);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void encryptOrDecryptContainer(BaseContainerHandle baseContainerHandle, String string, boolean bl) throws StandardException {
        BasePage basePage = null;
        StorageFile storageFile = this.dataFactory.getStorageFactory().newStorageFile(string);
        StorageRandomAccessFile storageRandomAccessFile = null;
        try {
            try {
                long l = this.getLastPageNumber(baseContainerHandle);
                storageRandomAccessFile = this.getRandomAccessFile(storageFile);
                byte[] byArray = null;
                if (bl) {
                    byArray = new byte[this.pageSize];
                }
                for (long i = 0L; i <= l; ++i) {
                    basePage = this.getLatchedPage(baseContainerHandle, i);
                    byte[] byArray2 = this.updatePageArray(i, basePage.getPageArray(), byArray, true);
                    storageRandomAccessFile.write(byArray2, 0, this.pageSize);
                    basePage.unlatch();
                    basePage = null;
                }
                storageRandomAccessFile.sync();
                storageRandomAccessFile.close();
                storageRandomAccessFile = null;
            }
            catch (IOException iOException) {
                String string2;
                String string3 = this.getIdentity() != null ? this.getIdentity().toString() : "unknown";
                if (bl) {
                    string2 = "encrypt";
                    throw StandardException.newException("XSDG3.D", iOException, (Object)string3, (Object)string2, (Object)string);
                }
                string2 = "decrypt";
                throw StandardException.newException("XSDG3.D", iOException, (Object)string3, (Object)string2, (Object)string);
            }
            Object var14_12 = null;
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
            if (storageRandomAccessFile == null) return;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
            if (storageRandomAccessFile == null) throw throwable;
            try {
                storageRandomAccessFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                String string4;
                storageRandomAccessFile = null;
                String string5 = this.getIdentity() != null ? this.getIdentity().toString() : "unknown";
                if (bl) {
                    string4 = "encrypt-close";
                    throw StandardException.newException("XSDG3.D", iOException, (Object)string5, (Object)string4, (Object)string);
                }
                string4 = "decrypt-close";
                throw StandardException.newException("XSDG3.D", iOException, (Object)string5, (Object)string4, (Object)string);
            }
        }
        try {}
        catch (IOException iOException) {
            String string6;
            storageRandomAccessFile = null;
            String string7 = this.getIdentity() != null ? this.getIdentity().toString() : "unknown";
            if (bl) {
                string6 = "encrypt-close";
                throw StandardException.newException("XSDG3.D", iOException, (Object)string7, (Object)string6, (Object)string);
            }
            string6 = "decrypt-close";
            throw StandardException.newException("XSDG3.D", iOException, (Object)string7, (Object)string6, (Object)string);
        }
        storageRandomAccessFile.close();
    }

    private RandomAccessFile getRandomAccessFile(final File file) throws FileNotFoundException {
        try {
            return (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    boolean bl = file.exists();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    if (!bl) {
                        FileUtil.limitAccessToOwner(file);
                    }
                    return randomAccessFile;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getCause();
        }
    }

    synchronized StorageRandomAccessFile getRandomAccessFile(StorageFile storageFile) throws SecurityException, StandardException {
        this.actionCode = 7;
        this.actionFile = storageFile;
        try {
            StorageRandomAccessFile storageRandomAccessFile = (StorageRandomAccessFile)AccessController.doPrivileged(this);
            Object var4_4 = null;
            this.actionFile = null;
            return storageRandomAccessFile;
        }
        catch (PrivilegedActionException privilegedActionException) {
            try {
                throw (StandardException)privilegedActionException.getException();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.actionFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run() throws StandardException {
        switch (this.actionCode) {
            case 1: {
                return this.privGetFileName(this.actionIdentity, this.actionStub, this.actionErrorOK, this.actionTryAlternatePath);
            }
            case 2: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, false, false);
                try {
                    if (storageFile.exists()) {
                        throw StandardException.newException("XSDF0.S", storageFile);
                    }
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDF1.S", securityException, (Object)storageFile);
                }
                try {
                    this.dataFactory.writeInProgress();
                    try {
                        this.fileData = storageFile.getRandomAccessFile("rw");
                        storageFile.limitAccessToOwner();
                        Object var4_13 = null;
                        this.dataFactory.writeFinished();
                    }
                    catch (Throwable throwable) {
                        Object var4_14 = null;
                        this.dataFactory.writeFinished();
                        throw throwable;
                    }
                    this.canUpdate = true;
                    this.writeRAFHeader(this.actionIdentity, this.fileData, true, this.actionIdentity.getSegmentId() != -1L);
                }
                catch (IOException iOException) {
                    boolean bl;
                    this.canUpdate = false;
                    try {
                        bl = this.privRemoveFile(storageFile);
                    }
                    catch (SecurityException securityException) {
                        throw StandardException.newException("XSDF2.S", iOException, (Object)storageFile, (Object)securityException.toString());
                    }
                    if (!bl) {
                        throw StandardException.newException("XSDF2.S", iOException, (Object)storageFile, (Object)iOException.toString());
                    }
                    throw StandardException.newException("XSDF1.S", iOException, (Object)storageFile);
                }
                return null;
            }
            case 3: {
                return this.privRemoveFile(this.actionFile) ? this : null;
            }
            case 4: {
                boolean bl = false;
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, true, true);
                if (storageFile == null) {
                    return null;
                }
                try {
                    if (!storageFile.exists()) {
                        storageFile = this.privGetFileName(this.actionIdentity, true, true, true);
                        if (!storageFile.exists()) {
                            return null;
                        }
                        bl = true;
                    }
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDA4.S", securityException);
                }
                this.canUpdate = false;
                try {
                    if (!this.dataFactory.isReadOnly() && storageFile.canWrite()) {
                        this.canUpdate = true;
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.fileName = storageFile.toString();
                try {
                    this.fileData = storageFile.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                    this.readHeader(this.getEmbryonicPage(this.fileData, 0L));
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException, (Object)(this.getIdentity() != null ? this.getIdentity().toString() : "unknown"), (Object)"read", (Object)this.fileName));
                    }
                    StorageFile storageFile2 = this.privGetFileName(this.actionIdentity, true, true, true);
                    if (storageFile2.exists()) {
                        try {
                            boolean bl2 = this.privRemoveFile(storageFile);
                            this.fileData = storageFile2.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                            this.readHeader(this.getEmbryonicPage(this.fileData, 0L));
                        }
                        catch (IOException iOException2) {
                            throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException2, (Object)(this.getIdentity() != null ? this.getIdentity().toString() : "unknown"), (Object)"delete-stub", (Object)this.fileName));
                        }
                    }
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException, (Object)(this.getIdentity() != null ? this.getIdentity().toString() : "unknown"), (Object)"read", (Object)this.fileName));
                }
                return this;
            }
            case 8: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, true, true);
                RAFContainer rAFContainer = this;
                synchronized (rAFContainer) {
                    try {
                        this.fileData = storageFile.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", fileNotFoundException, (Object)(this.getIdentity() != null ? this.getIdentity().toString() : "unknown"), (Object)"read", (Object)this.fileName));
                    }
                }
                return this;
            }
            case 5: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, false, true);
                StorageFile storageFile3 = this.privGetFileName(this.actionIdentity, true, false, false);
                StorageRandomAccessFile storageRandomAccessFile = null;
                try {
                    if (!storageFile3.exists()) {
                        storageRandomAccessFile = storageFile3.getRandomAccessFile("rw");
                        storageFile3.limitAccessToOwner();
                        this.writeRAFHeader(this.actionIdentity, storageRandomAccessFile, true, true);
                        storageRandomAccessFile.close();
                        storageRandomAccessFile = null;
                    }
                    this.dataFactory.flush(this.actionInstant);
                    this.privRemoveFile(storageFile);
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDF4.S", securityException, (Object)storageFile, (Object)securityException.toString());
                }
                catch (IOException iOException) {
                    try {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                            storageFile3.delete();
                            storageRandomAccessFile = null;
                        }
                        if (this.fileData != null) {
                            this.fileData.close();
                            this.fileData = null;
                        }
                    }
                    catch (IOException iOException3) {
                        throw StandardException.newException("XSDF4.S", iOException3, (Object)storageFile, (Object)iOException.toString());
                    }
                    catch (SecurityException securityException) {
                        throw StandardException.newException("XSDF4.S", securityException, (Object)storageFile, (Object)storageFile3);
                    }
                }
                this.dataFactory.stubFileToRemoveAfterCheckPoint(storageFile3, this.actionInstant, this.getIdentity());
                return null;
            }
            case 7: {
                try {
                    boolean bl = this.actionFile.exists();
                    StorageRandomAccessFile storageRandomAccessFile = this.actionFile.getRandomAccessFile("rw");
                    if (!bl) {
                        this.actionFile.limitAccessToOwner();
                    }
                    return storageRandomAccessFile;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw StandardException.newException("XSDF1.S", fileNotFoundException, (Object)this.actionFile.getPath());
                }
            }
        }
        return null;
    }
}

