/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExporterInterface;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.text.StringEscapeUtils;

public class CSVExporter
implements ExporterInterface {
    private final StringBuilder m_sb = new StringBuilder();
    private static final char CSV_SEPARATOR = ',';
    private int m_curRow = 0;
    private int m_curCell = 0;
    private FileWriter m_fw;
    private boolean m_decorated = false;

    @Override
    public void start(String filePath) throws IOException {
        if (!((String)filePath).endsWith(this.getFileExtension()) && !((String)filePath).endsWith(".txt")) {
            filePath = (String)filePath + this.getFileExtension();
        }
        this.m_fw = new FileWriter((String)filePath);
    }

    @Override
    public void startSheet(String pageName) {
    }

    @Override
    public void startRow() throws IOException {
        if (this.m_curRow > 0) {
            this.m_fw.write("\n");
        }
        ++this.m_curRow;
        this.m_curCell = 0;
    }

    @Override
    public void addCell(String t, ArrayList<ExportFontData> fonts) throws IOException {
        if (this.m_curCell > 0) {
            this.m_fw.write(44);
        }
        ++this.m_curCell;
        this.m_fw.write(t == null ? "" : StringEscapeUtils.escapeCsv((String)t));
    }

    @Override
    public void end() throws IOException {
        if (this.m_curRow > 0) {
            this.m_fw.write("\n");
        }
        this.m_fw.close();
    }

    @Override
    public void setDecorated(boolean decorated) {
        this.m_decorated = decorated;
    }

    @Override
    public boolean getDecorated() {
        return this.m_decorated;
    }

    @Override
    public String getFileExtension() {
        return ".csv";
    }
}

