/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.LockedDataModel;
import fr.proline.studio.graphics.Axis;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.MoveableInterface;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.cursor.AbstractCursor;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.measurement.AbstractMeasurement;
import fr.proline.studio.parameter.ParameterList;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import javax.swing.JPopupMenu;

public abstract class PlotBaseAbstract
implements Axis.EnumXInterface,
Axis.EnumYInterface {
    public static final int COL_X_ID = 0;
    public static final int COL_Y_ID = 1;
    protected PlotType m_plotType;
    protected ExtendedTableModelInterface m_compareDataInterface = null;
    protected CrossSelectionInterface m_crossSelectionInterface = null;
    protected int[] m_cols;
    protected String m_parameterZ;
    protected BasePlotPanel m_plotPanel;
    protected ArrayList<AbstractMarker> m_markersList = null;
    protected ArrayList<AbstractCursor> m_cursorList = null;
    protected AbstractCursor m_selectedCursor = null;
    protected boolean m_isPaintMarker = true;
    protected ArrayList<AbstractMeasurement> m_measurements = null;
    protected boolean m_locked = false;

    public abstract boolean needsXAxis();

    public abstract boolean needsYAxis();

    public abstract boolean canLogXAxis();

    public abstract boolean canLogYAxis();

    public abstract double getNearestXData(double var1);

    public abstract double getNearestYData(double var1);

    public abstract double getXMin();

    public abstract double getXMax();

    public abstract double getYMin();

    public abstract double getYMax();

    public abstract void parametersChanged();

    public boolean parametersCanceled() {
        return false;
    }

    public abstract void paint(Graphics2D var1, XAxis var2, YAxis var3);

    public void paintOver(Graphics2D g) {
    }

    public PlotBaseAbstract(BasePlotPanel plotPanel, PlotType plotType, ExtendedTableModelInterface compareDataInterface, CrossSelectionInterface crossSelectionInterface) {
        this.m_plotPanel = plotPanel;
        this.m_plotType = plotType;
        this.m_compareDataInterface = this.m_locked ? new LockedDataModel(compareDataInterface) : compareDataInterface;
        this.m_crossSelectionInterface = crossSelectionInterface;
    }

    public BasePlotPanel getBasePlotPanel() {
        return this.m_plotPanel;
    }

    public abstract String getToolTipText(double var1, double var3);

    public void update(int[] cols, String parameterZ) {
        if (cols == null) {
            this.updateAxisSpecificities();
            return;
        }
        if (this.m_cols == null || this.m_cols.length != cols.length) {
            this.m_cols = new int[cols.length];
        }
        for (int i = 0; i < cols.length; ++i) {
            this.m_cols[i] = cols[i];
        }
        this.m_parameterZ = parameterZ;
        this.updateAxisSpecificities();
        this.update();
    }

    public void updateAxisSpecificities() {
        if (!this.needsXAxis()) {
            this.m_plotPanel.getXAxis().setSpecificities(false, false, true);
        } else if (this.m_cols[0] != -1) {
            Class xClass = this.m_compareDataInterface.getDataColumnClass(this.m_cols[0]);
            boolean isIntegerX = xClass.equals(Integer.class) || xClass.equals(Long.class) || xClass.equals(String.class);
            boolean isEnumX = xClass.equals(String.class);
            this.m_plotPanel.setAxisXSpecificities(isIntegerX, isEnumX, false);
        }
        if (!this.needsYAxis()) {
            this.m_plotPanel.getYAxis().setSpecificities(false, false, true);
        } else if (this.needsYAxis() && this.m_cols[1] != -1) {
            Class yClass = this.m_compareDataInterface.getDataColumnClass(this.m_cols[1]);
            boolean isIntegerY = yClass.equals(Integer.class) || yClass.equals(Long.class) || yClass.equals(String.class);
            boolean isEnumY = yClass.equals(String.class);
            this.m_plotPanel.setAxisYSpecificities(isIntegerY, isEnumY, false, this);
        }
    }

    public abstract void update();

    public String getXAxisTitle() {
        return this.m_compareDataInterface.getDataColumnIdentifier(this.m_cols[0]);
    }

    public String getYAxisTitle() {
        return this.m_compareDataInterface.getDataColumnIdentifier(this.m_cols[1]);
    }

    public abstract boolean select(double var1, double var3, boolean var5);

    public abstract boolean select(Path2D.Double var1, double var2, double var4, double var6, double var8, boolean var10);

    public abstract ArrayList<Long> getSelectedIds();

    public abstract void setSelectedIds(ArrayList<Long> var1);

    public abstract ArrayList<ParameterList> getParameters();

    public void addMarker(AbstractMarker m) {
        if (this.m_markersList == null) {
            this.m_markersList = new ArrayList();
        }
        this.m_markersList.add(m);
    }

    public void selectCursor(AbstractCursor c) {
        if (this.m_selectedCursor != null) {
            this.m_selectedCursor.setSelected(false, false);
        }
        this.m_selectedCursor = c;
        c.setSelected(true, false);
    }

    public void addCursor(AbstractCursor c) {
        if (this.m_cursorList == null) {
            this.m_cursorList = new ArrayList();
        }
        this.m_cursorList.add(c);
        this.selectCursor(c);
    }

    public boolean removeCursor(AbstractCursor c) {
        if (this.m_cursorList != null) {
            this.m_cursorList.remove(c);
        }
        if (c == this.m_selectedCursor) {
            if (!this.m_cursorList.isEmpty()) {
                this.selectCursor(this.m_cursorList.get(this.m_cursorList.size() - 1));
            } else {
                this.m_selectedCursor = null;
            }
        }
        return false;
    }

    public void removeAllCursors() {
        if (this.m_cursorList != null) {
            this.m_cursorList.clear();
            this.m_selectedCursor = null;
        }
    }

    public MoveableInterface getOverMovable(int x, int y) {
        if (this.m_markersList != null) {
            int nb = this.m_markersList.size();
            for (int i = 0; i < nb; ++i) {
                MoveableInterface movable;
                AbstractMarker m = this.m_markersList.get(i);
                if (!(m instanceof MoveableInterface) || !(movable = (MoveableInterface)((Object)m)).isMoveable() || !movable.insideXY(x, y)) continue;
                return movable;
            }
        }
        return this.getOverCursor(x, y);
    }

    public AbstractCursor getOverCursor(int x, int y) {
        if (this.m_cursorList != null) {
            int nb = this.m_cursorList.size();
            for (int i = nb - 1; i >= 0; --i) {
                AbstractCursor c = this.m_cursorList.get(i);
                if (!c.isMoveable() || !c.insideXY(x, y)) continue;
                return c;
            }
        }
        return null;
    }

    public boolean removeMarker(AbstractMarker m) {
        if (this.m_markersList != null) {
            return this.m_markersList.remove(m);
        }
        return false;
    }

    public void clearMarkers() {
        if (this.m_markersList == null) {
            return;
        }
        this.m_markersList.clear();
    }

    public final void addMeasurement(AbstractMeasurement measurement) {
        if (this.m_measurements == null) {
            this.m_measurements = new ArrayList();
        }
        this.m_measurements.add(measurement);
    }

    public ArrayList<AbstractMeasurement> getMeasurements(ArrayList<AbstractMeasurement> measurements, AbstractMeasurement.MeasurementType type) {
        if (this.m_measurements == null) {
            return measurements;
        }
        for (AbstractMeasurement measurement : this.m_measurements) {
            if (measurement.getMeasurementType() != type) continue;
            measurements.add(measurement);
        }
        return measurements;
    }

    public void paintMarkers(Graphics2D g) {
        if (!this.m_isPaintMarker) {
            return;
        }
        if (this.m_markersList == null) {
            return;
        }
        int nb = this.m_markersList.size();
        for (int i = 0; i < nb; ++i) {
            this.m_markersList.get(i).paint(g);
        }
    }

    public void paintCursors(Graphics2D g) {
        if (this.m_cursorList == null) {
            return;
        }
        int nb = this.m_cursorList.size();
        for (int i = 0; i < nb; ++i) {
            AbstractCursor cursor = this.m_cursorList.get(i);
            cursor.paint(g);
        }
    }

    public boolean getDoubleBufferingPolicy() {
        return false;
    }

    public boolean setIsPaintMarker(boolean isPaintMarker) {
        return false;
    }

    public abstract boolean isMouseOnPlot(double var1, double var3);

    public abstract boolean isMouseOnSelectedPlot(double var1, double var3);

    public boolean isMouseWheelSupported() {
        return true;
    }

    public JPopupMenu getPopupMenu(double x, double y) {
        return null;
    }

    public void doubleClicked(int x, int y) {
    }

    public static enum DoubleBufferingPolicyEnum {
        DOUBLE_BUFFERING;

    }
}

