/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ParameterList
extends ArrayList<AbstractParameter> {
    private String m_name;
    private ParametersPanel m_parametersPanel;
    private boolean m_enable = true;
    protected List<String> m_backwardCompatiblePrefixes = new ArrayList<String>(1);
    private final HashMap<JComponent, JLabel> m_associatedLabels = new HashMap();

    public ParameterList(String name) {
        this.m_name = name;
    }

    @Override
    public String toString() {
        return this.m_name;
    }

    public String getPrefixName() {
        return this.m_name.replaceAll(" ", "_") + ".";
    }

    public void addBackwardCompatiblePrefix(String backwardCompatiblePrefix) {
        this.m_backwardCompatiblePrefixes.add(backwardCompatiblePrefix.replaceAll(" ", "_") + ".");
    }

    public List<String> getBackwardCompatiblePrefixes() {
        return new ArrayList<String>(this.m_backwardCompatiblePrefixes);
    }

    public ParametersPanel getPanel() {
        if (this.m_parametersPanel != null) {
            return this.m_parametersPanel;
        }
        Preferences preferences = NbPreferences.root();
        this.m_parametersPanel = new ParametersPanel();
        this.m_parametersPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            c.gridx = 0;
            c.weightx = 0.0;
            JLabel l = null;
            if (parameter.showLabel() == AbstractParameter.LabelVisibility.VISIBLE) {
                l = new JLabel(parameter.getName() + " :");
                l.setHorizontalAlignment(4);
                this.m_parametersPanel.add((Component)l, c);
            }
            String parameterValue = this.readParameter(preferences, parameter);
            if (parameter.hasComponent().booleanValue()) {
                JComponent comp;
                if (parameter.showLabel() == AbstractParameter.LabelVisibility.AS_BORDER_TITLE) {
                    c.gridx = 0;
                    c.gridwidth = 2;
                    c.weightx = 1.0;
                    JPanel framedPanel = new JPanel(new GridBagLayout());
                    framedPanel.setBorder(BorderFactory.createTitledBorder(" " + parameter.getName() + " "));
                    GridBagConstraints cFrame = new GridBagConstraints();
                    cFrame.anchor = 18;
                    cFrame.fill = 1;
                    cFrame.insets = new Insets(5, 5, 5, 5);
                    cFrame.weightx = 1.0;
                    comp = parameter.getComponent(parameterValue);
                    JComponent scroll = null;
                    if (parameter.componentNeedsScrollPane()) {
                        scroll = new JScrollPane(comp){
                            private Dimension maximumSize;
                            {
                                this.maximumSize = new Dimension(360, 400);
                            }

                            @Override
                            public Dimension getMaximumSize() {
                                return this.maximumSize;
                            }
                        };
                    }
                    framedPanel.add((Component)(scroll != null ? scroll : comp), cFrame);
                    this.m_parametersPanel.add((Component)framedPanel, c);
                    c.gridwidth = 1;
                } else {
                    c.gridx = 1;
                    c.weightx = 1.0;
                    comp = parameter.getComponent(parameterValue);
                    JComponent scroll = null;
                    if (parameter.componentNeedsScrollPane()) {
                        scroll = new JScrollPane(comp){
                            private Dimension maximumSize;
                            {
                                this.maximumSize = new Dimension(360, 400);
                            }

                            @Override
                            public Dimension getMaximumSize() {
                                return this.maximumSize;
                            }
                        };
                    }
                    this.m_parametersPanel.add((Component)(scroll != null ? scroll : comp), c);
                }
                if (l != null && comp != null) {
                    this.m_associatedLabels.put(comp, l);
                }
            }
            ++c.gridy;
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.m_parametersPanel.add(Box.createVerticalGlue(), c);
        return this.m_parametersPanel;
    }

    public void resetPanel() {
        this.m_parametersPanel = null;
    }

    public JLabel getAssociatedLabel(JComponent c) {
        return this.m_associatedLabels.get(c);
    }

    public void completePanel(JPanel p, GridBagConstraints c) {
        Preferences preferences = NbPreferences.root();
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            String parameterValue = this.readParameter(preferences, parameter);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            JLabel l = new JLabel(parameter.getName() + " :");
            l.setHorizontalAlignment(4);
            p.add((Component)l, c);
            if (!parameter.hasComponent().booleanValue()) continue;
            c.gridx = 1;
            c.weightx = 1.0;
            p.add((Component)parameter.getComponent(parameterValue), c);
        }
    }

    public void updateValues(Preferences preferences) {
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            String parameterValue = this.readParameter(preferences, parameter);
            if (!parameter.isUsed()) {
                if (parameterValue != null && !parameterValue.isEmpty()) {
                    parameter.setUsed(true);
                }
            } else if (parameterValue == null || parameterValue.isEmpty()) {
                parameter.setUsed(false);
            }
            parameter.getComponent(parameterValue);
        }
    }

    public void setDefaultValues() {
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            parameter.getComponent(null);
        }
    }

    private String readParameter(Preferences preferences, AbstractParameter parameter) {
        Iterator<String> iterator;
        String parameterKey = parameter.getKey();
        if (parameterKey == null) {
            return null;
        }
        String suffixKey = parameterKey.replaceAll(" ", "_");
        String prefixKey = this.getPrefixName();
        String key = prefixKey + suffixKey;
        String parameterValue = preferences.get(key, null);
        if (parameterValue == null) {
            String alternativePrefix;
            iterator = this.m_backwardCompatiblePrefixes.iterator();
            while (iterator.hasNext() && (parameterValue = preferences.get(key = (alternativePrefix = iterator.next()) + suffixKey, null)) == null) {
            }
        }
        if (parameterValue == null) {
            String newSuffixKey = parameter.getName().replaceAll(" ", "_");
            key = prefixKey + newSuffixKey;
            parameterValue = preferences.get(key, null);
        }
        if (parameterValue == null) {
            String alternativeKey;
            String newSuffixKey;
            iterator = parameter.getBackwardCompatibleKeys().iterator();
            while (iterator.hasNext() && (parameterValue = preferences.get(key = prefixKey + (newSuffixKey = (alternativeKey = iterator.next()).replaceAll(" ", "_")), null)) == null) {
            }
        }
        if (parameterValue == null) {
            for (String alternativePrefix : this.m_backwardCompatiblePrefixes) {
                String alternativeKey;
                String newSuffixKey;
                Iterator<String> iterator2 = parameter.getBackwardCompatibleKeys().iterator();
                while (iterator2.hasNext() && (parameterValue = preferences.get(key = alternativePrefix + (newSuffixKey = (alternativeKey = iterator2.next()).replaceAll(" ", "_")), null)) == null) {
                }
            }
        }
        return parameterValue;
    }

    public void initDefaults() {
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            parameter.initDefault();
        }
    }

    public void saveParameters(Preferences preferences) {
        String prefixKey = this.getPrefixName();
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            String parameterKey = parameter.getName();
            String suffixKey = parameterKey.replaceAll(" ", "_");
            String key = prefixKey + suffixKey;
            preferences.remove(key);
            for (String alternativeKey : parameter.getBackwardCompatibleKeys()) {
                suffixKey = alternativeKey.replaceAll(" ", "_");
                key = prefixKey + suffixKey;
                preferences.remove(key);
            }
            parameterKey = parameter.getKey();
            suffixKey = parameterKey.replaceAll(" ", "_");
            key = prefixKey + suffixKey;
            if (parameter.isUsed() || parameter.isCompulsory()) {
                String value = parameter.getStringValue();
                preferences.put(key, value);
                continue;
            }
            preferences.remove(key);
        }
    }

    public void loadParameters(Preferences preferences) {
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            String value = this.readParameter(preferences, parameter);
            if (value == null) continue;
            parameter.setValue(value);
        }
        this.updateValues(preferences);
    }

    public HashMap<String, String> getValues() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            if (!parameter.isUsed()) continue;
            String key = parameter.getKey();
            String value = parameter.getStringValue();
            valuesMap.put(key, value);
        }
        return valuesMap;
    }

    public AbstractParameter getParameter(String key) {
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            if (parameter.getKey().compareTo(key) != 0) continue;
            return parameter;
        }
        return null;
    }

    public ParameterError checkParameters() {
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            ParameterError error = parameter.checkParameter();
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public void clean() {
        int nbParameters = this.size();
        for (int i = 0; i < nbParameters; ++i) {
            AbstractParameter parameter = (AbstractParameter)this.get(i);
            parameter.clean();
        }
    }

    public void enableList(boolean v) {
        this.m_enable = v;
    }

    public boolean isEnable() {
        return this.m_enable;
    }

    public void displayModified() {
        this.m_parametersPanel.displayModified();
    }

    public class ParametersPanel
    extends JPanel {
        private DefaultDialog m_dialog = null;

        public void setParentDialog(DefaultDialog dialog) {
            this.m_dialog = dialog;
        }

        public void displayModified() {
            if (this.m_dialog != null) {
                this.m_dialog.repack();
                this.m_dialog.revalidate();
                this.m_dialog.repaint();
            }
        }
    }
}

