/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.tabs;

import fr.proline.studio.tabs.ILayoutPanel;
import fr.proline.studio.tabs.IWrappedPanel;
import fr.proline.studio.tabs.PanelAsGrid;
import fr.proline.studio.tabs.PanelAsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class TabsPanel
extends JPanel {
    private static final int VIEW_TAB = 0;
    private static final int VIEW_GRID = 1;
    private int m_displayMode = 1;
    private List<IWrappedPanel> m_panels = new ArrayList<IWrappedPanel>();
    private ILayoutPanel m_mainPanel;

    public TabsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        switch (this.m_displayMode) {
            case 0: {
                this.m_mainPanel = new PanelAsTab();
                break;
            }
            case 1: {
                this.m_mainPanel = new PanelAsGrid();
                break;
            }
        }
        this.add((Component)this.m_mainPanel.getComponent(), "Center");
    }

    public void setPanels(List<IWrappedPanel> panels, Integer nbCols) {
        this.m_panels = panels;
        if (this.m_mainPanel != null) {
            this.remove(this.m_mainPanel.getComponent());
        }
        switch (this.m_displayMode) {
            case 0: {
                this.m_mainPanel = new PanelAsTab();
                break;
            }
            case 1: {
                this.m_mainPanel = new PanelAsGrid();
                break;
            }
        }
        this.m_mainPanel.setPanels(panels, nbCols);
        this.add(this.m_mainPanel.getComponent());
        this.revalidate();
        this.repaint();
    }

    public void addTab(IWrappedPanel panel) {
        this.m_panels.add(panel);
        this.m_mainPanel.addPanel(panel);
        this.revalidate();
        this.repaint();
    }

    public void removeTabAt(int i) {
        this.m_mainPanel.removePanel(i);
        this.m_panels.remove(i);
    }

    public IWrappedPanel getSelectedPanel() {
        return this.m_mainPanel == null ? null : this.m_mainPanel.getSelectedPanel();
    }

    public void changeLayout() {
        IWrappedPanel oldSelectedPanel = null;
        if (this.m_mainPanel != null) {
            oldSelectedPanel = this.m_mainPanel.getSelectedPanel();
        }
        switch (this.m_displayMode) {
            case 0: {
                this.m_displayMode = 1;
                break;
            }
            case 1: {
                this.m_displayMode = 0;
                break;
            }
            default: {
                this.m_displayMode = 0;
            }
        }
        this.setPanels(this.m_panels, null);
        if (oldSelectedPanel != null) {
            this.m_mainPanel.setSelectedPanel(oldSelectedPanel);
        }
    }

    public int getTabCount() {
        return this.m_panels.size();
    }

    public String getTitleAt(int index) {
        if (index > -1 && index < this.getTabCount()) {
            return this.m_panels.get(index).getTitle();
        }
        return null;
    }

    public JPanel getComponentAt(int index) {
        if (index > -1 && index < this.getTabCount()) {
            return this.m_panels.get(index).getComponent();
        }
        return null;
    }

    public void setSelectedIndex(int index) {
        if (index > -1 && index < this.getTabCount()) {
            this.m_mainPanel.setSelectedPanel(this.m_panels.get(index));
        }
    }

    public int getSelectedIndex() {
        IWrappedPanel p = this.m_mainPanel.getSelectedPanel();
        if (p != null) {
            return this.m_panels.indexOf(p);
        }
        return -1;
    }

    public void setTabHeaderComponentAt(int index, Component c) {
        this.m_mainPanel.setTabHeaderComponentAt(index, c);
    }

    public int indexOfTabHeaderComponent(Component c) {
        return this.m_mainPanel.indexOfTabHeaderComponent(c);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_mainPanel.addChangeListener(l);
    }
}

