/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.BBSizes;
import fr.profi.mzdb.db.model.InstrumentConfiguration;
import fr.profi.mzdb.db.model.MzDbHeader;
import fr.profi.mzdb.db.model.Run;
import fr.profi.mzdb.db.model.Sample;
import fr.profi.mzdb.db.model.SharedParamTree;
import fr.profi.mzdb.db.model.Software;
import fr.profi.mzdb.db.model.SourceFile;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.db.model.params.param.CV;
import fr.profi.mzdb.db.model.params.param.CVEntry;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.param.CVTerm;
import fr.profi.mzdb.db.model.params.param.CVUnit;
import fr.profi.mzdb.db.model.params.param.UserParam;
import fr.profi.mzdb.db.model.params.param.UserTerm;
import fr.profi.mzdb.db.table.BoundingBoxTable;
import fr.profi.mzdb.db.table.CVTermTable;
import fr.profi.mzdb.db.table.CvTable;
import fr.profi.mzdb.db.table.CvUnitTable;
import fr.profi.mzdb.db.table.DataEncodingTable;
import fr.profi.mzdb.db.table.DataProcessingTable;
import fr.profi.mzdb.db.table.InstrumentConfigurationTable;
import fr.profi.mzdb.db.table.MzdbTable;
import fr.profi.mzdb.db.table.ProcessingMethodTable;
import fr.profi.mzdb.db.table.RunSliceTable;
import fr.profi.mzdb.db.table.RunTable;
import fr.profi.mzdb.db.table.SampleTable;
import fr.profi.mzdb.db.table.SharedParamTreeTable;
import fr.profi.mzdb.db.table.SoftwareTable;
import fr.profi.mzdb.db.table.SourceFileTable;
import fr.profi.mzdb.db.table.UserTermTable;
import fr.profi.mzdb.io.writer.BoundingBoxCache;
import fr.profi.mzdb.io.writer.BoundingBoxToWrite;
import fr.profi.mzdb.io.writer.DataEncodingRegistry;
import fr.profi.mzdb.io.writer.ParamTreeStringifier;
import fr.profi.mzdb.io.writer.RunSliceStructureFactory;
import fr.profi.mzdb.io.writer.SpectrumSliceIndex;
import fr.profi.mzdb.io.writer.SpectrumToWrite;
import fr.profi.mzdb.model.AcquisitionMode;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.DataMode;
import fr.profi.mzdb.model.IsolationWindow;
import fr.profi.mzdb.model.MzDBMetaData;
import fr.profi.mzdb.model.MzDBSchema;
import fr.profi.mzdb.model.PeakEncoding;
import fr.profi.mzdb.model.ProcessingMethod;
import fr.profi.mzdb.model.RunSliceHeader;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumMetaData;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzDBWriter {
    static final Logger logger = LoggerFactory.getLogger(MzDBWriter.class);
    public static double MODEL_VERSION = 0.7;
    private File tmpDBLocation;
    private File finalDBLocation;
    private MzDBMetaData metaData;
    private BBSizes bbSizes;
    private boolean isDIA;
    private SQLiteConnection sqliteConnection = null;
    private SQLiteStatement bboxInsertStmt;
    private SQLiteStatement rtreeInsertStmt;
    private SQLiteStatement msnRtreeInsertStmt;
    private SQLiteStatement spectrumInsertStmt;
    private DataEncodingRegistry dataEncodingRegistry;
    private BoundingBoxCache boundingBoxCache;
    private HashMap<BoundingBoxCache.MsLevelAndIsolationWindowKey, ArrayList<SpectrumToWrite>> spectrumCache = new HashMap();
    private RunSliceStructureFactory runSliceStructureFactory;
    private long insertedSpectraCount;
    protected final StopWatch globalSW = new StopWatch("Global");
    protected final StopWatch insertSpectrumSW = new StopWatch("InsertSpectrum");
    protected final StopWatch metadataSW = new StopWatch("MetaData");
    BoundingBoxCache.MsLevelAndIsolationWindowKey KEY = new BoundingBoxCache.MsLevelAndIsolationWindowKey();
    private TreeSet<Long> _spectraIdsTreeSet = new TreeSet();

    public MzDBWriter(File location, boolean useTmp, MzDBMetaData metaData, BBSizes bbSizes, Boolean isDIA) {
        this.finalDBLocation = location;
        this.tmpDBLocation = useTmp ? new File(location.getAbsolutePath() + ".tmp") : location;
        this.metaData = metaData;
        this.bbSizes = bbSizes;
        this.isDIA = isDIA;
        this.dataEncodingRegistry = new DataEncodingRegistry();
        this.runSliceStructureFactory = new RunSliceStructureFactory(1, 1000, bbSizes);
        this.insertedSpectraCount = 0L;
        this.boundingBoxCache = new BoundingBoxCache(bbSizes);
        this.globalSW.start();
        this.insertSpectrumSW.start();
        this.insertSpectrumSW.suspend();
        this.metadataSW.start();
        this.metadataSW.suspend();
    }

    public void initialize() throws SQLiteException {
        logger.debug("Initialize Writer for " + this.tmpDBLocation.getName());
        this.createConnection();
        if (this.metaData != null) {
            this.insertMetaData();
        }
    }

    public void addMetaData(MzDBMetaData metaData) throws SQLiteException {
        this.metaData = metaData;
        this.insertMetaData();
    }

    private void createConnection() throws SQLiteException {
        this.sqliteConnection = new SQLiteConnection(this.tmpDBLocation);
        this.sqliteConnection.open(true);
        this.sqliteConnection.exec("PRAGMA encoding='UTF-8';");
        this.sqliteConnection.exec("PRAGMA synchronous=OFF;");
        this.sqliteConnection.exec("PRAGMA journal_mode=OFF;");
        this.sqliteConnection.exec("PRAGMA temp_store=2;");
        this.sqliteConnection.exec("PRAGMA cache_size=-100000;");
        this.sqliteConnection.exec("PRAGMA page_size=4096;");
        this.sqliteConnection.exec("PRAGMA automatic_index=OFF;");
        this.sqliteConnection.exec("PRAGMA locking_mode=EXCLUSIVE;");
        this.sqliteConnection.exec("PRAGMA foreign_keys=OFF;");
        this.sqliteConnection.exec("PRAGMA ignore_check_constraints=ON;");
        this.sqliteConnection.exec("BEGIN TRANSACTION;");
        this.sqliteConnection.exec(MzDBSchema.getSchemaDDL());
        this.bboxInsertStmt = this.sqliteConnection.prepare("INSERT INTO " + BoundingBoxTable.tableName + " VALUES (NULL, ?, ?, ?, ?)", false);
        this.rtreeInsertStmt = this.sqliteConnection.prepare("INSERT INTO bounding_box_rtree VALUES (?, ?, ?, ?, ?)", false);
        this.msnRtreeInsertStmt = this.sqliteConnection.prepare("INSERT INTO bounding_box_msn_rtree VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", false);
        StringBuilder placeHolders = new StringBuilder();
        for (int i = 0; i < 24; ++i) {
            placeHolders.append("?, ");
        }
        placeHolders.delete(placeHolders.length() - 2, placeHolders.length() - 1);
        this.spectrumInsertStmt = this.sqliteConnection.prepare("INSERT INTO spectrum VALUES (" + placeHolders + ")", false);
    }

    private void insertMetaData() throws SQLiteException {
        this.metadataSW.resume();
        if (this.sqliteConnection == null) {
            throw new IllegalStateException("The database connection isn't initialized  !");
        }
        logger.debug(" --- insertMetaData ");
        logger.trace("     - INSERT DATA PROCESSING ");
        SQLiteStatement stmt = this.sqliteConnection.prepare("INSERT INTO " + DataProcessingTable.tableName + " VALUES (NULL, ?)", false);
        List<ProcessingMethod> procMethods = this.metaData.getProcessingMethods();
        List dpNames = procMethods.stream().map(ProcessingMethod::getDataProcessingName).distinct().collect(Collectors.toList());
        logger.trace("     --- NBR " + dpNames.size());
        HashMap<String, Long> dpIdByName = new HashMap<String, Long>();
        for (String string : dpNames) {
            stmt.bind(1, string);
            stmt.step();
            Long l = this.sqliteConnection.getLastInsertId();
            stmt.reset();
            dpIdByName.put(string, l);
        }
        stmt.dispose();
        logger.trace("     - INSERT PROCESSING METHODS ");
        stmt = this.sqliteConnection.prepare("INSERT INTO " + ProcessingMethodTable.tableName + " VALUES (NULL, ?, ?, ?, ?, ?)", false);
        logger.trace("     --- NBR " + procMethods.size());
        for (ProcessingMethod processingMethod : procMethods) {
            stmt.bind(1, processingMethod.getNumber());
            if (!processingMethod.hasParamTree()) {
                stmt.bind(2, ParamTreeStringifier.stringifyParamTree(new ParamTree()));
            } else {
                stmt.bind(2, ParamTreeStringifier.stringifyParamTree(processingMethod.getParamTree(this.sqliteConnection)));
            }
            stmt.bindNull(3);
            stmt.bind(4, ((Long)dpIdByName.get(processingMethod.getDataProcessingName())).longValue());
            stmt.bind(5, processingMethod.getSoftwareId().intValue());
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        logger.trace("     - INSERT CV** METHODS ");
        stmt = this.sqliteConnection.prepare("INSERT INTO " + CvTable.tableName + " VALUES (?, ?, ?, ?)", false);
        List<CV> cvs = this.metaData.getCvList();
        logger.trace("     --- NBR CV " + cvs.size());
        for (CV cV : cvs) {
            stmt.bind(1, cV.getCvId());
            stmt.bind(2, cV.getFullName());
            stmt.bind(3, cV.getCvVersion());
            stmt.bind(4, cV.getUri());
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        stmt = this.sqliteConnection.prepare("INSERT INTO " + CVTermTable.tableName + " VALUES (?, ?, ?, ?)", false);
        List<CVTerm> list = this.metaData.getCvTerms();
        logger.trace("     --- NBR CV Terms " + list.size());
        for (CVTerm cVTerm : list) {
            stmt.bind(1, cVTerm.getAccession());
            stmt.bind(2, cVTerm.getName());
            stmt.bind(3, cVTerm.getUnitAccession());
            stmt.bind(4, cVTerm.getCvId());
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        stmt = this.sqliteConnection.prepare("INSERT INTO " + CvUnitTable.tableName + " VALUES (?, ?, ?)", false);
        List<CVUnit> list2 = this.metaData.getCvUnits();
        logger.trace("     --- NBR CV Units " + list2.size());
        for (CVUnit cVUnit : list2) {
            stmt.bind(1, cVUnit.getAccession());
            stmt.bind(2, cVUnit.getName());
            stmt.bind(3, cVUnit.getCvId());
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        stmt = this.sqliteConnection.prepare("INSERT INTO " + UserTermTable.tableName + " VALUES (?, ?, ?, ?)", false);
        List<UserTerm> list3 = this.metaData.getUserTerms();
        logger.trace("     --- NBR USER Terms " + list3.size());
        for (UserTerm userTerm : list3) {
            stmt.bind(1, userTerm.getId());
            stmt.bind(2, userTerm.getName());
            stmt.bind(3, userTerm.getType());
            stmt.bind(4, userTerm.getUnitAccession());
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        logger.trace("     - INSERT SHARED PARAM ");
        List<SharedParamTree> list4 = this.metaData.getSharedParamTrees();
        list4.sort((o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return Long.compare(o1.getId(), o2.getId());
        });
        logger.trace("       -- NBR " + list4.size());
        stmt = this.sqliteConnection.prepare("INSERT INTO " + SharedParamTreeTable.tableName + " VALUES (NULL, ?, ?)", false);
        for (SharedParamTree sharedParamTree : list4) {
            stmt.bind(1, ParamTreeStringifier.stringifyRefParamGroup(sharedParamTree.getData()));
            stmt.bind(2, sharedParamTree.getSchemaName());
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        logger.trace("     - INSERT INSTRUMENT CONFIGS ");
        stmt = this.sqliteConnection.prepare("INSERT INTO " + InstrumentConfigurationTable.tableName + " VALUES (NULL, ?, NULL, ?, NULL,  ?)", false);
        List<InstrumentConfiguration> list5 = this.metaData.getInstrumentConfigurations();
        logger.trace("     --- NBR " + list5.size());
        for (InstrumentConfiguration instConfig : list5) {
            if (instConfig.getComponentList() == null) continue;
            stmt.bind(1, instConfig.getName());
            stmt.bind(2, ParamTreeStringifier.stringifyComponentList(instConfig.getComponentList()));
            stmt.bind(3, instConfig.getSoftwareId());
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        logger.trace("     - INSERT MZDB HEADER ");
        stmt = this.sqliteConnection.prepare("INSERT INTO " + MzdbTable.tableName + " VALUES (?, ?, ?, ?, ?)", false);
        MzDbHeader mzDbHeader = this.metaData.getMzdbHeader();
        ParamTree mzdbHeaderParams = mzDbHeader.hasParamTree() ? mzDbHeader.getParamTree(this.sqliteConnection) : new ParamTree();
        HashSet<String> bbSizesKeySet = new HashSet<String>();
        bbSizesKeySet.add("ms1_bb_mz_width");
        bbSizesKeySet.add("ms1_bb_time_width");
        bbSizesKeySet.add("msn_bb_mz_width");
        bbSizesKeySet.add("msn_bb_time_width");
        List<UserParam> userExtraParams = mzdbHeaderParams.getUserParams().stream().filter(p -> !bbSizesKeySet.contains(p.getName())).collect(Collectors.toList());
        userExtraParams.add(new UserParam("ms1_bb_mz_width", String.valueOf(this.bbSizes.BB_MZ_HEIGHT_MS1), "xsd:float", null));
        userExtraParams.add(new UserParam("ms1_bb_time_width", String.valueOf(this.bbSizes.BB_RT_WIDTH_MS1), "xsd:float", null));
        userExtraParams.add(new UserParam("msn_bb_mz_width", String.valueOf(this.bbSizes.BB_MZ_HEIGHT_MSn), "xsd:float", null));
        userExtraParams.add(new UserParam("msn_bb_time_width", String.valueOf(this.bbSizes.BB_RT_WIDTH_MSn), "xsd:float", null));
        mzdbHeaderParams.setUserParams(userExtraParams);
        String serializedMzDbParamTree = ParamTreeStringifier.stringifyParamTree(mzdbHeaderParams);
        stmt.bind(1, MODEL_VERSION);
        stmt.bind(2, Integer.parseInt(String.valueOf(new Date().getTime() / 1000L)));
        stmt.bind(3, ParamTreeStringifier.stringifyFileContentParam(mzDbHeader.getFileContent()));
        stmt.bind(4, "");
        stmt.bind(5, serializedMzDbParamTree);
        stmt.step();
        stmt.reset();
        stmt.dispose();
        logger.trace("     - INSERT RUNS ");
        stmt = this.sqliteConnection.prepare("INSERT INTO " + RunTable.tableName + " VALUES (NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?)", false);
        List<Run> runs = this.metaData.getRuns();
        logger.trace("     --- NBR " + runs.size());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        for (Run run : runs) {
            ParamTree runParamTree = run.hasParamTree() ? run.getParamTree(this.sqliteConnection) : new ParamTree();
            List<CVParam> cvParams = runParamTree.getCVParams();
            long nbr = cvParams.stream().filter(cv -> cv.getAccession().equals(CVEntry.ACQUISITION_PARAMETER.getAccession())).count();
            if (nbr == 0L) {
                String modeName = this.isDIA ? AcquisitionMode.SWATH.name() : AcquisitionMode.DDA.name();
                CVParam cvParam = new CVParam();
                cvParam.setCvRef("MS");
                cvParam.setAccession(CVEntry.ACQUISITION_PARAMETER.getAccession());
                cvParam.setName("acquisition parameter");
                cvParam.setValue(modeName);
                cvParams.add(cvParam);
                runParamTree.setCvParams(cvParams);
            }
            stmt.bind(1, run.getName());
            stmt.bind(2, dateFormat.format(run.getStartTimestamp()));
            stmt.bind(3, ParamTreeStringifier.stringifyParamTree(runParamTree));
            if (this.metaData.getSharedParamTrees() == null || this.metaData.getSharedParamTrees().isEmpty()) {
                stmt.bindNull(4);
            } else {
                stmt.bind(4, 1);
            }
            stmt.bind(5, 1);
            stmt.bind(6, 1);
            stmt.bind(7, 1);
            stmt.bind(8, 1);
            stmt.bind(9, 1);
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        logger.trace("     - INSERT SOURCE FILES ");
        stmt = this.sqliteConnection.prepare("INSERT INTO " + SourceFileTable.tableName + " VALUES (NULL, ?, ?, ?, NULL)", false);
        List<SourceFile> sourceFiles = this.metaData.getSourceFiles();
        logger.trace("         - Nbr " + sourceFiles.size());
        for (SourceFile sourceFile : sourceFiles) {
            stmt.bind(1, sourceFile.getName());
            stmt.bind(2, sourceFile.getLocation());
            if (sourceFile.hasParamTree()) {
                stmt.bind(3, ParamTreeStringifier.stringifyParamTree(sourceFile.getParamTree(this.sqliteConnection)));
            } else {
                stmt.bind(3, "");
            }
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        logger.trace("     - INSERT SAMPLES ");
        stmt = this.sqliteConnection.prepare("INSERT INTO " + SampleTable.tableName + " VALUES (NULL, ?, ?, NULL)", false);
        List<Sample> list6 = this.metaData.getSamples();
        logger.trace("         - Nbr " + list6.size());
        if (list6.isEmpty()) {
            String sampleName = sourceFiles.isEmpty() ? this.tmpDBLocation.getName().split("\\.")[0] : sourceFiles.get(0).getName();
            stmt.bind(1, sampleName);
            stmt.step();
        } else {
            for (Sample sample : list6) {
                stmt.bind(1, sample.getName());
                if (!sample.hasParamTree()) {
                    stmt.bindNull(2);
                } else {
                    stmt.bind(2, ParamTreeStringifier.stringifyParamTree(sample.getParamTree(this.sqliteConnection)));
                }
                stmt.step();
                stmt.reset();
            }
        }
        stmt.dispose();
        logger.trace("     - INSERT SOFTWARE LIST ");
        stmt = this.sqliteConnection.prepare("INSERT INTO " + SoftwareTable.tableName + " VALUES (NULL, ?, ?, ?, NULL)", false);
        List<Software> softwareList = this.metaData.getSoftwares();
        logger.trace("         - Nbr " + softwareList.size());
        for (Software software : softwareList) {
            stmt.bind(1, software.getName());
            stmt.bind(2, software.getVersion());
            ParamTree pt = software.hasParamTree() ? software.getParamTree(this.sqliteConnection) : new ParamTree();
            stmt.bind(3, ParamTreeStringifier.stringifyParamTree(pt));
            stmt.step();
            stmt.reset();
        }
        stmt.dispose();
        this.metadataSW.stop();
        logger.trace("  --- Insert MetaData done ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.sqliteConnection == null) {
            throw new IllegalStateException("The method open() must first be called");
        }
        try {
            for (BoundingBoxCache.MsLevelAndIsolationWindowKey levelAndIsolationWindow : this.boundingBoxCache.getBBRowsKeys()) {
                Long bbFirstSpectrumId = this.flushBBRow(levelAndIsolationWindow.msLevel, levelAndIsolationWindow.isolationWindow);
                if (bbFirstSpectrumId == null) continue;
                this.flushSpectrum(levelAndIsolationWindow.msLevel, levelAndIsolationWindow.isolationWindow, bbFirstSpectrumId);
            }
            try {
                SQLiteStatement stmt = this.sqliteConnection.prepare("INSERT INTO " + DataEncodingTable.tableName + " VALUES (?, ?, ?, ?, ?, ?, NULL)", false);
                List<DataEncoding> dataEncs = this.dataEncodingRegistry.getDistinctDataEncoding();
                for (DataEncoding dataEnc : dataEncs) {
                    long mzPrecision = 64L;
                    long intPrecision = 32L;
                    PeakEncoding peakEnc = dataEnc.getPeakEncoding();
                    if (peakEnc == PeakEncoding.LOW_RES_PEAK) {
                        mzPrecision = 32L;
                    } else if (peakEnc == PeakEncoding.NO_LOSS_PEAK) {
                        intPrecision = 64L;
                    }
                    stmt.bind(1, dataEnc.getId());
                    stmt.bind(2, dataEnc.getMode().name());
                    stmt.bind(3, dataEnc.getCompression());
                    stmt.bind(4, dataEnc.getByteOrder().toString().toLowerCase());
                    stmt.bind(5, mzPrecision);
                    stmt.bind(6, intPrecision);
                    stmt.step();
                    stmt.reset();
                }
                stmt.dispose();
                stmt = this.sqliteConnection.prepare("INSERT INTO " + RunSliceTable.tableName + " VALUES (?, ?, ?, ?, ?, NULL, ?)", false);
                for (RunSliceHeader runSlice : this.runSliceStructureFactory.getAllRunSlices()) {
                    stmt.bind(1, runSlice.getId());
                    stmt.bind(2, runSlice.getMsLevel());
                    stmt.bind(3, runSlice.getNumber());
                    stmt.bind(4, runSlice.getBeginMz());
                    stmt.bind(5, runSlice.getEndMz());
                    stmt.bind(6, runSlice.getRunId());
                    stmt.step();
                    stmt.reset();
                }
                stmt.dispose();
                this.sqliteConnection.exec("CREATE UNIQUE INDEX spectrum_initial_id_idx ON spectrum (initial_id ASC,run_id ASC);");
                this.sqliteConnection.exec("CREATE INDEX spectrum_ms_level_idx ON spectrum (ms_level ASC,run_id ASC);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX run_name_idx ON run (name);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX run_slice_mz_range_idx ON run_slice (begin_mz ASC,end_mz ASC,ms_level ASC,run_id ASC);");
                this.sqliteConnection.exec("CREATE INDEX bounding_box_run_slice_idx ON bounding_box (run_slice_id ASC);");
                this.sqliteConnection.exec("CREATE INDEX bounding_box_first_spectrum_idx ON bounding_box (first_spectrum_id ASC); ");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX controlled_vocabulary_full_name_idx ON cv (full_name);");
                this.sqliteConnection.exec("CREATE INDEX controlled_vocabulary_uri_idx ON cv (uri);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX source_file_name_idx ON source_file (name);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX sample_name_idx ON sample (name);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX software_name_idx ON software (name);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX instrument_configuration_name_idx ON instrument_configuration (name);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX processing_method_number_idx ON processing_method (number ASC);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX data_processing_name_idx ON data_processing (name);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX chromatogram_name_idx ON chromatogram (name);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX cv_term_name_idx ON cv_term (name ASC);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX user_term_name_idx ON user_term (name ASC);");
                this.sqliteConnection.exec("CREATE UNIQUE INDEX cv_unit_name_idx ON cv_unit (name ASC);");
                this.sqliteConnection.exec("CREATE INDEX spectrum_bb_first_spectrum_id_idx ON spectrum (bb_first_spectrum_id ASC);");
                this.sqliteConnection.exec("COMMIT TRANSACTION;");
            }
            finally {
                if (this.bboxInsertStmt != null) {
                    this.bboxInsertStmt.dispose();
                }
                if (this.rtreeInsertStmt != null) {
                    this.rtreeInsertStmt.dispose();
                }
                if (this.msnRtreeInsertStmt != null) {
                    this.msnRtreeInsertStmt.dispose();
                }
                if (this.spectrumInsertStmt != null) {
                    this.spectrumInsertStmt.dispose();
                }
                this.sqliteConnection.dispose();
            }
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
        if (!this.finalDBLocation.equals(this.tmpDBLocation)) {
            this.tmpDBLocation.renameTo(this.finalDBLocation);
        }
        this.globalSW.stop();
        this.insertSpectrumSW.stop();
        logger.debug("mzDB Writer closed");
    }

    public void insertSpectrum(Spectrum spectrum, DataEncoding dataEncoding) throws SQLiteException {
        String precursorListAsString;
        String scanListAsString;
        SpectrumHeader spectrumHeader = spectrum.getHeader();
        String paramTreeAsString = spectrumHeader.getParamTreeAsString();
        if (paramTreeAsString == null && spectrumHeader.hasParamTree()) {
            paramTreeAsString = ParamTreeStringifier.stringifyParamTree(spectrumHeader.getParamTree(null));
        }
        if ((scanListAsString = spectrumHeader.getScanListAsString()) == null && spectrumHeader.hasScanList()) {
            scanListAsString = ParamTreeStringifier.stringifyScanList(spectrumHeader.getScanList());
        }
        if ((precursorListAsString = spectrumHeader.getPrecursorListAsString()) == null && spectrumHeader.hasPrecursorList()) {
            precursorListAsString = ParamTreeStringifier.stringifyPrecursorList(spectrumHeader.getPrecursorList());
        }
        SpectrumMetaData spectrumMetaData = new SpectrumMetaData(spectrumHeader.getId(), paramTreeAsString, scanListAsString, precursorListAsString);
        this.insertSpectrum(spectrum, spectrumMetaData, dataEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSpectrum(Spectrum spectrum, SpectrumMetaData metaDataAsText, DataEncoding dataEncoding) throws SQLiteException {
        this.insertSpectrumSW.resume();
        try {
            SpectrumHeader spectrumHeader = spectrum.getHeader();
            SpectrumData spectrumData = spectrum.getData();
            int peaksCount = spectrumData.getPeaksCount();
            boolean emptySpectrum = peaksCount == 0;
            ++this.insertedSpectraCount;
            long spectrumId = this.insertedSpectraCount;
            int msLevel = spectrumHeader.getMsLevel();
            Float spectrumTime = Float.valueOf(spectrumHeader.getElutionTime());
            IsolationWindow isolationWindow = this.isDIA && msLevel >= 2 ? spectrumHeader.getIsolationWindow() : null;
            DataEncoding dataEnc = this.dataEncodingRegistry.getOrAddDataEncoding(dataEncoding);
            if (!emptySpectrum) {
                Long bbFirstSpectrumId;
                float curMaxMz;
                float curMinMz;
                Double mzInc = msLevel == 1 ? this.bbSizes.BB_MZ_HEIGHT_MS1 : this.bbSizes.BB_MZ_HEIGHT_MSn;
                if (this.isDIA) {
                    curMinMz = (float)(Math.floor(spectrumData.getMzList()[0] / this.bbSizes.BB_MZ_HEIGHT_MS1) * this.bbSizes.BB_MZ_HEIGHT_MS1);
                    curMaxMz = (float)((double)curMinMz + mzInc);
                } else if (msLevel >= 2) {
                    curMinMz = 0.0f;
                    curMaxMz = (float)this.bbSizes.BB_MZ_HEIGHT_MSn;
                } else {
                    curMinMz = (float)(Math.floor(spectrumData.getMzList()[0] / mzInc) * mzInc);
                    curMaxMz = (float)((double)curMinMz + mzInc);
                }
                boolean isTimeForNewBBRow = this.boundingBoxCache.isTimeForNewBBRow(msLevel, isolationWindow, spectrumTime);
                if (isTimeForNewBBRow && (bbFirstSpectrumId = this.flushBBRow(msLevel, isolationWindow)) != null) {
                    this.flushSpectrum(msLevel, isolationWindow, bbFirstSpectrumId);
                }
                int i = 0;
                BoundingBoxToWrite curBB = this.getBBWithNextSpectrumSlice(spectrum, spectrumId, spectrumTime, msLevel, dataEnc, isolationWindow, i, Float.valueOf(curMinMz), Float.valueOf(curMaxMz));
                for (i = 1; i < peaksCount; ++i) {
                    double mz = spectrumData.getMzList()[i];
                    if (!(mz > (double)curMaxMz)) continue;
                    while (mz > (double)curMaxMz) {
                        curMinMz = (float)((double)curMinMz + mzInc);
                        curMaxMz = (float)((double)curMaxMz + mzInc);
                        if (this.runSliceStructureFactory.hasRunSlice(msLevel, Float.valueOf(curMinMz), Float.valueOf(curMaxMz))) continue;
                        this.runSliceStructureFactory.addRunSlice(msLevel, Float.valueOf(curMinMz), Float.valueOf(curMaxMz));
                    }
                    SpectrumSliceIndex lastSpectrumSlice = curBB.getSpectrumSlices().get(curBB.getSpectrumIds().size() - 1);
                    lastSpectrumSlice.setLastPeakIdx(i - 1);
                    curBB = this.getBBWithNextSpectrumSlice(spectrum, spectrumId, spectrumTime, msLevel, dataEnc, isolationWindow, i, Float.valueOf(curMinMz), Float.valueOf(curMaxMz));
                }
                SpectrumSliceIndex lastSpectrumSlice = curBB.getSpectrumSlices().get(curBB.getSpectrumIds().size() - 1);
                lastSpectrumSlice.setLastPeakIdx(i - 1);
                this.KEY.msLevel = msLevel;
                this.KEY.isolationWindow = isolationWindow;
                ArrayList<SpectrumToWrite> spectrumList = this.spectrumCache.get(this.KEY);
                if (spectrumList == null) {
                    spectrumList = new ArrayList();
                    BoundingBoxCache.MsLevelAndIsolationWindowKey key = new BoundingBoxCache.MsLevelAndIsolationWindowKey();
                    key.msLevel = msLevel;
                    key.isolationWindow = isolationWindow;
                    this.spectrumCache.put(key, spectrumList);
                }
                spectrumList.add(new SpectrumToWrite(spectrumHeader, metaDataAsText, spectrumId, dataEnc));
            } else {
                SpectrumToWrite spectrumToWrite = new SpectrumToWrite(spectrumHeader, metaDataAsText, spectrumId, dataEnc);
                this.insertSpectrumToWrite(spectrumToWrite, spectrumToWrite.spectrumId);
            }
        }
        finally {
            this.insertSpectrumSW.suspend();
        }
    }

    private void flushSpectrum(int msLevel, IsolationWindow isolationWindow, Long bbFirstSpectrumId) throws SQLiteException {
        this.KEY.msLevel = msLevel;
        this.KEY.isolationWindow = isolationWindow;
        ArrayList<SpectrumToWrite> spectrumToWriteList = this.spectrumCache.remove(this.KEY);
        for (SpectrumToWrite s : spectrumToWriteList) {
            this.insertSpectrumToWrite(s, bbFirstSpectrumId);
        }
    }

    private void insertSpectrumToWrite(SpectrumToWrite spectrumToWrite, Long bbFirstSpectrumId) throws SQLiteException {
        SQLiteStatement stmt = this.spectrumInsertStmt;
        stmt.bind(1, spectrumToWrite.spectrumId);
        stmt.bind(2, spectrumToWrite.spectrumId);
        stmt.bind(3, spectrumToWrite.header.getTitle());
        stmt.bind(4, spectrumToWrite.header.getCycle());
        stmt.bind(5, (double)spectrumToWrite.header.getTime());
        stmt.bind(6, spectrumToWrite.header.getMsLevel());
        if (spectrumToWrite.header.getActivationType() == null) {
            stmt.bindNull(7);
        } else {
            stmt.bind(7, spectrumToWrite.header.getActivationType().name());
        }
        stmt.bind(8, (double)spectrumToWrite.header.getTIC());
        stmt.bind(9, spectrumToWrite.header.getBasePeakMz());
        stmt.bind(10, (double)spectrumToWrite.header.getBasePeakIntensity());
        if (spectrumToWrite.header.getPrecursorMz() == null || spectrumToWrite.header.getPrecursorMz() == 0.0) {
            stmt.bindNull(11);
        } else {
            stmt.bind(11, spectrumToWrite.header.getPrecursorMz().doubleValue());
        }
        if (spectrumToWrite.header.getPrecursorCharge() == null || spectrumToWrite.header.getPrecursorCharge() == 0) {
            stmt.bindNull(12);
        } else {
            stmt.bind(12, spectrumToWrite.header.getPrecursorCharge().intValue());
        }
        stmt.bind(13, spectrumToWrite.header.getPeaksCount());
        stmt.bind(14, spectrumToWrite.metadata.getParamTree());
        stmt.bind(15, spectrumToWrite.metadata.getScanList());
        if (StringUtils.isEmpty((CharSequence)spectrumToWrite.metadata.getPrecursorList())) {
            stmt.bindNull(16);
        } else {
            String precList = spectrumToWrite.metadata.getPrecursorList();
            stmt.bind(16, precList);
        }
        stmt.bindNull(17);
        stmt.bind(18, 1);
        stmt.bind(19, 1);
        stmt.bind(20, 1);
        stmt.bind(21, 1);
        stmt.bind(22, 1);
        stmt.bind(23, spectrumToWrite.dataEncoding.getId());
        stmt.bind(24, bbFirstSpectrumId.longValue());
        stmt.step();
        stmt.reset();
    }

    private BoundingBoxToWrite getBBWithNextSpectrumSlice(Spectrum spectrum, Long spectrumId, Float spectrumTime, Integer msLevel, DataEncoding dataEnc, IsolationWindow isolationWindow, Integer peakIdx, Float minMz, Float maxMz) {
        BoundingBoxToWrite cachedBB;
        Integer runSliceId = this.runSliceStructureFactory.getRunSliceId(msLevel, minMz, maxMz);
        if (runSliceId == null) {
            runSliceId = this.runSliceStructureFactory.addRunSlice(msLevel, minMz, maxMz).getId();
        }
        if ((cachedBB = this.boundingBoxCache.getCachedBoundingBox(msLevel, runSliceId, isolationWindow)) == null) {
            int sliceSlicesCountHint = msLevel >= 2 ? 1 : this.runSliceStructureFactory.getRunSlicesCount();
            cachedBB = this.boundingBoxCache.createBoundingBox(spectrumTime, runSliceId, msLevel, dataEnc, isolationWindow, sliceSlicesCountHint);
        } else {
            cachedBB.lastTime = spectrumTime;
        }
        cachedBB.getSpectrumIds().add(spectrumId);
        cachedBB.spectrumSlices.add(new SpectrumSliceIndex(spectrum.getData(), peakIdx.intValue(), peakIdx.intValue()));
        return cachedBB;
    }

    private Long flushBBRow(Integer msLevel, IsolationWindow isolationWindowOpt) {
        BoundingBoxToWrite singleBoundingBox = this.boundingBoxCache.hasOneCachedBBWithOneSpectrum(msLevel, isolationWindowOpt);
        if (singleBoundingBox != null) {
            try {
                this.insertAndIndexBoundingBox(singleBoundingBox);
            }
            catch (SQLiteException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.boundingBoxCache.removeBBRow(msLevel, isolationWindowOpt);
            return singleBoundingBox.getSpectrumIds().get(0);
        }
        this._spectraIdsTreeSet.clear();
        Function<BoundingBoxToWrite, Void> spectraIdsfunction = bb -> {
            this._spectraIdsTreeSet.addAll(bb.getSpectrumIds());
            return null;
        };
        this.boundingBoxCache.forEachCachedBB(msLevel, isolationWindowOpt, spectraIdsfunction);
        if (this._spectraIdsTreeSet.isEmpty()) {
            return null;
        }
        ArrayList<Long> allSpectrasIds = new ArrayList<Long>(this._spectraIdsTreeSet);
        Function<BoundingBoxToWrite, Void> insertBBFunction = bb -> {
            int spSize = bb.getSpectrumIds().size();
            if (spSize != allSpectrasIds.size()) {
                HashMap<Long, SpectrumSliceIndex> specSliceById = new HashMap<Long, SpectrumSliceIndex>();
                for (int i = 0; i < spSize; ++i) {
                    specSliceById.put(bb.spectrumIds.get(i), bb.spectrumSlices.get(i));
                }
                ArrayList<SpectrumSliceIndex> distinctBBSpectraSlice = new ArrayList<SpectrumSliceIndex>(allSpectrasIds.size());
                for (Long spectrumId : allSpectrasIds) {
                    distinctBBSpectraSlice.add((SpectrumSliceIndex)specSliceById.get(spectrumId));
                }
                bb.spectrumIds = allSpectrasIds;
                bb.spectrumSlices = distinctBBSpectraSlice;
            }
            try {
                this.insertAndIndexBoundingBox((BoundingBoxToWrite)bb);
            }
            catch (SQLiteException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return null;
        };
        this.boundingBoxCache.forEachCachedBB(msLevel, isolationWindowOpt, insertBBFunction);
        this.boundingBoxCache.removeBBRow(msLevel, isolationWindowOpt);
        return this._spectraIdsTreeSet.isEmpty() ? null : this._spectraIdsTreeSet.first();
    }

    private void insertAndIndexBoundingBox(BoundingBoxToWrite bb) throws SQLiteException {
        Integer msLevel = bb.getMsLevel();
        long bbId = this.insertBoundingBoxToWrite(bb);
        RunSliceHeader runSlice = this.runSliceStructureFactory.getRunSlice(bb.runSliceId);
        SQLiteStatement stmt = null;
        boolean isRTreeIndexInserted = false;
        try {
            if (msLevel == 1) {
                stmt = this.rtreeInsertStmt;
                stmt.bind(1, bbId);
                stmt.bind(2, runSlice.getBeginMz());
                stmt.bind(3, runSlice.getEndMz());
                stmt.bind(4, (double)bb.getFirstTime().floatValue());
                stmt.bind(5, (double)bb.getLastTime().floatValue());
                isRTreeIndexInserted = true;
            } else if (msLevel >= 2) {
                if (this.isDIA) {
                    IsolationWindow isolationWindow = bb.getIsolationWindow();
                    if (isolationWindow != null) {
                        stmt = this.msnRtreeInsertStmt;
                        stmt.bind(1, bbId);
                        stmt.bind(2, msLevel.intValue());
                        stmt.bind(3, msLevel.intValue());
                        stmt.bind(4, isolationWindow.getMinMz());
                        stmt.bind(5, isolationWindow.getMaxMz());
                        stmt.bind(6, runSlice.getBeginMz());
                        stmt.bind(7, runSlice.getEndMz());
                        stmt.bind(8, (double)bb.getFirstTime().floatValue());
                        stmt.bind(9, (double)bb.getLastTime().floatValue());
                        isRTreeIndexInserted = true;
                    }
                } else {
                    stmt = this.msnRtreeInsertStmt;
                    stmt.bind(1, bbId);
                    stmt.bind(2, msLevel.intValue());
                    stmt.bind(3, msLevel.intValue());
                    stmt.bind(4, 0);
                    stmt.bind(5, 0);
                    stmt.bind(6, runSlice.getBeginMz());
                    stmt.bind(7, runSlice.getEndMz());
                    stmt.bind(8, (double)bb.getFirstTime().floatValue());
                    stmt.bind(9, (double)bb.getLastTime().floatValue());
                    isRTreeIndexInserted = true;
                }
            }
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
        if (isRTreeIndexInserted) {
            try {
                stmt.step();
                stmt.reset();
            }
            catch (SQLiteException e) {
                e.printStackTrace();
            }
        } else if (this.isDIA) {
            // empty if block
        }
    }

    protected Long insertBoundingBoxToWrite(BoundingBoxToWrite bb) throws SQLiteException {
        List<Long> spectrumIds = bb.getSpectrumIds();
        List<SpectrumSliceIndex> spectrumSlices = bb.getSpectrumSlices();
        int slicesCount = spectrumSlices.size();
        int bbPeaksCount = 0;
        for (SpectrumSliceIndex spectrumSliceIndex : spectrumSlices) {
            if (spectrumSliceIndex == null) continue;
            bbPeaksCount += spectrumSliceIndex.peaksCount();
        }
        logger.trace("BB " + bb.getId() + " has " + slicesCount + " slicesCount with nbr peaks " + bbPeaksCount);
        DataEncoding dataEnc = bb.getDataEncoding();
        PeakEncoding pe = dataEnc.getPeakEncoding();
        assert (pe != PeakEncoding.NO_LOSS_PEAK) : "The NO_LOSS_PEAK encoding is no yet supported!";
        int peakStructSize = dataEnc.getPeakStructSize();
        int bbLen = (int)(8L * (long)slicesCount) + peakStructSize * bbPeaksCount;
        byte[] bbBytes = new byte[bbLen];
        ByteBuffer bytesBuffer = ByteBuffer.wrap(bbBytes).order(dataEnc.getByteOrder());
        for (int sliceIdx = 0; sliceIdx < slicesCount; ++sliceIdx) {
            Long spectrumId = spectrumIds.get(sliceIdx);
            bytesBuffer.putInt(spectrumId.intValue());
            SpectrumSliceIndex spectrumSliceIdx = spectrumSlices.get(sliceIdx);
            if (spectrumSliceIdx == null) {
                bytesBuffer.putInt(0);
                continue;
            }
            SpectrumData spectrumData = spectrumSliceIdx.getSpectrumData();
            float firstPeakIdx = spectrumSliceIdx.getFirstPeakIdx();
            float lastPeakIdx = spectrumSliceIdx.getLastPeakIdx();
            int slicePeaksCount = spectrumSliceIdx.peaksCount();
            bytesBuffer.putInt(slicePeaksCount);
            int i = (int)firstPeakIdx;
            while ((float)i <= lastPeakIdx) {
                if (pe == PeakEncoding.HIGH_RES_PEAK) {
                    bytesBuffer.putDouble(spectrumData.getMzList()[i]);
                } else {
                    bytesBuffer.putFloat(Double.valueOf(spectrumData.getMzList()[i]).floatValue());
                }
                bytesBuffer.putFloat(spectrumData.getIntensityList()[i]);
                if (dataEnc.getMode().equals(DataMode.FITTED)) {
                    if (spectrumData.getLeftHwhmList() != null && spectrumData.getLeftHwhmList()[i] > 0.0f) {
                        bytesBuffer.putFloat(spectrumData.getLeftHwhmList()[i]);
                    } else {
                        bytesBuffer.putFloat(0.0f);
                    }
                    if (spectrumData.getRightHwhmList() != null && spectrumData.getRightHwhmList()[i] > 0.0f) {
                        bytesBuffer.putFloat(spectrumData.getRightHwhmList()[i]);
                    } else {
                        bytesBuffer.putFloat(0.0f);
                    }
                }
                ++i;
            }
        }
        SQLiteStatement stmt = this.bboxInsertStmt;
        stmt.bind(1, bbBytes);
        stmt.bind(2, bb.getRunSliceId().intValue());
        stmt.bind(3, spectrumIds.get(0).longValue());
        stmt.bind(4, spectrumIds.get(spectrumIds.size() - 1).longValue());
        stmt.step();
        long bbId = this.sqliteConnection.getLastInsertId();
        stmt.reset();
        return bbId;
    }

    public void dumpExecutionWatches() {
        logger.info("Global stop watch : " + this.globalSW.formatTime());
        logger.info("insertSpectrum stop watch : " + this.insertSpectrumSW.formatTime());
        logger.info("metadata stop watch : " + this.metadataSW.formatTime());
    }
}

