/*
 * Decompiled with CFR 0.152.
 */
package jwave.compressions;

import jwave.compressions.Compressor;

public class CompressorPeaksAverage
extends Compressor {
    protected double _peakMinimum = 0.0;
    protected double _peakMaximum = 0.0;

    public CompressorPeaksAverage() {
        this._magnitude = 0.0;
    }

    public CompressorPeaksAverage(double threshold) {
        super(threshold);
        this._magnitude = 0.0;
    }

    @Override
    public double[] compress(double[] arrHilb) {
        for (double val : arrHilb) {
            double absVal = Math.abs(val);
            if (absVal <= this._peakMinimum) {
                this._peakMinimum = absVal;
            }
            if (!(absVal >= this._peakMaximum)) continue;
            this._peakMaximum = absVal;
        }
        this._magnitude = 0.5 * (this._peakMaximum - this._peakMinimum);
        return this.compress(arrHilb, this._magnitude);
    }

    @Override
    public double[][] compress(double[][] matHilb) {
        int matHilbNoOfRows = matHilb.length;
        int matHilbNoOfCols = matHilb[0].length;
        for (int i = 0; i < matHilbNoOfRows; ++i) {
            for (int j = 0; j < matHilbNoOfCols; ++j) {
                double absVal = Math.abs(matHilb[i][j]);
                if (absVal <= this._peakMinimum) {
                    this._peakMinimum = absVal;
                }
                if (!(absVal >= this._peakMaximum)) continue;
                this._peakMaximum = absVal;
            }
        }
        this._magnitude = 0.5 * (this._peakMaximum - this._peakMinimum);
        return this.compress(matHilb, this._magnitude);
    }

    @Override
    public double[][][] compress(double[][][] spcHilb) {
        int matHilbNoOfRows = spcHilb.length;
        int matHilbNoOfCols = spcHilb[0].length;
        int matHilbNoOfLvls = spcHilb[0][0].length;
        for (int i = 0; i < matHilbNoOfRows; ++i) {
            for (int j = 0; j < matHilbNoOfCols; ++j) {
                for (int k = 0; k < matHilbNoOfLvls; ++k) {
                    double absVal = Math.abs(spcHilb[i][j][k]);
                    if (absVal <= this._peakMinimum) {
                        this._peakMinimum = absVal;
                    }
                    if (!(absVal >= this._peakMaximum)) continue;
                    this._peakMaximum = absVal;
                }
            }
        }
        this._magnitude = 0.5 * (this._peakMaximum - this._peakMinimum);
        return this.compress(spcHilb, this._magnitude);
    }
}

