/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.blocks;

import jwave.datatypes.Super;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;

public abstract class Block
extends Super {
    protected int _noOfRows;
    protected int _noOfCols;
    protected int _offSetRow;
    protected int _offSetCol;

    public Block() {
        this._offSetRow = 0;
        this._offSetCol = 0;
        this._noOfRows = 0;
        this._noOfCols = 0;
    }

    public Block(Block block) {
        this._offSetRow = block._offSetRow;
        this._offSetCol = block._offSetCol;
        this._noOfRows = block._offSetRow;
        this._noOfCols = block._noOfCols;
    }

    public Block(int noOfRows, int noOfCols) {
        this._offSetRow = 0;
        this._offSetCol = 0;
        this._noOfRows = noOfRows;
        this._noOfCols = noOfCols;
    }

    public Block(int offSetRow, int offSetCol, int noOfRows, int noOfCols) {
        this._offSetRow = offSetRow;
        this._offSetCol = offSetCol;
        this._noOfRows = noOfRows;
        this._noOfCols = noOfCols;
    }

    public int getNoOfRows() {
        return this._noOfRows;
    }

    public int getNoOfCols() {
        return this._noOfCols;
    }

    public int getOffSetRow() {
        return this._offSetRow;
    }

    public int getOffSetCol() {
        return this._offSetCol;
    }

    protected void check(int j) throws JWaveException {
        if (j < 0) {
            throw new JWaveFailure("Block - i is smaller than zero");
        }
        if (j == this._noOfCols) {
            throw new JWaveFailure("Block - i is equal to noOfCols: " + this._noOfCols);
        }
        if (j > this._noOfCols) {
            throw new JWaveFailure("Block - i is greater than noOfCols: " + this._noOfCols);
        }
    }

    protected void check(int i, int j) throws JWaveException {
        if (i < 0) {
            throw new JWaveFailure("Block - i is smaller than zero");
        }
        if (i == this._noOfRows) {
            throw new JWaveFailure("Block - i is equal to noOfRows: " + this._noOfRows);
        }
        if (i > this._noOfRows) {
            throw new JWaveFailure("Block - i is greater than noOfRows: " + this._noOfRows);
        }
        this.check(j);
    }

    public abstract double get(int var1, int var2) throws JWaveException;

    public abstract void set(int var1, int var2, double var3) throws JWaveException;
}

