/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzscope.threading.queue;

import fr.profi.mzscope.threading.queue.AbstractTask;
import fr.profi.mzscope.threading.queue.WorkerPool;
import fr.profi.mzscope.threading.queue.WorkerThread;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerThread
extends Thread {
    private static TaskManagerThread m_instance;
    private Queue<AbstractTask> m_actions;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());
    private HashMap<Class, HashSet<String>> m_registeredActions = new HashMap();
    private WorkerPool m_workerPool;

    private TaskManagerThread() {
        super("TaskManagerThread");
        this.m_actions = new ArrayDeque<AbstractTask>();
        this.m_workerPool = WorkerPool.getWorkerPool();
    }

    public static TaskManagerThread getTaskManagerThread() {
        if (m_instance == null) {
            m_instance = new TaskManagerThread();
            m_instance.start();
        }
        return m_instance;
    }

    private boolean register(AbstractTask action) {
        HashSet<String> registerSet = this.m_registeredActions.get(action.getClass());
        if (registerSet == null) {
            registerSet = new HashSet();
            registerSet.add(action.getUniqueKey());
            this.m_registeredActions.put(action.getClass(), registerSet);
            return true;
        }
        if (registerSet.contains(action.getUniqueKey())) {
            return false;
        }
        registerSet.add(action.getUniqueKey());
        return true;
    }

    private void unregister(AbstractTask action) {
        HashSet<String> registerSet = this.m_registeredActions.get(action.getClass());
        registerSet.remove(action.getUniqueKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.logger.debug("Start  Tasks Manager Thread");
            Object workerPoolMutex = this.m_workerPool.getMutex();
            block8: while (true) {
                AbstractTask action = null;
                Object object = this;
                synchronized (object) {
                    block9: while (true) {
                        if (!this.m_actions.isEmpty()) {
                            Object object2 = workerPoolMutex;
                            synchronized (object2) {
                                for (AbstractTask actionCur : this.m_actions) {
                                    if (this.m_workerPool.getWorkerThread(actionCur.getType()) == null) continue;
                                    this.m_actions.remove(actionCur);
                                    action = actionCur;
                                    break block9;
                                }
                            }
                            action = this.m_actions.poll();
                            break;
                        }
                        this.wait();
                    }
                    this.notifyAll();
                }
                object = workerPoolMutex;
                synchronized (object) {
                    WorkerThread workerThread = null;
                    while (true) {
                        if ((workerThread = this.m_workerPool.getWorkerThread(action.getType())) != null) {
                            workerThread.setAction(action);
                            workerPoolMutex.notifyAll();
                            continue block8;
                        }
                        workerPoolMutex.wait();
                    }
                }
                break;
            }
        }
        catch (Throwable t) {
            LoggerFactory.getLogger((String)"mzDB-Task").error("Unexpected exception in main loop of AccessDatabaseThread", t);
            m_instance = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionDone(AbstractTask task) {
        TaskManagerThread taskManagerThread = this;
        synchronized (taskManagerThread) {
            this.unregister(task);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTask(AbstractTask task) {
        TaskManagerThread taskManagerThread = this;
        synchronized (taskManagerThread) {
            if (!this.register(task)) {
                return;
            }
        }
        taskManagerThread = this;
        synchronized (taskManagerThread) {
            this.m_actions.add(task);
            this.notifyAll();
        }
    }
}

