/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.peakeldb;

import com.almworks.sqlite4java.SQLiteConnection;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Point;
import fr.profi.mzdb.Settings$;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelCursor;
import fr.profi.mzdb.peakeldb.io.PeakelDbReader$;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

public final class PeakelDbHelper$ {
    public static PeakelDbHelper$ MODULE$;
    private final double SQLITE_RTREE_UB_CORR;
    private final double SQLITE_RTREE_LB_CORR;
    private final double MIN_CORRELATION_THRESHOLD;
    private final PearsonsCorrelation PEARSON;

    static {
        new PeakelDbHelper$();
    }

    private double SQLITE_RTREE_UB_CORR() {
        return this.SQLITE_RTREE_UB_CORR;
    }

    private double SQLITE_RTREE_LB_CORR() {
        return this.SQLITE_RTREE_LB_CORR;
    }

    private double MIN_CORRELATION_THRESHOLD() {
        return this.MIN_CORRELATION_THRESHOLD;
    }

    private PearsonsCorrelation PEARSON() {
        return this.PEARSON;
    }

    public Seq<Object> findPeakelIdsInRange(RTree<Integer, Point> rTree, double minMz, double maxMz, float minTime, float maxTime) {
        Iterator peakelIdIter = rTree.search(Geometries.rectangle((double)minMz, (double)minTime, (double)maxMz, (double)maxTime)).toBlocking().toIterable().iterator();
        ArrayBuffer peakelIds = new ArrayBuffer();
        while (peakelIdIter.hasNext()) {
            peakelIds.$plus$eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)((Entry)peakelIdIter.next()).value())));
        }
        return peakelIds;
    }

    public Peakel[] findPeakelsInRange(SQLiteConnection sqliteConn, Option<RTree<Integer, Point>> rTreeOpt, double minMz, double maxMz, float minTime, float maxTime) {
        Seq<Object> peakelIds = rTreeOpt.isDefined() ? this.findPeakelIdsInRange((RTree<Integer, Point>)((RTree)rTreeOpt.get()), minMz, maxMz, minTime, maxTime) : PeakelDbReader$.MODULE$.findPeakelIdsInRangeFromPeakelDB(sqliteConn, minMz, maxMz, minTime, maxTime);
        Peakel[] peakels = (Peakel[])PeakelDbReader$.MODULE$._loadPeakelsForIds(sqliteConn, peakelIds).toArray(ClassTag$.MODULE$.apply(Peakel.class));
        return peakels;
    }

    public Option<Peakel> findCorrelatingPeakel(Peakel ref, Peakel[] peakels) {
        Tuple2[] correlations = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakels)).map((Function1 & Serializable & scala.Serializable)peakel -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)MODULE$.computeCorrelation(ref, (Peakel)peakel))), peakel), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])correlations)).maxBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double correlation = tuple2._1$mcD$sp();
        Peakel bestPeakel = (Peakel)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)correlation), (Object)bestPeakel);
        Tuple2 tuple23 = tuple22;
        double correlation2 = tuple23._1$mcD$sp();
        Peakel bestPeakel2 = (Peakel)tuple23._2();
        return correlation2 > this.MIN_CORRELATION_THRESHOLD() ? new Some((Object)bestPeakel2) : None$.MODULE$;
    }

    public double computeCorrelation(Peakel p1, Peakel p2) {
        Tuple2<double[], double[]> tuple2 = this.zipPeakelIntensities(p1, p2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double[] y1 = (double[])tuple2._1();
        double[] y2 = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)y1, (Object)y2);
        Tuple2 tuple23 = tuple22;
        double[] y12 = (double[])tuple23._1();
        double[] y22 = (double[])tuple23._2();
        return this.PEARSON().correlation(y12, y22);
    }

    private Tuple2<double[], double[]> zipPeakelIntensities(Peakel p1, Peakel p2) {
        float[] p1Intensities = p1.getIntensityValues();
        float[] p2Intensities = p2.getIntensityValues();
        ObjectRef indexes = ObjectRef.create((Object)((List)((SeqLike)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(p1.spectrumIds())).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(p2.spectrumIds())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toList().distinct()).sortWith((Function2)(JFunction2.mcZJJ.sp & Serializable & scala.Serializable)(a, b) -> a < b)));
        return new Tuple2((Object)PeakelDbHelper$._buildIntensityVector$1(p1, indexes), (Object)PeakelDbHelper$._buildIntensityVector$1(p2, indexes));
    }

    /*
     * WARNING - void declaration
     */
    private static final double[] _buildIntensityVector$1(Peakel p, ObjectRef indexes$1) {
        void var2_2;
        double[] y = (double[])Array$.MODULE$.fill(((List)indexes$1.elem).size(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        int index = 0;
        PeakelCursor peakelCursor = p.getNewCursor();
        while (peakelCursor.next()) {
            while (index < ((List)indexes$1.elem).length() && BoxesRunTime.unboxToLong((Object)((List)indexes$1.elem).apply(index)) < peakelCursor.getSpectrumId()) {
                ++index;
            }
            if (BoxesRunTime.unboxToLong((Object)((List)indexes$1.elem).apply(index)) != peakelCursor.getSpectrumId()) continue;
            y[index] = peakelCursor.getIntensity();
        }
        return var2_2;
    }

    private PeakelDbHelper$() {
        MODULE$ = this;
        this.SQLITE_RTREE_UB_CORR = 1.00000012;
        this.SQLITE_RTREE_LB_CORR = 0.99999988;
        this.MIN_CORRELATION_THRESHOLD = Settings$.MODULE$.isotopicPeakelsCorrelationThreshold();
        this.PEARSON = new PearsonsCorrelation();
    }
}

