/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.ui.event.ScanHeaderListener;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerModel;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanHeaderPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(ScanHeaderPanel.class);
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("0.00");
    private static final DecimalFormat MASS_FORMATTER = new DecimalFormat("0.####");
    private JLabel titleLabel;
    private JLabel precursorLabel;
    private JTextField retentionTimeTF;
    private JTextField msLevelTF;
    private JToggleButton keepSameMsLevelTB;
    private String mzdbFileName;
    private Spectrum scan;
    private EventListenerList listenerList = new EventListenerList();

    public ScanHeaderPanel(Spectrum scan, SpinnerModel model) {
        this.scan = scan;
        this.initComponents(model);
    }

    private void initComponents(SpinnerModel model) {
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(2, 0, 2, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPanelScanIndex(model), c);
        ++c.gridx;
        this.add((Component)this.getPanelRetentionTime(), c);
        ++c.gridx;
        ++c.gridx;
        this.add((Component)this.getPanelMsLevel(), c);
        ++c.gridx;
        this.precursorLabel = new JLabel("");
        this.add((Component)this.precursorLabel, c);
        ++c.gridx;
        c.insets = new Insets(2, 5, 2, 0);
        this.titleLabel = new JLabel(this.mzdbFileName);
        this.add((Component)this.titleLabel, c);
        this.updateScan();
    }

    private JPanel getPanelScanIndex(SpinnerModel model) {
        JPanel scanIndexPanel = new JPanel();
        scanIndexPanel.setLayout(new BoxLayout(scanIndexPanel, 2));
        JLabel scanIndexLabel = new JLabel("scan:");
        scanIndexPanel.add(scanIndexLabel);
        JSpinner scansSpinner = new JSpinner(model);
        ((JSpinner.DefaultEditor)scansSpinner.getEditor()).getTextField().setEditable(true);
        ((JSpinner.DefaultEditor)scansSpinner.getEditor()).getTextField().setColumns(6);
        scanIndexPanel.add(scansSpinner);
        return scanIndexPanel;
    }

    private JPanel getPanelRetentionTime() {
        JPanel retentionTimePanel = new JPanel();
        retentionTimePanel.setLayout(new BoxLayout(retentionTimePanel, 2));
        JLabel retentionTimeLabel = new JLabel("rt:");
        retentionTimePanel.add(retentionTimeLabel);
        this.retentionTimeTF = new JTextField();
        this.retentionTimeTF.setToolTipText("retention time in min");
        this.retentionTimeTF.setColumns(6);
        this.retentionTimeTF.addActionListener(evt -> this.retentionTimeActionPerformed(evt));
        retentionTimePanel.add(this.retentionTimeTF);
        return retentionTimePanel;
    }

    private JPanel getPanelMsLevel() {
        JPanel msLevelPanel = new JPanel();
        msLevelPanel.setLayout(new BoxLayout(msLevelPanel, 2));
        JLabel msLevelLabel = new JLabel("ms:");
        msLevelPanel.add(msLevelLabel);
        this.msLevelTF = new JTextField();
        this.msLevelTF.setEditable(false);
        this.msLevelTF.setColumns(3);
        this.msLevelTF.setToolTipText("msLevel");
        msLevelPanel.add(this.msLevelTF);
        msLevelPanel.add(this.getKeepSameMsLevelBtn());
        return msLevelPanel;
    }

    private JToggleButton getKeepSameMsLevelBtn() {
        this.keepSameMsLevelTB = new JToggleButton(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(24, 24);
            }
        };
        this.keepSameMsLevelTB.setBorderPainted(false);
        this.keepSameMsLevelTB.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SAME_MS_LEVEL));
        this.keepSameMsLevelTB.setSelected(true);
        this.keepSameMsLevelTB.setToolTipText("Stay on the same previous MS level while navigating. This can also be done by using the keyboard's arrows (or Ctrl+arrows to keep the same ms level)");
        this.keepSameMsLevelTB.addActionListener(e -> this.msLevelActionPerformed(e));
        return this.keepSameMsLevelTB;
    }

    private void updateScan() {
        if (this.scan == null) {
            this.clearValues();
        } else {
            if (this.scan.getPrecursorMz() == null) {
                this.precursorLabel.setText("");
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append(MASS_FORMATTER.format(this.scan.getPrecursorMz())).append(" (");
                builder.append(this.scan.getPrecursorCharge()).append("+)");
                this.precursorLabel.setText(builder.toString());
            }
            this.retentionTimeTF.setText(TIME_FORMATTER.format((double)this.scan.getRetentionTime() / 60.0));
            this.msLevelTF.setText(Integer.toString(this.scan.getMsLevel()));
            if (this.scan.getTitle() != null && !this.scan.getTitle().isEmpty()) {
                this.titleLabel.setText(this.scan.getTitle());
            }
        }
    }

    private void clearValues() {
        this.titleLabel.setText("");
        this.precursorLabel.setText("");
        this.retentionTimeTF.setText("");
        this.msLevelTF.setText("");
    }

    public void setScan(Spectrum scan) {
        this.scan = scan;
        this.updateScan();
    }

    public void setMzdbFileName(String fileName) {
        this.mzdbFileName = fileName;
        this.titleLabel.setText(fileName);
    }

    public void addScanHeaderListener(ScanHeaderListener listener) {
        this.listenerList.add(ScanHeaderListener.class, listener);
    }

    public void removeScanHeaderListener(ScanHeaderListener listener) {
        this.listenerList.remove(ScanHeaderListener.class, listener);
    }

    private void fireUpdateRetentionTime(float retentionTime) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ScanHeaderListener.class) continue;
            ((ScanHeaderListener)listeners[i + 1]).updateRetentionTime(retentionTime);
        }
    }

    private void fireKeepMsLevel(boolean keepMsLevel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ScanHeaderListener.class) continue;
            ((ScanHeaderListener)listeners[i + 1]).keepMsLevel(keepMsLevel);
        }
    }

    public void retentionTimeActionPerformed(ActionEvent evt) {
        float retentionTimeMin;
        if (this.scan == null) {
            return;
        }
        String value = this.retentionTimeTF.getText();
        if (value == null || value.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "The retention time could not be empty!");
            this.updateScan();
            return;
        }
        try {
            retentionTimeMin = Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "The format of the retention time is incorrect!");
            this.updateScan();
            return;
        }
        float retentionTime = (float)((double)retentionTimeMin * 60.0);
        this.fireUpdateRetentionTime(retentionTime);
    }

    public void msLevelActionPerformed(ActionEvent evt) {
        if (this.scan == null) {
            return;
        }
        this.fireKeepMsLevel(this.keepSameMsLevelTB.isSelected());
    }
}

