/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import umich.ms.util.Interval1D;

public class IntervalST<K extends Comparable<K>, V>
implements Iterable<Node<K, V>> {
    private final K MIN_OBJ = new Comparable<K>(){

        @Override
        public int compareTo(K o) {
            if (o == IntervalST.this.MIN_OBJ) {
                return 0;
            }
            return -1;
        }
    };
    private Node<K, V> root;

    public static void main(String[] args) {
        Interval1D<Integer> interval;
        int i;
        int N = args != null && args.length != 0 ? Integer.parseInt(args[0]) : 10;
        IntervalST<Integer, Double> st = new IntervalST<Integer, Double>();
        double intervalId = 0.0;
        st.put(new Interval1D<Integer>(1, 5), intervalId += 1.0);
        st.put(new Interval1D<Integer>(2, 5), intervalId += 1.0);
        st.put(new Interval1D<Integer>(3, 6), intervalId += 1.0);
        st.put(new Interval1D<Integer>(3, 6), intervalId += 1.0);
        st.put(new Interval1D<Integer>(7, 7), intervalId += 1.0);
        st.put(new Interval1D<Integer>(4, 10), intervalId += 1.0);
        st.put(new Interval1D<Integer>(15, 20), intervalId += 1.0);
        ArrayList<Integer> vals = new ArrayList<Integer>();
        vals.add(52);
        vals.add(54);
        vals.add(56);
        vals.add(58);
        st.put(new Interval1D<Integer>(4, 100), intervalId += 1.0);
        st.put(new Interval1D<Integer>(4, 101), intervalId += 1.0);
        st.put(new Interval1D<Integer>(4, 102), intervalId += 1.0);
        st.put(new Interval1D<Integer>(4, 103), intervalId += 1.0);
        st.put(new Interval1D<Integer>(0, 103), intervalId += 1.0);
        st.put(new Interval1D<Integer>(-10, 103), intervalId += 1.0);
        st.put(new Interval1D<Integer>(Integer.MIN_VALUE, -1000), intervalId += 1.0);
        st.put(new Interval1D<Integer>(Integer.MIN_VALUE, -1100), intervalId += 1.0);
        st.put(new Interval1D<Integer>(Integer.MIN_VALUE, -900), intervalId += 1.0);
        st.put(new Interval1D<Integer>(1000, Integer.MAX_VALUE), intervalId += 1.0);
        st.put(new Interval1D<Integer>(900, Integer.MAX_VALUE), intervalId += 1.0);
        st.put(new Interval1D<Integer>(1100, Integer.MAX_VALUE), intervalId += 1.0);
        st.put(new Interval1D<Integer>(Integer.MIN_VALUE, Integer.MAX_VALUE), intervalId += 1.0);
        Node removed = st.remove(new Interval1D<Integer>(-10, 103));
        System.err.flush();
        System.out.println("Tree stats:");
        System.out.println("\theight:          " + st.height());
        System.out.println("\tsize:            " + st.size());
        System.out.println("\tintegrity check: " + st.check());
        System.out.println();
        System.out.flush();
        ArrayList<Interval1D<Integer>> queries = new ArrayList<Interval1D<Integer>>();
        queries.add(new Interval1D<Integer>(-1, -1));
        queries.add(new Interval1D<Integer>(0, 0));
        queries.add(new Interval1D<Integer>(1, 1));
        queries.add(new Interval1D<Integer>(2, 2));
        queries.add(new Interval1D<Integer>(3, 3));
        queries.add(new Interval1D<Integer>(4, 4));
        queries.add(new Interval1D<Integer>(5, 5));
        queries.add(new Interval1D<Integer>(6, 6));
        queries.add(new Interval1D<Integer>(7, 7));
        queries.add(new Interval1D<Integer>(10, 10));
        queries.add(new Interval1D<Integer>(11, 11));
        queries.add(new Interval1D<Integer>(12, 16));
        queries.add(new Interval1D<Integer>(100, 100));
        queries.add(new Interval1D<Integer>(200, 400));
        queries.add(new Interval1D<Integer>(Integer.MIN_VALUE, Integer.MIN_VALUE));
        queries.add(new Interval1D<Integer>(Integer.MIN_VALUE, -10000));
        queries.add(new Interval1D<Integer>(Integer.MIN_VALUE, -1101));
        queries.add(new Interval1D<Integer>(Integer.MIN_VALUE, -1100));
        queries.add(new Interval1D<Integer>(Integer.MIN_VALUE, -999));
        queries.add(new Interval1D<Integer>(Integer.MIN_VALUE, -899));
        queries.add(new Interval1D<Integer>(-900, -899));
        queries.add(new Interval1D<Integer>(-899, -800));
        queries.add(new Interval1D<Integer>(Integer.MAX_VALUE, Integer.MAX_VALUE));
        queries.add(new Interval1D<Integer>(10000, Integer.MAX_VALUE));
        queries.add(new Interval1D<Integer>(1101, Integer.MAX_VALUE));
        queries.add(new Interval1D<Integer>(1100, Integer.MAX_VALUE));
        queries.add(new Interval1D<Integer>(1000, Integer.MAX_VALUE));
        queries.add(new Interval1D<Integer>(900, Integer.MAX_VALUE));
        queries.add(new Interval1D<Integer>(899, 900));
        queries.add(new Interval1D<Integer>(898, 899));
        for (Interval1D interval1D : queries) {
            System.out.println("Query: " + interval1D.toString());
            List nodes = st.searchAll(interval1D);
            if (!nodes.iterator().hasNext()) {
                System.out.print("No intersections");
            }
            for (Node node : nodes) {
                System.out.print("\t" + node.getInterval() + " :: " + node.getValue() + "\n");
            }
            System.out.println();
            System.out.println();
        }
        System.exit(1);
        st = new IntervalST();
        for (i = 0; i < N; ++i) {
            int n = (int)(Math.random() * 1000.0);
            int high = (int)(Math.random() * 50.0) + n;
            interval = new Interval1D<Integer>(n, high);
            System.out.println(interval);
            st.put(interval, Double.valueOf(i));
        }
        System.out.println("height:          " + st.height());
        System.out.println("size:            " + st.size());
        System.out.println("integrity check: " + st.check());
        System.out.println();
        for (i = 0; i < N; ++i) {
            int n = (int)(Math.random() * 100.0);
            int high = (int)(Math.random() * 10.0) + n;
            interval = new Interval1D<Integer>(n, high);
            System.out.println(interval + ":  " + st.search(interval));
            System.out.print(interval + ":  ");
            for (Node x : st.searchAll(interval)) {
                System.out.print(x + " ");
            }
            System.out.println();
            System.out.println();
        }
    }

    public void prettyPrint() {
        if (this.root == null) {
            System.out.println("Map is empty");
        }
        this.prettyPrint(this.root);
    }

    private void prettyPrint(Node<K, V> n) {
        if (((Node)n).left != null) {
            this.prettyPrint(((Node)n).left);
        }
        System.out.println(n);
        if (((Node)n).right != null) {
            this.prettyPrint(((Node)n).right);
        }
    }

    @Override
    public Iterator<Node<K, V>> iterator() {
        return new IntervalSTIterator();
    }

    public boolean contains(Interval1D<K> interval) {
        return this.get(interval) != null;
    }

    public Node<K, V> get(Interval1D<K> interval) {
        return this.get(this.root, interval);
    }

    private Node<K, V> get(Node<K, V> x, Interval1D<K> interval) {
        if (x == null) {
            return null;
        }
        int cmp = interval.compareTo(((Node)x).interval);
        if (cmp < 0) {
            return this.get(((Node)x).left, interval);
        }
        if (cmp > 0) {
            return this.get(((Node)x).right, interval);
        }
        return x;
    }

    public void put(Interval1D<K> interval, V value) {
        Node<K, V> origNode = this.get(interval);
        if (origNode != null) {
            origNode.setValue(value);
        } else {
            this.root = this.randomizedInsert(this.root, interval, value);
        }
    }

    private Node<K, V> randomizedInsert(Node<K, V> x, Interval1D<K> interval, V value) {
        if (x == null) {
            return new Node<K, V>(interval, value);
        }
        if (Math.random() * (double)this.size(x) < 1.0) {
            return this.rootInsert(x, interval, value);
        }
        int cmp = interval.compareTo(((Node)x).interval);
        if (cmp < 0) {
            ((Node)x).left = (Node)this.randomizedInsert(((Node)x).left, interval, value);
        } else {
            ((Node)x).right = (Node)this.randomizedInsert(((Node)x).right, interval, value);
        }
        this.fix(x);
        return x;
    }

    private Node<K, V> rootInsert(Node<K, V> x, Interval1D<K> interval, V value) {
        if (x == null) {
            return new Node<K, V>(interval, value);
        }
        int cmp = interval.compareTo(((Node)x).interval);
        if (cmp < 0) {
            ((Node)x).left = (Node)this.rootInsert(((Node)x).left, interval, value);
            x = this.rotR(x);
        } else {
            ((Node)x).right = (Node)this.rootInsert(((Node)x).right, interval, value);
            x = this.rotL(x);
        }
        return x;
    }

    private Node<K, V> joinLR(Node<K, V> a, Node<K, V> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (Math.random() * (double)(this.size(a) + this.size(b)) < (double)this.size(a)) {
            ((Node)a).right = (Node)this.joinLR(((Node)a).right, b);
            this.fix(a);
            return a;
        }
        ((Node)b).left = (Node)this.joinLR(a, ((Node)b).left);
        this.fix(b);
        return b;
    }

    public Node<K, V> remove(Interval1D<K> interval) {
        Node<K, V> node = this.get(interval);
        this.root = this.remove(this.root, interval);
        return node;
    }

    private Node<K, V> remove(Node<K, V> h, Interval1D<K> interval) {
        if (h == null) {
            return null;
        }
        int cmp = interval.compareTo(((Node)h).interval);
        if (cmp < 0) {
            ((Node)h).left = (Node)this.remove(((Node)h).left, interval);
        } else if (cmp > 0) {
            ((Node)h).right = (Node)this.remove(((Node)h).right, interval);
        } else {
            h = this.joinLR(((Node)h).left, ((Node)h).right);
        }
        this.fix(h);
        return h;
    }

    public Interval1D<K> search(Interval1D<K> interval) {
        return this.search(this.root, interval);
    }

    private Interval1D<K> search(Node<K, V> x, Interval1D<K> interval) {
        while (x != null) {
            if (interval.intersects(x.interval)) {
                return x.interval;
            }
            if (x.left == null) {
                x = x.right;
                continue;
            }
            if (x.left.max.compareTo(interval.lo) < 0) {
                x = x.right;
                continue;
            }
            x = x.left;
        }
        return null;
    }

    public List<Node<K, V>> searchAll(Interval1D<K> interval) {
        LinkedList<Node<K, V>> list = new LinkedList<Node<K, V>>();
        this.searchAll(this.root, interval, list);
        return list;
    }

    private boolean searchAll(Node<K, V> x, Interval1D<K> interval, List<Node<K, V>> toAppend) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        if (x == null) {
            return false;
        }
        if (interval.intersects(((Node)x).interval)) {
            toAppend.add(x);
            found1 = true;
        }
        if (((Node)x).left != null && ((Node)x).left.max.compareTo(interval.lo) >= 0) {
            found2 = this.searchAll(((Node)x).left, interval, toAppend);
        }
        if (found2 || ((Node)x).left == null || ((Node)x).left.max.compareTo(interval.lo) < 0) {
            found3 = this.searchAll(((Node)x).right, interval, toAppend);
        }
        return found1 || found2 || found3;
    }

    public int size() {
        return this.size(this.root);
    }

    private int size(Node<K, V> x) {
        if (x == null) {
            return 0;
        }
        return ((Node)x).N;
    }

    public int height() {
        return this.height(this.root);
    }

    private int height(Node<K, V> x) {
        if (x == null) {
            return 0;
        }
        return 1 + Math.max(this.height(((Node)x).left), this.height(((Node)x).right));
    }

    private void fix(Node<K, V> x) {
        if (x == null) {
            return;
        }
        ((Node)x).N = 1 + this.size(((Node)x).left) + this.size(((Node)x).right);
        ((Node)x).max = this.max3(((Node)x).interval.hi, this.max(((Node)x).left), this.max(((Node)x).right));
    }

    private K max(Node<K, V> x) {
        if (x == null) {
            return this.MIN_OBJ;
        }
        return (K)((Node)x).max;
    }

    private K max2(K a, K b) {
        int cmp = 0;
        try {
            cmp = !b.getClass().equals(a.getClass()) ? (a == this.MIN_OBJ ? -1 : 1) : a.compareTo(b);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        if (cmp <= 0) {
            return b;
        }
        return a;
    }

    private K max3(K a, K b, K c) {
        return this.max2(a, this.max2(b, c));
    }

    private Node<K, V> rotR(Node<K, V> h) {
        Node x = ((Node)h).left;
        ((Node)h).left = x.right;
        x.right = (Node)h;
        this.fix(h);
        this.fix(x);
        return x;
    }

    private Node<K, V> rotL(Node<K, V> h) {
        Node x = ((Node)h).right;
        ((Node)h).right = x.left;
        x.left = (Node)h;
        this.fix(h);
        this.fix(x);
        return x;
    }

    public boolean check() {
        return this.checkCount() && this.checkMax();
    }

    private boolean checkCount() {
        return this.checkCount(this.root);
    }

    private boolean checkCount(Node<K, V> x) {
        if (x == null) {
            return true;
        }
        return this.checkCount(((Node)x).left) && this.checkCount(((Node)x).right) && ((Node)x).N == 1 + this.size(((Node)x).left) + this.size(((Node)x).right);
    }

    private boolean checkMax() {
        return this.checkMax(this.root);
    }

    private boolean checkMax(Node<K, V> x) {
        if (x == null) {
            return true;
        }
        return ((Node)x).max == this.max3(((Node)x).interval.hi, this.max(((Node)x).left), this.max(((Node)x).right));
    }

    private class IntervalSTIterator
    implements Iterator<Node<K, V>> {
        private int cntNodesVisited = 0;
        private Node<K, V> lastVisitedNode = null;
        private LinkedList<Node<K, V>> parentStack = new LinkedList();
        private int size;

        public IntervalSTIterator() {
            this.size = IntervalST.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.cntNodesVisited < this.size;
        }

        @Override
        public Node<K, V> next() {
            if (IntervalST.this.root == null) {
                return null;
            }
            this.lastVisitedNode = this.cntNodesVisited == 0 ? this.findLeftMost(IntervalST.this.root) : this.findNext(this.lastVisitedNode);
            if (this.lastVisitedNode != null) {
                ++this.cntNodesVisited;
            }
            return this.lastVisitedNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removals from tree by iterator are not supported. Use IntervalST.remove(Interval1D<K>) for that.");
        }

        private Node<K, V> findLeftMost(Node<K, V> n) {
            while (n.left != null) {
                this.parentStack.push(n);
                n = n.left;
            }
            return n;
        }

        private Node<K, V> findNext(Node<K, V> n) {
            if (n == null) {
                return null;
            }
            if (n.right != null) {
                this.parentStack.push(n);
                return this.findLeftMost(n.right);
            }
            while (!this.parentStack.isEmpty()) {
                Node parent = this.parentStack.pop();
                if (n == parent.left) {
                    return parent;
                }
                n = parent;
            }
            return null;
        }
    }

    public static class Node<U extends Comparable<U>, W> {
        private final Interval1D<U> interval;
        private W value;
        private Node<U, W> left;
        private Node<U, W> right;
        private int N;
        private U max;

        Node(Interval1D<U> interval, W value) {
            this.interval = interval;
            this.value = value;
            this.N = 1;
            this.max = interval.hi;
        }

        public Interval1D<U> getInterval() {
            return this.interval;
        }

        public W getValue() {
            return this.value;
        }

        public void setValue(W value) {
            this.value = value;
        }

        public String toString() {
            String valStr = this.value.toString();
            if (valStr.length() > 64) {
                valStr = valStr.substring(0, 61) + "...";
            }
            return this.interval.toString() + " => " + valStr;
        }
    }
}

