/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class NumExpr
extends Expr {
    public double dval;

    public NumExpr(double d) {
        this.dval = d;
    }

    public String toString() {
        if (this.dval == (double)((long)this.dval)) {
            return "" + (long)this.dval;
        }
        return "" + this.dval;
    }

    public double eval() {
        return this.dval;
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return true;
    }

    public boolean evalBoolean(VTDNavHuge vn) {
        return this.dval != 0.0 && !Double.isNaN(this.dval);
    }

    public double evalNumber(VTDNavHuge vn) {
        return this.dval;
    }

    public int evalNodeSet(VTDNavHuge vn) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("NumExpr can't eval to a node set!");
    }

    public String evalString(VTDNavHuge vn) {
        if (this.dval == (double)((int)this.dval)) {
            return "" + (int)this.dval;
        }
        return "" + this.dval;
    }

    public void reset(VTDNavHuge vn) {
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean requireContextSize() {
        return false;
    }

    public void setContextSize(int size) {
    }

    public void setPosition(int pos) {
    }

    public int adjust(int n) {
        return 0;
    }
}

