/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class LiteralExpr
extends Expr {
    public String s;

    public LiteralExpr(String st) {
        this.s = st;
    }

    public final String toString() {
        boolean b = true;
        for (int i = 0; i < this.s.length(); ++i) {
            if (this.s.charAt(i) != '\'') continue;
            b = false;
            break;
        }
        if (b) {
            return "\"" + this.s + "\"";
        }
        return "'" + this.s + "'";
    }

    public final boolean evalBoolean(VTDNav vn) {
        return this.s.length() != 0;
    }

    public final double evalNumber(VTDNav vn) {
        try {
            double dval = Double.parseDouble(this.s);
            return dval;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public final int evalNodeSet(VTDNav vn) throws XPathEvalException {
        throw new XPathEvalException("LiteralExpr can't eval to a node set!");
    }

    public String evalString(VTDNav vn) {
        return this.s;
    }

    public final void reset(VTDNav vn) {
    }

    public final boolean isNodeSet() {
        return false;
    }

    public final boolean isNumerical() {
        return false;
    }

    public final boolean isString() {
        return true;
    }

    public final boolean isBoolean() {
        return false;
    }

    public final boolean requireContextSize() {
        return false;
    }

    public final void setContextSize(int size) {
    }

    public final void setPosition(int pos) {
    }

    public final int adjust(int n) {
        return 0;
    }

    public final boolean isFinal() {
        return true;
    }
}

