/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.BigAggregator;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.math.MathType;

public class ArrayR256
extends ReferenceTypeArray<BigDecimal> {
    public static final DenseArray.Factory<BigDecimal> FACTORY = new DenseArray.Factory<BigDecimal>(){

        @Override
        public AggregatorSet<BigDecimal> aggregator() {
            return BigAggregator.getSet();
        }

        @Override
        public FunctionSet<BigDecimal> function() {
            return BigFunction.getSet();
        }

        @Override
        public Scalar.Factory<BigDecimal> scalar() {
            return BigScalar.FACTORY;
        }

        @Override
        public MathType getMathType() {
            return MathType.R128;
        }

        @Override
        PlainArray<BigDecimal> makeDenseArray(long size) {
            return ArrayR256.make((int)size);
        }
    };

    public static ArrayR256 make(int size) {
        return new ArrayR256(size);
    }

    public static ArrayR256 wrap(BigDecimal ... data) {
        return new ArrayR256(data);
    }

    protected ArrayR256(BigDecimal[] data) {
        super(FACTORY, (Comparable[])data);
    }

    protected ArrayR256(int size) {
        super(FACTORY, size);
    }

    @Override
    public void axpy(double a, Mutate1D.Modifiable<?> y) {
        AXPY.invoke(y, a, (BigDecimal[])this.data);
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort((Comparable[])((BigDecimal[])this.data));
    }

    @Override
    public void sortDescending() {
        Arrays.parallelSort((BigDecimal[])this.data, Comparator.reverseOrder());
    }

    @Override
    protected void add(int index, Comparable<?> addend) {
        this.fillOne(index, ((BigDecimal)this.get(index)).add((BigDecimal)this.valueOf(addend)));
    }

    @Override
    protected void add(int index, double addend) {
        this.fillOne(index, ((BigDecimal)this.get(index)).add((BigDecimal)this.valueOf(addend)));
    }

    @Override
    protected byte byteValue(int index) {
        return ((BigDecimal)this.get(index)).byteValue();
    }

    @Override
    protected double doubleValue(int index) {
        return ((BigDecimal[])this.data)[index].doubleValue();
    }

    @Override
    protected void fillOne(int index, Access1D<?> values, long valueIndex) {
        ((BigDecimal[])this.data)[index] = (BigDecimal)this.valueOf((Comparable<?>)values.get(valueIndex));
    }

    @Override
    protected float floatValue(int index) {
        return ((BigDecimal[])this.data)[index].floatValue();
    }

    @Override
    protected int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke((BigDecimal[])this.data, first, limit, step);
    }

    @Override
    protected int intValue(int index) {
        return ((BigDecimal)this.get(index)).intValue();
    }

    @Override
    protected boolean isAbsolute(int index) {
        return BigScalar.isAbsolute(((BigDecimal[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return BigScalar.isSmall(comparedTo, ((BigDecimal[])this.data)[index]);
    }

    @Override
    protected long longValue(int index) {
        return ((BigDecimal)this.get(index)).longValue();
    }

    @Override
    protected short shortValue(int index) {
        return ((BigDecimal)this.get(index)).shortValue();
    }

    @Override
    protected void set(int index, long value) {
        ((BigDecimal[])this.data)[index] = new BigDecimal(value);
    }
}

