/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.machine.CommonMachine;
import org.ojalgo.machine.Hardware;
import org.ojalgo.netio.BasicLogger;

public final class VirtualMachine
extends CommonMachine {
    private static final String AMD64 = "amd64";
    private static final String I386 = "i386";
    private static final String X86 = "x86";
    private static final String X86_64 = "x86_64";
    private final Hardware myHardware;
    private final Runtime myRuntime;

    public static String getArchitecture() {
        String tmpProperty = System.getProperty("os.arch").toLowerCase();
        if (I386.equals(tmpProperty)) {
            return X86;
        }
        if (AMD64.equals(tmpProperty)) {
            return X86_64;
        }
        return tmpProperty;
    }

    public static long getMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static int getThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    VirtualMachine(Hardware hardware, Runtime runtime) {
        super(hardware, runtime);
        this.myHardware = hardware;
        this.myRuntime = runtime;
    }

    VirtualMachine(VirtualMachine base, int modUnits, int modCores, int modThreads) {
        super(base, modUnits, modCores, modThreads);
        this.myHardware = base.myHardware;
        this.myRuntime = base.myRuntime;
    }

    public void collectGarbage() {
        long tmpWasFree;
        this.myRuntime.runFinalization();
        long tmpIsFree = this.myRuntime.freeMemory();
        do {
            tmpWasFree = tmpIsFree;
            this.myRuntime.gc();
            try {
                Thread.sleep(8L);
            }
            catch (InterruptedException exception) {
                BasicLogger.error(exception.getMessage());
            }
        } while ((tmpIsFree = this.myRuntime.freeMemory()) > tmpWasFree);
        this.myRuntime.runFinalization();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine other = (VirtualMachine)obj;
        if (this.myHardware == null ? other.myHardware != null : !this.myHardware.equals(other.myHardware)) {
            return false;
        }
        return !(this.myRuntime == null ? other.myRuntime != null : !this.myRuntime.equals(other.myRuntime));
    }

    public int getAvailableDim1D(long elementSize) {
        return (int)CommonMachine.elements(this.getAvailableMemory(), elementSize);
    }

    public int getAvailableDim2D(long elementSize) {
        return (int)PrimitiveMath.SQRT.invoke(CommonMachine.elements(this.getAvailableMemory(), elementSize));
    }

    public long getAvailableMemory() {
        long tmpMax = this.myRuntime.maxMemory();
        long tmpTotal = this.myRuntime.totalMemory();
        long tmpFree = this.myRuntime.freeMemory();
        return tmpMax - tmpTotal + tmpFree;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myHardware == null ? 0 : this.myHardware.hashCode());
        return 31 * result + (this.myRuntime == null ? 0 : this.myRuntime.hashCode());
    }

    public VirtualMachine limitBy(double fraction) {
        double factor = Math.max(0.0, Math.min(Math.abs(fraction), 1.0));
        int newUnits = Math.max(1, MissingMath.roundToInt((double)this.units * factor));
        int newCores = Math.max(1, MissingMath.roundToInt((double)this.cores * factor));
        int newThreads = Math.max(1, MissingMath.roundToInt((double)this.threads * factor));
        return new VirtualMachine(this, newUnits, newCores, newThreads);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.myHardware.toString();
    }
}

