/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.Matrix2D;
import org.ojalgo.matrix.store.AboveBelowStore;
import org.ojalgo.matrix.store.AbstractStore;
import org.ojalgo.matrix.store.ColumnsStore;
import org.ojalgo.matrix.store.ComposingStore;
import org.ojalgo.matrix.store.ConjugatedStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.LeftRightStore;
import org.ojalgo.matrix.store.LimitStore;
import org.ojalgo.matrix.store.LowerHessenbergStore;
import org.ojalgo.matrix.store.LowerSymmetricStore;
import org.ojalgo.matrix.store.LowerTriangularStore;
import org.ojalgo.matrix.store.MatrixPipeline;
import org.ojalgo.matrix.store.OffsetStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.RepeatedColumnsStore;
import org.ojalgo.matrix.store.RepeatedRowsStore;
import org.ojalgo.matrix.store.RowsStore;
import org.ojalgo.matrix.store.SuperimposedStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.store.UnaryOperatoStore;
import org.ojalgo.matrix.store.UpperHessenbergStore;
import org.ojalgo.matrix.store.UpperSymmetricStore;
import org.ojalgo.matrix.store.UpperTriangularStore;
import org.ojalgo.matrix.store.ZeroStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public interface MatrixStore<N extends Comparable<N>>
extends Matrix2D<N, MatrixStore<N>>,
ElementsSupplier<N>,
Access2D.Visitable<N>,
Access2D.Sliceable<N>,
Structure2D.ReducibleTo1D<ElementsSupplier<N>>,
Structure2D.Logical<Access2D<N>, MatrixStore<N>> {
    @Override
    default public MatrixStore<N> above(Access2D<N> ... matrices) {
        MatrixStore<N> above = AbstractStore.buildRow(this.physical(), this.countColumns(), matrices);
        return new AboveBelowStore<N>(above, this);
    }

    @Override
    default public MatrixStore<N> above(Access2D<N> matrix) {
        MatrixStore<N> above = AbstractStore.buildRow(this.physical(), this.countColumns(), matrix);
        return new AboveBelowStore<N>(above, this);
    }

    @Override
    default public MatrixStore<N> above(long numberOfRows) {
        ZeroStore<N> above = new ZeroStore<N>(this.physical(), numberOfRows, this.countColumns());
        return new AboveBelowStore<N>(above, this);
    }

    @Override
    default public MatrixStore<N> add(double scalarAddend) {
        return this.add((Comparable)this.physical().scalar().cast(scalarAddend));
    }

    @Override
    default public MatrixStore<N> add(MatrixStore<N> addend) {
        return (MatrixStore)this.onMatching((BinaryFunction)this.physical().function().add(), (Access2D)addend).collect(this.physical());
    }

    @Override
    default public MatrixStore<N> add(N scalarAddend) {
        return this.onAll((UnaryFunction)this.physical().function().add().second(scalarAddend));
    }

    @Override
    default public N aggregateAll(Aggregator aggregator) {
        AggregatorFunction<N> tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitAll(tmpVisitor);
        return (N)((Comparable)tmpVisitor.get());
    }

    @Override
    default public N aggregateColumn(long row, long col, Aggregator aggregator) {
        AggregatorFunction<N> tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitColumn(row, col, tmpVisitor);
        return (N)((Comparable)tmpVisitor.get());
    }

    @Override
    default public N aggregateDiagonal(long row, long col, Aggregator aggregator) {
        AggregatorFunction<N> tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitDiagonal(row, col, tmpVisitor);
        return (N)((Comparable)tmpVisitor.get());
    }

    @Override
    default public N aggregateRange(long first, long limit, Aggregator aggregator) {
        AggregatorFunction<N> tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitRange(first, limit, tmpVisitor);
        return (N)((Comparable)tmpVisitor.get());
    }

    @Override
    default public N aggregateRow(long row, long col, Aggregator aggregator) {
        AggregatorFunction<N> tmpVisitor = this.physical().aggregator().get(aggregator);
        this.visitRow(row, col, tmpVisitor);
        return (N)((Comparable)tmpVisitor.get());
    }

    @Override
    default public MatrixStore<N> below(Access2D<N> ... matrices) {
        MatrixStore<N> below = AbstractStore.buildRow(this.physical(), this.countColumns(), matrices);
        return new AboveBelowStore<N>(this, below);
    }

    @Override
    default public MatrixStore<N> below(Access2D<N> matrix) {
        MatrixStore<N> below = AbstractStore.buildRow(this.physical(), this.countColumns(), matrix);
        return new AboveBelowStore<N>(this, below);
    }

    @Override
    default public MatrixStore<N> below(long numberOfRows) {
        ZeroStore<N> below = new ZeroStore<N>(this.physical(), numberOfRows, (long)((int)this.countColumns()));
        return new AboveBelowStore<N>(this, below);
    }

    @Override
    default public MatrixStore<N> bidiagonal(boolean upper) {
        if (upper) {
            return new UpperTriangularStore(new LowerHessenbergStore(this), false);
        }
        return new LowerTriangularStore(new UpperHessenbergStore(this), false);
    }

    @Override
    default public MatrixStore<N> column(int column) {
        return (MatrixStore)Structure2D.Logical.super.column(column);
    }

    @Override
    default public MatrixStore<N> column(long column) {
        return (MatrixStore)Structure2D.Logical.super.column(column);
    }

    @Override
    default public MatrixStore<N> columns(int ... columns) {
        return new ColumnsStore(this, columns);
    }

    @Override
    default public MatrixStore<N> columns(long ... columns) {
        return (MatrixStore)Structure2D.Logical.super.columns(columns);
    }

    @Override
    default public MatrixStore<N> conjugate() {
        return new ConjugatedStore(this);
    }

    default public PhysicalStore<N> copy() {
        PhysicalStore retVal = (PhysicalStore)this.physical().make(this);
        this.supplyTo(retVal);
        return retVal;
    }

    @Override
    default public MatrixStore<N> diagonal() {
        return new UpperTriangularStore(new LowerTriangularStore(this, false), false);
    }

    default public MatrixStore<N> diagonally(Access2D<N> ... diagonally) {
        AboveBelowStore<N> retVal = this;
        PhysicalStore.Factory<N, ?> tmpFactory = this.physical();
        for (int ij = 0; ij < diagonally.length; ++ij) {
            MatrixStore<N> tmpDiagonalStore = AbstractStore.cast(tmpFactory, diagonally[ij]);
            int tmpBaseRowDim = (int)this.countRows();
            int tmpBaseColDim = (int)this.countColumns();
            int tmpDiagRowDim = (int)tmpDiagonalStore.countRows();
            int tmpDiagColDim = (int)tmpDiagonalStore.countColumns();
            ZeroStore<N> tmpRightStore = new ZeroStore<N>(tmpFactory, tmpBaseRowDim, tmpDiagColDim);
            LeftRightStore<N> tmpAboveStore = new LeftRightStore<N>(this, tmpRightStore);
            ZeroStore<N> tmpLeftStore = new ZeroStore<N>(tmpFactory, tmpDiagRowDim, tmpBaseColDim);
            LeftRightStore<N> tmpBelowStore = new LeftRightStore<N>(tmpLeftStore, tmpDiagonalStore);
            retVal = new AboveBelowStore<N>(tmpAboveStore, tmpBelowStore);
        }
        return retVal;
    }

    @Override
    default public MatrixStore<N> divide(double scalarDivisor) {
        return this.divide((Comparable)this.physical().scalar().cast(scalarDivisor));
    }

    @Override
    default public MatrixStore<N> divide(N scalarDivisor) {
        return this.onAll((UnaryFunction)this.physical().function().divide().second(scalarDivisor));
    }

    @Override
    default public double doubleValue(long row, long col) {
        return NumberDefinition.doubleValue(this.get(row, col));
    }

    @Override
    default public boolean equals(MatrixStore<N> other, NumberContext context) {
        return Access2D.equals(this, other, context);
    }

    @Deprecated
    default public MatrixStore<N> get() {
        return this;
    }

    @Override
    default public MatrixStore<N> hermitian(boolean upper) {
        if (upper) {
            return new UpperSymmetricStore(this, true);
        }
        return new LowerSymmetricStore(this, true);
    }

    @Override
    default public MatrixStore<N> hessenberg(boolean upper) {
        if (upper) {
            return new UpperHessenbergStore(this);
        }
        return new LowerHessenbergStore(this);
    }

    @Override
    default public long indexOfLargest() {
        return AMAX.invoke(this, 0L, this.count(), 1L);
    }

    default public boolean isHermitian() {
        boolean retVal;
        int numberOfRows = Math.toIntExact(this.countRows());
        int numberOfColumns = Math.toIntExact(this.countColumns());
        Object element = this.get(0L);
        boolean bl = retVal = numberOfRows == numberOfColumns;
        if (element instanceof ComplexNumber) {
            for (int j = 0; retVal && j < numberOfColumns; ++j) {
                ComplexNumber upperRight;
                ComplexNumber lowerLeft;
                retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, ComplexNumber.valueOf(this.get((long)((long)j), (long)((long)j))).i);
                for (int i = j + 1; retVal && i < numberOfRows; retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, lowerLeft.subtract(upperRight).norm()), ++i) {
                    lowerLeft = ComplexNumber.valueOf(this.get(i, j)).conjugate();
                    upperRight = ComplexNumber.valueOf(this.get(j, i));
                }
            }
        } else {
            for (int j = 0; retVal && j < numberOfColumns; ++j) {
                for (int i = j + 1; retVal && i < numberOfRows; retVal &= PrimitiveScalar.isSmall(PrimitiveMath.ONE, this.doubleValue(i, j) - this.doubleValue(j, i)), ++i) {
                }
            }
        }
        return retVal;
    }

    default public boolean isNormal() {
        Object conjugate = this.conjugate();
        return conjugate.multiply((N)this).equals(this.multiply((N)conjugate));
    }

    @Override
    default public boolean isSmall(double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.norm());
    }

    default public boolean isSmall(long row, long col, double comparedTo) {
        return this.toScalar(row, col).isSmall(comparedTo);
    }

    @Override
    default public MatrixStore<N> left(Access2D<N> ... matrices) {
        MatrixStore<N> left = AbstractStore.buildColumn(this.physical(), this.countRows(), matrices);
        return new LeftRightStore<N>(left, this);
    }

    @Override
    default public MatrixStore<N> left(Access2D<N> matrix) {
        MatrixStore<N> left = AbstractStore.buildColumn(this.physical(), this.countRows(), matrix);
        return new LeftRightStore<N>(left, this);
    }

    @Override
    default public MatrixStore<N> left(long numberOfColumns) {
        ZeroStore<N> left = new ZeroStore<N>(this.physical(), this.countRows(), numberOfColumns);
        return new LeftRightStore<N>(left, this);
    }

    @Override
    default public MatrixStore<N> limits(long rowLimit, long columnLimit) {
        return new LimitStore(rowLimit < 0L ? (long)((int)this.countRows()) : rowLimit, columnLimit < 0L ? (long)((int)this.countColumns()) : columnLimit, this);
    }

    @Deprecated
    default public MatrixStore<N> logical() {
        return this;
    }

    default public void multiply(Access1D<N> right, TransformableRegion<N> target) {
        target.fillByMultiplying(this, right);
    }

    @Override
    default public MatrixStore<N> multiply(double scalarMultiplicand) {
        return this.multiply((Comparable)this.physical().scalar().cast(scalarMultiplicand));
    }

    @Override
    default public MatrixStore<N> multiply(MatrixStore<N> right) {
        long tmpCountRows = this.countRows();
        long tmpCountColumns = right.countColumns();
        PhysicalStore retVal = (PhysicalStore)this.physical().make(tmpCountRows, tmpCountColumns);
        this.multiply(right, retVal);
        return retVal;
    }

    @Override
    default public MatrixStore<N> multiply(N scalarMultiplicand) {
        return this.onAll((UnaryFunction)this.physical().function().multiply().second(scalarMultiplicand));
    }

    default public N multiplyBoth(Access1D<N> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)this.physical().make(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)this.physical().make(1L, 1L);
        PhysicalStore tmpLeft = (PhysicalStore)this.physical().rows(leftAndRight);
        tmpLeft.modifyAll(this.physical().function().conjugate());
        tmpStep1.fillByMultiplying(tmpLeft.conjugate(), this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return tmpStep2.get(0L);
    }

    @Override
    default public MatrixStore<N> negate() {
        return this.onAll((UnaryFunction)this.physical().function().negate());
    }

    @Override
    default public double norm() {
        double frobeniusNorm = NumberDefinition.doubleValue(this.aggregateAll(Aggregator.NORM2));
        if (this.isVector()) {
            return frobeniusNorm;
        }
        return frobeniusNorm / PrimitiveMath.SQRT.invoke((double)Math.min(this.countRows(), this.countColumns()));
    }

    @Override
    default public MatrixStore<N> offsets(long rowOffset, long columnOffset) {
        return new OffsetStore(this, rowOffset < 0L ? 0L : rowOffset, columnOffset < 0L ? 0L : columnOffset);
    }

    @Override
    default public MatrixStore<N> onAll(UnaryFunction<N> operator) {
        return new UnaryOperatoStore<N>(this, operator);
    }

    default public ElementsSupplier<N> operate() {
        return this;
    }

    public PhysicalStore.Factory<N, ?> physical();

    @Override
    default public MatrixStore<N> power(int power) {
        if (power < 0) {
            throw new ProgrammingError("Negative powers not supported!");
        }
        if (!this.isSquare()) {
            throw new ProgrammingError("Matrix must be square!");
        }
        PhysicalStore.Factory<N, ?> factory = this.physical();
        if (power == 0) {
            return factory.makeIdentity(this.countRows());
        }
        if (power == 1) {
            return this;
        }
        if (power == 2) {
            return this.multiply((N)this);
        }
        if (power % 2 == 0) {
            return this.power(2).power(power / 2);
        }
        if (power > 8) {
            return this.power(power - 1).multiply((N)this);
        }
        PhysicalStore right = (PhysicalStore)factory.make(this);
        PhysicalStore product = (PhysicalStore)factory.make(this);
        this.multiply(this, product);
        for (int i = 2; i < power; ++i) {
            PhysicalStore temp = right;
            right = product;
            product = temp;
            this.multiply(right, product);
        }
        return product;
    }

    default public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return new MatrixPipeline.Multiplication<N>(left, this);
    }

    @Override
    default public ElementsSupplier<N> reduceColumns(Aggregator aggregator) {
        return new MatrixPipeline.ColumnsReducer(this, aggregator);
    }

    @Override
    default public ElementsSupplier<N> reduceRows(Aggregator aggregator) {
        return new MatrixPipeline.RowsReducer(this, aggregator);
    }

    @Override
    default public MatrixStore<N> repeat(int rowsRepetitions, int columnsRepetitions) {
        ComposingStore retVal = this;
        if (rowsRepetitions > 1) {
            retVal = new RepeatedRowsStore(retVal, rowsRepetitions);
        }
        if (columnsRepetitions > 1) {
            retVal = new RepeatedColumnsStore(retVal, columnsRepetitions);
        }
        return retVal;
    }

    @Override
    default public MatrixStore<N> right(Access2D<N> ... matrices) {
        MatrixStore<N> right = AbstractStore.buildColumn(this.physical(), this.countRows(), matrices);
        return new LeftRightStore<N>(this, right);
    }

    @Override
    default public MatrixStore<N> right(Access2D<N> matrix) {
        MatrixStore<N> right = AbstractStore.buildColumn(this.physical(), this.countRows(), matrix);
        return new LeftRightStore<N>(this, right);
    }

    @Override
    default public MatrixStore<N> right(long numberOfColumns) {
        ZeroStore<N> right = new ZeroStore<N>(this.physical(), this.countRows(), numberOfColumns);
        return new LeftRightStore<N>(this, right);
    }

    @Override
    default public MatrixStore<N> row(int row) {
        return (MatrixStore)Structure2D.Logical.super.row(row);
    }

    @Override
    default public MatrixStore<N> row(long row) {
        return (MatrixStore)Structure2D.Logical.super.row(row);
    }

    @Override
    default public MatrixStore<N> rows(int ... rows) {
        return new RowsStore(this, rows);
    }

    @Override
    default public MatrixStore<N> rows(long ... rows) {
        return (MatrixStore)Structure2D.Logical.super.rows(rows);
    }

    @Override
    default public MatrixStore<N> select(int[] rows, int[] columns) {
        Access2D<N> retVal = this;
        if (rows != null && rows.length > 0) {
            retVal = retVal.rows(rows);
        }
        if (columns != null && columns.length > 0) {
            retVal = retVal.columns(columns);
        }
        return retVal;
    }

    @Override
    default public MatrixStore<N> select(long[] rows, long[] columns) {
        return this.select(Structure1D.toIntIndexes(rows), Structure1D.toIntIndexes(columns));
    }

    @Override
    default public MatrixStore<N> signum() {
        return this.multiply(PrimitiveMath.ONE / this.norm());
    }

    @Override
    default public Access1D<N> sliceColumn(final long row, final long col) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return MatrixStore.this.countRows() - row;
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(row + index, col);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(row + index, col);
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    @Override
    default public Access1D<N> sliceDiagonal(final long row, final long col) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return Math.min(MatrixStore.this.countRows() - row, MatrixStore.this.countColumns() - col);
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(row + index, col + index);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(row + index, col + index);
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    @Override
    default public Access1D<N> sliceRange(final long first, final long limit) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return limit - first;
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(first + index);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(first + index);
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    @Override
    default public Access1D<N> sliceRow(final long row, final long col) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return MatrixStore.this.countColumns() - col;
            }

            @Override
            public double doubleValue(long index) {
                return MatrixStore.this.doubleValue(row, col + index);
            }

            @Override
            public N get(long index) {
                return MatrixStore.this.get(row, col + index);
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    @Override
    default public MatrixStore<N> subtract(double scalarSubtrahend) {
        return this.subtract((Comparable)this.physical().scalar().cast(scalarSubtrahend));
    }

    @Override
    default public MatrixStore<N> subtract(MatrixStore<N> subtrahend) {
        return (MatrixStore)this.onMatching((BinaryFunction)this.physical().function().subtract(), (Access2D)subtrahend).collect(this.physical());
    }

    @Override
    default public MatrixStore<N> subtract(N scalarSubtrahend) {
        return this.onAll((UnaryFunction)this.physical().function().subtract().second(scalarSubtrahend));
    }

    @Override
    default public MatrixStore<N> superimpose(Access2D<N> matrix) {
        return new SuperimposedStore<N>(this, 0L, 0L, AbstractStore.cast(this.physical(), matrix));
    }

    @Override
    default public MatrixStore<N> superimpose(long row, long col, Access2D<N> matrix) {
        return new SuperimposedStore<N>(this, row, col, AbstractStore.cast(this.physical(), matrix));
    }

    @Override
    default public void supplyTo(TransformableRegion<N> receiver) {
        if (!receiver.isAcceptable(this)) {
            throw new ProgrammingError("Not acceptable!");
        }
        receiver.fillMatching(this);
    }

    @Override
    default public MatrixStore<N> symmetric(boolean upper) {
        if (upper) {
            return new UpperSymmetricStore(this, false);
        }
        return new LowerSymmetricStore(this, false);
    }

    default public Scalar<N> toScalar(long row, long column) {
        return this.physical().scalar().convert((Comparable<?>)this.get(row, column));
    }

    @Override
    default public MatrixStore<N> transpose() {
        return new TransposedStore(this);
    }

    @Override
    default public MatrixStore<N> triangular(boolean upper, boolean assumeOne) {
        if (upper) {
            return new UpperTriangularStore(this, assumeOne);
        }
        return new LowerTriangularStore(this, assumeOne);
    }

    @Override
    default public MatrixStore<N> tridiagonal() {
        return new UpperHessenbergStore(new LowerHessenbergStore(this));
    }

    @Override
    default public void visitOne(long row, long col, VoidFunction<N> visitor) {
        visitor.invoke(this.get(row, col));
    }
}

