/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.ArrayC128;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.array.operation.ApplyCholesky;
import org.ojalgo.array.operation.ApplyLDL;
import org.ojalgo.array.operation.ApplyLU;
import org.ojalgo.array.operation.FillMatchingDual;
import org.ojalgo.array.operation.FillMatchingSingle;
import org.ojalgo.array.operation.GenerateApplyAndCopyHouseholderColumn;
import org.ojalgo.array.operation.GenerateApplyAndCopyHouseholderRow;
import org.ojalgo.array.operation.HouseholderHermitian;
import org.ojalgo.array.operation.ModifyAll;
import org.ojalgo.array.operation.OperationBinary;
import org.ojalgo.array.operation.OperationUnary;
import org.ojalgo.array.operation.RotateLeft;
import org.ojalgo.array.operation.RotateRight;
import org.ojalgo.array.operation.SubstituteBackwards;
import org.ojalgo.array.operation.SubstituteForwards;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.machine.JavaType;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.EvD1D;
import org.ojalgo.matrix.operation.HouseholderLeft;
import org.ojalgo.matrix.operation.HouseholderRight;
import org.ojalgo.matrix.operation.MultiplyBoth;
import org.ojalgo.matrix.operation.MultiplyLeft;
import org.ojalgo.matrix.operation.MultiplyNeither;
import org.ojalgo.matrix.operation.MultiplyRight;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveFactory;
import org.ojalgo.matrix.store.Subregion2D;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.matrix.store.TransjugatedStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.math.MathType;

public final class Primitive64Store
extends ArrayR064
implements PhysicalStore<Double>,
DecompositionStore<Double> {
    public static final PhysicalStore.Factory<Double, Primitive64Store> FACTORY = new PrimitiveFactory<Primitive64Store>(){

        @Override
        public Primitive64Store columns(Access1D<?> ... source) {
            int tmpRowDim = (int)source[0].count();
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn.doubleValue(i);
                }
            }
            return new Primitive64Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive64Store columns(Comparable<?>[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Comparable<?>[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = NumberDefinition.doubleValue(tmpColumn[i]);
                }
            }
            return new Primitive64Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive64Store columns(double[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = tmpColumn[i];
                }
            }
            return new Primitive64Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive64Store columns(List<? extends Comparable<?>> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                List<Comparable<?>> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = NumberDefinition.doubleValue(tmpColumn.get(i));
                }
            }
            return new Primitive64Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive64Store copy(final Access2D<?> source) {
            final int tmpRowDim = (int)source.countRows();
            int tmpColDim = (int)source.countColumns();
            final Primitive64Store retVal = new Primitive64Store(tmpRowDim, tmpColDim);
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.copy(retVal.data, tmpRowDim, aFirst, aLimit, source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.copy(retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }

        @Override
        public Primitive64Store make(long rows, long columns) {
            return new Primitive64Store((int)rows, (int)columns);
        }

        @Override
        public Primitive64Store rows(Access1D<?> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = (int)source[0].count();
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Access1D<?> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow.doubleValue(j);
                }
            }
            return new Primitive64Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive64Store rows(Comparable<?>[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Comparable<?>[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = NumberDefinition.doubleValue(tmpRow[j]);
                }
            }
            return new Primitive64Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive64Store rows(double[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = tmpRow[j];
                }
            }
            return new Primitive64Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive64Store rows(List<? extends Comparable<?>> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].size();
            double[] tmpData = new double[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                List<Comparable<?>> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = NumberDefinition.doubleValue(tmpRow.get(j));
                }
            }
            return new Primitive64Store(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Primitive64Store transpose(final Access2D<?> source) {
            final Primitive64Store retVal = new Primitive64Store((int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillMatchingSingle.transpose(retVal.data, tmpRowDim, first, limit, source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.transpose(retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }

        @Override
        public MathType getMathType() {
            return MathType.R064;
        }
    };
    static final long ELEMENT_SIZE = JavaType.DOUBLE.memory();
    static final long SHALLOW_SIZE = MemoryEstimator.estimateObject(Primitive64Store.class);
    private final MultiplyBoth.Primitive multiplyBoth;
    private final MultiplyLeft.Primitive64 multiplyLeft;
    private final MultiplyNeither.Primitive64 multiplyNeither;
    private final MultiplyRight.Primitive64 multiplyRight;
    private final int myColDim;
    private final int myRowDim;
    private final Array2D<Double> myUtility;
    private transient double[] myWorkerColumn;

    public static Primitive64Store getComplexArgument(Access2D<ComplexNumber> arg) {
        long numberOfRows = arg.countRows();
        long numberOfColumns = arg.countColumns();
        Primitive64Store retVal = (Primitive64Store)FACTORY.make(numberOfRows, numberOfColumns);
        Mutate1D.copyComplexArgument(arg, retVal);
        return retVal;
    }

    public static Primitive64Store getComplexImaginary(Access2D<ComplexNumber> arg) {
        long numberOfRows = arg.countRows();
        long numberOfColumns = arg.countColumns();
        Primitive64Store retVal = (Primitive64Store)FACTORY.make(numberOfRows, numberOfColumns);
        Mutate1D.copyComplexImaginary(arg, retVal);
        return retVal;
    }

    public static Primitive64Store getComplexModulus(Access2D<ComplexNumber> arg) {
        long numberOfRows = arg.countRows();
        long numberOfColumns = arg.countColumns();
        Primitive64Store retVal = (Primitive64Store)FACTORY.make(numberOfRows, numberOfColumns);
        Mutate1D.copyComplexModulus(arg, retVal);
        return retVal;
    }

    public static Primitive64Store getComplexReal(Access2D<ComplexNumber> arg) {
        long numberOfRows = arg.countRows();
        long numberOfColumns = arg.countColumns();
        Primitive64Store retVal = (Primitive64Store)FACTORY.make(numberOfRows, numberOfColumns);
        Mutate1D.copyComplexReal(arg, retVal);
        return retVal;
    }

    public static Primitive64Store wrap(double ... data) {
        return new Primitive64Store(data);
    }

    public static Primitive64Store wrap(double[] data, int structure) {
        return new Primitive64Store(structure, data.length / structure, data);
    }

    static Primitive64Store cast(Access1D<Double> matrix) {
        if (matrix instanceof Primitive64Store) {
            return (Primitive64Store)matrix;
        }
        if (matrix instanceof Access2D) {
            return (Primitive64Store)FACTORY.copy((Access2D)matrix);
        }
        return (Primitive64Store)FACTORY.columns(matrix);
    }

    static Householder.Primitive64 cast(Householder<Double> transformation) {
        if (transformation instanceof Householder.Primitive64) {
            return (Householder.Primitive64)transformation;
        }
        if (transformation instanceof HouseholderReference) {
            return ((Householder.Primitive64)((HouseholderReference)transformation).getWorker(FACTORY)).copy(transformation);
        }
        return new Householder.Primitive64(transformation);
    }

    static Rotation.Primitive cast(Rotation<Double> transformation) {
        if (transformation instanceof Rotation.Primitive) {
            return (Rotation.Primitive)transformation;
        }
        return new Rotation.Primitive(transformation);
    }

    private Primitive64Store(double[] dataArray) {
        this(dataArray.length, 1, dataArray);
    }

    private Primitive64Store(int numbRows) {
        this(numbRows, 1L);
    }

    Primitive64Store(int numbRows, int numbCols, double[] dataArray) {
        super(dataArray);
        this.myRowDim = numbRows;
        this.myColDim = numbCols;
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.newPrimitive64(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.newPrimitive64(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.newPrimitive64(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.newPrimitive64(this.myRowDim, this.myColDim);
    }

    Primitive64Store(long numbRows, long numbCols) {
        super(Math.toIntExact(numbRows * numbCols));
        this.myRowDim = Math.toIntExact(numbRows);
        this.myColDim = Math.toIntExact(numbCols);
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.newPrimitive64(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.newPrimitive64(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.newPrimitive64(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.newPrimitive64(this.myRowDim, this.myColDim);
    }

    @Override
    public void accept(Access2D<?> supplied) {
        for (long j = 0L; j < supplied.countColumns(); ++j) {
            for (long i = 0L; i < supplied.countRows(); ++i) {
                this.set(i, j, supplied.doubleValue(i, j));
            }
        }
    }

    @Override
    public void add(long row, long col, Comparable<?> addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public void add(long row, long col, double addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public void applyCholesky(int iterationPoint, BasicArray<Double> multipliers) {
        final double[] tmpData = this.data;
        final double[] tmpColumn = ((ArrayR064)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyCholesky.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyCholesky.invoke(tmpData, Primitive64Store.this.myRowDim, first, limit, tmpColumn);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyCholesky.THRESHOLD);
        } else {
            ApplyCholesky.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn);
        }
    }

    @Override
    public void applyLDL(final int iterationPoint, BasicArray<Double> multipliers) {
        final double[] column = ((ArrayR064)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLDL.THRESHOLD) {
            DivideAndConquer conquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLDL.invoke(Primitive64Store.this.data, Primitive64Store.this.myRowDim, first, limit, column, iterationPoint);
                }
            };
            conquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLDL.THRESHOLD);
        } else {
            ApplyLDL.invoke(this.data, this.myRowDim, iterationPoint + 1, this.myColDim, column, iterationPoint);
        }
    }

    @Override
    public void applyLU(final int iterationPoint, BasicArray<Double> multipliers) {
        final double[] column = ((ArrayR064)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLU.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLU.invoke(Primitive64Store.this.data, Primitive64Store.this.myRowDim, first, limit, column, iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLU.THRESHOLD);
        } else {
            ApplyLU.invoke(this.data, this.myRowDim, iterationPoint + 1, this.myColDim, column, iterationPoint);
        }
    }

    @Override
    public Array1D<Double> asList() {
        return this.myUtility.flatten();
    }

    public void caxpy(double aSclrA, int aColX, int aColY, int aFirstRow) {
        AXPY.invoke(this.data, aColY * this.myRowDim + aFirstRow, aSclrA, this.data, aColX * this.myRowDim + aFirstRow, 0, this.myRowDim - aFirstRow);
    }

    @Override
    public Array1D<ComplexNumber> computeInPlaceSchur(PhysicalStore<Double> transformationCollector, boolean eigenvalue) {
        double[] tmpData = this.data;
        double[] tmpCollectorData = ((Primitive64Store)transformationCollector).data;
        double[] tmpVctrWork = new double[this.getMinDim()];
        EvD1D.orthes(tmpData, tmpCollectorData, tmpVctrWork);
        double[][] tmpDiags = EvD1D.hqr2(tmpData, tmpCollectorData, eigenvalue);
        double[] aRawReal = tmpDiags[0];
        double[] aRawImag = tmpDiags[1];
        int tmpLength = Math.min(aRawReal.length, aRawImag.length);
        ArrayC128 retVal = ArrayC128.make(tmpLength);
        ComplexNumber[] tmpRaw = (ComplexNumber[])retVal.data;
        for (int i = 0; i < tmpLength; ++i) {
            tmpRaw[i] = ComplexNumber.of(aRawReal[i], aRawImag[i]);
        }
        return Array1D.C128.wrap(retVal);
    }

    @Override
    public MatrixStore<Double> conjugate() {
        return this.transpose();
    }

    public Primitive64Store copy() {
        return new Primitive64Store(this.myRowDim, this.myColDim, this.copyOfData());
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public void divideAndCopyColumn(int row, int column, BasicArray<Double> destination) {
        double[] destinationData = ((ArrayR064)destination).data;
        int index = row + column * this.myRowDim;
        double denominator = this.data[index];
        for (int i = row + 1; i < this.myRowDim; ++i) {
            int n = ++index;
            double d = this.data[n] / denominator;
            this.data[n] = d;
            destinationData[i] = d;
        }
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myUtility.doubleValue(row, col);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof Primitive64Store)) {
            return false;
        }
        Primitive64Store other = (Primitive64Store)obj;
        return this.myColDim == other.myColDim && this.myRowDim == other.myRowDim;
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myUtility.exchangeColumns(colA, colB);
    }

    @Override
    public void exchangeHermitian(int indexA, int indexB) {
        double tmpVal;
        int indexMin = Math.min(indexA, indexB);
        int indexMax = Math.max(indexA, indexB);
        for (int j = 0; j < indexMin; ++j) {
            tmpVal = this.doubleValue(indexMin, j);
            this.set((long)indexMin, (long)j, this.doubleValue(indexMax, j));
            this.set((long)indexMax, (long)j, tmpVal);
        }
        tmpVal = this.doubleValue(indexMin, indexMin);
        this.set((long)indexMin, (long)indexMin, this.doubleValue(indexMax, indexMax));
        this.set((long)indexMax, (long)indexMax, tmpVal);
        for (int ij = indexMin + 1; ij < indexMax; ++ij) {
            tmpVal = this.doubleValue(ij, indexMin);
            this.set((long)ij, (long)indexMin, this.doubleValue(indexMax, ij));
            this.set((long)indexMax, (long)ij, tmpVal);
        }
        for (int i = indexMax + 1; i < this.myRowDim; ++i) {
            tmpVal = this.doubleValue(i, indexMin);
            this.set((long)i, (long)indexMin, this.doubleValue(i, indexMax));
            this.set((long)i, (long)indexMax, tmpVal);
        }
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myUtility.exchangeRows(rowA, rowB);
    }

    @Override
    public void fillByMultiplying(Access1D<Double> left, Access1D<Double> right) {
        int complexity = Math.toIntExact(left.count() / this.countRows());
        if (complexity != Math.toIntExact(right.count() / this.countColumns())) {
            ProgrammingError.throwForMultiplicationNotPossible();
        }
        if (left instanceof Primitive64Store) {
            if (right instanceof Primitive64Store) {
                this.multiplyNeither.invoke(this.data, Primitive64Store.cast(left).data, complexity, Primitive64Store.cast(right).data);
            } else {
                this.multiplyRight.invoke(this.data, Primitive64Store.cast(left).data, complexity, right);
            }
        } else if (right instanceof Primitive64Store) {
            this.multiplyLeft.invoke(this.data, left, complexity, Primitive64Store.cast(right).data);
        } else {
            this.multiplyBoth.invoke(this, left, complexity, right);
        }
    }

    @Override
    public void fillColumn(long row, long col, Access1D<Double> values) {
        this.myUtility.fillColumn(row, col, (Double)((Object)values));
    }

    @Override
    public void fillColumn(long row, long col, Double value) {
        this.myUtility.fillColumn(row, col, value);
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillColumn(row, col, supplier);
    }

    @Override
    public void fillDiagonal(long row, long col, Double value) {
        this.myUtility.fillDiagonal(row, col, value);
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillDiagonal(row, col, supplier);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        if (values instanceof TransjugatedStore) {
            final TransjugatedStore transposed = (TransjugatedStore)values;
            if (this.myColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillMatchingSingle.transpose(Primitive64Store.this.data, Primitive64Store.this.myRowDim, first, limit, transposed.getOriginal());
                    }
                };
                tmpConquerer.invoke(0, this.myColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.transpose(this.data, this.myRowDim, 0, this.myColDim, transposed.getOriginal());
            }
        } else {
            super.fillMatching(values);
        }
    }

    @Override
    public void fillMatching(final Access1D<Double> left, final BinaryFunction<Double> function, final Access1D<Double> right) {
        int matchingCount = MissingMath.toMinIntExact(this.count(), left.count(), right.count());
        if (this.myColDim > FillMatchingDual.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    OperationBinary.invoke(Primitive64Store.this.data, first, limit, 1, (Access1D<Double>)left, (BinaryFunction<Double>)function, (Access1D<Double>)right);
                }
            };
            tmpConquerer.invoke(0, matchingCount, FillMatchingDual.THRESHOLD * FillMatchingDual.THRESHOLD);
        } else {
            OperationBinary.invoke(this.data, 0, matchingCount, 1, left, function, right);
        }
    }

    @Override
    public void fillMatching(final UnaryFunction<Double> function, final Access1D<Double> arguments) {
        int matchingCount = MissingMath.toMinIntExact(this.count(), arguments.count());
        if (this.myColDim > FillMatchingSingle.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    OperationUnary.invoke(Primitive64Store.this.data, first, limit, 1, (Access1D<Double>)arguments, (UnaryFunction<Double>)function);
                }
            };
            tmpConquerer.invoke(0, matchingCount, FillMatchingSingle.THRESHOLD * FillMatchingSingle.THRESHOLD);
        } else {
            OperationUnary.invoke(this.data, 0, matchingCount, 1, arguments, function);
        }
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.set(row, col, values.doubleValue(valueIndex));
    }

    @Override
    public void fillOne(long row, long col, Double value) {
        this.myUtility.fillOne(row, col, value);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillOne(row, col, supplier);
    }

    @Override
    public void fillRow(long row, long col, Access1D<Double> values) {
        this.myUtility.fillRow(row, col, (Double)((Object)values));
    }

    @Override
    public void fillRow(long row, long col, Double value) {
        this.myUtility.fillRow(row, col, value);
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillRow(row, col, supplier);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderColumn(int row, int column, Householder<Double> destination) {
        return GenerateApplyAndCopyHouseholderColumn.invoke(this.data, this.myRowDim, row, column, (Householder.Primitive64)destination);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderRow(int row, int column, Householder<Double> destination) {
        return GenerateApplyAndCopyHouseholderRow.invoke(this.data, this.myRowDim, row, column, (Householder.Primitive64)destination);
    }

    @Override
    public MatrixStore<Double> get() {
        return this;
    }

    @Override
    public Double get(long row, long col) {
        return this.myUtility.get(row, col);
    }

    @Override
    public int getColDim() {
        return this.myColDim;
    }

    @Override
    public int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    @Override
    public int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    @Override
    public int getRowDim() {
        return this.myRowDim;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.myColDim;
        return 31 * result + this.myRowDim;
    }

    @Override
    public void modifyAll(final UnaryFunction<Double> modifier) {
        if (this.myColDim > ModifyAll.THRESHOLD) {
            DivideAndConquer conquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    Primitive64Store.this.modify(Primitive64Store.this.myRowDim * first, Primitive64Store.this.myRowDim * limit, 1, modifier);
                }
            };
            conquerer.invoke(0, this.myColDim, ModifyAll.THRESHOLD);
        } else {
            this.modify(0, this.myRowDim * this.myColDim, 1, modifier);
        }
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyColumn(row, col, modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyDiagonal(row, col, modifier);
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<Double> modifier) {
        double tmpValue = this.doubleValue(row, col);
        tmpValue = modifier.invoke(tmpValue);
        this.set(row, col, tmpValue);
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<Double> modifier) {
        this.myUtility.modifyRow(row, col, modifier);
    }

    @Override
    public MatrixStore<Double> multiply(MatrixStore<Double> right) {
        Primitive64Store retVal = (Primitive64Store)FACTORY.make((long)this.myRowDim, right.countColumns());
        if (right instanceof Primitive64Store) {
            retVal.multiplyNeither.invoke(retVal.data, this.data, this.myColDim, Primitive64Store.cast(right).data);
        } else {
            retVal.multiplyRight.invoke(retVal.data, this.data, this.myColDim, right);
        }
        return retVal;
    }

    @Override
    public Double multiplyBoth(Access1D<Double> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)FACTORY.make(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)FACTORY.make(1L, 1L);
        tmpStep1.fillByMultiplying(leftAndRight, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return (Double)tmpStep2.get(0L);
    }

    @Override
    public void negateColumn(int column) {
        this.myUtility.modifyColumn(0L, column, PrimitiveMath.NEGATE);
    }

    @Override
    public PhysicalStore.Factory<Double, Primitive64Store> physical() {
        return FACTORY;
    }

    @Override
    public TransformableRegion<Double> regionByColumns(int ... columns) {
        return new Subregion2D.ColumnsRegion<Double>(this, this.multiplyBoth, columns);
    }

    @Override
    public TransformableRegion<Double> regionByLimits(int rowLimit, int columnLimit) {
        return new Subregion2D.LimitRegion<Double>(this, this.multiplyBoth, rowLimit, columnLimit);
    }

    @Override
    public TransformableRegion<Double> regionByOffsets(int rowOffset, int columnOffset) {
        return new Subregion2D.OffsetRegion<Double>(this, this.multiplyBoth, rowOffset, columnOffset);
    }

    @Override
    public TransformableRegion<Double> regionByRows(int ... rows) {
        return new Subregion2D.RowsRegion<Double>(this, this.multiplyBoth, rows);
    }

    @Override
    public TransformableRegion<Double> regionByTransposing() {
        return new Subregion2D.TransposedRegion<Double>(this, this.multiplyBoth);
    }

    @Override
    public void rotateRight(int low, int high, double cos, double sin) {
        RotateRight.invoke(this.data, this.myRowDim, low, high, cos, sin);
    }

    @Override
    public void set(long row, long col, Comparable<?> value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public void setToIdentity(int col) {
        this.myUtility.set((long)col, (long)col, PrimitiveMath.ONE);
        this.myUtility.fillColumn((long)(col + 1), (long)col, PrimitiveMath.ZERO);
    }

    @Override
    public Array1D<Double> sliceColumn(long row, long col) {
        return this.myUtility.sliceColumn(row, col);
    }

    @Override
    public Array1D<Double> sliceDiagonal(long row, long col) {
        return this.myUtility.sliceDiagonal(row, col);
    }

    @Override
    public Array1D<Double> sliceRange(long first, long limit) {
        return this.myUtility.sliceRange(first, limit);
    }

    @Override
    public Array1D<Double> sliceRow(long row, long col) {
        return this.myUtility.sliceRow(row, col);
    }

    @Override
    public void substituteBackwards(final Access2D<Double> body, final boolean unitDiagonal, final boolean conjugated, final boolean hermitian) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteBackwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    SubstituteBackwards.invoke(Primitive64Store.this.data, tmpRowDim, first, limit, body, unitDiagonal, conjugated, hermitian);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteBackwards.THRESHOLD);
        } else {
            SubstituteBackwards.invoke(this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, hermitian);
        }
    }

    @Override
    public void substituteForwards(final Access2D<Double> body, final boolean unitDiagonal, final boolean conjugated, final boolean identity) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteForwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int first, int limit) {
                    SubstituteForwards.invoke(Primitive64Store.this.data, tmpRowDim, first, limit, body, unitDiagonal, conjugated, identity);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteForwards.THRESHOLD);
        } else {
            SubstituteForwards.invoke(this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, identity);
        }
    }

    public PrimitiveScalar toScalar(long row, long column) {
        return PrimitiveScalar.of(this.doubleValue(row, column));
    }

    @Override
    public String toString() {
        return Access2D.toString(this);
    }

    @Override
    public void transformLeft(Householder<Double> transformation, int firstColumn) {
        HouseholderLeft.call(this.data, this.myRowDim, firstColumn, Primitive64Store.cast(transformation));
    }

    @Override
    public void transformLeft(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = Primitive64Store.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                RotateLeft.invoke(this.data, this.myRowDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveMath.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveMath.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyRow(tmpLow, 0L, PrimitiveMath.NEGATE);
        }
    }

    @Override
    public void transformRight(Householder<Double> transformation, int firstRow) {
        HouseholderRight.call(this.data, this.myRowDim, firstRow, Primitive64Store.cast(transformation), this.getWorkerColumn());
    }

    @Override
    public void transformRight(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = Primitive64Store.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                RotateRight.invoke(this.data, this.myRowDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveMath.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveMath.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyColumn(0L, tmpHigh, PrimitiveMath.NEGATE);
        }
    }

    @Override
    public void transformSymmetric(Householder<Double> transformation) {
        HouseholderHermitian.invoke(this.data, Primitive64Store.cast(transformation), this.getWorkerColumn());
    }

    @Override
    public void tred2(BasicArray<Double> mainDiagonal, BasicArray<Double> offDiagonal, boolean yesvecs) {
        HouseholderHermitian.tred2j(this.data, ((ArrayR064)mainDiagonal).data, ((ArrayR064)offDiagonal).data, yesvecs);
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitColumn(row, col, visitor);
    }

    @Override
    public void visitDiagonal(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitDiagonal(row, col, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<Double> visitor) {
        this.myUtility.visitRow(row, col, visitor);
    }

    private double[] getWorkerColumn() {
        if (this.myWorkerColumn != null) {
            Arrays.fill(this.myWorkerColumn, PrimitiveMath.ZERO);
        } else {
            this.myWorkerColumn = new double[this.myRowDim];
        }
        return this.myWorkerColumn;
    }
}

