/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.SparseArray;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.multiary.LinearFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.GenericSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.OptimisationData;
import org.ojalgo.optimisation.UpdatableSolver;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.linear.DualSimplex;
import org.ojalgo.optimisation.linear.LinearStructure;
import org.ojalgo.optimisation.linear.PhasedSimplexSolver;
import org.ojalgo.optimisation.linear.PrimalSimplex;
import org.ojalgo.optimisation.linear.Primitive1D;
import org.ojalgo.optimisation.linear.Primitive2D;
import org.ojalgo.optimisation.linear.RevisedStore;
import org.ojalgo.optimisation.linear.SimplexSolver;
import org.ojalgo.optimisation.linear.SimplexStore;
import org.ojalgo.optimisation.linear.SimplexTableau;
import org.ojalgo.optimisation.linear.TableauStore;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.IndexSelector;

public abstract class LinearSolver
extends GenericSolver
implements UpdatableSolver {
    public static final ExpressionsBasedModel.Integration<LinearSolver> INTEGRATION = new ModelIntegration();
    public static final ExpressionsBasedModel.Integration<LinearSolver> NEW_INTEGRATION = new NewIntegration();

    public static GeneralBuilder newGeneralBuilder() {
        return new GeneralBuilder();
    }

    public static GeneralBuilder newGeneralBuilder(double ... objective) {
        return (GeneralBuilder)LinearSolver.newGeneralBuilder().objective(objective);
    }

    public static LinearSolver newSolver(ExpressionsBasedModel model) {
        SimplexTableau tableau = PrimalSimplex.build(model);
        return new PrimalSimplex(tableau, model.options);
    }

    public static StandardBuilder newStandardBuilder() {
        return new StandardBuilder();
    }

    public static StandardBuilder newStandardBuilder(double ... objective) {
        return (StandardBuilder)LinearSolver.newStandardBuilder().objective(objective);
    }

    public static Optimisation.Result solve(OptimisationData convex, Optimisation.Options options, boolean zeroC) {
        int primSize;
        int dualSize = DualSimplex.size(convex);
        boolean dual = dualSize <= (primSize = PrimalSimplex.size(convex));
        return dual ? DualSimplex.doSolve(convex, options, zeroC) : PrimalSimplex.doSolve(convex, options, zeroC);
    }

    static LinearFunction<Double> toObjectiveFunction(MatrixStore<Double> mtrxC) {
        ProgrammingError.throwIfNull(mtrxC);
        PhysicalStore<Double> tmpC = null;
        tmpC = mtrxC instanceof PhysicalStore ? (PhysicalStore<Double>)mtrxC : mtrxC.copy();
        return LinearFunction.wrap(tmpC);
    }

    protected LinearSolver(Optimisation.Options solverOptions) {
        super(solverOptions);
    }

    static final class NewIntegration
    extends ExpressionsBasedModel.Integration<LinearSolver> {
        NewIntegration() {
        }

        @Override
        public SimplexSolver build(ExpressionsBasedModel model) {
            PhasedSimplexSolver solver = SimplexStore.build(model, structure -> {
                if (Boolean.TRUE.equals(model.options.sparse)) {
                    return new RevisedStore((LinearStructure)structure);
                }
                if (Boolean.FALSE.equals(model.options.sparse)) {
                    return new TableauStore((LinearStructure)structure);
                }
                return SimplexStore.newInstance(structure);
            }).newPhasedSimplexSolver(model.options, new int[0]);
            if (model.options.validate) {
                solver.setValidator(solvState -> {
                    Optimisation.Result modState = this.toModelState(solvState, model);
                    if (!model.validate(modState)) {
                        BasicLogger.error();
                        BasicLogger.error("Validation with Model Failed!");
                        BasicLogger.error();
                    }
                });
            }
            return solver;
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return !model.isAnyVariableInteger() && !model.isAnyExpressionQuadratic();
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            List<Variable> freeVariables = model.getFreeVariables();
            Set<Structure1D.IntIndex> fixedVariables = model.getFixedVariables();
            int nbFreeVars = freeVariables.size();
            int nbModelVars = model.countVariables();
            ArrayR064 modelSolution = ArrayR064.make(nbModelVars);
            for (int i = 0; i < nbFreeVars; ++i) {
                modelSolution.set((long)model.indexOf(freeVariables.get(i)), solverState.doubleValue(i));
            }
            for (Structure1D.IntIndex fixed : fixedVariables) {
                modelSolution.set((long)fixed.index, model.getVariable(fixed.index).getValue());
            }
            return new Optimisation.Result(solverState.getState(), modelSolution);
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            List<Variable> freeVariables = model.getFreeVariables();
            int nbFreeVars = freeVariables.size();
            ArrayR064 solverSolution = ArrayR064.make(nbFreeVars);
            for (int i = 0; i < nbFreeVars; ++i) {
                Variable variable = freeVariables.get(i);
                int modelIndex = model.indexOf(variable);
                solverSolution.set((long)i, modelState.doubleValue(modelIndex));
            }
            return new Optimisation.Result(modelState.getState(), solverSolution);
        }
    }

    static final class ModelIntegration
    extends ExpressionsBasedModel.Integration<LinearSolver> {
        ModelIntegration() {
        }

        private static ArrayR064 toModelVariableValues(Access1D<?> solverVariableValues, ExpressionsBasedModel model, ArrayR064 modelVariableValues) {
            List<Variable> positiveVariables = model.getPositiveVariables();
            for (int p = 0; p < positiveVariables.size(); ++p) {
                Variable variable = positiveVariables.get(p);
                int index = model.indexOf(variable);
                modelVariableValues.set((long)index, solverVariableValues.doubleValue(p));
            }
            List<Variable> negativeVariables = model.getNegativeVariables();
            for (int n = 0; n < negativeVariables.size(); ++n) {
                Variable variable = negativeVariables.get(n);
                int index = model.indexOf(variable);
                modelVariableValues.add((long)index, -solverVariableValues.doubleValue(positiveVariables.size() + n));
            }
            return modelVariableValues;
        }

        @Override
        public LinearSolver build(ExpressionsBasedModel model) {
            SimplexTableau tableau = PrimalSimplex.build(model);
            return new PrimalSimplex(tableau, model.options);
        }

        public LinearSolver build(OptimisationData convexBuilder, Optimisation.Options options) {
            SimplexTableau tableau = PrimalSimplex.build(convexBuilder, options, false);
            return new PrimalSimplex(tableau, options);
        }

        @Override
        public boolean isCapable(ExpressionsBasedModel model) {
            return !model.isAnyVariableInteger() && !model.isAnyExpressionQuadratic();
        }

        @Override
        public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
            ArrayR064 modelSolution = ArrayR064.make(model.countVariables());
            for (Structure1D.IntIndex fixed : model.getFixedVariables()) {
                modelSolution.set((long)fixed.index, model.getVariable(fixed.index).getValue().doubleValue());
            }
            ModelIntegration.toModelVariableValues(solverState, model, modelSolution);
            return new Optimisation.Result(solverState.getState(), solverState.getValue(), modelSolution);
        }

        @Override
        public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
            int tmpIndex;
            Variable tmpVariable;
            List<Variable> tmpPositives = model.getPositiveVariables();
            List<Variable> tmpNegatives = model.getNegativeVariables();
            int tmpCountPositives = tmpPositives.size();
            int tmpCountNegatives = tmpNegatives.size();
            ArrayR064 tmpSolverSolution = ArrayR064.make(tmpCountPositives + tmpCountNegatives);
            for (int p = 0; p < tmpCountPositives; ++p) {
                tmpVariable = tmpPositives.get(p);
                tmpIndex = model.indexOf(tmpVariable);
                tmpSolverSolution.set((long)p, PrimitiveMath.MAX.invoke(modelState.doubleValue(tmpIndex), PrimitiveMath.ZERO));
            }
            for (int n = 0; n < tmpCountNegatives; ++n) {
                tmpVariable = tmpNegatives.get(n);
                tmpIndex = model.indexOf(tmpVariable);
                tmpSolverSolution.set((long)(tmpCountPositives + n), PrimitiveMath.MAX.invoke(-modelState.doubleValue(tmpIndex), PrimitiveMath.ZERO));
            }
            return new Optimisation.Result(modelState.getState(), modelState.getValue(), tmpSolverSolution);
        }

        @Override
        protected int getIndexInSolver(ExpressionsBasedModel model, Variable variable) {
            int retVal = -1;
            BigDecimal value = variable.getValue();
            if ((value != null && value.signum() >= 0 || variable.isPositive()) && (retVal = model.indexOfPositiveVariable(variable)) >= 0) {
                return retVal;
            }
            if ((value != null && value.signum() <= 0 || variable.isNegative()) && (retVal = model.indexOfNegativeVariable(variable)) >= 0) {
                return retVal += model.getPositiveVariables().size();
            }
            return -1;
        }
    }

    static abstract class Builder<B extends Builder<B>>
    extends GenericSolver.Builder<B, LinearSolver> {
        Builder() {
        }

        @Override
        public B equalities(Access2D<?> mtrxAE, Access1D<?> mtrxBE) {
            return (B)((Builder)super.equalities(mtrxAE, mtrxBE));
        }

        @Override
        public B equality(double rhs, double ... factors) {
            return (B)((Builder)super.equality(rhs, factors));
        }

        public final LinearFunction<Double> getObjective() {
            LinearFunction<Double> retVal = this.getObjective(LinearFunction.class);
            if (retVal == null) {
                retVal = LinearFunction.factory(this.getFactory()).make(this.countVariables());
                super.setObjective(retVal);
            }
            return retVal;
        }

        public final B lower(double ... bounds) {
            double[] lowerBounds = this.getLowerBounds((double)PrimitiveMath.ZERO).data;
            int limit = Math.min(lowerBounds.length, bounds.length);
            for (int i = 0; i < limit; ++i) {
                lowerBounds[i] = bounds[i];
            }
            return (B)this;
        }

        public final B lower(double bound) {
            double[] lowerBounds = this.getLowerBounds((double)PrimitiveMath.ZERO).data;
            Arrays.fill(lowerBounds, bound);
            return (B)this;
        }

        public final B objective(double ... factors) {
            this.setNumberOfVariables(factors.length);
            ((LinearFunction)this.getObjective()).linear().fillMatching((Access1D)this.getFactory().column(factors));
            return (B)this;
        }

        public final B objective(int index, double value) {
            ((LinearFunction)this.getObjective()).linear().set((long)index, value);
            return (B)this;
        }

        public final B objective(MatrixStore<Double> mtrxC) {
            this.setObjective(LinearSolver.toObjectiveFunction(mtrxC));
            return (B)this;
        }

        public final B upper(double ... bounds) {
            double[] upperBounds = this.getUpperBounds((double)Double.POSITIVE_INFINITY).data;
            int limit = Math.min(upperBounds.length, bounds.length);
            for (int i = 0; i < limit; ++i) {
                upperBounds[i] = bounds[i];
            }
            return (B)this;
        }

        public final B upper(double bound) {
            double[] upperBounds = this.getUpperBounds((double)Double.POSITIVE_INFINITY).data;
            Arrays.fill(upperBounds, bound);
            return (B)this;
        }

        @Override
        protected LinearSolver doBuild(Optimisation.Options options) {
            int i;
            int nbInequalites = this.countInequalityConstraints();
            int nbEqualites = this.countEqualityConstraints();
            int nbVariables = this.countVariables();
            IndexSelector ineqSign = new IndexSelector(nbInequalites);
            if (nbInequalites > 0) {
                MatrixStore<Double> mtrxBI = this.getBI();
                for (int i2 = 0; i2 < nbInequalites; ++i2) {
                    double valRHS = mtrxBI.doubleValue(i2);
                    if (valRHS < PrimitiveMath.ZERO) {
                        ineqSign.exclude(i2);
                        continue;
                    }
                    ineqSign.include(i2);
                }
            }
            int nbIdentitySlackVariables = ineqSign.countIncluded();
            int nbSlackVariables = ineqSign.countExcluded();
            int nbProblemVariables = nbVariables;
            int nbConstraints = nbEqualites + nbInequalites;
            boolean needDual = true;
            SimplexTableau tableau = SimplexTableau.make(nbConstraints, nbProblemVariables, 0, nbSlackVariables, nbIdentitySlackVariables, needDual, options);
            Primitive2D constraintsBody = tableau.constraintsBody();
            Primitive1D constraintsRHS = tableau.constraintsRHS();
            Primitive1D objective = tableau.objective();
            if (nbInequalites > 0) {
                int insIdSlack = 0;
                int insGnSlack = 0;
                for (i = 0; i < nbInequalites; ++i) {
                    SparseArray<Double> body = this.getAI(i);
                    double valRHS = this.getBI(i);
                    boolean positive = ineqSign.isIncluded(i);
                    int row = positive ? insIdSlack : nbIdentitySlackVariables + insGnSlack;
                    int col = positive ? nbProblemVariables + nbSlackVariables + insIdSlack++ : nbProblemVariables + insGnSlack++;
                    for (SparseArray.NonzeroView nz : body.nonzeros()) {
                        constraintsBody.set((long)row, nz.index(), positive ? nz.doubleValue() : -nz.doubleValue());
                    }
                    constraintsBody.set(row, col, positive ? PrimitiveMath.ONE : PrimitiveMath.NEG);
                    constraintsRHS.set(row, positive ? valRHS : -valRHS);
                }
            }
            if (nbEqualites > 0) {
                MatrixStore<Double> mtrxAE = this.getAE();
                MatrixStore<Double> mtrxBE = this.getBE();
                for (i = 0; i < nbEqualites; ++i) {
                    double valRHS = mtrxBE.doubleValue(i);
                    boolean positive = valRHS >= PrimitiveMath.ZERO;
                    int row = nbInequalites + i;
                    for (int j = 0; j < nbVariables; ++j) {
                        double value = mtrxAE.doubleValue(i, j);
                        if (!(Math.abs(value) > PrimitiveMath.MACHINE_EPSILON)) continue;
                        constraintsBody.set(row, j, positive ? value : -value);
                    }
                    constraintsRHS.set(row, positive ? valRHS : -valRHS);
                }
            }
            MatrixStore<Double> mtrxC = this.getC();
            for (int i3 = 0; i3 < nbVariables; ++i3) {
                objective.set(i3, mtrxC.doubleValue(i3));
            }
            return new PrimalSimplex(tableau, options);
        }

        protected final double[] getLowerBounds() {
            return super.getLowerBounds((double)PrimitiveMath.ZERO).data;
        }

        protected final double[] getUpperBounds() {
            return super.getUpperBounds((double)Double.POSITIVE_INFINITY).data;
        }

        <S extends SimplexStore> S newSimplexStore(Function<LinearStructure, S> storeFactory, int ... basis) {
            int j;
            double factor;
            int j2;
            int i;
            MatrixStore builderC = ((LinearFunction)this.getObjective()).getLinearFactors(false);
            MatrixStore<Double> builderAE = this.getAE();
            MatrixStore<Double> builderBE = this.getBE();
            MatrixStore<Double> builderAI = this.getAI();
            MatrixStore<Double> builderBI = this.getBI();
            double[] builderLB = this.getLowerBounds();
            double[] builderUB = this.getUpperBounds();
            int nbUpConstr = builderAI.getRowDim();
            int nbLoConstr = 0;
            int nbEqConstr = builderAE.getRowDim();
            int nbProbVars = builderC.size();
            int nbSlckVars = nbUpConstr + nbLoConstr;
            int nbArtiVars = basis.length == nbUpConstr + nbLoConstr + nbEqConstr ? 0 : nbEqConstr;
            LinearStructure structure = new LinearStructure(nbUpConstr, nbLoConstr, nbEqConstr, nbProbVars, 0, nbSlckVars, nbArtiVars);
            SimplexStore simplex = (SimplexStore)storeFactory.apply(structure);
            double[] lowerBounds = simplex.getLowerBounds();
            double[] upperBounds = simplex.getUpperBounds();
            Mutate2D mtrxA = simplex.constraintsBody();
            Mutate1D mtrxB = simplex.constraintsRHS();
            Mutate1D mtrxC = simplex.objective();
            for (i = 0; i < nbUpConstr; ++i) {
                for (j2 = 0; j2 < nbProbVars; ++j2) {
                    factor = builderAI.doubleValue(i, j2);
                    mtrxA.set((long)i, (long)j2, factor);
                }
                mtrxA.set((long)i, (long)(nbProbVars + i), PrimitiveMath.ONE);
                mtrxB.set((long)i, builderBI.doubleValue(i));
                lowerBounds[nbProbVars + i] = PrimitiveMath.ZERO;
                upperBounds[nbProbVars + i] = Double.POSITIVE_INFINITY;
            }
            for (i = 0; i < nbEqConstr; ++i) {
                for (j2 = 0; j2 < nbProbVars; ++j2) {
                    factor = builderAE.doubleValue(i, j2);
                    mtrxA.set((long)(nbUpConstr + nbLoConstr + i), (long)j2, factor);
                }
                mtrxB.set((long)(nbUpConstr + nbLoConstr + i), builderBE.doubleValue(i));
            }
            for (j = 0; j < nbProbVars; ++j) {
                lowerBounds[j] = builderLB[j];
                upperBounds[j] = builderUB[j];
                double weight = builderC.doubleValue(j);
                mtrxC.set((long)j, weight);
            }
            for (j = 0; j < nbArtiVars; ++j) {
                mtrxA.set((long)(nbUpConstr + nbLoConstr + j), (long)(nbProbVars + nbSlckVars + j), PrimitiveMath.ONE);
                lowerBounds[nbProbVars + nbSlckVars + j] = PrimitiveMath.ZERO;
                upperBounds[nbProbVars + nbSlckVars + j] = PrimitiveMath.ZERO;
            }
            return (S)simplex;
        }

        <T extends SimplexTableau> T newSimplexTableau(SimplexTableau.SimplexTableauFactory<T> tableauFactory) {
            int i;
            int nbInequalites = this.countInequalityConstraints();
            int nbEqualites = this.countEqualityConstraints();
            int nbVariables = this.countVariables();
            IndexSelector ineqSign = new IndexSelector(nbInequalites);
            if (nbInequalites > 0) {
                MatrixStore<Double> mtrxBI = this.getBI();
                for (int i2 = 0; i2 < nbInequalites; ++i2) {
                    double valRHS = mtrxBI.doubleValue(i2);
                    if (valRHS < PrimitiveMath.ZERO) {
                        ineqSign.exclude(i2);
                        continue;
                    }
                    ineqSign.include(i2);
                }
            }
            int nbIdentitySlackVariables = ineqSign.countIncluded();
            int nbSlackVariables = ineqSign.countExcluded();
            int nbProblemVariables = nbVariables;
            int nbConstraints = nbEqualites + nbInequalites;
            boolean needDual = true;
            T tableau = tableauFactory.make(nbConstraints, nbProblemVariables, 0, nbSlackVariables, nbIdentitySlackVariables, needDual);
            Primitive2D constraintsBody = ((SimplexTableau)tableau).constraintsBody();
            Primitive1D constraintsRHS = ((SimplexTableau)tableau).constraintsRHS();
            Primitive1D objective = ((SimplexTableau)tableau).objective();
            if (nbInequalites > 0) {
                int insIdSlack = 0;
                int insGnSlack = 0;
                for (i = 0; i < nbInequalites; ++i) {
                    SparseArray<Double> body = this.getAI(i);
                    double valRHS = this.getBI(i);
                    boolean positive = ineqSign.isIncluded(i);
                    int row = positive ? insIdSlack : nbIdentitySlackVariables + insGnSlack;
                    int col = positive ? nbProblemVariables + nbSlackVariables + insIdSlack++ : nbProblemVariables + insGnSlack++;
                    for (SparseArray.NonzeroView nz : body.nonzeros()) {
                        constraintsBody.set((long)row, nz.index(), positive ? nz.doubleValue() : -nz.doubleValue());
                    }
                    constraintsBody.set(row, col, positive ? PrimitiveMath.ONE : PrimitiveMath.NEG);
                    constraintsRHS.set(row, positive ? valRHS : -valRHS);
                }
            }
            if (nbEqualites > 0) {
                MatrixStore<Double> mtrxAE = this.getAE();
                MatrixStore<Double> mtrxBE = this.getBE();
                for (i = 0; i < nbEqualites; ++i) {
                    double valRHS = mtrxBE.doubleValue(i);
                    boolean positive = valRHS >= PrimitiveMath.ZERO;
                    int row = nbInequalites + i;
                    for (int j = 0; j < nbVariables; ++j) {
                        double value = mtrxAE.doubleValue(i, j);
                        if (!(Math.abs(value) > PrimitiveMath.MACHINE_EPSILON)) continue;
                        constraintsBody.set(row, j, positive ? value : -value);
                    }
                    constraintsRHS.set(row, positive ? valRHS : -valRHS);
                }
            }
            MatrixStore<Double> mtrxC = this.getC();
            for (int i3 = 0; i3 < nbVariables; ++i3) {
                objective.set(i3, mtrxC.doubleValue(i3));
            }
            return tableau;
        }
    }

    public static final class StandardBuilder
    extends Builder<StandardBuilder> {
        @Deprecated
        public StandardBuilder() {
        }

        @Deprecated
        public StandardBuilder(MatrixStore<Double> mtrxC) {
            this.objective(mtrxC);
        }
    }

    public static final class GeneralBuilder
    extends Builder<GeneralBuilder> {
        GeneralBuilder() {
        }

        @Override
        public GeneralBuilder inequalities(Access2D<?> mtrxAI, Access1D<?> mtrxBI) {
            return (GeneralBuilder)super.inequalities(mtrxAI, mtrxBI);
        }

        @Override
        public GeneralBuilder inequality(double rhs, double ... factors) {
            return (GeneralBuilder)super.inequality(rhs, factors);
        }

        public StandardBuilder toStandardForm() {
            int nbInequalites = this.countInequalityConstraints();
            int nbEqualites = this.countEqualityConstraints();
            int nbVariables = this.countVariables();
            StandardBuilder retVal = LinearSolver.newStandardBuilder();
            PhysicalStore mtrxC = null;
            PhysicalStore mtrxAE = null;
            PhysicalStore mtrxBE = null;
            if (nbEqualites > 0) {
                if (nbInequalites > 0) {
                    mtrxC = (PhysicalStore)this.getC().below(nbInequalites).collect(this.getFactory());
                    mtrxAE = (PhysicalStore)this.getAE().below((Access2D<Double>)this.getAI()).right(nbInequalites).collect(this.getFactory());
                    mtrxAE.fillDiagonal((long)nbEqualites, (long)nbVariables, PrimitiveMath.ONE);
                    mtrxBE = (PhysicalStore)this.getBE().below((Access2D<Double>)this.getBI()).collect(this.getFactory());
                } else {
                    mtrxC = (PhysicalStore)this.getC().collect(this.getFactory());
                    mtrxAE = (PhysicalStore)this.getAE().collect(this.getFactory());
                    mtrxBE = (PhysicalStore)this.getBE().collect(this.getFactory());
                }
            } else if (nbInequalites > 0) {
                mtrxC = (PhysicalStore)this.getC().below(nbInequalites).collect(this.getFactory());
                mtrxAE = (PhysicalStore)this.getAI().right(nbInequalites).collect(this.getFactory());
                mtrxAE.fillDiagonal((long)nbEqualites, (long)nbVariables, PrimitiveMath.ONE);
                mtrxBE = (PhysicalStore)this.getBI().collect(this.getFactory());
            } else {
                throw new IllegalStateException("The problem is unconstrained!");
            }
            for (int i = 0; i < mtrxBE.getRowDim(); ++i) {
                double rhs = mtrxBE.doubleValue(i, 0L);
                if (!(rhs < PrimitiveMath.ZERO)) continue;
                mtrxAE.modifyRow(i, PrimitiveMath.NEGATE);
                mtrxBE.set((long)i, 0L, -rhs);
            }
            retVal.objective(mtrxC);
            retVal.equalities((Access2D)mtrxAE, (Access1D)mtrxBE);
            return retVal;
        }
    }

    public static final class Configuration {
    }
}

