/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.scedasticity;

import java.util.Arrays;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.SampleSet;
import org.ojalgo.random.scedasticity.AbstractScedasticity;
import org.ojalgo.structure.Access1D;

public final class ARCH
extends AbstractScedasticity {
    private double myBase = PrimitiveMath.ZERO;
    private double myMean = PrimitiveMath.ZERO;
    private final double[] mySquaredErrors;
    private final double[] myWeights;

    public static ARCH estimate(Access1D<?> series, int q) {
        SampleSet ss = SampleSet.wrap(series);
        double mean = ss.getMean();
        double variance = ss.getVariance();
        ARCH model = ARCH.newInstance(q);
        Access1D<?> parameters = AbstractScedasticity.parameters(series, mean, q);
        double base = variance / PrimitiveMath.TWELVE;
        double[] errorWeights = new double[q];
        for (int i = 0; i < q; ++i) {
            double weight = ELEVEN_TWELFTHS * parameters.doubleValue(i);
            if (weight < PrimitiveMath.ZERO) {
                base += weight * variance;
                continue;
            }
            errorWeights[i] = weight;
        }
        model.base(base);
        model.errorWeights(errorWeights);
        model.initialise(mean, variance);
        return model;
    }

    public static ARCH newInstance(int q) {
        return ARCH.newInstance(q, PrimitiveMath.ZERO, DEFAULT_VARIANCE);
    }

    public static ARCH newInstance(int q, double mean, double variance) {
        ARCH retVal = new ARCH(q);
        retVal.base(variance / PrimitiveMath.TWELVE);
        double[] errorWeights = new double[q];
        AbstractScedasticity.average(errorWeights, ELEVEN_TWELFTHS);
        retVal.errorWeights(errorWeights);
        retVal.initialise(mean, variance);
        return retVal;
    }

    public ARCH(int q) {
        this.mySquaredErrors = new double[q];
        this.myWeights = new double[q];
    }

    public ARCH base(double base) {
        if (base <= PrimitiveMath.ZERO) {
            throw new IllegalArgumentException();
        }
        this.myBase = base;
        return this;
    }

    public ARCH errorWeights(double ... lagged) {
        Arrays.fill(this.myWeights, PrimitiveMath.ZERO);
        int limit = Math.min(this.myWeights.length, lagged.length);
        for (int i = 0; i < limit; ++i) {
            double tmpVal = lagged[i];
            if (tmpVal < PrimitiveMath.ZERO) {
                throw new IllegalArgumentException();
            }
            this.myWeights[i] = tmpVal;
        }
        return this;
    }

    @Override
    public double getMean() {
        return this.myMean;
    }

    @Override
    public double getVariance() {
        double retVal = this.myBase;
        int limit = Math.min(this.myWeights.length, this.mySquaredErrors.length);
        for (int i = 0; i < limit; ++i) {
            retVal += this.myWeights[i] * this.mySquaredErrors[i];
        }
        return retVal;
    }

    @Override
    public void initialise(double mean, double variance) {
        this.myMean = mean;
        Arrays.fill(this.mySquaredErrors, variance);
    }

    @Override
    public void update(double value) {
        double error = value - this.myMean;
        double squared = error * error;
        for (int i = this.mySquaredErrors.length - 1; i > 0; --i) {
            this.mySquaredErrors[i] = this.mySquaredErrors[i - 1];
        }
        this.mySquaredErrors[0] = squared;
    }
}

