/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.function;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.ojalgo.type.function.AutoFunctional;
import org.ojalgo.type.function.ManagedConsumer;
import org.ojalgo.type.function.MappedConsumer;
import org.ojalgo.type.function.QueuedConsumer;
import org.ojalgo.type.function.ShardedConsumer;
import org.ojalgo.type.management.MBeanUtils;
import org.ojalgo.type.management.Throughput;

@FunctionalInterface
public interface AutoConsumer<T>
extends AutoCloseable,
Consumer<T>,
AutoFunctional {
    public static final AutoConsumer<?> NULL = item -> {
        throw new IllegalStateException("NULL!");
    };

    public static <T> AutoConsumer<T> managed(String name, Consumer<T> consumer) {
        Throughput manager = new Throughput();
        MBeanUtils.register(manager, name);
        return new ManagedConsumer<T>(manager, consumer);
    }

    public static <T> AutoConsumer<T> managed(Throughput manager, Consumer<T> consumer) {
        return new ManagedConsumer<T>(manager, consumer);
    }

    public static <S, T> AutoConsumer<S> mapped(Function<S, T> mapper, Consumer<T> consumer) {
        return new MappedConsumer<S, T>(mapper, consumer);
    }

    public static <T> AutoConsumer<T> queued(ExecutorService executor, BlockingQueue<T> queue, Consumer<T> ... consumers) {
        return new QueuedConsumer<T>(executor, queue, consumers);
    }

    public static <T> AutoConsumer<T> sharded(ToIntFunction<T> distributor, Consumer<T> ... consumers) {
        return ShardedConsumer.of(distributor, consumers);
    }

    @Override
    default public void accept(T item) {
        this.write(item);
    }

    @Override
    default public void close() throws Exception {
    }

    public void write(T var1);

    default public void writeBatch(Iterable<? extends T> batch) {
        for (T item : batch) {
            this.write(item);
        }
    }
}

