/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui;

import fr.profi.mgfboost.ui.MainPanel;
import fr.profi.mgfboost.ui.model.MS2Collection;
import fr.proline.studio.ImageUtilities;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class MS2CollectionRenderer
implements ListCellRenderer {
    private static final ImageIcon mzdbIcon = ImageUtilities.loadImageIcon((String)"fr/profi/mgfboost/images/iconeMzDB.png", (boolean)false);
    private static final ImageIcon mgfIcon = ImageUtilities.loadImageIcon((String)"fr/profi/mgfboost/images/iconeMGF.png", (boolean)false);
    private static final ImageIcon mqIcon = ImageUtilities.loadImageIcon((String)"fr/profi/mgfboost/images/iconeMQ.png", (boolean)false);
    ListCellRenderer defaultListCellRenderer;

    public MS2CollectionRenderer(ListCellRenderer defaultListCellRenderer) {
        this.defaultListCellRenderer = defaultListCellRenderer;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = this.defaultListCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        MS2Collection collection = (MS2Collection)value;
        ((JLabel)c).setText(collection.getName());
        ((JLabel)c).setIcon(MS2CollectionRenderer.getIcon(collection.getFileType()));
        return c;
    }

    private static ImageIcon getIcon(MainPanel.FileType fileType) {
        switch (fileType) {
            case MZDB: {
                return mzdbIcon;
            }
            case MGF: {
                return mgfIcon;
            }
            case MAXQUANT: {
                return mqIcon;
            }
        }
        return null;
    }
}

