/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.biology.variants.Variant;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.VariantMatch;
import com.compomics.util.experiment.identification.protein_inference.PeptideMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.experiment.massspectrometry.utils.StandardMasses;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Semaphore;

public class Peptide
extends ExperimentObject {
    static final long serialVersionUID = 5632064601627536034L;
    private String sequence;
    private String key;
    private String matchingKey;
    private String sequenceWithLowerCasePtms;
    private Semaphore massMutex;
    private Double mass = null;
    private ArrayList<String> parentProteins = null;
    private Semaphore proteinsMutex;
    private ArrayList<ModificationMatch> modifications = null;
    private ArrayList<VariantMatch> variants = null;
    private HashMap<String, HashMap<Integer, ArrayList<Variant>>> variantsMap = null;
    public static final String MODIFICATION_LOCALIZATION_SEPARATOR = "-ATAA-";
    public static final String MODIFICATION_SEPARATOR = "_";
    public static final char MODIFICATION_SEPARATOR_CHAR = '_';

    public Peptide() {
    }

    public Peptide(String aSequence, ArrayList<ModificationMatch> modifications, boolean sanityCheck) {
        this(aSequence, modifications, sanityCheck, null);
    }

    public Peptide(String aSequence, ArrayList<ModificationMatch> modifications, boolean sanityCheck, Double mass) {
        this.sequence = aSequence;
        if (modifications != null) {
            this.modifications = new ArrayList<ModificationMatch>(modifications);
        }
        if (sanityCheck) {
            this.sanityCheck();
        }
        this.proteinsMutex = new Semaphore(1);
        this.mass = mass;
        if (mass == null) {
            this.massMutex = new Semaphore(1);
        }
    }

    public Peptide(String aSequence, ArrayList<ModificationMatch> modifications) {
        this(aSequence, modifications, false);
    }

    private void sanityCheck() {
        this.sequence = this.sequence.replaceAll("[#*$%&]", "");
        if (this.modifications != null) {
            for (ModificationMatch mod : this.modifications) {
                if (mod.getTheoreticPtm().contains(MODIFICATION_SEPARATOR)) {
                    throw new IllegalArgumentException("PTM names containing '_' are not supported. Conflicting name: " + mod.getTheoreticPtm());
                }
                if (!mod.getTheoreticPtm().contains(MODIFICATION_LOCALIZATION_SEPARATOR)) continue;
                throw new IllegalArgumentException("PTM names containing '-ATAA-' are not supported. Conflicting name: " + mod.getTheoreticPtm());
            }
        }
    }

    public Peptide(String aSequence, ArrayList<ModificationMatch> modifications, ArrayList<VariantMatch> variants, boolean sanityCheck) {
        this.sequence = aSequence;
        this.modifications = new ArrayList<ModificationMatch>(modifications);
        this.variants = new ArrayList<VariantMatch>(variants);
        if (sanityCheck) {
            this.sanityCheck();
        }
        this.proteinsMutex = new Semaphore(1);
        this.massMutex = new Semaphore(1);
    }

    public Double getMass() throws InterruptedException {
        if (this.mass == null) {
            this.estimateTheoreticMass();
        }
        return this.mass;
    }

    public ArrayList<ModificationMatch> getModificationMatches() {
        return this.modifications;
    }

    public void setModificationMatches(ArrayList<ModificationMatch> modificationMatches) {
        this.modifications = modificationMatches;
        this.mass = null;
        this.massMutex = new Semaphore(1);
        this.key = null;
        this.matchingKey = null;
    }

    public void clearModificationMatches() {
        this.modifications.clear();
        this.mass = null;
        this.massMutex = new Semaphore(1);
        this.key = null;
        this.matchingKey = null;
    }

    public void addModificationMatch(ModificationMatch modificationMatch) {
        if (this.modifications == null) {
            this.modifications = new ArrayList(1);
        }
        this.modifications.add(modificationMatch);
        this.mass = null;
        this.massMutex = new Semaphore(1);
        this.key = null;
        this.matchingKey = null;
    }

    public ArrayList<VariantMatch> getVariantMatches() {
        return this.variants;
    }

    public void setVariantMatches(ArrayList<VariantMatch> variants) {
        this.variants = variants;
    }

    public void clearVariantMatches() {
        if (this.variants != null) {
            this.variants.clear();
            this.variantsMap = null;
        }
    }

    public void addVariantMatch(VariantMatch variantMatch) {
        if (this.variants == null) {
            this.variants = new ArrayList(1);
        }
        this.variants.add(variantMatch);
        this.variantsMap = null;
    }

    public void addVariantMatches(Collection<VariantMatch> variantMatch) {
        if (this.variants == null) {
            this.variants = new ArrayList(variantMatch != null ? variantMatch.size() : 0);
        }
        if (variantMatch != null) {
            this.variants.addAll(variantMatch);
        }
        this.variantsMap = null;
    }

    public HashMap<String, HashMap<Integer, ArrayList<Variant>>> getVariantsMap() {
        if (this.variantsMap == null) {
            this.variantsMap = new HashMap(this.variants.size());
            for (VariantMatch variantMatch : this.variants) {
                int site;
                ArrayList<Variant> variantsAtSite;
                String proteinAccession = variantMatch.getProteinAccession();
                HashMap<Integer, ArrayList<Variant>> proteinVariants = this.variantsMap.get(proteinAccession);
                if (proteinVariants == null) {
                    proteinVariants = new HashMap(2);
                    this.variantsMap.put(proteinAccession, proteinVariants);
                }
                if ((variantsAtSite = proteinVariants.get(site = variantMatch.getSite())) == null) {
                    variantsAtSite = new ArrayList(1);
                    proteinVariants.put(site, variantsAtSite);
                }
                variantsAtSite.add(variantMatch.getVariant());
            }
        }
        return this.variantsMap;
    }

    public void clearVariantsMap() {
        this.variantsMap = null;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getSequenceWithLowerCasePtms() {
        if (this.sequenceWithLowerCasePtms != null) {
            return this.sequenceWithLowerCasePtms;
        }
        StringBuilder peptideSequence = new StringBuilder(this.sequence.length());
        for (int i = 0; i < this.sequence.length(); ++i) {
            boolean modified = false;
            if (this.modifications != null) {
                for (int j = 0; j < this.modifications.size() && !modified; ++j) {
                    if (this.modifications.get(j).getModificationSite() != i + 1) continue;
                    modified = true;
                }
            }
            if (modified) {
                peptideSequence.append(this.sequence.substring(i, i + 1).toLowerCase());
                continue;
            }
            peptideSequence.append(this.sequence.charAt(i));
        }
        this.sequenceWithLowerCasePtms = peptideSequence.toString();
        return this.sequenceWithLowerCasePtms;
    }

    public int getNMissedCleavages(Enzyme enzyme) {
        return enzyme.getNmissedCleavages(this.sequence);
    }

    public Integer getNMissedCleavages(DigestionPreferences digestionPreferences) {
        Integer peptideMinMissedCleavages = null;
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                int tempMissedCleavages = this.getNMissedCleavages(enzyme);
                if (peptideMinMissedCleavages != null && tempMissedCleavages >= peptideMinMissedCleavages) continue;
                peptideMinMissedCleavages = tempMissedCleavages;
            }
        }
        return peptideMinMissedCleavages;
    }

    public ArrayList<String> getParentProteins(SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, InterruptedException, SQLException, ClassNotFoundException {
        return this.getParentProteins(sequenceMatchingPreferences, true);
    }

    public ArrayList<String> getParentProteins(SequenceMatchingPreferences sequenceMatchingPreferences, boolean remap) throws IOException, ClassNotFoundException, InterruptedException, SQLException {
        if (!remap || this.parentProteins != null) {
            return this.parentProteins;
        }
        PeptideMapper peptideMapper = SequenceFactory.getInstance().getDefaultPeptideMapper();
        if (peptideMapper == null) {
            throw new IllegalArgumentException("Index not created for peptide to protein mapping.");
        }
        return this.getParentProteins(sequenceMatchingPreferences, peptideMapper);
    }

    public ArrayList<String> getParentProteins(SequenceMatchingPreferences sequenceMatchingPreferences, PeptideMapper peptideMapper) throws IOException, InterruptedException, SQLException, ClassNotFoundException {
        if (this.parentProteins == null) {
            this.mapParentProteins(sequenceMatchingPreferences, peptideMapper);
        }
        return this.parentProteins;
    }

    public void mapParentProteins(SequenceMatchingPreferences sequenceMatchingPreferences, PeptideMapper peptideMapper) throws IOException, InterruptedException, SQLException, ClassNotFoundException {
        this.proteinsMutex.acquire();
        if (this.parentProteins == null) {
            ArrayList<PeptideProteinMapping> proteinMapping = peptideMapper.getProteinMapping(this.sequence, sequenceMatchingPreferences);
            HashSet<String> accessionsFound = new HashSet<String>(2);
            for (PeptideProteinMapping peptideProteinMapping : proteinMapping) {
                accessionsFound.add(peptideProteinMapping.getProteinAccession());
            }
            this.parentProteins = new ArrayList(accessionsFound);
            Collections.sort(this.parentProteins);
        }
        this.proteinsMutex.release();
    }

    public ArrayList<String> getParentProteinsNoRemapping() {
        return this.parentProteins;
    }

    public void setParentProteins(ArrayList<String> parentProteins) {
        this.parentProteins = parentProteins;
    }

    public void clearParentProteins() {
        this.parentProteins = null;
        this.proteinsMutex = new Semaphore(1);
    }

    public String getMatchingKey(SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (this.matchingKey == null) {
            String matchingSequence = AminoAcid.getMatchingSequence(this.sequence, sequenceMatchingPreferences);
            this.matchingKey = Peptide.getKey(matchingSequence, this.modifications);
        }
        return this.matchingKey;
    }

    public void resetKeysCaches() {
        this.matchingKey = null;
        this.key = null;
    }

    public String getKey() {
        if (this.key == null) {
            this.key = Peptide.getKey(this.sequence, this.modifications);
        }
        return this.key;
    }

    public static String getKey(String sequence, ArrayList<ModificationMatch> modificationMatches) {
        if (modificationMatches == null) {
            return sequence;
        }
        int size = sequence.length();
        ArrayList<String> tempModifications = new ArrayList<String>(modificationMatches.size());
        for (ModificationMatch mod : modificationMatches) {
            if (!mod.isVariable()) continue;
            String ptmName = mod.getTheoreticPtm();
            if (ptmName != null) {
                PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
                if (mod.isConfident() || mod.isInferred()) {
                    StringBuilder tempModKey = new StringBuilder();
                    tempModKey.append(ptm.getMassAsString()).append(MODIFICATION_LOCALIZATION_SEPARATOR).append(mod.getModificationSite());
                    tempModifications.add(tempModKey.toString());
                    size += tempModKey.length();
                    continue;
                }
                String massAsString = ptm.getMassAsString();
                tempModifications.add(massAsString);
                size += massAsString.length();
                continue;
            }
            tempModifications.add("unknown-modification");
        }
        StringBuilder result = new StringBuilder(size);
        result.append(sequence);
        Collections.sort(tempModifications);
        for (String mod : tempModifications) {
            result.append('_').append(mod);
        }
        return result.toString();
    }

    public boolean isModified() {
        return this.modifications != null && !this.modifications.isEmpty();
    }

    public static boolean isModified(String peptideKey) {
        return peptideKey.contains(MODIFICATION_SEPARATOR);
    }

    public static boolean isModified(String peptideKey, Double modificationMass) {
        return peptideKey.contains(modificationMass.toString());
    }

    public static int getModificationCount(String peptideKey, Double modificationMass) {
        String modKey = modificationMass + "";
        String test = peptideKey + MODIFICATION_SEPARATOR;
        return test.split(modKey).length - 1;
    }

    public int getNVariableModifications(double modificationMass) {
        int n = 0;
        if (this.modifications != null) {
            for (ModificationMatch modificationMatch : this.modifications) {
                PTM ptm;
                if (!modificationMatch.isVariable() || (ptm = PTMFactory.getInstance().getPTM(modificationMatch.getTheoreticPtm())).getMass() != modificationMass) continue;
                ++n;
            }
        }
        return n;
    }

    public int getNModifications() {
        if (this.modifications != null) {
            return this.modifications.size();
        }
        return 0;
    }

    public static ArrayList<Integer> getNModificationLocalized(String peptideKey, Double ptmMass) {
        String test = peptideKey;
        ArrayList<Integer> result = new ArrayList<Integer>();
        boolean first = true;
        String modKey = ptmMass + "";
        for (String modificationSplit : test.split(MODIFICATION_SEPARATOR)) {
            if (!first) {
                String[] localizationSplit = modificationSplit.split(MODIFICATION_LOCALIZATION_SEPARATOR);
                if (localizationSplit.length != 2 || !localizationSplit[0].equals(modKey)) continue;
                try {
                    result.add(Integer.valueOf(localizationSplit[1]));
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot parse modification localization " + localizationSplit[1] + " for modification of mass " + ptmMass + " in peptide key " + peptideKey);
                }
            }
            first = false;
        }
        return result;
    }

    public static String getSequence(String peptideKey) {
        int index = peptideKey.indexOf(MODIFICATION_SEPARATOR);
        if (index > 0) {
            return peptideKey.substring(0, peptideKey.indexOf(MODIFICATION_SEPARATOR));
        }
        return peptideKey;
    }

    public static ArrayList<String> getModificationFamily(String peptideKey) {
        ArrayList<String> result = new ArrayList<String>();
        String[] parsedKey = peptideKey.split(MODIFICATION_SEPARATOR);
        for (int i = 1; i < parsedKey.length; ++i) {
            String[] parsedMod = parsedKey[i].split(MODIFICATION_LOCALIZATION_SEPARATOR);
            result.add(parsedMod[0]);
        }
        return result;
    }

    public ArrayList<String> isNterm(SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        ArrayList<String> result = new ArrayList<String>();
        if (this.parentProteins == null) {
            this.getParentProteins(sequenceMatchingPreferences);
        }
        for (String accession : this.parentProteins) {
            Protein protein = sequenceFactory.getProtein(accession);
            if (!protein.isNTerm(this.sequence, sequenceMatchingPreferences)) continue;
            result.add(accession);
        }
        return result;
    }

    public ArrayList<String> isCterm(SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        ArrayList<String> result = new ArrayList<String>();
        if (this.parentProteins == null) {
            this.getParentProteins(sequenceMatchingPreferences);
        }
        for (String accession : this.parentProteins) {
            Protein protein = sequenceFactory.getProtein(accession);
            if (!protein.isCTerm(this.sequence, sequenceMatchingPreferences)) continue;
            result.add(accession);
        }
        return result;
    }

    public boolean isModifiable(PTM ptm, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        AminoAcidPattern pattern = ptm.getPattern();
        switch (ptm.getType()) {
            case 0: {
                int patternLength = pattern.length();
                int target = pattern.getTarget();
                if (target >= 0 && patternLength - target <= 1) {
                    return pattern.matchesIn(this.sequence, sequenceMatchingPreferences);
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, sequenceMatchingPreferences)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.matchesIn(tempSequence = protein.getSequence().substring(beginIndex, endIndex), sequenceMatchingPreferences)) continue;
                        return true;
                    }
                }
                return false;
            }
            case 7: {
                return true;
            }
            case 5: {
                return true;
            }
            case 3: {
                return !this.isCterm(sequenceMatchingPreferences).isEmpty();
            }
            case 1: {
                return !this.isNterm(sequenceMatchingPreferences).isEmpty();
            }
            case 4: {
                if (this.isCterm(sequenceMatchingPreferences).isEmpty()) {
                    return false;
                }
            }
            case 8: {
                int patternLength = pattern.length();
                int target = pattern.getTarget();
                if (target == patternLength - 1 && this.sequence.length() >= patternLength) {
                    return pattern.isEnding(this.sequence, sequenceMatchingPreferences);
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, sequenceMatchingPreferences)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.isEnding(tempSequence = protein.getSequence().substring(beginIndex, endIndex), sequenceMatchingPreferences)) continue;
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                if (this.isNterm(sequenceMatchingPreferences).isEmpty()) {
                    return false;
                }
            }
            case 6: {
                int patternLength = pattern.length();
                int target = pattern.getTarget();
                if (target == 0 && this.sequence.length() >= patternLength) {
                    return pattern.isStarting(this.sequence, sequenceMatchingPreferences);
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, sequenceMatchingPreferences)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.isStarting(tempSequence = protein.getSequence().substring(beginIndex, endIndex), sequenceMatchingPreferences)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public ArrayList<Integer> getPotentialModificationSites(Double ptmMass, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences, PtmSettings modificationProfile) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        ArrayList<Integer> sites = new ArrayList<Integer>();
        for (String ptmName : modificationProfile.getAllNotFixedModifications()) {
            PTM ptm = PTMFactory.getInstance().getPTM(ptmName);
            if (ptm.getMass() != ptmMass.doubleValue()) continue;
            for (int site : this.getPotentialModificationSites(ptm, sequenceMatchingPreferences, ptmSequenceMatchingPreferences)) {
                if (sites.contains(site)) continue;
                sites.add(site);
            }
        }
        return sites;
    }

    public ArrayList<Integer> getPotentialModificationSites(PTM ptm, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>(1);
        switch (ptm.getType()) {
            case 0: {
                AminoAcidPattern pattern = ptm.getPattern();
                int patternLength = pattern.length();
                int target = pattern.getTarget();
                if (target >= 0 && patternLength - target <= 1) {
                    return pattern.getIndexes(this.sequence, ptmSequenceMatchingPreferences);
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, sequenceMatchingPreferences)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.matchesIn(tempSequence = protein.getSequence().substring(beginIndex, endIndex), ptmSequenceMatchingPreferences)) continue;
                        for (int tempIndex : pattern.getIndexes(tempSequence, ptmSequenceMatchingPreferences)) {
                            Integer sequenceIndex = tempIndex - target;
                            if (possibleSites.contains(sequenceIndex)) continue;
                            possibleSites.add(tempIndex);
                        }
                    }
                }
                return possibleSites;
            }
            case 3: {
                if (this.isCterm(sequenceMatchingPreferences).isEmpty()) {
                    return possibleSites;
                }
            }
            case 7: {
                possibleSites.add(this.sequence.length());
                return possibleSites;
            }
            case 1: {
                if (this.isNterm(sequenceMatchingPreferences).isEmpty()) {
                    return possibleSites;
                }
            }
            case 5: {
                possibleSites.add(1);
                return possibleSites;
            }
            case 4: {
                if (this.isCterm(sequenceMatchingPreferences).isEmpty()) {
                    return possibleSites;
                }
            }
            case 8: {
                AminoAcidPattern pattern = ptm.getPattern();
                int patternLength = pattern.length();
                int target = pattern.getTarget();
                if (target == patternLength - 1 && this.sequence.length() >= patternLength) {
                    if (pattern.isEnding(this.sequence, ptmSequenceMatchingPreferences)) {
                        possibleSites.add(this.sequence.length());
                    }
                    return possibleSites;
                }
                SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                for (String accession : this.parentProteins) {
                    Protein protein = sequenceFactory.getProtein(accession);
                    for (int index : protein.getPeptideStart(this.sequence, sequenceMatchingPreferences)) {
                        String tempSequence;
                        int beginIndex = index - target - 1;
                        int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                        if (endIndex >= protein.getLength() || !pattern.isEnding(tempSequence = protein.getSequence().substring(beginIndex, endIndex), ptmSequenceMatchingPreferences)) continue;
                        possibleSites.add(this.sequence.length());
                        return possibleSites;
                    }
                }
                return possibleSites;
            }
            case 2: {
                if (this.isNterm(sequenceMatchingPreferences).isEmpty()) {
                    return possibleSites;
                }
            }
            case 6: {
                AminoAcidPattern pattern = ptm.getPattern();
                int patternLength = pattern.length();
                int target = pattern.getTarget();
                if (target == 0 && this.sequence.length() >= patternLength) {
                    if (pattern.isStarting(this.sequence, ptmSequenceMatchingPreferences)) {
                        possibleSites.add(1);
                    }
                } else {
                    SequenceFactory sequenceFactory = SequenceFactory.getInstance();
                    for (String accession : this.parentProteins) {
                        Protein protein = sequenceFactory.getProtein(accession);
                        for (int index : protein.getPeptideStart(this.sequence, sequenceMatchingPreferences)) {
                            String tempSequence;
                            int beginIndex = index - target - 1;
                            int endIndex = index + this.sequence.length() - 2 + patternLength - target;
                            if (endIndex >= protein.getLength() || !pattern.isStarting(tempSequence = protein.getSequence().substring(beginIndex, endIndex), ptmSequenceMatchingPreferences)) continue;
                            possibleSites.add(1);
                            return possibleSites;
                        }
                    }
                }
                return possibleSites;
            }
        }
        throw new UnsupportedOperationException("Modification site not implemented for modification of type " + ptm.getType() + ".");
    }

    public ArrayList<Integer> getPotentialModificationSitesNoCombination(PTM ptm, String proteinSequence, Integer indexOnProtein) {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>(1);
        switch (ptm.getType()) {
            case 0: {
                AminoAcidPattern aminoAcidPattern = ptm.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                if (aminoAcidPattern.length() == 1) {
                    for (int i = 0; i < this.sequence.length(); ++i) {
                        Character aa = Character.valueOf(this.sequence.charAt(i));
                        if (!targetedAA.contains(aa)) continue;
                        possibleSites.add(i + 1);
                    }
                } else {
                    for (int i = 0; i < this.sequence.length(); ++i) {
                        Character aa = Character.valueOf(this.sequence.charAt(i));
                        if (!targetedAA.contains(aa) || !aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingPreferences.defaultStringMatching, indexOnProtein + i)) continue;
                        possibleSites.add(i + 1);
                    }
                }
                return possibleSites;
            }
            case 3: {
                int peptideLength = this.sequence.length();
                if (indexOnProtein + peptideLength == proteinSequence.length()) {
                    possibleSites.add(peptideLength);
                }
                return possibleSites;
            }
            case 7: {
                possibleSites.add(this.sequence.length());
                return possibleSites;
            }
            case 1: {
                if (indexOnProtein == 0) {
                    possibleSites.add(1);
                }
                return possibleSites;
            }
            case 5: {
                possibleSites.add(1);
                return possibleSites;
            }
            case 4: {
                AminoAcidPattern aminoAcidPattern = ptm.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                int peptideLength = this.sequence.length();
                if (indexOnProtein + peptideLength == proteinSequence.length()) {
                    Character aa = Character.valueOf(this.sequence.charAt(peptideLength - 1));
                    if (aminoAcidPattern.length() == 1) {
                        if (targetedAA.contains(aa)) {
                            possibleSites.add(peptideLength);
                        }
                    } else if (targetedAA.contains(aa) && aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingPreferences.defaultStringMatching, indexOnProtein + peptideLength)) {
                        possibleSites.add(peptideLength);
                    }
                }
                return possibleSites;
            }
            case 8: {
                AminoAcidPattern aminoAcidPattern = ptm.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                int peptideLength = this.sequence.length();
                Character aa = Character.valueOf(this.sequence.charAt(peptideLength - 1));
                if (aminoAcidPattern.length() == 1) {
                    if (targetedAA.contains(aa)) {
                        possibleSites.add(peptideLength);
                    }
                } else if (targetedAA.contains(aa) && aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingPreferences.defaultStringMatching, indexOnProtein + peptideLength)) {
                    possibleSites.add(peptideLength);
                }
                return possibleSites;
            }
            case 2: {
                AminoAcidPattern aminoAcidPattern = ptm.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                if (indexOnProtein == 0) {
                    Character aa = Character.valueOf(this.sequence.charAt(0));
                    if (aminoAcidPattern.length() == 1) {
                        if (targetedAA.contains(aa)) {
                            possibleSites.add(1);
                        }
                    } else if (targetedAA.contains(aa) && aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingPreferences.defaultStringMatching, 0)) {
                        possibleSites.add(1);
                    }
                }
                return possibleSites;
            }
            case 6: {
                AminoAcidPattern aminoAcidPattern = ptm.getPattern();
                HashSet<Character> targetedAA = aminoAcidPattern.getAminoAcidsAtTargetSet();
                Character aa = Character.valueOf(this.sequence.charAt(0));
                if (aminoAcidPattern.length() == 1) {
                    if (targetedAA.contains(aa)) {
                        possibleSites.add(1);
                    }
                } else if (targetedAA.contains(aa) && aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingPreferences.defaultStringMatching, 0)) {
                    possibleSites.add(1);
                }
                return possibleSites;
            }
        }
        throw new UnsupportedOperationException("Modification site not implemented for modification of type " + ptm.getType() + ".");
    }

    public boolean isSameSequenceAndModificationStatus(Peptide anotherPeptide, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.isSameSequence(anotherPeptide, sequenceMatchingPreferences) && this.isSameModificationStatus(anotherPeptide);
    }

    public boolean isSameSequence(Peptide anotherPeptide, SequenceMatchingPreferences sequenceMatchingPreferences) {
        AminoAcidSequence pattern = new AminoAcidSequence(anotherPeptide.getSequence());
        return pattern.matches(this.sequence, sequenceMatchingPreferences);
    }

    public boolean isSameModificationStatus(Peptide anotherPeptide) {
        if (!this.isModified() && !anotherPeptide.isModified()) {
            return true;
        }
        if (this.getNModifications() != anotherPeptide.getNModifications()) {
            return false;
        }
        PTMFactory ptmFactory = PTMFactory.getInstance();
        ArrayList<String> modifications1 = Peptide.getModificationFamily(this.getKey());
        HashMap<Double, Integer> masses1 = new HashMap<Double, Integer>();
        for (String modName : modifications1) {
            PTM ptm = ptmFactory.getPTM(modName);
            double tempMass = ptm.getMass();
            Integer occurrence = (Integer)masses1.get(tempMass);
            if (occurrence == null) {
                masses1.put(tempMass, 1);
                continue;
            }
            masses1.put(tempMass, occurrence + 1);
        }
        ArrayList<String> modifications2 = Peptide.getModificationFamily(anotherPeptide.getKey());
        HashMap<Double, Integer> masses2 = new HashMap<Double, Integer>();
        for (String modName : modifications2) {
            PTM ptm = ptmFactory.getPTM(modName);
            double tempMass = ptm.getMass();
            Integer occurrence = (Integer)masses2.get(tempMass);
            if (occurrence == null) {
                masses2.put(tempMass, 1);
                continue;
            }
            masses2.put(tempMass, occurrence + 1);
        }
        if (masses1.size() != masses2.size()) {
            return false;
        }
        for (Double tempMass : masses1.keySet()) {
            Integer occurrence1 = (Integer)masses1.get(tempMass);
            Integer occurrence2 = (Integer)masses2.get(tempMass);
            if (occurrence2 != null && occurrence2.intValue() == occurrence1.intValue()) continue;
            return false;
        }
        return true;
    }

    public boolean sameModificationsAs(Peptide anotherPeptide, ArrayList<String> ptms) {
        int position;
        ArrayList<Integer> sites;
        double tempMass;
        String modName;
        if (!this.isModified() && !anotherPeptide.isModified()) {
            return true;
        }
        if (this.getNModifications() != anotherPeptide.getNModifications()) {
            return false;
        }
        HashMap ptmToPositionsMap1 = new HashMap();
        HashMap ptmToPositionsMap2 = new HashMap();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (ModificationMatch modificationMatch : this.modifications) {
            modName = modificationMatch.getTheoreticPtm();
            if (!ptms.contains(modName)) continue;
            tempMass = ptmFactory.getPTM(modName).getMass();
            sites = (ArrayList<Integer>)ptmToPositionsMap1.get(tempMass);
            if (sites == null) {
                sites = new ArrayList<Integer>();
                ptmToPositionsMap1.put(tempMass, sites);
            }
            position = modificationMatch.getModificationSite();
            sites.add(position);
        }
        for (ModificationMatch modificationMatch : anotherPeptide.getModificationMatches()) {
            modName = modificationMatch.getTheoreticPtm();
            if (!ptms.contains(modName)) continue;
            tempMass = ptmFactory.getPTM(modName).getMass();
            sites = (ArrayList<Integer>)ptmToPositionsMap2.get(tempMass);
            if (sites == null) {
                sites = new ArrayList<Integer>();
                ptmToPositionsMap2.put(tempMass, sites);
            }
            position = modificationMatch.getModificationSite();
            sites.add(position);
        }
        for (Double tempMass2 : ptmToPositionsMap1.keySet()) {
            ArrayList sites1 = (ArrayList)ptmToPositionsMap1.get(tempMass2);
            ArrayList sites2 = (ArrayList)ptmToPositionsMap2.get(tempMass2);
            if (sites2 == null || sites1.size() != sites2.size()) {
                return false;
            }
            Collections.sort(sites1);
            Collections.sort(sites2);
            for (int i = 0; i < sites1.size(); ++i) {
                if (((Integer)sites1.get(i)).intValue() == ((Integer)sites2.get(i)).intValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean sameModificationsAs(Peptide anotherPeptide) {
        String modName;
        if (!this.isModified() && !anotherPeptide.isModified()) {
            return true;
        }
        if (this.getNModifications() != anotherPeptide.getNModifications()) {
            return false;
        }
        ArrayList<String> ptms = new ArrayList<String>();
        for (ModificationMatch modificationMatch : this.modifications) {
            modName = modificationMatch.getTheoreticPtm();
            if (ptms.contains(modName)) continue;
            ptms.add(modName);
        }
        for (ModificationMatch modificationMatch : anotherPeptide.getModificationMatches()) {
            modName = modificationMatch.getTheoreticPtm();
            if (ptms.contains(modName)) continue;
            ptms.add(modName);
        }
        return this.sameModificationsAs(anotherPeptide, ptms);
    }

    public String getNTerminal() {
        String nTerm = "NH2";
        PTMFactory ptmFactory = PTMFactory.getInstance();
        if (this.modifications != null) {
            for (ModificationMatch modificationMatch : this.modifications) {
                PTM ptm;
                if (modificationMatch.getModificationSite() != 1 || (ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm())).getType() == 0 || ptm.getType() == 9) continue;
                nTerm = ptm.getShortName();
            }
        }
        nTerm = nTerm.replaceAll("-", " ");
        return nTerm;
    }

    public String getCTerminal() {
        String cTerm = "COOH";
        PTMFactory ptmFactory = PTMFactory.getInstance();
        if (this.modifications != null) {
            for (int i = 0; i < this.modifications.size(); ++i) {
                PTM ptm;
                if (this.modifications.get(i).getModificationSite() != this.sequence.length() || (ptm = ptmFactory.getPTM(this.modifications.get(i).getTheoreticPtm())).getType() == 0 || ptm.getType() == 9) continue;
                cTerm = ptm.getShortName();
            }
        }
        cTerm = cTerm.replaceAll("-", " ");
        return cTerm;
    }

    public String getTaggedModifiedSequence(PtmSettings modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean excludeAllFixedPtms) {
        HashMap<Integer, ArrayList<String>> confidentModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> representativeModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> secondaryModificationSites = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<String>> fixedModificationSites = new HashMap<Integer, ArrayList<String>>();
        if (this.modifications != null) {
            for (ModificationMatch modMatch : this.modifications) {
                String modName = modMatch.getTheoreticPtm();
                int modSite = modMatch.getModificationSite();
                if (modMatch.isVariable()) {
                    if (modMatch.isConfident()) {
                        if (!confidentModificationSites.containsKey(modSite)) {
                            confidentModificationSites.put(modSite, new ArrayList(1));
                        }
                        confidentModificationSites.get(modSite).add(modName);
                        continue;
                    }
                    if (!representativeModificationSites.containsKey(modSite)) {
                        representativeModificationSites.put(modSite, new ArrayList(1));
                    }
                    representativeModificationSites.get(modSite).add(modName);
                    continue;
                }
                if (excludeAllFixedPtms) continue;
                if (!fixedModificationSites.containsKey(modSite)) {
                    fixedModificationSites.put(modSite, new ArrayList(1));
                }
                fixedModificationSites.get(modSite).add(modName);
            }
        }
        return Peptide.getTaggedModifiedSequence(modificationProfile, this, confidentModificationSites, representativeModificationSites, secondaryModificationSites, fixedModificationSites, useHtmlColorCoding, includeHtmlStartEndTags, useShortName);
    }

    public String getTaggedModifiedSequence(PtmSettings modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName) {
        return this.getTaggedModifiedSequence(modificationProfile, useHtmlColorCoding, includeHtmlStartEndTags, useShortName, false);
    }

    public static String getTaggedModifiedSequence(PtmSettings modificationProfile, Peptide peptide, HashMap<Integer, ArrayList<String>> confidentModificationSites, HashMap<Integer, ArrayList<String>> representativeAmbiguousModificationSites, HashMap<Integer, ArrayList<String>> secondaryAmbiguousModificationSites, HashMap<Integer, ArrayList<String>> fixedModificationSites, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName) {
        if (confidentModificationSites == null) {
            confidentModificationSites = new HashMap(0);
        }
        if (representativeAmbiguousModificationSites == null) {
            representativeAmbiguousModificationSites = new HashMap(0);
        }
        if (secondaryAmbiguousModificationSites == null) {
            secondaryAmbiguousModificationSites = new HashMap(0);
        }
        if (fixedModificationSites == null) {
            fixedModificationSites = new HashMap(0);
        }
        String modifiedSequence = "";
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "<html>";
        }
        modifiedSequence = modifiedSequence + peptide.getNTerminal() + "-";
        modifiedSequence = modifiedSequence + AminoAcidSequence.getTaggedModifiedSequence(modificationProfile, peptide.sequence, confidentModificationSites, representativeAmbiguousModificationSites, secondaryAmbiguousModificationSites, fixedModificationSites, useHtmlColorCoding, useShortName);
        modifiedSequence = modifiedSequence + "-" + peptide.getCTerminal();
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "</html>";
        }
        return modifiedSequence;
    }

    public static String getPeptideModificationsAsString(Peptide peptide, boolean variablePtms) {
        StringBuilder result = new StringBuilder();
        HashMap modMap = new HashMap();
        if (peptide.isModified()) {
            for (ModificationMatch modificationMatch : peptide.getModificationMatches()) {
                if ((!variablePtms || !modificationMatch.isVariable()) && (variablePtms || modificationMatch.isVariable())) continue;
                if (!modMap.containsKey(modificationMatch.getTheoreticPtm())) {
                    modMap.put(modificationMatch.getTheoreticPtm(), new ArrayList());
                }
                ((ArrayList)modMap.get(modificationMatch.getTheoreticPtm())).add(modificationMatch.getModificationSite());
            }
        }
        boolean first = true;
        ArrayList mods = new ArrayList(modMap.keySet());
        Collections.sort(mods);
        for (String mod : mods) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            boolean first2 = true;
            result.append(mod);
            result.append(" (");
            Iterator iterator = ((ArrayList)modMap.get(mod)).iterator();
            while (iterator.hasNext()) {
                int aa = (Integer)iterator.next();
                if (first2) {
                    first2 = false;
                } else {
                    result.append(", ");
                }
                result.append(aa);
            }
            result.append(")");
        }
        return result.toString();
    }

    public ArrayList<Integer> getModifiedIndexes() {
        return this.getModifiedIndexes(true);
    }

    public ArrayList<Integer> getModifiedIndexes(boolean excludeFixed) {
        if (this.modifications == null) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> modifiedResidues = new ArrayList<Integer>(this.modifications.size());
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (int i = 0; i < this.sequence.length(); ++i) {
            for (int j = 0; j < this.modifications.size(); ++j) {
                PTM ptm = ptmFactory.getPTM(this.modifications.get(j).getTheoreticPtm());
                if (ptm.getType() != 0 || !this.modifications.get(j).isVariable() && excludeFixed || this.modifications.get(j).getModificationSite() != i + 1) continue;
                modifiedResidues.add(i + 1);
            }
        }
        return modifiedResidues;
    }

    public HashMap<Integer, ArrayList<String>> getIndexedFixedModifications() {
        if (this.modifications == null) {
            return new HashMap<Integer, ArrayList<String>>(0);
        }
        HashMap<Integer, ArrayList<String>> result = new HashMap<Integer, ArrayList<String>>(this.modifications.size());
        for (ModificationMatch modificationMatch : this.modifications) {
            if (modificationMatch.isVariable()) continue;
            int aa = modificationMatch.getModificationSite();
            if (!result.containsKey(aa)) {
                result.put(aa, new ArrayList());
            }
            result.get(aa).add(modificationMatch.getTheoreticPtm());
        }
        return result;
    }

    public void estimateTheoreticMass() throws InterruptedException {
        if (this.mass == null) {
            Semaphore threadMutex = this.massMutex;
            threadMutex.acquire();
            if (this.mass == null) {
                char[] sequenceAsCharArray;
                double tempMass = StandardMasses.h2o.mass;
                for (char aa : sequenceAsCharArray = this.sequence.toCharArray()) {
                    AminoAcid currentAA = AminoAcid.getAminoAcid(aa);
                    tempMass += currentAA.getMonoisotopicMass();
                }
                if (this.modifications != null) {
                    PTMFactory ptmFactory = PTMFactory.getInstance();
                    for (ModificationMatch ptmMatch : this.modifications) {
                        tempMass += ptmFactory.getPTM(ptmMatch.getTheoreticPtm()).getMass();
                    }
                }
                this.mass = tempMass;
            }
            threadMutex.release();
            this.massMutex = null;
        }
    }

    public AminoAcidPattern getSequenceAsPattern() {
        return Peptide.getSequenceAsPattern(this.sequence);
    }

    public static AminoAcidPattern getSequenceAsPattern(String sequence) {
        return AminoAcidPattern.getAminoAcidPatternFromString(sequence);
    }

    public AminoAcidSequence getSequenceAsAminoAcidSequence() {
        return Peptide.getSequenceAsAminoAcidSequence(this.sequence);
    }

    public static AminoAcidSequence getSequenceAsAminoAcidSequence(String sequence) {
        return new AminoAcidSequence(sequence);
    }

    public boolean isDecoy(SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, InterruptedException, SQLException, ClassNotFoundException {
        if (this.parentProteins == null) {
            this.getParentProteins(sequenceMatchingPreferences);
        }
        for (String accession : this.parentProteins) {
            if (!SequenceFactory.getInstance().isDecoyAccession(accession)) continue;
            return true;
        }
        return false;
    }

    public static Peptide getNoModPeptide(Peptide peptide, ArrayList<PTM> ptms) throws IOException, SQLException, ClassNotFoundException, InterruptedException {
        Peptide noModPeptide = new Peptide(peptide.getSequence(), new ArrayList<ModificationMatch>());
        noModPeptide.setParentProteins(peptide.getParentProteinsNoRemapping());
        if (peptide.isModified()) {
            for (ModificationMatch modificationMatch : peptide.getModificationMatches()) {
                boolean found = false;
                for (PTM ptm : ptms) {
                    if (!modificationMatch.getTheoreticPtm().equals(ptm.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                noModPeptide.addModificationMatch(modificationMatch);
            }
        }
        return noModPeptide;
    }
}

