/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.taxonomy.mappings;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class UniprotTaxonomy {
    public static final String SEPARATOR = "\t";
    private HashMap<String, Integer> nameToIdMap = new HashMap();
    private HashMap<Integer, String> idToNameMap = new HashMap();
    private HashMap<Integer, String> idToCommonNameMap = new HashMap();
    private File mappingFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapping(File speciesFile) throws IOException {
        this.mappingFile = speciesFile;
        FileReader r = new FileReader(speciesFile);
        try {
            BufferedReader br = new BufferedReader(r);
            try {
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    String[] elements = line.split(SEPARATOR);
                    Integer id = new Integer(elements[0].trim());
                    String latinName = elements[2].trim();
                    String commonName = elements[3].trim();
                    this.nameToIdMap.put(latinName, id);
                    this.idToNameMap.put(id, latinName);
                    if (commonName.equals("")) continue;
                    this.idToCommonNameMap.put(id, commonName);
                }
            }
            finally {
                br.close();
            }
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadMapping(String name) throws MalformedURLException, URIException, IOException {
        String query = URIUtil.encodeQuery((String)name);
        URL url = new URL("http://www.uniprot.org/taxonomy/?sort=score&desc=&compress=no&query=" + query + "&format=tab&columns=id");
        URLConnection conn = url.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.mappingFile, true));
            try {
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    String[] elements = line.split(SEPARATOR);
                    Integer id = new Integer(elements[0].trim());
                    String latinName = elements[2].trim();
                    String commonName = elements[3].trim();
                    if (this.idToNameMap.containsKey(id)) continue;
                    this.nameToIdMap.put(latinName, id);
                    this.idToNameMap.put(id, latinName);
                    if (!commonName.equals("")) {
                        this.idToCommonNameMap.put(id, commonName);
                    }
                    try {
                        bw.write(line);
                        bw.newLine();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                bw.close();
            }
        }
        finally {
            br.close();
        }
    }

    public Integer getId(String name, boolean query) throws MalformedURLException, URIException, IOException {
        Integer result = this.nameToIdMap.get(name);
        if (result == null && query) {
            this.downloadMapping(name);
            result = this.nameToIdMap.get(name);
        }
        return result;
    }

    public String getLatinName(Integer id) {
        return this.idToNameMap.get(id);
    }

    public String getCommonName(Integer id) {
        return this.idToCommonNameMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadTaxonomyFile(File destinationFile) throws IOException {
        URL url = new URL("http://www.uniprot.org/taxonomy/?format=tab&columns=id");
        URLConnection conn = url.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(destinationFile));
            try {
                String rowLine;
                while ((rowLine = br.readLine()) != null) {
                    bw.write(rowLine);
                    bw.newLine();
                }
            }
            finally {
                bw.close();
            }
        }
        finally {
            br.close();
        }
    }
}

