/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches_iterators;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class PsmIterator {
    private final Identification identification;
    private final ArrayList<String> spectrumKeys;
    private final ArrayList<UrParameter> psmParameters;
    private final boolean loadAssumptions;
    private final int nMatches;
    private int index = -1;
    public final int defaultBatchSize = 1000;
    private int batchSize = 1000;
    private int loadingIndex = -1;
    private boolean buffering = false;
    private Semaphore bufferingMutex = new Semaphore(1);
    public final double defaultMargin = 0.1;
    private double margin = 0.1;
    private WaitingHandler waitingHandler;

    public PsmIterator(String spectrumFile, ArrayList<String> spectrumKeys, Identification identification, ArrayList<UrParameter> psmParameters, boolean loadAssumptions, WaitingHandler waitingHandler) {
        this.identification = identification;
        if (spectrumKeys == null) {
            if (spectrumFile != null) {
                this.spectrumKeys = new ArrayList<String>(identification.getSpectrumIdentification(spectrumFile));
            } else {
                this.spectrumKeys = new ArrayList(identification.getSpectrumIdentificationSize());
                for (String tempSpectrumFile : identification.getOrderedSpectrumFileNames()) {
                    this.spectrumKeys.addAll(identification.getSpectrumIdentification(tempSpectrumFile));
                }
            }
        } else {
            this.spectrumKeys = spectrumKeys;
        }
        this.nMatches = this.spectrumKeys.size();
        this.psmParameters = psmParameters;
        this.loadAssumptions = loadAssumptions;
        this.waitingHandler = waitingHandler;
        if (spectrumKeys != null) {
            this.batchSize = Math.max(50, spectrumKeys.size() / 100);
            this.batchSize = Math.min(1000, Math.max(this.batchSize, spectrumKeys.size() / 1000));
        }
    }

    public PsmIterator(ArrayList<String> spectrumKeys, Identification identification, ArrayList<UrParameter> psmParameters, boolean loadAssumptions, WaitingHandler waitingHandler) {
        this(null, spectrumKeys, identification, psmParameters, loadAssumptions, waitingHandler);
    }

    public PsmIterator(ArrayList<String> spectrumKeys, Identification identification, boolean loadAssumptions, WaitingHandler waitingHandler) {
        this(null, spectrumKeys, identification, null, loadAssumptions, waitingHandler);
    }

    public PsmIterator(String spectrumFile, ArrayList<String> spectrumKeys, Identification identification, boolean loadAssumptions, WaitingHandler waitingHandler) {
        this(spectrumFile, spectrumKeys, identification, null, loadAssumptions, waitingHandler);
    }

    public PsmIterator(String spectrumFile, Identification identification, ArrayList<UrParameter> psmParameters, boolean loadAssumptions, WaitingHandler waitingHandler) {
        this(spectrumFile, null, identification, psmParameters, loadAssumptions, waitingHandler);
    }

    public PsmIterator(String spectrumFile, Identification identification, boolean loadAssumptions, WaitingHandler waitingHandler) {
        this(spectrumFile, identification, null, loadAssumptions, waitingHandler);
    }

    public PsmIterator(String spectrumFile, Identification identification, boolean loadAssumptions, ArrayList<UrParameter> psmParameters, WaitingHandler waitingHandler) {
        this(spectrumFile, identification, null, loadAssumptions, waitingHandler);
    }

    public PsmIterator(Identification identification, boolean loadAssumptions, WaitingHandler waitingHandler) {
        this(null, null, identification, null, loadAssumptions, waitingHandler);
    }

    public PsmIterator(Identification identification, ArrayList<UrParameter> psmParameters, boolean loadAssumptions, WaitingHandler waitingHandler) {
        this(null, null, identification, psmParameters, loadAssumptions, waitingHandler);
    }

    public SpectrumMatch next() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        int threadIndex = this.incrementIndex();
        if (threadIndex < this.nMatches) {
            this.checkBuffer();
            String key = this.spectrumKeys.get(threadIndex);
            SpectrumMatch match = this.identification.getSpectrumMatch(key);
            return match;
        }
        return null;
    }

    private void checkBuffer() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (!this.buffering) {
            int trigger = this.loadingIndex - (int)(this.margin * (double)this.batchSize);
            if (this.index >= trigger) {
                this.bufferingMutex.acquire();
                trigger = this.loadingIndex - (int)(this.margin * (double)this.batchSize);
                if (this.index >= trigger) {
                    this.buffering = true;
                    int newLoadingIndex = Math.min(this.loadingIndex + this.batchSize, this.nMatches - 1);
                    ArrayList<String> keysInBatch = new ArrayList<String>(this.spectrumKeys.subList(this.loadingIndex + 1, newLoadingIndex + 1));
                    this.identification.loadSpectrumMatches(keysInBatch, this.waitingHandler, false);
                    if (this.waitingHandler != null && this.waitingHandler.isRunCanceled()) {
                        return;
                    }
                    if (this.psmParameters != null) {
                        for (UrParameter urParameter : this.psmParameters) {
                            if (urParameter == null) {
                                throw new IllegalArgumentException("Parameter to batch load is null.");
                            }
                            this.identification.loadSpectrumMatchParameters(keysInBatch, urParameter, this.waitingHandler, false);
                            if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) continue;
                            return;
                        }
                    }
                    if (this.loadAssumptions) {
                        this.identification.loadAssumptions(keysInBatch, this.waitingHandler, false);
                        if (this.waitingHandler != null && this.waitingHandler.isRunCanceled()) {
                            return;
                        }
                    }
                    this.loadingIndex = newLoadingIndex;
                    trigger += (int)(this.margin * (double)this.batchSize / 2.0);
                    if (this.index < (trigger = Math.max(0, trigger))) {
                        if (this.batchSize > 1000) {
                            this.batchSize = Math.max(1000, 0 * this.batchSize);
                        } else if (this.margin > 0.1) {
                            this.margin = Math.max(0.1, 0.9 * this.margin);
                        }
                    }
                }
                if (!this.bufferingMutex.hasQueuedThreads()) {
                    this.buffering = false;
                }
                this.bufferingMutex.release();
            }
        } else if (this.index == this.loadingIndex) {
            this.margin *= 1.1;
            if (this.margin >= 0.25) {
                this.batchSize = (int)((double)this.batchSize * 1.1);
                this.margin = 0.1;
            }
        }
    }

    private synchronized int incrementIndex() {
        int localIndex = ++this.index;
        return localIndex;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

