/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXBException;
import org.apache.commons.math.util.FastMath;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class AndromedaIdfileReader
extends ExperimentObject
implements IdfileReader {
    private File resultsFile;
    private String fileName;

    public AndromedaIdfileReader() {
    }

    public AndromedaIdfileReader(File resultsFile) throws FileNotFoundException, IOException {
        this.resultsFile = resultsFile;
        this.fileName = Util.getFileName(resultsFile);
    }

    @Override
    public String getExtension() {
        return ".res";
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, false);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        String line;
        String mgfFile = Util.removeExtension(this.fileName) + ".mgf";
        LinkedList<SpectrumMatch> result = new LinkedList<SpectrumMatch>();
        HashMap<String, SpectrumMatch> spectrumMatchesMap = new HashMap<String, SpectrumMatch>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(this.resultsFile, "r", 102400);
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        String title = null;
        SpectrumMatch spectrumMatch = null;
        int rank = 0;
        boolean firstSpectrum = false;
        while ((line = bufferedRandomAccessFile.readLine()) != null) {
            if (line.startsWith(">")) {
                if (!firstSpectrum) {
                    firstSpectrum = true;
                }
                title = line.substring(1);
                title = URLDecoder.decode(title, "utf-8");
                spectrumMatch = null;
                long currentIndex = bufferedRandomAccessFile.getFilePointer();
                if (waitingHandler == null) continue;
                waitingHandler.setSecondaryProgressCounter((int)(currentIndex / progressUnit));
                continue;
            }
            if (!firstSpectrum) continue;
            if (spectrumMatch == null) {
                String spectrumKey = Spectrum.getSpectrumKey(mgfFile, title);
                spectrumMatch = (SpectrumMatch)spectrumMatchesMap.get(spectrumKey);
                rank = 0;
                if (spectrumMatch == null) {
                    spectrumMatch = new SpectrumMatch(Spectrum.getSpectrumKey(mgfFile, title));
                    result.add(spectrumMatch);
                    spectrumMatchesMap.put(spectrumKey, spectrumMatch);
                }
            }
            PeptideAssumption peptideAssumption = this.getAssumptionFromLine(line, ++rank);
            if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideAssumption.getPeptide().getSequence())) {
                Peptide peptide = peptideAssumption.getPeptide();
                ArrayList<ModificationMatch> previousModificationMatches = peptide.getModificationMatches();
                ArrayList<ModificationMatch> newModificationMatches = null;
                if (previousModificationMatches != null) {
                    newModificationMatches = new ArrayList<ModificationMatch>(previousModificationMatches.size());
                }
                for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                    Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                    if (previousModificationMatches != null) {
                        for (ModificationMatch modificationMatch : previousModificationMatches) {
                            newPeptide.addModificationMatch(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite()));
                        }
                    }
                    PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                    spectrumMatch.addHit(Advocate.andromeda.getIndex(), newAssumption, true);
                }
                continue;
            }
            spectrumMatch.addHit(Advocate.andromeda.getIndex(), peptideAssumption, true);
        }
        return result;
    }

    private PeptideAssumption getAssumptionFromLine(String line, int rank) {
        String[] temp = line.trim().split("\t");
        String[] temp1 = temp[4].split(",");
        ArrayList<ModificationMatch> modMatches = new ArrayList<ModificationMatch>();
        for (int aa = 0; aa < temp1.length; ++aa) {
            String mod = temp1[aa];
            if (mod.equals("A")) continue;
            modMatches.add(new ModificationMatch(mod, true, aa));
        }
        String sequence = temp[0];
        Peptide peptide = new Peptide(sequence, modMatches, true);
        Charge charge = new Charge(1, new Integer(temp[6]));
        Double score = new Double(temp[1]);
        Double p = FastMath.pow((double)10.0, (double)(-(score / 10.0)));
        PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, Advocate.andromeda.getIndex(), charge, p, this.fileName);
        peptideAssumption.setRawScore(score);
        return peptideAssumption;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add("1.5.3.4");
        result.put("Andromeda", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

