/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.math.statistics.distributions.NonSymmetricalNormalDistribution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.math.MathException;
import org.apache.commons.math.util.FastMath;

public class SimpleNoiseDistribution {
    private static final int nBins = 100;
    private final double binSize;
    private int[] orderedBins;
    private double[] pLog;
    private NonSymmetricalNormalDistribution intensityLogDistribution;

    public SimpleNoiseDistribution(HashMap<Double, Peak> peakList) throws MathException {
        ArrayList<Double> intensitiesLog = new ArrayList<Double>(peakList.size());
        for (Peak peak : peakList.values()) {
            double log = FastMath.log10((double)peak.intensity);
            intensitiesLog.add(log);
        }
        Collections.sort(intensitiesLog);
        this.intensityLogDistribution = NonSymmetricalNormalDistribution.getRobustNonSymmetricalNormalDistributionFromSortedList(intensitiesLog);
        this.orderedBins = new int[99];
        this.pLog = new double[99];
        this.binSize = 0.01;
        for (int i = 1; i < 100; ++i) {
            double p = this.binSize * (double)i;
            double x = this.intensityLogDistribution.getValueAtDescendingCumulativeProbability(p);
            this.orderedBins[i - 1] = (int)FastMath.pow((double)10.0, (double)x);
            this.pLog[i - 1] = FastMath.log10((double)p);
        }
    }

    public double getBinnedCumulativeProbability(double intensity) {
        for (int i = 0; i < this.orderedBins.length; ++i) {
            int bin = this.orderedBins[i];
            if (!(intensity > (double)bin)) continue;
            return this.binSize * (double)i;
        }
        return 1.0;
    }

    public double getBinnedCumulativeProbabilityLog(double intensity) {
        for (int i = 0; i < this.orderedBins.length; ++i) {
            int bin = this.orderedBins[i];
            if (!(intensity > (double)bin)) continue;
            return this.pLog[i];
        }
        return 0.0;
    }

    public double getLogIntensityAtP(double p) throws MathException {
        return this.intensityLogDistribution.getValueAtDescendingCumulativeProbability(p);
    }

    public double getIntensityAtP(double p) throws MathException {
        return FastMath.pow((double)10.0, (double)this.getLogIntensityAtP(p));
    }
}

